'use strict';
define(function() {
  var gcelement = function(
    gclayers,
    $translate,
    SridFactory,
    $timeout,
    gcPopup,
    EditRulesFactory,
    $rootScope,
    $filter,
    gcInteractions,
    extendedNgDialog,
    gaJsUtils,
    mapJsUtils,
    bizeditProvider
  ) {
    return {
      templateUrl: 'js/XG/widgets/mapapp/bizedition/views/bizeditpoint.html',
      restrict: 'A',
      scope: {
        map: '=map',
        editdescription: '=editdescription',
        drawinteraction: '=drawinteraction',
        isActive: '=isactive',
        toolbarwidget: '=?toolbarwidget',
        execrules: '&execrules', //correspond à 'performRules' dans le widget d'édition
        performendrules: '&performendrules',
        reset: '&',
        isGuide: '=isguide',
        createGuide: '&createguide',
        updateGuide: '&updateguide',
        guide: '&',
        stopGuide: '&stopguide',
        preStartEndRules: '&?prestartendrules', // exécute les règles métier à la création d'un point par coordonnées
        drawMode: '=?', // 'normal': main levée ou 'coord': par coordonnées
        isAttributePopupOpen: '=?',
        network: '=' // nom du réseau d'interconnexion des composants défini dans l'admin
      },
      link: function(scope) {
        scope.drawinteraction = {};
        scope.drawModes = [
          {
            label: $filter('translate')('bizedition.drawModesNormal'),
            value: 'normal',
            id: 0
          },
          {
            label: $filter('translate')('bizedition.byCoordinates'),
            value: 'coord',
            id: 1
          },
          {
            label: $filter('translate')('bizedition.byDistance'),
            value: 'lineaire',
            id: 2
          }
        ];
        scope.drawMode = 'normal';

        //Gestion de l'indicateur et de la possibilité d'activer et désactiver la fonctionnalité de snap.
        scope.snapState = { isOn: false };
        scope.map.on('snapAddedEvent', () => {
          scope.snapState.isOn = true;
        });
        scope.map.on('snapRemovedEvent', () => {
          scope.snapState.isOn = false;
        });

        /**
         * Handler de la case à cocher permettant d'activer ou de desactiver l'interaction de snap
         * (si la règle métier exécutée à l'initialisation à ajouter une interaction de snap)
         */
        scope.switchSnap = () => {
          scope.snapState.isOn=!scope.snapState.isOn;
          for (let inter of scope.map.getInteractions().getArray()) {
            if (inter instanceof ol.interaction.Snap) {
              inter.setActive(scope.snapState.isOn);
            }
          }
        };

        $translate('bizedition.drawModesNormal').then(function(res) {
          scope.drawModes[0].label = res;
        });

        let pointPlacementPopupTitle = '';
        $translate('bizedition.pointplacement.title').then(function(res) {
          pointPlacementPopupTitle = res;
        });

        //////// GESTION DES PROJECTIONS ///////////////////////////////

        const mapProjCode = scope.map.getView().getProjection().getCode();

        //Liste des systemes de projection
        scope.srids = SridFactory.sridsList;

        //Projection sélectionnée.
        if ($rootScope.xgos.mouseposition && $rootScope.xgos.mouseposition.srid) {
          scope.selectedsrid = angular.copy($rootScope.xgos.mouseposition.srid);
        } else {
          if (scope.map && mapProjCode) {
            scope.selectedsrid = angular.copy(mapProjCode)
          } else {
            scope.selectedsrid = {
              name: 'EPSG:3857',
              description:
                  '+proj=merc +a=6378137 +b=6378137 +lat_ts=0.0 +lon_0=0.0 +x_0=0.0 +y_0=0 +k=1.0 +units=m +nadgrids=@null +wktext  +no_defs',
            };
          }
        }

        //Récupération du code de projection de la carte
        //Récupération de la description de la projection de la carte
        let mapProjDescription = '';
        SridFactory.getbycode(mapProjCode).then(
          res => {
            mapProjDescription = res.data;
          },
          () => {
            require('toastr').error('Map SRID description not found !');
          }
        );

        /**
         * Appelée à chaque changement de projectiond dans la liste déroulante.
         */
        scope.onSridSelected = () => {
          if (scope.selectedsrid.name) {
            SridFactory.getbycode(scope.selectedsrid.name).then(
              res => {
                scope.selectedsrid.description = res.data;
              },
              () => {
                require('toastr').error('SRID description not found !');
              }
            );
          }
        };

        /**
         * Sélectionne le système de projection correspondant à celui de la carte.
         */
        scope.selectMapEPSG = () => {
          scope.selectedsrid = {
            name: mapProjCode,
            description: mapProjDescription
          };
        };

        //////// FIN GESTION DES PROJECTIONS ///////////////////////////////

        var distancePopup = undefined;
        /**
         * Méthode d'activation de l'outil de saisie d'objet ponctuel.
         * @returns {undefined}
         */
        scope.add = function() {
          //Activation si désactivé et desactivation si activé
          scope.isActive = !scope.isActive;
          if (!scope.isActive) {
            scope.reset();
            return;
          }

          //Si mode d'édition à main levé
          if (scope.drawMode === 'normal') {
            scope.drawinteraction = new ol.interaction.Draw({
              source: gclayers.getDrawLayer().getSource(),
              type: 'Point',
              geometryFunction: geometryCoordinatesUpdated,
            });

            scope.drawinteraction.set('gctype', 'kis');
            scope.drawinteraction.set('interaction', 'Draw');
            scope.drawinteraction.set('widget', 'Edition');

            if (scope.isGuide) {
              scope.guide();
            }
            gcInteractions.setCurrentToolBar(scope.toolbarwidget);
            scope.map.addInteraction(scope.drawinteraction);
            //on start
            scope.drawinteraction.on('drawstart', function(evt) {
              /*sketchFeature = evt.feature;*/
              console.log('drawstart');
              if (scope.isGuide) {
                scope.guide();
              }
            });
            // on end
            scope.drawinteraction.on('drawend', function(evt) {
              //vider la source du markerPosition
              const markerPositionLayer = mapJsUtils.getLayerByProperty(scope.map, 'id', bizeditProvider.MARKER_POSITION_LAYER_ID);
              if (markerPositionLayer) {
                markerPositionLayer.setSource(null);
              }
              scope.XConstraint = "";
              scope.YConstraint = "";
              scope.isXConstraint = false;
              scope.isYConstraint = false;

            });
          }
          try {
            $timeout(() => {
              scope.$apply();
            });
          } catch (e) { }
          $timeout(() => {
            scope.execrules();
          });
        };

        /**
         * Dans la popup "Crréation d'un point par coordonnées",
         * au clic sur l'icône de la puce de localisation permettant de positionner le point saisi
         */
        scope.getMarkerPosition = () => {
          const x = Number.parseFloat(scope.draftPointCoords.x);
          const y = Number.parseFloat(scope.draftPointCoords.y);
          if (!Number.isNaN(x) && !Number.isNaN(y)) {
            scope.XConstraint = x;
            scope.YConstraint = y;
            const marker = new ol.Feature({
              geometry: new ol.geom.Point(angular.isDefined(scope.selectedsrid.description)
              && angular.isDefined(mapProjDescription) && scope.selectedsrid.description !== mapProjDescription ?
                  proj4(scope.selectedsrid.description, mapProjDescription, [scope.XConstraint, scope.YConstraint]):[scope.XConstraint, scope.YConstraint])
            });
            bizeditProvider.drawMarker(scope.map, marker);
          }
        };

        ////////// Gestion de la pose de point par coordonéees X Y ////////////////////////

        var warningToastrDiv = undefined;
        function resetToastrDiv() {
          warningToastrDiv = undefined;
        }
        function getProjConstraintsCoordinates(coordinates) {
          var x = coordinates[0];
          var y = coordinates[1];

          //Messages d'avertissement si contrainte activée mais sans valeur rentrée
          if (scope.isXConstraint) {
            if (
              angular.isUndefined(scope.XConstraint) ||
              scope.XConstraint == null
            ) {
              if (warningToastrDiv == undefined) {
                warningToastrDiv = require('toastr').warning($filter('translate')('bizedition.xWarningMsg'));
                $timeout(resetToastrDiv, 5000);
              }
              return [x, y];
            }
          }
          if (scope.isYConstraint) {
            if (
              angular.isUndefined(scope.YConstraint) ||
              scope.YConstraint == null
            ) {
              if (warningToastrDiv == undefined) {
                warningToastrDiv = require('toastr').warning($filter('translate')('bizedition.yWarningMsg'));
                $timeout(resetToastrDiv, 5000);
              }
              return [x, y];
            }
          }

          require('toastr').clear();

          if (scope.isXConstraint) {
            const projCoords = proj4(
              scope.selectedsrid.description,
              mapProjDescription,
              [scope.XConstraint, scope.YConstraint]
            );
            x = projCoords[0];
          }
          if (scope.isYConstraint) {
            const projCoords = proj4(
              scope.selectedsrid.description,
              mapProjDescription,
              [scope.XConstraint, scope.YConstraint]
            );
            y = projCoords[1];
          }

          return [x, y];
        }

        /**
         * Méthode appelée par l'interaction draw  permettant de modifier dynamiquement
         * la géométrie de l'objet en cours de saisie en fonction des valeurs de
         * contraintes rentrées dans l'ihm du widget.
         * @param {ol.Coordinate[]} coordinates
         * @param {ol.geom.Point} geom
         * @returns {ol.geom.Point}
         */
        function geometryCoordinatesUpdated(coordinates, geom) {
          //Si première fois, geom pas encore instanciée
          if (!geom) {
            geom = new ol.geom.Point(coordinates);
            //Si dessin avec contrainte X et/ou Y
            if (scope.isXConstraint || scope.isYConstraint) {
              geom.setCoordinates(getProjConstraintsCoordinates(coordinates));
            }
            return geom;
          }

          //Si dessin avec contrainte X et/ou Y
          if (scope.isXConstraint || scope.isYConstraint) {
            coordinates = getProjConstraintsCoordinates(coordinates);
          }

          geom.setCoordinates(coordinates);
          return geom;
        }

        //////// Gestion de la création d'objet par saisie de point de départ et distance /////////////
        scope.createFromPointDistance = function() {
          //Si mode d'édition normal (non rapide)
          if (!scope.editdescription.fastMode) {
            //Fermeture de la popup contenant le composant de creation d'objet par point de départ et distance
            distancePopup.destroy();
          }
          scope.performendrules(new Event('drawend'));
        };

        scope.$on('runAdd', function(event, p1) {
          if (p1.geomtype === 'POINT') scope.add();
        });


        /**
         * Au clic sur le bouton de création (crayon) après sélection d'un composant de type ponctuel,
         * initialise la création d'un point de manière différente suivant editMode<ul><li>
         *   en mode "Main levée": initialisation de l'intéraction draw classique</li><li>
         *   en mode "Coordonnées": exécution des règles métier à l'initialisation et ouvre une popup de saisie des coordonnées</li></ul>
         */
        scope.startPointCreationByEditMode = () => {
          if (scope.drawMode && !scope.isCreationPopupOpened) {
            switch (scope.drawMode) {
              case 'normal': // main levée
                scope.reset();
                scope.add();
                break;
              case 'coord': // par coordonnées
                openPointCreationByCoordinates();
                break;
              case 'lineaire': // positionnement linéaire
                openPointCreationByDistance();
                break;
              default:
                scope.drawMode = 'normal';
                scope.reset();
                scope.add();
            }
          }
        };


        /********************************
         EDITION DE POINT PAR COORDONNEES
         ********************************/

        /**
         * Au clic sur le bouton "créer un objet" (crayon).
         * Exécute les règles métiers d'initialisation {@link performRules}.
         * Ouvre la popup de création de point par coordonnées
         */
        const openPointCreationByCoordinates = () => {
          // obligé de créer un objet pour stocker les points
          // la popup ne renvoie pas XConstraint/YConstraint à la directive (angularjs ist ein Stück Scheiße)
          scope.draftPointCoords = {x:null,y:null};

          scope.isActive = true;

          // Crée un objet editdescription décrivant l'action d'édtion courante,
          // appelle les règles métier d'initialisation,
          // s'abonne aux evenement de début et de fin de dessin permettant de lancer les règles métiers correspondantes.
          scope.execrules();

          // empeche la ré-ouverture de la popup
          scope.isCreationPopupOpened = true;

          // empeche la double exécution du preCloseCallback
          let isClosingPopup = false;

          extendedNgDialog.open({
            template:
                'js/XG/widgets/mapapp/bizedition/views/modals/modal.bizeditpoint.coords.html',
            className: 'ngdialog-theme-plain noclose bizeditpoint-modal',
            closeByDocument: false,
            draggable: true,
            showClose: false,
            title: $filter('translate')('bizedition.bycoords.newModalTitle'),
            scope: scope,
            preCloseCallback: () => {
              if (!isClosingPopup) {
                bizeditProvider.removeMarkerLayer(scope.map);
                scope.isCreationPopupOpened = false;
                isClosingPopup = true;
                scope.isActive = false;
              }
            }
          });
        };

        /**
         * Au clic sur le bouton "créer le point" depuis la popup de création de point par coordonnées,
         * créé une feature openlayers à partir des coordonnées saisies puis lance l'exécution des règles métiers
         */
        scope.createPointByCoordinates = () => {
          if (Number.isFinite(scope.draftPointCoords.x)
              && Number.isFinite(scope.draftPointCoords.y)) {
            scope.XConstraint = scope.draftPointCoords.x;
            scope.YConstraint = scope.draftPointCoords.y;
            const x = scope.draftPointCoords.x;
            const y = scope.draftPointCoords.y;

            const hasSelectDistinctSrid = gaJsUtils.notNullAndDefined(scope.selectedsrid, 'name')
                && typeof scope.selectedsrid.name === 'string' && scope.selectedsrid.name.length > 0
                && scope.selectedsrid.name !== mapProjCode;
            const coordsInMapProj = hasSelectDistinctSrid ? ol.proj.transform([x, y], scope.selectedsrid.name, mapProjCode) : [x, y];

            const newFeature = new ol.Feature({
              geometry: new ol.geom.Point(coordsInMapProj),
            });
            const evt = new Event('drawend');
            evt.feature = newFeature;
            scope.preStartEndRules()(evt);
            gclayers.getDrawLayer().getSource().addFeature(newFeature);
          }
        };

        /**
         * Dans la popup de création d'un point par coordonnées, vérifie si le texte saisi dans les inputs sont bien des nombres
         * @return {boolean} true si le texte saisi dans les deux inputs sont des nombres
         */
        scope.isPointCoordinatesValid = () => {
          return Number.isFinite(scope.draftPointCoords.x) &&  Number.isFinite(scope.draftPointCoords.y);
        };

        /**
         * Au clic sur le bouton "Annuler" de la popup de création d'un point par coordonnées:<ul><li>
         */
        scope.cancelPointByCoordinates = () => {
          scope.reset();
        };

        /**
         * Active/désactive l'intéraction de dessin au changement du select du mode d'édition d'un point
         */
        scope.toggleDrawInteraction = () => {
          if (scope.drawinteraction && typeof scope.drawinteraction.setActive === 'function') {
            scope.drawinteraction.setActive(scope.drawMode === 'normal');
          }
        };


        /********************************************
         EDITION DE POINT PAR POSITIONNEMENT LINEAIRE
         ********************************************/

        /**
         * Au clic sur le bouton "créer un objet" (crayon), lorsque le mode de dessin est "positionnement linéaire"
         * Exécute les règles métiers d'initialisation {@link performRules}.
         * Ouvre la popup de création de point par positionnement linéaire
         * Créé la configuration d'un parcours réseau et les variables de la popup.
         * A la fermeture de la popup, les couches et les intéractions du parcours sont supprimées
         *  (nécessaire si clic sur "Annuler" ou appui touche "Escape")
         */
        const openPointCreationByDistance = () => {

          // ajoute la classe CSS 'btn-info' au bouton crayon
          scope.isActive = true;


          // lance les règles métier onInit
          scope.execrules();

          // variables fournies au composant gcpathselect
          scope.networkPath = {};
          scope.config = {
            netname: scope.network,
            minnodes: 2,
            maxnodes: 50,
            nodesincr: 1
          }

          // initialise les données de la popup "Positionnement linéaire"
          scope.pointByDistance = {
            distance: null,
            validators: {
              hasPath: false,
              hasPosition: false
            },
          };

          // empêche la double-exécution du callback onClose
          let isClosingPopup = false;
          // empeche la ré-ouverture de la popup
          scope.isCreationPopupOpened = true;

          extendedNgDialog.open({
            template:
                'js/XG/widgets/mapapp/bizedition/views/modals/modal.bizeditpoint.distance.html',
            className: 'ngdialog-theme-plain noclose bizeditpoint-modal',
            closeByDocument: false,
            draggable: true,
            showClose: false,
            title: $filter('translate')('bizedition.bydist.newModalTitle'),
            scope: scope,
            preCloseCallback: () => {
              if (!isClosingPopup) {
                bizeditProvider.removeMarkerLayer(scope.map);
                bizeditProvider.networkPathLayersCleanRemoval(scope.map);
                bizeditProvider.networkSelectInteractionRemoval(scope.map);
                scope.isCreationPopupOpened = false;
                isClosingPopup = true;
              }
            }
          });
        };

        /**
         * Au clic sur le bouton "Calculer" de la popup "Positionnement linéaire de l'objet ponctuel"
         * Place un marqueur à l'emplacement calculé du point sur le parcours réseau
         * Centre la carte sur le marqueur
         */
        scope.drawMarkerOnPathByDistance = () => {
          if (gaJsUtils.notNullAndDefined(scope.networkPath, 'fullData.path.geometry')) {
            bizeditProvider.drawMarkerOnPathByDistance(scope.map,
                scope.networkPath.fullData.userDirectionPath, scope.pointByDistance);
          } else {
            console.error('Aucun parcours réseau. networkPath = ', scope.networkPath);
          }
        };

        /**
         * Au clic sur le bouton "Annuler" de la popup "Positionnement d'un objet ponctuel",
         * purge et retire la layer du marqueur de l'emplacement du point
         * purge et retire les layers du parcours réseau
         * puis re-initialise le widget
         */
        scope.cancelPointByDistance = () => {
          scope.reset();
        };

        /**
         * Au clic sur le bouton "Créer le point" de la popup "Positionnement d'un objet ponctuel",
         * Créé un objet à partir de l'emplacement calculé
         */
        scope.createPointByDistance = () => {
          if (Array.isArray(scope.pointByDistance.coords)) {
            const newFeature = new ol.Feature({
              geometry: new ol.geom.Point(scope.pointByDistance.coords),
            });
            const evt = new Event('drawend');
            evt.feature = newFeature;
            scope.preStartEndRules()(evt);
            gclayers.getDrawLayer().getSource().addFeature(newFeature);
          }
        };

        /**
         * A la fin du parcours réseau,
         * on passe la variable à true pour permettre l'activation du bouton "Calculer"
         * de la popup "Positionnement de l'objet ponctuel"
         */
        scope.onNetworkPathFinish = () => {
          scope.pointByDistance.validators.hasPath = true;
          scope.pointByDistance.validators.hasPosition = false;
        };

        /**
         * Après un clic sur le bouton "Sélectionner le noeud amont" pour démarrer la saisie d'un parcours réseau,
         * le composant du parcours réseau envoie un évèmenent lors de l'activation du dessin du parcours.
         * Cet évènement permet de détecter quand l'utilisateur démarre une session de dessin de parcours.
         */
        scope.$on('networkPathDrawActivation',(event, isActivated) => {
          if (isActivated) {
            // exécute les règles métier onInit à l'activation du parcours réseau
            scope.execrules();
            scope.pointByDistance.validators.hasPath = false;
          }
        });

        /**
         * Gère l'activation du bouton "Calculer" de la popup "Positionnement linéaire de l'objet ponctuel"
         * @return {boolean|boolean} true si une distance est saisie et si le parcours réseau est valide
         */
        scope.isPointDistanceFormValid = () => {
          return Number.isFinite(scope.pointByDistance.distance) && scope.pointByDistance.validators.hasPath;
        };
      },
    };
  };

  gcelement.$inject = [
    'gclayers',
    '$translate',
    'SridFactory',
    '$timeout',
    'gcPopup',
    'EditRulesFactory',
    '$rootScope',
    '$filter',
    'gcInteractions',
    'extendedNgDialog',
    'gaJsUtils',
    'mapJsUtils',
    'bizeditProvider'
  ];
  return gcelement;
});
