'use strict';
define(function() {
  /**
   * ATTENTION,
   * ce widget possède des outils permettant de sélectionner plusieurs objets (modif. géométrique,
   * modif.attributaire)
   * Le 1er objet sélectionné, le 1er de la liste, est "editdescription.editedfeature".
   * Les autres objets, les "objets liés" sont "editdescription.relatedfeatures"
   * La distinction objet principal/objets liés a été prévue
   * pour l'unique cas particulier tronçon/regards.
   */
  var basemapwidget = function(
    gclayers,
    gcPopup,
    EditRulesFactory,
    ConfigFactory,
    ngDialog,
    $rootScope,
    $filter,
    $timeout,
    CopyPasteAttributeFactory,
    bizeditProvider,
    FeatureTypeFactory,
    RightsFactory,
    ObjectFilesFactory,
    $q,
    NetworkFactory,
    layersService,
    gaJsUtils,
    mapJsUtils,
    EditDescription
  ) {
    return {
      templateUrl: 'js/XG/widgets/mapapp/bizedition/views/bizeditwidget.html',
      restrict: 'A',
      link: function(scope) {
        scope.updatesToSave = false;
        const map = scope.map;
        scope.testbutton = true;
        scope.applyRules = {};
        scope.applyRules.value = true;

        // on doit définir ConfigName pour Représentation Filière (ANC) et
        // Cartographie des Branchements (BAC)
        if (!scope.ConfigName && $rootScope.xgos && $rootScope.xgos.sector && scope.map){
          if ($rootScope.xgos.sector==='anc' && scope.map.getTarget()==='rf_map'){
            scope.ConfigName = 'rf_bizeditwidget';
          }else if ($rootScope.xgos.sector==='bac' && scope.map.getTarget()==='map_branchement'){
            scope.ConfigName = 'branchement_bizeditwidget';
          }
        }

        scope.templatefeature = {
          type: 'Feature',
          geometry: {},
          properties: {},
        };

        // Theme des couches de données à charger dans le widget.
        scope.theme = '';

        // Indicateur du mode d'édition rapide
        scope.fastMode = { value: false };

        scope.workspace = {};

        // //////////////////////////////////////////////////////////////////
        //
        // Gestion de la configuration du widget
        //
        // //////////////////////////////////////////////////////////////////
        scope.config = {};

        /**
         * [cursor rajout du style crosshair sur le curseur]
         */
        scope.cursor = function() {
          if (scope.viseur) {
            $rootScope.$broadcast('gcChangeCursorMap', 'olEditorControlDrawPolygonActive');
          } else {
            $rootScope.$broadcast('gcChangeCursorMap', '');
          }
        };
        scope.startCusror = function() {
          $rootScope.$broadcast('gcChangeCursorMap','olEditorControlDrawPolygonActive');
        };
        scope.stopCusror = function() {
          $rootScope.$broadcast('gcChangeCursorMap', '');
        };
        scope.$watch('viseur', function(newval) {
          newval ? scope.startCusror() : scope.stopCusror();
        });

        // ////////Guide de la carte////////////
        /**
         * [createGuide création du guide de la carte]
         */
        scope.createGuide = () => {
          if (scope.line1 && scope.line2) {
            scope.element1.parentNode.removeChild(scope.element1);
            scope.element2.parentNode.removeChild(scope.element2);
            scope.coordXElement.parentNode.removeChild(scope.coordXElement);
            scope.coordYElement.parentNode.removeChild(scope.coordYElement);
          }
          scope.element1 = document.createElement('div');
          scope.element1.style.border = '0.5px dashed black';
          scope.element1.style.width = map.getSize()[0] * 2 + 'px';
          scope.element1.style.height = '1px';
          scope.element1.style.opacity = '0.35';
          scope.element2 = document.createElement('div');
          scope.element2.style.border = '0.5px dashed black';
          scope.element2.style.width = '1px';
          scope.element2.style.opacity = '0.5';
          scope.element2.style.height = map.getSize()[1] * 2 + 'px';
          scope.coordXElement = document.createElement('div');
          scope.coordXElement.style.fontWeight = 'bold';

          scope.coordXElement.style.left = '100px';
          scope.coordYElement = document.createElement('div');
          scope.coordYElement.style.fontWeight = 'bold';

          scope.line1 = new ol.Overlay({
            element: scope.element1,
            offset: [0, 0],
            positioning: 'center-center',
            stopEvent: false,
          });
          map.addOverlay(scope.line1);
          scope.line2 = new ol.Overlay({
            element: scope.element2,
            offset: [0, 0],
            positioning: 'center-center',
            stopEvent: false,
          });
          map.addOverlay(scope.line2);

          // scope.measureAngleElement.className = 'tooltip tooltip-measure';
          scope.coordX = new ol.Overlay({
            element: scope.coordXElement,
            offset: [200, 0],
            positioning: 'bottom-left',
          });
          map.addOverlay(scope.coordX);
          scope.coordY = new ol.Overlay({
            element: scope.coordYElement,
            offset: [5, -200],
            positioning: 'bottom-left',
          });
          map.addOverlay(scope.coordY);
        };
        /**
         * [updateGuide update la position des guide en fonction du mousemove]
         *
         * @param evt
         */
        scope.updateGuide = function(evt) {
          if (!scope.isGuide) {
            scope.stopGuide();
          }
          if (scope.line1 && scope.line2 && scope.coordX && scope.coordY) {
            // if(scope.line1.c!=null && scope.line1.c!=null ){
            try {
              scope.line1.setPosition(evt.coordinate);
              scope.line2.setPosition(evt.coordinate);
              scope.coordX.setPosition(evt.coordinate);
              scope.coordY.setPosition(evt.coordinate);
            } catch (e) {
              // console.info(e)
            }
            const positionX = parseFloat(
              document.getElementsByClassName('xy x ng-binding')[0].innerHTML
            );
            const positionY = parseFloat(
              document.getElementsByClassName('xy y ng-binding')[0].innerHTML
            );

            scope.coordXElement.innerHTML = String(positionX);
            scope.coordYElement.innerHTML = String(positionY);
          }
        };

        scope.activeGraticule2154 = function() {
          scope.grat2154 = new ol.Graticule({
            // the style to use for the lines, optional.
            strokeStyle: new ol.style.Stroke({
              color: 'rgba(255, 0, 0, 0.8)',
              width: 2,
              lineDash: [0.5, 4],
            }),
            projection: 'EPSG:2154',
            showLabels: true,
          });
          scope.grat2154.setMap(map);
        };
        scope.activeGraticule4326 = function() {
          scope.grat4326 = new ol.Graticule({
            // the style to use for the lines, optional.
            strokeStyle: new ol.style.Stroke({
              color: 'rgba(0,0,255,0.5)',
              width: 2,
              lineDash: [0.5, 4],
            }),
            showLabels: true,
            projection: 'EPSG:4326',
          });
          scope.grat4326.setMap(map);
        };

        /**
         * [guide start guide de la carte]
         */
        scope.guide = function() {
          map.on('pointermove', scope.updateGuide);
          scope.createGuide();
        };
        // à déplacer ou supprimer
        if (!('remove' in Element.prototype)) {
          Element.prototype.remove = function() {
            if (this.parentNode) {
              this.parentNode.removeChild(this);
            }
          };
        }

        /**
         * [stopGuide stop guide de la carte]
         */
        scope.stopGuide = function() {
          map.un('pointermove', scope.updateGuide);
          if (scope.line1 != null && scope.line2 != null) {
            scope.element1.remove();
            scope.element2.remove();
            scope.coordXElement.remove();
            scope.coordYElement.remove();
          }
          scope.line1 = null;
          scope.line2 = null;
          scope.coordY = null;
          scope.coordX = null;
        };

        scope.$watch('isGuide', function(newval) {
          newval ? scope.guide() : scope.stopGuide();
        });

        function checkApplyGuides(config) {
          config.isGuide ? scope.guide() : scope.stopGuide();
          config.viseur ? scope.startCusror() : scope.stopCusror();
        }
        // ////////Fin Guide de la carte////////////
        // ////////Guides orthogonaux /////////////

        /**
         * [penteLine calcul la pente d'une droite]
         *
         * @param coordinates
         * @return pente de la droite
         */
        scope.penteLine = function(coordinates) {
          return (
            (coordinates[1][1] - coordinates[0][1]) /
            (coordinates[1][0] - coordinates[0][0])
          );
        };

        /**
         * [updateGuideOrth création et mise à jour des guides orthogonaux]
         *
         * @param evt
         */
        scope.updateGuideOrth = function(evt) {
          if (scope.isGuideOrth && scope.editdescription && scope.editdescription.editedfeature) {
            scope.obj = {
              type: 'FeatureCollection',
              crs: {
                type: 'name',
                properties: {
                  name: 'EPSG:3857',
                },
              },
              features: [
                {
                  type: 'Feature',
                  id: 'orth.1',
                  geometry: {
                    type: 'LineString',
                    coordinates: [[scope.X1, scope.Y1], [scope.X11, scope.Y11]],
                  },
                },
                {
                  type: 'Feature',
                  id: 'orth.2',
                  geometry: {
                    type: 'LineString',
                    coordinates: [[scope.X2, scope.Y2], [scope.X22, scope.Y22]],
                  },
                },
              ],
            };

            if (!scope.isGuideOrth) {
              scope.stopGuideOrth();
            }

            const l = 1000 * map.getView().getResolution();

            const coords = getEditedFeatureCoordsByGeomType();
            if (scope.editdescription.editedfeature && coords && coords.length >= 3) {
              const coordinates = [
                coords[coords.length - 3],
                coords[coords.length - 2],
              ];

              let p1 = scope.penteLine(coordinates);
              if (p1 === 0) {
                p1 = 0.001;
              }
              const b1 = coordinates[0][1] - p1 * coordinates[0][0];
              const p2 = -1 / p1;
              const b2 = coordinates[1][1] - p2 * coordinates[1][0];
              scope.X1 = coordinates[1][0] - l;
              scope.Y1 = p1 * scope.X1 + b1;
              scope.X11 = coordinates[1][0] + l;
              scope.Y11 = p1 * scope.X11 + b1;
              scope.X2 = coordinates[1][0] - l;
              scope.Y2 = p2 * scope.X2 + b2;
              scope.X22 = coordinates[1][0] + l;
              scope.Y22 = p2 * scope.X22 + b2;
            } else if (scope.editdescription.editedfeature && coords.length === 2) {
              scope.X1 = coords[coords.length - 2][0];
              scope.Y1 = coords[coords.length - 2][1] - l;
              scope.X11 = coords[coords.length - 2][0];
              scope.Y11 = coords[coords.length - 2][1] + l;
              scope.X2 = coords[coords.length - 2][0] + l;
              scope.Y2 = coords[coords.length - 2][1];
              scope.X22 = coords[coords.length - 2][0] - l;
              scope.Y22 = coords[coords.length - 2][1];
            } else {
              scope.coords = evt.coordinate;
              scope.X1 = scope.coords[0];
              scope.Y1 = scope.coords[1] - l;
              scope.X11 = scope.coords[0];
              scope.Y11 = scope.coords[1] + l;
              scope.X2 = scope.coords[0] + l;
              scope.Y2 = scope.coords[1];
              scope.X22 = scope.coords[0] - l;
              scope.Y22 = scope.coords[1];
            }

            const coordFeat1 = [[scope.X1, scope.Y1], [scope.X11, scope.Y11]];
            const coordFeat2 = [[scope.X2, scope.Y2], [scope.X22, scope.Y22]];
            scope.obj.features[0].geometry.coordinates = coordFeat1;
            scope.obj.features[1].geometry.coordinates = coordFeat2;
            const parser = new ol.format.GeoJSON();
            const features = parser.readFeatures(scope.obj);

            const style = new ol.style.Style({
              stroke: new ol.style.Stroke({
                color: 'red',
                width: 1,
              }),
            });
            for (const feature of features) {
              feature.setStyle(style);
            }
            const feats = gclayers.getGuideLayer().getSource().getFeatures();
            for (const feature of feats) {
              if (feature.getId() === 'orth.1' || feature.getId() === 'orth.2') {
                gclayers.getGuideLayer().getSource().removeFeature(feature);
              }
            }
            gclayers.getGuideLayer().getSource().addFeatures(features);
            if (scope.editdescription.editedfeature) {
              const interactions = map.getInteractions().getArray();
              for (const interaction of interactions) {
                if (interaction instanceof ol.interaction.Snap) {
                  for (const feature of features) {
                    interaction.addFeature(feature);
                  }
                }
              }
            }
          }
        };

        /**
         * [startGuideOrth start guides orthogonaux]
         */
        scope.startGuideOrth = function() {
          if (!scope.isGuideOrth) {
            scope.stopGuideOrth();
          }
          if (!scope.isGuideFly) {
            scope.stopGuideFly();
          }
          map.on('pointermove', scope.updateGuideOrth);
        };

        /**
         * [stopGuideOrth stop les guides orthogonaux]
         */
        scope.stopGuideOrth = function() {
          map.un('pointermove', scope.updateGuideOrth);
          try {
            const feats = gclayers.getGuideLayer().getSource().getFeatures();
            for (const feature of feats) {
              if (feature.getId() === 'orth.1' || feature.getId() === 'orth.2') {
                gclayers.getGuideLayer().getSource().removeFeature(feature);
              }
            }
          } catch (e) {
            console.info('import layer pas encore chargé');
          }
        };

        scope.$watch('isGuideOrth', function(newval) {
          newval ? scope.startGuideOrth() : scope.stopGuideOrth();
        });

        // ////////////////////////////////////////Guide Fly
        scope.updateGuideFly = function(evt) {
          scope.obj1 = {
            type: 'FeatureCollection',
            crs: {
              type: 'name',
              properties: {
                name: 'EPSG:3857',
              },
            },
            features: [
              {
                type: 'Feature',
                id: 'fly.1',
                geometry: {
                  type: 'LineString',
                  coordinates: [[scope.X3, scope.Y3], [scope.X33, scope.Y33]],
                },
              },
              {
                type: 'Feature',
                id: 'fly.2',
                geometry: {
                  type: 'LineString',
                  coordinates: [[scope.X4, scope.Y4], [scope.X44, scope.Y44]],
                },
              },
            ],
          };

          if (!scope.isGuideFly) {
            scope.stopGuideFly();
          }

          const l = 1000 * map.getView().getResolution();

          if (scope.editdescription && scope.editdescription.editedfeature) {
            const coords = getEditedFeatureCoordsByGeomType();
            if (scope.editdescription.editedfeature && coords.length >= 2) {
              const coordinates = [
                coords[coords.length - 2],
                coords[coords.length - 1],
              ];
              let p1 = scope.penteLine(coordinates);
              if (p1 === 0) {
                p1 = 0.001;
              }
              const b1 = coordinates[0][1] - p1 * coordinates[0][0];
              const p2 = -1 / p1;
              const b2 = coordinates[1][1] - p2 * coordinates[1][0];
              scope.X3 = coordinates[1][0] - l;
              scope.Y3 = p1 * scope.X3 + b1;
              scope.X33 = coordinates[1][0] + l;
              scope.Y33 = p1 * scope.X33 + b1;
              scope.X4 = coordinates[1][0] - l;
              scope.Y4 = p2 * scope.X4 + b2;
              scope.X44 = coordinates[1][0] + l;
              scope.Y44 = p2 * scope.X44 + b2;
            } else {
              scope.coords = evt.coordinate;
              scope.X3 = scope.coords[0];
              scope.Y3 = scope.coords[1] - l;
              scope.X33 = scope.coords[0];
              scope.Y33 = scope.coords[1] + l;
              scope.X4 = scope.coords[0] + l;
              scope.Y4 = scope.coords[1];
              scope.X44 = scope.coords[0] - l;
              scope.Y44 = scope.coords[1];
            }

            const coordFeat1 = [[scope.X3, scope.Y3], [scope.X33, scope.Y33]];
            const coordFeat2 = [[scope.X4, scope.Y4], [scope.X44, scope.Y44]];
            scope.obj1.features[0].geometry.coordinates = coordFeat1;
            scope.obj1.features[1].geometry.coordinates = coordFeat2;
            const parser = new ol.format.GeoJSON();
            const features = parser.readFeatures(scope.obj1);
            const style = new ol.style.Style({
              stroke: new ol.style.Stroke({
                color: 'green',
                width: 1,
                lineDash: [3],
              }),
            });
            for (const feature of features) {
              feature.setStyle(style);
            }
            const feats = gclayers.getGuideLayer().getSource().getFeatures();
            for (const feature of feats) {
              if (feature.getId() === 'fly.1' || feature.getId() === 'fly.2') {
                gclayers.getGuideLayer().getSource().removeFeature(feature);
              }
            }
            gclayers.getGuideLayer().getSource().addFeatures(features);
          }
        };

        /**
         * Renvoie tout ou partie des coordonnées de la géométrie de l'objet en cours d'édition
         * en fonction de son type de géométrie
         * @return {{}} coordonnées de la ligne ou du point ou bien du premier sommet (cas du polygone)
         * @see updateGuideFly
         * @see updateGuideOrth
         */
        const getEditedFeatureCoordsByGeomType = () => {
          let coords = {};
          if (scope.editdescription.editedfeature
              && typeof scope.editdescription.editedfeature.getGeometry === 'function') {
            const geom = scope.editdescription.editedfeature.getGeometry();
            const sketchCoordinates = geom.getCoordinates();
            switch (geom.getType()) {
              case 'Polygon':
                coords = sketchCoordinates[0];
                break;
              case 'MultiPolygon':
                coords = sketchCoordinates[0][0];
                break;
              case 'LineString':
                coords = sketchCoordinates;
                break;
              case 'MultiLineString':
                coords = sketchCoordinates[0];
                break;
              case 'Point':
                coords = sketchCoordinates[0];
                break;
            }
          } else {
            console.error('Aucun objet en cours d\'édition. editdescription = ', scope.editdescription);
          }
          return coords;
        };

        scope.startGuideFly = function() {
          map.on('pointermove', scope.updateGuideFly);
          if (!scope.isGuideFly) {
            scope.stopGuideFly();
          }
        };

        scope.stopGuideFly = function() {
          map.un('pointermove', scope.updateGuideFly);
          try {
            const feats = gclayers.getGuideLayer().getSource().getFeatures();
            for (const feature of feats) {
              if (feature.getId() === 'fly.1' || feature.getId() === 'fly.2') {
                gclayers.getGuideLayer().getSource().removeFeature(feature);
              }
            }
          } catch (e) {
            console.info('import layer pas encore chargé');
          }
        };

        scope.$watch('isGuideFly', function(newval) {
          newval ? scope.startGuideFly() : scope.stopGuideFly();
        });

        // ////////////////////////////////////////Fin guide fly

        /**
         * applyConfiguration to current scope
         */
        const applyConfiguration = (cfg) => {
          scope.config = cfg;
          scope.config.viseur = cfg.viseur || false;
          scope.config.isGuide = cfg.isGuide || false;
          scope.config.isGuideOrth = cfg.isGuideOrth || false;
          scope.config.isGuideFly = cfg.isGuideFly || false;
          scope.config.disablingRulesAuthorized =
            cfg.disablingRulesAuthorized || false;
          if (cfg.rulesAppliedByDefault === undefined) {
            cfg.rulesAppliedByDefault = scope.applyRules.value = true;
          } else scope.applyRules.value = cfg.rulesAppliedByDefault;
          initWidgetFromConfig();
        };
        /**
         * Récupèration de la configuration.
         */
        scope.getConfig = () => {
          ConfigFactory.get('widgets', scope.ConfigName).then(
            (res) => {
              const cfg = res.data !== '' && res.status === 200 ? res.data : {};
              applyConfiguration(cfg);
              console.info('Configuration de bizeditwidget chargée : ', cfg);
            },
            (reason) => {
              console.error('Configuration de bizeditwidget non chargée: ' + reason);
            }
          );
        };

        /**
         * Ouvre l'IHM de la configuration et permet de la modifer.
         */
        scope.getNetworksThenOpenConfig = () => {
          const openConfig = () => {
            try {
              scope.themes = Object.keys(gclayers.getGroupLayer())
                .filter(groupKey => groupKey !== 'Techniques' && groupKey !== 'WebBackGround');
              ngDialog.open({
                template:
                    'js/XG/widgets/mapapp/bizedition/views/configuration.html',
                className: 'ngdialog-theme-plain width800 bizedit-config nopadding miniclose',
                scope: scope
              });
            } catch (e) {
              console.error(e.stack);
            }
            scope.config.viseur = scope.viseur;
            scope.config.isGuide = scope.isGuide;
            scope.config.isGuideOrth = scope.isGuideOrth;
            scope.config.isGuideFly = scope.isGuideFly;
          };
          // KIS-3378: Compense la mauvaise valeur par défaut de NetworkFactory.get
          NetworkFactory.get(false).then(
            () => {
              scope.networks = NetworkFactory.resources.networks.map(net => net.name);
              openConfig();
            },
            err => {
              scope.networks = [];
              console.log(err.data);
              openConfig();
            }
          );
        };

        /**
         * Sauve dans le fichier de configuration, la configuration presente dans le scope courant.
         */
        scope.saveconfig = function() {
          console.log(scope.ConfigName);
          ConfigFactory.add(scope.config, 'widgets', scope.ConfigName).then(
            function(res) {
              require('toastr').success(res.data);
              initWidgetFromConfig();
            },
            function(reason) {
              require('toastr').error(reason);
            }
          );
        };

        /**
         * Initialise le widget à partir de l'objet configuration.
         */
        function initWidgetFromConfig() {
          getLayersOfTheme();
          getGuides();
          const obj = {
            snaptolerance: scope.config.snaptolerance,
            viseur: scope.config.viseur,
            isGuide: scope.config.isGuide,
            isGuideOrth: scope.config.isGuideOrth,
            isGuideFly: scope.config.isGuideFly,
          };
          // On utilise l'objet map pour transmettre l'information de
          // configuration dans la règle snapOn.
          map.set(scope.config.theme, obj);
          checkApplyGuides(scope.config);
        }

        /**
         * Récupération des couches du theme d'édition
         */
        function getLayersOfTheme() {
          scope.theme = scope.config.theme;
          const isAdmin = $rootScope.xgos && ($rootScope.xgos.isroot || $rootScope.xgos.isadmin);
          FeatureTypeFactory.get().then(
            featureTypes => {
              // KIS-3196: si le composant n’est pas publié le composant ne doit pas être visible dans la liste déroulante de l'édition métier
              scope.themeFtis = featureTypes.filter(ft => ft.theme === scope.theme && ft.published
                    && RightsFactory.isAllowedToReadOrWriteFeatureType(ft, isAdmin, $rootScope.xgos.user));
            }
          );
        }

        function getGuides() {
          scope.viseur = scope.config.viseur;
          scope.isGuide = scope.config.isGuide;
          scope.isGuideOrth = scope.config.isGuideOrth;
          scope.isGuideFly = scope.config.isGuideFly;
        }

        // ///////////////////////////////////////////////////////////////////
        //
        // FIN CONFIGURATION du widget
        //
        // ///////////////////////////////////////////////////////////////////

        // //////////////////////////////////////////////////////////////////
        //
        // Gestion Règles métiers.
        //
        // //////////////////////////////////////////////////////////////////

        // Objets contenant des references vers des objets d'un composant
        // d'édition.
        scope.editpolygon = {};
        scope.editline = {};
        scope.editpoint = {};
        scope.updateComponentInfos = {};
        scope.reverseComponentInfos = {};
        scope.updateAttrsComponentInfos = {};
        scope.removeComponentInfos = {};
        scope.deposeComponentInfos = {};
        scope.transformComponentInfos = {};

        /**
         * @type Object contenant les informations sur l'édition en cours.
         *       editedfeature : Object principal en cours d'édition.
         *
         * relatedfeatures : Objets liés à l'objet principal et destinés à être
         * sauvés avec l'objet principal. (array of
         * {shareObject:shareObjectName, shareObjects:[], editType:'', feature:
         * ol.Feature, fti:featureTypeInfo} )
         *
         * shareObjects: objets differents de l'objet principal ecrits et lus
         * par certaines règles métiers. (array of {shareObject:shareObjectName,
         * editType:'', feature: ol.Feature, fti:featureTypeInfo} )
         *
         * interactions: interactions ajoutées à la map par les règles métiers.
         */
        const editdescriptionTemplate = {
          theme: '',
          editType: '',
          fastMode: false,
          fti: undefined,
          editedfeature: undefined,
          relatedfeatures: [],
          shareObjects: [],
          interactions: []
        };

        // Méthode appelée par les composant d'édition lors de leur activation
        // pour créer un nouvel objet décrivant l'action d'édition .
        scope.createeditdescription = function() {
          scope.editdescription = angular.copy(editdescriptionTemplate);
          scope.editdescription.fastMode = scope.fastMode.value;
          scope.editdescription.theme = scope.theme;
          //$timeout(function(){scope.$apply();},0); // necessaire pour avoir l'instance de
          // 'editdescription' disponible juste après son
          // instanciation.
          return scope.editdescription;
        };

        function boutonDroit() {
          const Valider = [
            'Valider',
            function() {
              scope.save();
            },
          ];
          const menu = scope.menuContext;
          if (angular.isDefined(menu)) {
            if (scope.menuContext.length >= 3) {
              scope.menuContext.splice(0, scope.menuContext.length - 2);
            }
            menu.unshift(Valider);
          }
        }

        /**
         * Appelée par les composants de CREATION d'objet (bizeditpont,
         * bizeditline, bizeditpolygon) (corrspond à 'execrules' dans les
         * directives de création).
         *
         * Crée un objet editdescription décrivant l'action d'édtion courante,
         * appelle les règles métier d'initialisation , s'abonne aux evenement
         * de début et de fin de dessin permettant de lancer les règles métiers
         * correspondantes.
         *
         * @param {string} editType: type de geométrie de l'objet saisie.
         */
        scope.performRules = function(editType) {
          if (editType === '' || scope.selectfti === undefined) return;

          // gclayers.getDrawLayer().getSource().clear();
          scope.editdescription = angular.copy(editdescriptionTemplate);
          scope.editdescription.editType = editType;
          scope.editdescription.fti = scope.selectfti;
          scope.editdescription.fastMode = scope.fastMode.value;
          scope.editdescription.theme = scope.theme;

          if (editType === 'add') {
            if (scope.selectfti.typeInfo === 'POLYGON') {
              if (!scope.editpolygon.active) return;
            } else if (scope.selectfti.typeInfo === 'LINE') {
              if (!scope.editline.active) return;
            } else if (scope.selectfti.typeInfo === 'POINT') {
              if (!scope.editpoint.active) return;
            }
          }

          // appelle les règles métier d'initialisation
          EditRulesFactory.executeInitRules(scope.editdescription, scope.selectfti, map).then(
            () => {
              if (editType === 'add') {
                addEditAddListeners(scope.editdescription);
              }
            });
        };

        function resetAddAction() {
          scope.reset();
          scope.$broadcast('runAdd', { geomtype: scope.selectfti.typeInfo });
        }


        /**
         * Réinitialiser l'action d'ajout quand on est dans ce mode.
         */
        const ifAddResetAddAction = () => {
          if (scope.editdescription.editType === 'add') {
            // -- Une première fois pour désactiver la commande en cours.
            resetAddAction();
            // -- Une deuxième fois pour réactiver la commande en cours.
            $timeout(resetAddAction, 250);
          }
        };


        /**
         * Appelée à l'evenement 'drawstart' (début de saisie) pour lancer les
         * règles métiers correspondantes.
         *
         * @param {ol.interaction.Draw.Event} evt
         */
        scope.performStartRules = (evt) => {
          bizeditProvider.checkEditedFeature(evt.feature, map).then((res) => {
            if (!res.restrictionOk) {
              ifAddResetAddAction();
            }
            else {
              removeEditAddListers(scope.editdescription);
              scope.editdescription.editedfeature = evt.feature;

              const params = {};
              params.evt = evt;

              EditRulesFactory.executeStartRules(scope.editdescription, scope.selectfti, map, params).then(
                () => {
                  addEditAddListeners(scope.editdescription);
                },
                () => {
                  ifAddResetAddAction();
                }
              );
            }
          });
        };


        /**
         * Appelée à l'evenement 'drawstart' dans le cas de création d'un point.
         * Jusqu'à présent le drawStart n'est pas appelé, mais pour vérifier que
         * les règles onInit sont ok, il faut exécuter le PreStartRules (cela
         * permet de gérer le snap obligatoire pour un point).
         *
         * @param {ol.interaction.Draw.Event} evt
         */
        scope.performPreStartAndEndRules = (evt) => {
          bizeditProvider.checkEditedFeature(evt.feature, map).then((res) => {
            if (!res.restrictionOk) {
              ifAddResetAddAction();
            }
            else {
              removeEditAddListers(scope.editdescription);
              scope.editdescription.editedfeature = evt.feature;

              const params = {};
              params.evt = evt;
              params.executionType = 'onlyPreStart';

              EditRulesFactory.executeStartRules(scope.editdescription, scope.selectfti, map, params).then(
                () => {
                  scope.performEndRules(evt);
                },
                () => {
                  ifAddResetAddAction();
                }
              );
            }
          });
        };


        function afterEndRulesOk() {
          // Si mode de creation rapide, on sauve immediatement
          if (scope.editdescription.fastMode) {
            scope.save();
          }
          // Sinon
          else {
            // Ecoute à nouveau des evenements de creation au cas ou
            // l'utilisateur desire modifier l'action de création existante
            // addEditAddListeners(scope.editdescription);//pose probleme car il
            // faudra retirer les ecouteurs avant de sauver.
            finalizeRules();
          }
        }
        // Exécute les règles sur related features d'un objet `editdescription`.
        function executeRulesForRelatedFeatures(editdescription, toByPassRules) {
          const defer = $q.defer();
          let index = 0;
          // Fonction récursive pour exécuter les règles une par une
          function executeNext() {
            if (index < editdescription.relatedfeatures.length) {
              let relatedFeat = editdescription.relatedfeatures[index];
              // Get template for the related feature
              relatedFeat = EditDescription.getTemplateRelatedFeature(relatedFeat,editdescription);

              EditRulesFactory.executeEndRules(relatedFeat, relatedFeat.fti, map, toByPassRules).then(
                () => {
                  index++;
                  executeNext();
                },
                (errorReason) => {
                  console.error('Error in related feature rule execution:', errorReason);
                  defer.reject(errorReason);
                }
              );
            } else {
              defer.resolve();
            }
          }
          executeNext();

          return defer.promise;
        }
        /**
         * Appelée à l'evenement 'drawend' (fin de saisie) pour lancer les
         * règles métiers correspondantes.
         *
         * @param {ol.interaction.Draw.Event} evt
         */
        scope.performEndRules = function(evt) {

          removeEditAddListers(scope.editdescription);

          // Si méthode appélée par ecoute de l'evenement drawEnd emis par
          // l'interaction draw
          if (evt !== undefined) {
            if (scope.editdescription.editedfeature === undefined) {
              scope.editdescription.editedfeature = evt.feature;
            } else {
              scope.editdescription.editedfeature.setGeometry(
                evt.feature.getGeometry()
              );
              boutonDroit();
              scope.uploadfile = {};
            }
          }
          // Sinon, cette méthode peut être appelée esxplicitement par
          // d'autres outils de saisie et
          // alors editdescription contient ici le feature.
          const toByPassRules = ['MergeIntersectingLines', 'MergeRemainingLines', 'CutIntersectingLine',
            'MoveObjectOnEnd', 'ObjectNotAllowedAtInterse'];
          EditRulesFactory.executeEndRules(scope.editdescription, scope.selectfti, map).then(
            () => {
              if(Array.isArray(scope.editdescription.relatedfeatures) && scope.editdescription.relatedfeatures.length>0){
                executeRulesForRelatedFeatures(scope.editdescription, toByPassRules).then(() => {
                  afterEndRulesOk();
                })
              } else {
                afterEndRulesOk();
              }
            },
            (errorReason) => {

              // Règles pour lesquelles un échec doit provoquer la fin de l'édition en cours
              const mandatoryRules = ['checkNbConnectionOfSnappedPoint', 'objectNotAllowedAtIntersection',
                'mustNotSelfIntersect', 'mustNotSelfOverlap'];

              if (errorReason && errorReason.type === 'zoneInterdite') {
                $timeout(function() {
                  require('toastr').error($filter('translate')('rulecfg.cancelDraw'));
                  scope.reset();
                }, 700);
              } else {
                if (mandatoryRules.includes(errorReason)) {
                  const failOnMandatoryRuleLog = $filter('translate')('rulecfg.ruleError')
                      + errorReason + '. ' + $filter('translate')('rulecfg.cancelDraw');
                  console.info(failOnMandatoryRuleLog);
                }
                onRuleError(errorReason);
              }
            }
          );
        };

        // ///////// Gestion des écouteurs d'evenements des interactions de
        // CREATION d'objets ///////////////////////
        /**
         * Ajoute les ecouteurs d'evenement de creation d'objets
         *
         * @param {object} editdescription
         */
        function addEditAddListeners(editdescription) {
          if (editdescription.editType === 'add') {
            if (editdescription.fti.typeInfo === 'POLYGON') {
              addPolyDrawListeners();
            } else if (editdescription.fti.typeInfo === 'LINE') {
              addLineDrawListeners();
            } else if (editdescription.fti.typeInfo === 'POINT') {
              addPointDrawListeners();
            }
          }
        }

        /**
         * Retire les ecouteurs d'evenement de creation d'objets
         *
         * @param {object} editdescription
         */
        function removeEditAddListers(editdescription) {
          if (editdescription.editType === 'add') {
            if (editdescription.fti.typeInfo === 'POLYGON') {
              removePolyDrawListeners();
            } else if (editdescription.fti.typeInfo === 'LINE') {
              removeLineDrawListeners();
            } else if (editdescription.fti.typeInfo === 'POINT') {
              removePointDrawListeners();
            }
          }
        }

        /**
         * Méthodes utilitaires d'ajout et de retrait des ecouteur d'evenements
         * de début et de fin de saisie pour une CREATION d'objet.
         *
         */

        function addPolyDrawListeners() {
          // Utilisation des évenements de Interaction.Draw utilisés par les
          // composants de creation de features.
          if (Object.prototype.hasOwnProperty.call(scope.editpolygon, 'drawinter')) {
            if (scope.editpolygon.drawinter !== undefined && scope.editpolygon.drawinter.on !== undefined) {
              scope.editpolygon.drawinter.on('drawstart',scope.performStartRules);
              scope.editpolygon.drawinter.on('drawend', scope.performEndRules);
            }
          }
        }
        function removePolyDrawListeners() {
          if (Object.prototype.hasOwnProperty.call(scope.editpolygon, 'drawinter')) {
            if (scope.editpolygon.drawinter !== undefined
              && scope.editpolygon.drawinter.un !== undefined) {
              scope.editpolygon.drawinter.un('drawstart',scope.performStartRules);
              scope.editpolygon.drawinter.un('drawend', scope.performEndRules);
            }
          }
        }
        function addLineDrawListeners() {
          // Utilisation des évenements de Interaction.Draw utilisés par les
          // composants de creation de features.
          if (Object.prototype.hasOwnProperty.call(scope.editline, 'drawinter')) {
            if (scope.editline.drawinter !== undefined
              && scope.editline.drawinter.on !== undefined) {
              scope.editline.drawinter.on('drawstart', scope.performStartRules);
              scope.editline.drawinter.on('drawend', scope.performEndRules);
            }
          }
        }
        function removeLineDrawListeners() {
          if (Object.prototype.hasOwnProperty.call(scope.editline, 'drawinter')) {
            if (scope.editline.drawinter !== undefined
              && scope.editline.drawinter.un !== undefined) {
              scope.editline.drawinter.un('drawstart', scope.performStartRules);
              scope.editline.drawinter.un('drawend', scope.performEndRules);
            }
          }
        }
        function addPointDrawListeners() {
          // Utilisation des évenements de Interaction.Draw utilisés par les
          // composants de creation de features.
          if (Object.prototype.hasOwnProperty.call(scope.editpoint, 'drawinter')) {
            if (scope.editpoint.drawinter !== undefined
              && scope.editpoint.drawinter.on !== undefined) {
              scope.editpoint.drawinter.on('drawend', scope.performPreStartAndEndRules);
            }
          }
        }
        function removePointDrawListeners() {
          if (Object.prototype.hasOwnProperty.call(scope.editpoint, 'drawinter')) {
            if (scope.editpoint.drawinter !== undefined
              && scope.editpoint.drawinter.un !== undefined) {
              scope.editpoint.drawinter.un('drawend', scope.performEndRules);
            }
          }
        }

        // //////////////////////////////////////////////////////
        //
        // Fonction appelées à la fin de l'execution des règles.
        //
        // //////////////////////////////////////////////////////
        function onRuleError() {
          removeWfsLayers();
          removeInteractions();
          gclayers.clearEditLayer();
          scope.reset();
        }


        const removeWfsLayers = () => {
          const layersToRemove = [];
          const layers = map.getLayers().getArray();
          for (const layer of layers) {
            if (layer.type === 'wfs') {
              layersToRemove.push(layer);
            }
          }
          for (const layerToRemove of layersToRemove) {
            map.removeLayer(layerToRemove);
          }
        };


        /**
         * Utilitaire: retire toutes les interactions de la carte qui ont pu
         * être activées au cours d'une session d'édition.
         *
         */
        function removeInteractions() {
          try {
            for (const interaction of scope.editdescription.interactions) {
              if (interaction !== undefined) {
                map.removeInteraction(interaction);
              }
            }
            // Envoi de l'information de l'eventuelle interaction snap retirée
            // de la carte.
            map.dispatchEvent({ type: 'snapRemovedEvent' });

            if (Object.prototype.hasOwnProperty.call(scope.editpolygon, 'drawinter')
               && scope.editpolygon.drawinter !== undefined) {
              map.removeInteraction(scope.editpolygon.drawinter);
              scope.editpolygon.active = false;
            }
            if (Object.prototype.hasOwnProperty.call(scope.editline, 'drawinter')
              && scope.editline.drawinter !== undefined) {
              map.removeInteraction(scope.editline.drawinter);
              scope.editline.active = false;
            }
            if (Object.prototype.hasOwnProperty.call(scope.editpoint, 'drawinter')
              && scope.editpoint.drawinter !== undefined) {
              map.removeInteraction(scope.editpoint.drawinter);
              scope.editpoint.active = false;
            }

            // L'interaction des composants suivants se trouve dans
            // scope.editdescription.interactions (a déjà été retiré par les
            // instructions précedentes dans cette fonction)
            scope.removeComponentInfos.active = false;
            scope.deposeComponentInfos.active = false;
            scope.updateComponentInfos.active = false;
            scope.reverseComponentInfos.active = false;
            scope.transformComponentInfos.active = false;
            scope.updateAttrsComponentInfos.active = false;
          } catch (err) {}
        }

        /**
         * Ouverture consécutives des popups d'édition des features liées à
         * notre feature principale
         * La popup d'une feature attend que la précédente soit terminée.
         * Lorsque le composant principal possède la règle setObjectOnExtremity,
         * on évalue l'option hidePopupAttribute avant l’affichage des popups amont et aval.
         * @param indexRelatedFeature rang de l'objet relié
         * dans le tableau des objets relatifs de l'objet principal
         */
        const editRelatedFeature = (indexRelatedFeature) => {
          if (scope.editdescription.relatedfeatures
            && Array.isArray(scope.editdescription.relatedfeatures)
            && indexRelatedFeature < scope.editdescription.relatedfeatures.length
              && !hideRelatedFeatAttributePopup(scope.editdescription.fti)) {
            if (scope.editdescription.relatedfeatures[indexRelatedFeature].isNew) {
              scope.openpopupattribute2(scope.editdescription.relatedfeatures[indexRelatedFeature].feature,
                scope.editdescription.relatedfeatures[indexRelatedFeature].fti, indexRelatedFeature)
                .then(() => {
                  editRelatedFeature(indexRelatedFeature+1);
                });
            } else {
              editRelatedFeature(indexRelatedFeature+1);
            }
          }
        };

        /**
         * Appelée à la fin de l'éxécution des règles métiers 'end' après une
         * CREATION d'objet.
         *
         */
        function finalizeRules() {
          // en commentaire si on veut eventuellement redessiner pour modifier
          // l'existant, mais il faut alors gérer les ecouteurs d'evenement de
          // dessin.
          removeWfsLayers();
          removeInteractions();

          // propriété servant à déclencher l'ouverture des popups d'édition attributaire des objets liés
          // uniquement après exécution des règles postValidation de l'objet principal (cf. bonus KIS-2818)
          scope.editdescription.editedfeature.set('isMainObject', true);

          // la popup attributaire du 1er objet lié ne doit pas s'ouvrir à la validation de la popup attributaire de l'objet principal
          // mais bien à la fin de l'exécution des règles onPostValidation de l'objet principal (cf. bonus KIS-2818)
          scope.openpopupattribute2(
            scope.editdescription.editedfeature,
            scope.editdescription.fti
          ).then(() => {
            if (scope.currentFeature.get('isMainObject') && !scope.isCheckingPostValidationRules) {
              editRelatedFeature(0);
            }
          });
        }

        // /////////////////////////////////////////////////////////////////////////////////
        //
        // Méthodes utilisées dans l'interface de presentation des objets en
        // cours d'édition
        //
        // /////////////////////////////////////////////////////////////////////////////////

        // .
        /**
         * Mise en évidence de l'objet édité sur la carte
         * uniquement si la popup d'édition des attributs n'est pas affichée.
         * Lorsque cette popup est ouverte, l'objet édité reste en surbrillance et
         * il n'est pas possible de mettre en surbrillance un autre objet.
         * Pour pouvoir mettre en surbrillance plusieurs objets non enregistrés (sans id),
         * une refonte de la méthode {@link gclayers.removehighLightFeatures} est nécessaire
         * @param {ol.Feature} feature objet en cours d'édition
         */
        scope.highLightFeature = (feature) => {
          if (!scope.isAttributePopupOpen) {
            gclayers.addhighLightFeature(feature);
          }
        };

        /**
         * Suppression de la mise en évidence de l'objet édité sur la carte
         * uniquement si la popup d'édition des attributs n'est pas affichée.
         * Lorsque cette popup est ouverte, l'objet édité doit rester en surbrillance.
         * Pour pouvoir mettre en surbrillance plusieurs objets non enregistrés (sans id),
         * une refonte de la méthode {@link gclayers.removehighLightFeatures} est nécessaire
         * @param {ol.Feature} feature objet en cours d'édition
         */
        scope.removehighLightFeature = (feature) => {
          if (!scope.isAttributePopupOpen) {
            gclayers.removehighLightFeatures(feature);
          }
        };

        /**
         * Méthode permettant de retirer un objet édité depuis le tableau des
         * objets édité ihm du widget afin d'éviter son enregistrement en base
         * de données.
         *
         * @param {object|ol.Feature} f feature
         * @param {string} type type de l'édition en cours ('add' ou 'new')
         */
        scope.removeFromEditDescription = function(f, type) {
          const feature = type === 'editedfeature' ? f : (f.hasOwnProperty('feature') ? f.feature : null);
          if (feature) {
            scope.removehighLightFeature(feature);
          }
          if (scope.editdescription.editType === 'add'
            && scope.editdescription.editedfeature === feature) {
            scope.reset();
          } else if (scope.editdescription.editedfeature === feature) {
            const removedFeatures = scope.editdescription.relatedfeatures.splice(0,1);
            if (Array.isArray(removedFeatures) && removedFeatures.length === 1) {
              scope.editdescription.editedfeature = removedFeatures[0].feature;
              removeFromDrawAndSelectLayers(feature);
            } else {
              scope.reset();
            }
          } else {
            //-- Ne pas transformer ce for(ind=0...) en for( of ),
            //-- on a besoin de l'indice pour le splice.
            for (let ind = 0;
              ind < scope.editdescription.relatedfeatures.length; ind++) {
              const relatedFeature = scope.editdescription.relatedfeatures[ind];
              if (relatedFeature.feature === feature
                  && f.hasOwnProperty('fti') && relatedFeature.fti.uid === f.fti.uid
                  && f.hasOwnProperty('editType') && f.editType === relatedFeature.editType) {
                scope.editdescription.relatedfeatures.splice(ind, 1);
                removeFromDrawAndSelectLayers(feature);
                break;
              }
            }
          }
        };

        /**
         * Méthode appelé par l'interface de presentation des objets édité et
         * permettant d'ouvrir la fiche attributaire d'un objet édité.
         *
         * @param {ol.Feature} feature objet principal/lié dont on veut éditer les attributs
         * @param {object} fti composant de l'objet édité
         * @param {number} indexFeature rang de l'objet dans le tableau d'objets liés (-1 si objet principal)
         */
        scope.editAttribute = function(feature, fti, indexFeature = -1) {
          if (scope.editdescription.editType === 'add') {
            if (
              !angular.isUndefined(scope.allRecords) &&
              !angular.isUndefined(scope.allRecords[scope.currentFti.uid]) &&
              !angular.isUndefined(
                scope.allRecords[scope.currentFti.uid].adds
              ) &&
              !angular.isUndefined(
                scope.allRecords[scope.currentFti.uid].adds.features
              )
            ) {
              if (
                scope.allRecords[scope.currentFti.uid].adds.features.length > 0
              ) {
                scope.editdescription.editedfeature.id_ =
                  scope.allRecords[scope.currentFti.uid].adds.features[0].id;
                // changement du type d'édition uniquement si l'objet principal est sauvegardé
                if (scope.editdescription.editedfeature.saved == true) {
                  scope.editdescription.editType = 'updateattributes';
                }
              }
            }
          }
          scope.openpopupattribute2(feature, fti, indexFeature);
        };

        // //////////////////////////////////////////////////////
        //
        // Méthodes pour l'édition attributaire
        //
        // //////////////////////////////////////////////////////

        // Référence vers la popup attributaire d'un objet.
        scope.p = undefined;
        scope.uploadfile = {};

        /**
         * get saved object
         *
         * @param {object} fti
         */
        scope.saveOnCopyPasteAttribute = function(fti) {
          const rules = fti.rules;
          rules.find(function(attribute) {
            if (attribute.name === 'CopyPasteAttribute') {
              const uId = scope.editdescription.fti.uid;
              const currentObj = scope.currentProperties;
              const savedObj = CopyPasteAttributeFactory.GetStoredObject(uId);
              if (savedObj && currentObj) {
                for (let prop in savedObj) {
                  if (!currentObj.hasOwnProperty(prop)) {
                    scope.showResetButton = true;
                    currentObj[prop] = savedObj[prop];
                  }
                }
              }
            }
          });
        };

        /**
         * Ouvre la popup d'édition des attributs
         * @param {ol.Feature} feature objet principal/lié dont on veut éditer les attributs
         * @param {object} fti composant de l'objet édité
         * @param {number} indexFeature rang de l'objet dans le tableau d'objets liés (-1 si objet principal)
         */
        scope.openpopupattribute2 = function(feature, fti, indexFeature = -1) {
          // prépare le stockage des attachments de l'objet principal et des objets liés
          scope.isAbleToSaveRelatedFeatureAttachments = true;
          if (!scope.uploadfile) {
            scope.uploadfile = {};
          }
          if (!scope.uploadfile[fti.uid]) {
            scope.uploadfile[fti.uid] = {};
          }
          scope.indexFeature = indexFeature;
          scope.uploadfile[fti.uid][indexFeature] = {};

          scope.editdescription.messages = [];
          if (scope.p !== undefined && scope.p.element != null) {
            scope.p.destroy();
          }
          scope.currentFti = fti;
          scope.currentFeature = feature;
          if ($rootScope.xgos) {
            scope.isAdmin = $rootScope.xgos.isroot || $rootScope.xgos.isadmin;
            scope.authorizedReadAttributes =RightsFactory.getUserWriteOrReadRightsAttributes($rootScope.xgos.user, fti, scope.isAdmin, true);
            scope.authorizedWriteAttributes = RightsFactory.getUserWriteOrReadRightsAttributes($rootScope.xgos.user, fti, scope.isAdmin);
            scope.authorizedWriteAttributesNames = scope.authorizedWriteAttributes.map(att => att.name);
            // construit les objets de configuration des champs de la popup
            // ces champs sont nécessaires pour l'utilisation des champs attachments
            scope.createAttributePopupFieldDatas(fti, indexFeature, null);
          } else {
            scope.authorizedReadAttributes = [];
            console.error('$rootScope.xgos = ', $rootScope.xgos);
          }

          scope.currentProperties = Object.assign({},feature.getProperties());
          scope.originalCurrentProperties = feature.getProperties();

          scope.saveOnCopyPasteAttribute(fti);
          scope.deferPopupOpen = $q.defer();

          scope.configurationTab = false;
          ObjectFilesFactory.getObjectFilesFiltredByAuthorizedAttributes(
            fti.uid,scope.authorizedReadAttributes).then(res =>{
            scope.configurationTab = res;

            // construit les objets de configuration des champs de la popup
            // ces champs sont nécessaires pour l'utilisation des champs attachments
            if (scope.configurationTab) {
              scope.createAttributePopupFieldDatas(fti, indexFeature,
                scope.configurationTab.configuration);
            }
          }).finally(() => {
            // KIS-2841 [DEA - Edition] :
            //   surbrillance sur l'objet dont la fiche attributaire est ouverte
            scope.highLightFeature(feature);

            scope.isAttributePopupOpen = true;

            // booleen pour éviter d'exécuter 2x le callback onClose
            let isClosing = false;

            // KIS-2987: la configuration de la fiche-objet contient la largeur initiale de la popup
            // => affiche la popup après la récupération de la configuration de la fiche-objet.
            let hasTabs = false;
            let popupWidth = null;
            if (gaJsUtils.notNullAndDefined(scope.configurationTab) && typeof scope.configurationTab !== 'boolean'
                && Array.isArray(scope.configurationTab.configuration) && scope.configurationTab.configuration.length > 0) {
              hasTabs = true;
              const firstConf = scope.configurationTab.configuration[0];
              if (firstConf.popupWidth > 0 && firstConf.popupWidth < window.innerWidth) {
                popupWidth = firstConf.popupWidth;
              }
            }

            // affecte une classe particulière à la gcPopup en présence d'une fiche-objet
            scope.p = gcPopup.open({
              scope: scope,
              title: scope.currentFti ? scope.currentFti.alias : $filter('translate')('edition.popup_title'),
              template:
                  'js/XG/widgets/mapapp/bizedition/views/attribute_popup2.html',
              showClose: true,
              minimizeMaximize: true,
              resizable: false,
              minWidth: hasTabs ? 430 : 400,
              minHeight: 300,
              width: popupWidth,
              className: 'attribute-popup' + (hasTabs ? ' objectFilePopup' : ' nomaximize'),
              onclose: function() {
                if (!isClosing) {
                  scope.isAttributePopupOpen = false;
                  scope.removehighLightFeature(feature);
                  scope.deferPopupOpen.resolve();
                  isClosing = true;
                  delete scope.indexFeature;
                }
              },
            });

            // Ajustement de la hauteur du tab-content dans le cas de plusieurs lignes d'onglets
            if (hasTabs) {

              // sélecteur de la règle CSS que l'on va modifier
              // on ne peut pas modifier directement le style de l'élement HTML car il est modifiable par le redimensionnement vertical
              const cssRuleIdentifier = '.gcPopup.objectFilePopup .popup-template .myBody .popupContent.attributes-info-box .scrolledTabs .tab-content';
              bizeditProvider.adjustObjectFileTabContentHeight(scope.p.popup.iddiv, cssRuleIdentifier,'scrolledTabs', 3);
            }
          });
          return scope.deferPopupOpen.promise;
        };

        /**
         * Evalue si un objet openLayers contient les mêmes propriétés avec les mêmes valeurs
         * depuis l'ouverture de la popup d'édition des attributs
         * @param {ol.Feature} editedFeature objet openLayers (objet principal ou objet lié)
         * @param {object} originalProps objet contenant les propriétés
         *           de l'objet openLayers avant édition
         * @return {boolean} true si une propriété a été ajoutée/supprimée dans l'objet édité
         * ou bien si la valeur d'une propriété a été modifiée.
         * KIS-3110 BONUS: active le bouton "Sauvegarder" quand une valeur d'attribut est supprimée
         */
        const isFeaturePropertiesChanged = (editedFeature, originalProps) => {
          const properties = editedFeature.getProperties();

          // vérifie si au moins une propriété a été modifiée dans l'une ou l'autre des directions.
          return Object.keys(properties).some(propName => properties[propName] !== originalProps[propName])
              || Object.keys(originalProps).some(propName => originalProps[propName] !== properties[propName]);
        };

        /**
         * KIS-3110: reécriture de cette méthode verbeuse
         */
        const checkFeatureHasBeenModified = () => {

          const editedOlFeature = scope.editdescription.editedfeature;
          const olFeatInitProps = scope.editdescription.editedfeature0;

          let componentHasModifiedAttributes = !olFeatInitProps;

          if (!componentHasModifiedAttributes) {
            componentHasModifiedAttributes = isFeaturePropertiesChanged(editedOlFeature, olFeatInitProps);

            for (let i = 0; !componentHasModifiedAttributes && i < scope.editdescription.relatedfeatures.length; i++) {
              const olRelatedFeature = scope.editdescription.relatedfeatures[i].feature;
              const olRelatedFeatInitProps = scope.editdescription.relatedfeatures0[i];
              componentHasModifiedAttributes = isFeaturePropertiesChanged(olRelatedFeature, olRelatedFeatInitProps);
            }
          }

          if (componentHasModifiedAttributes || scope.editdescription.geometryStatus !== '') {
            scope.updatesToSave = true;
          }
        };

        /**
         * Appelée à la validation d'une édition attributaire
         */
        scope.validFeatures = function() {
          if (
            !bizeditProvider.checkMandatory(
              scope,
              scope.authorizedReadAttributes,
              1,
              undefined,
              scope.currentProperties
            )
          ) {
            return;
          }
          // Mise à jour attributaires

          // KIS-3110: les attributs supprimés ne sont pas mis à jour
          mapJsUtils.clearFeatureProperties(scope.currentFeature);

          //setProperties n'enlève pas une propriété existante
          // @see https://github.com/openlayers/openlayers/blob/v4.6.5/src/ol/object.js#L170
          scope.currentFeature.setProperties(scope.currentProperties);

          scope.currentFeature.attrEdited = true;
          scope.currentFeature.saved = false;
          if (scope.p) scope.p.destroy();
          scope.isCheckingPostValidationRules = true;
          let feature;
         // Réutilise le même traitement que pour les EndRules pour les relatedFeatures
         if(scope.indexFeature === -1) {
            feature = scope.editdescription;
          } else {
            const relatedfeature = scope.editdescription.relatedfeatures[scope.indexFeature];
            feature = EditDescription.getTemplateRelatedFeature(relatedfeature,scope.editdescription);
          }
          EditRulesFactory.executePostValidationRules(feature, scope.currentFti, map).finally(
            () => {
              checkFeatureHasBeenModified();
              if (scope.currentFeature.get('isMainObject') === true) {

                // si on clique sur le bouton Edition des attributs ("A") de l'objet principal,
                // on ne doit pas entraîner l'ouverture des popups des objets liés
                scope.currentFeature.unset('isMainObject');

                // Après l'édition de l'objet principal et la fin de l'exécution des règles de postValidation
                // alors on ouvre la popup atributaire du 1er objet lié
                editRelatedFeature(0);
              }
              scope.isCheckingPostValidationRules = false;
            }
          );
          scope.isAttributePopupOpen = false;
          scope.removehighLightFeature(scope.currentFeature);
          scope.deferPopupOpen.resolve();
        };

        // réception de la modification géométrique depuis bizmultiupdate
        scope.$on('geometryHasBeenModified', checkFeatureHasBeenModified);

        scope.resetCopiedObject = function() {
          const uId = scope.editdescription.fti.uid;
          const tmpObj = CopyPasteAttributeFactory.GetStoredObject(uId);
          if (tmpObj.objectIsCopied === true) {
            scope.currentProperties = scope.originalCurrentProperties;
          }
          scope.isAttributePopupOpen = false;
        };

        // //////////////////////////////////////////////////////
        //
        // Finalisation de la sauvegarde d'une action d'édition
        //
        // //////////////////////////////////////////////////////

        /**
         * Appélée après la sauvegarde et l'execution des règles
         * post-sauvegarde.
         */
        scope.endsave = function(allRecords) {
          gclayers.setNoMapRefresh(false);
          // Rafraichissment des layers opérationnelles
          angular.forEach(allRecords, function(value, key) {
            gclayers.refreshlayerByid(key, map);
          });

          gclayers.clearhighLightFeatures();
          gclayers.clearEditLayer();
          gclayers.clearSelectLayer();
          gclayers.getDrawLayer().getSource().clear();
          $rootScope.$broadcast('removeTransformation');
          $rootScope.$broadcast('removeDeplMultiple');
          $rootScope.$broadcast('bizedit_endsave', {
            records: allRecords,
          });

          // KIS-3135:  l’enregistrement des objets associés se fait après enregistrement de l’objet édité
          // et une fois que son identifiant est récupéré
          saveAssociatedFeaturesOnPostSave(allRecords);

          // Si mode de creation rapide alors relancement d'une action par
          // appel de performRules()
          if (scope.editdescription.fastMode && scope.editdescription.editType === 'add') {
            scope.performRules(scope.editdescription.editType);
          }
          scope.updatesToSave = false;
          scope.currentFeature = undefined;

          // on est obligé d'envoyer editdescription en paramètre
          // car, dans bizeditsave, scope.editdescription est undefined (bien que le scope soit partagé)
          scope.initializeSnapLayer(scope.editdescription);
        };

        // //////////////////////////////////////////////////////
        //
        // Reinitialisation du widget
        //
        // //////////////////////////////////////////////////////

        /**
         * Méthode utilitaire permettant de reinitialiser entirement le widget
         * d'édition.
         */
        scope.reset = function() {
          if (scope.p !== undefined && scope.p.element != null)
            scope.p.destroy();
          removeWfsLayers();
          removeInteractions();
          try {
            gclayers.clearhighLightFeatures();
            gclayers.clearEditLayer();
            gclayers.clearSelectLayer();
          } catch (e) {
            console.error(e.message);
          }
          // Suppression des features de la couche de visualisation des
          // features sélectionnés.
          if (scope.editdescription && scope.editdescription.editedfeature) {
            const selectedFeatures = gclayers.getselectSource().getFeatures();
            const bizEditFeaturesSelected = [];
            for (const selectedFeature of selectedFeatures) {
              if (scope.editdescription.editedfeature === selectedFeature) {
                bizEditFeaturesSelected.push(selectedFeature);
                continue;
              }
              for (const relatedFeature of scope.editdescription.relatedfeatures) {
                if (relatedFeature.feature === selectedFeature) {
                  bizEditFeaturesSelected.push(selectedFeature);
                  break;
                }
              }
            }
            for (const bizEditFeatureSelected of bizEditFeaturesSelected) {
              gclayers.getselectSource().removeFeature(bizEditFeatureSelected);
            }
          }
          scope.editdescription = undefined;
          try {
            const drawSource = gclayers.getDrawLayer().getSource();
            if (drawSource !== undefined) {
              drawSource.clear();
            }
            $rootScope.$broadcast('gcChangeCursorMap', '');
            gclayers.getGuideLayer().getSource().clear();
          } catch (e) {
            console.error(e.message);
          }

          scope.saveinProgress = false;

          // enlève les fonctions spécifiques du menu contextuel. Préserve zoom +/-
          scope.resetContextMenu();

          $rootScope.$broadcast('removeTransformation');
          $rootScope.$broadcast('removeDeplMultiple');
          scope.updatesToSave = false;
        };

        $rootScope.$on('resetBizEditWidget', () => {
          scope.reset();
        })

        scope.$on('openTools_bizeditwidget', function(event, arg) {
          // @RB force to use antoher config (i.e : used in BacApp >
          // Branchements)
          if (arg.forceConfig) {
            applyConfiguration(arg.forceConfig.cfg);
          } else if (scope.ConfigName === arg.config) {
            scope.getConfig();
          }
          // KIS-2853 Visibilité de la couche Techniques/Sélection à l'ouverture du widget Edition Métier
          layersService.enableSelectLayerVisible(scope.map);
        });

        // Reinitialisation si fermeture du widget
        scope.$on('openCloseTools_bizeditwidget', function(event, arg) {
          if (arg.directive === 'bizeditwidget' && arg.active === false && scope.ConfigName === arg.config) {
            scope.reset();
            scope.map.getOverlays().clear();
            $rootScope.$broadcast('gcChangeCursorMap', '');
            // suppression des actions ajouté au widget edition à la fermeture
            if (scope.contextMenu) {
              if (scope.contextMenu.length > 1) {
                scope.contextMenu.splice(0, scope.contextMenu.length - 2);
              }
            }
          }
          require('toastr').clear();
        });

        // Reinitialisation si ouverture d'un autre widget.
        scope.$on('newCategorie', function(event, currentTool) {
          if (currentTool.directive === 'bizeditwidget') {
            scope.reset();
            scope.getConfig();
            console.log('reset edit biz');
          }
        });

        scope.setUpdatesToSave = function(newValue) {
          scope.updatesToSave = newValue;
        };
        scope.$on ('setUpdatesToSave', (evt,params) => {
          scope.updatesToSave = params.value;
        });

        scope.$watch('applyRules.value', function() {
          EditRulesFactory.enableRules(scope.applyRules.value);
          scope.$broadcast('bizeditmultiupdate_moveApplyRulesButton');
        });

        scope.$watch('config.rulesAppliedByDefault', function() {
          scope.applyRules.value = scope.config.rulesAppliedByDefault;
        });

        // conteneur du mode de création de chaque type de géométrie (bizeditline, bizeditpoint)
        scope.drawMode = {};

        /**
         * Méthode formatée qui retire un objet de la couche de dessin temporaire et de la couche de sélection
         */
        const removeFromDrawAndSelectLayers = (feature) => {
          const selectedFeature = gclayers.getselectSource().getFeatureById(feature.getId());
          if (selectedFeature) {
            gclayers.getselectSource().removeFeature(selectedFeature);
          }
          const drawnFeature = gclayers.getDrawLayer().getSource().getFeatureById(feature.getId());
          if (drawnFeature) {
            gclayers.getDrawLayer().getSource().removeFeature(drawnFeature);
          }
        };

        /**
         * Supprime les autres fonctions du menu contextuel sur clic droit.<br>
         * Préserve zoom +/- <br>
         * Méthode exécutée : <ul><li>
         * A l'initialisation du type de sélection d'une modification géométrique (cf.bizeditmultiupdate.selectfeaturesToUpdate)</li><li>
         * Après sélection polygonale/rectangulaire lors d'une modification géographique (cf.bizeditmultiupdate.onSelectionResult)</li><li>
         * Après création/édition, au clic sur le bouton Enregistrer ("disquette") {@link scope.save()}</li><li>
         * A la désactivation de l'outil de modification géométrique {@link scope.reset()}</li></ul>
         */
        scope.resetContextMenu = () => {
          if (scope.contextMenu && scope.contextMenu.length >= 3) {
            scope.contextMenu.splice(0, scope.contextMenu.length - 2);
          }
        };

        /**
         * Récupère la hauteur de la div absolute des outils de sélection de l'outil d'édition actif
         * afin de positionner la table des résultats et éviter un chevauchement.
         * @return {string} hauteur suffixée par "px" des outils de sélection de l'outil d'édition actif
         */
        scope.findResultMarginByEditToolHeight = () => {
          let height = 20;
          const activeTool = document.querySelector('.edit-tool-container.active');
          // recherche l'outil d'édition actif
          if (activeTool) {
            const toolContent = activeTool.querySelector('.edit-tool-content');
            // recherche le corps de l'outil d'édition actif (càd l'outil sans le bouton de la barre d'outil d'édition)
            if (toolContent) {
              height += toolContent.offsetHeight;
            }
          }
          return height + 'px';
        };

        /**
         * A l'initialisation des champs de la popup des attributs.
         * Création de la variable @Input fieldData de chaque form-field de la popup des attributs.
         * Les fieldData sont créé la 1ère fois et ne doivent pas être recréés à chaque ouverture ultérieure de popup par clic sur le bouton "A" de modification attributaire
         * La récupération des fichiers attachés des objets nouvellement créés s'appuie sur la structure des fieldDatas.
         * Un changement de structure des fieldDatas a une influence sur la récupération des fichiers attachés des objets nouvellement créés dans l'édition métier.
         * Un changement de structure doit être répercuté dans la méthode <code>bizeditProvider.getAttributePopupFieldDatas</code>
         * @param {object} fti featuretypeinfo du composant de l'objet dont on édite les attributs dans la popup
         * @param {number} indexFeature rang de l'objet parmi tous les objets nouvellement créés du composant
         * @param {object[]} tabs onglets de configuration des attributs dans le cas d'une fiche-objet. Le paramètre est null dans le cas d'une structure classique.
         */
        scope.createAttributePopupFieldDatas = (fti, indexFeature, tabs) => {
          if (fti && fti.uid) {

            if (!scope.fieldDatas) {
              scope.fieldDatas = {};
            }
            if (!scope.fieldDatas[fti.uid]) {
              scope.fieldDatas[fti.uid] = {};
            }

            // les fieldDatas ne doivent pas être recréés à chaque ouverture ultérieure de popup par clic sur le bouton "A" de modification attributaire
            // sinon on perd le nom du sous-dossier upload dans lequel ont été copiés les fichiers attachés

            if (Array.isArray(tabs) && tabs.length > 0) {
              if (!scope.fieldDatas[fti.uid][indexFeature] || Array.isArray(scope.fieldDatas[fti.uid][indexFeature])) {
                scope.fieldDatas[fti.uid][indexFeature] = {};
                for (let i = 0; i < scope.configurationTab.configuration.length; i++) {
                  const tab = scope.configurationTab.configuration[i];
                  scope.fieldDatas[fti.uid][indexFeature][i] = tab.fields.map(attr => {
                    return {restrictionKeyAsInt: attr.type === 'java.lang.Integer', name: attr.name};
                  });
                }
              }
            } else if (Array.isArray(scope.authorizedReadAttributes)) {
              // construit les objets de configuration des champs de la popup
              // ces champs sont nécessaires pour l'utilisation des champs attachments
              if (!scope.fieldDatas[fti.uid][indexFeature]) {
                scope.fieldDatas[fti.uid][indexFeature] = scope.authorizedReadAttributes.map(attr => {
                  return {restrictionKeyAsInt: attr.type === 'java.lang.Integer', name: attr.name};
                });
              }
            }
          }

        };

        /**
         * KIS-3116: A l’exécution de la règle setObjectOnextremity depuis le widget d’Edition,
         * il faut évaluer l’option avant l’affichage des popups amont et aval.
         * @param fti composant principal en cours d'édition
         * @return {boolean} true pour afficher la popup d'attributs des objets liés
         */
        const hideRelatedFeatAttributePopup = (fti) => {
          if (fti && Array.isArray(fti.rules)) {
            const setObjectOnExtremity = fti.rules.find(rule => rule.name === 'SetObjectOnExtremity');
            if (gaJsUtils.notNullAndDefined(setObjectOnExtremity, 'parameters.hidePopupAttribute')) {
              return setObjectOnExtremity.parameters.hidePopupAttribute;
            }
          }
          return false;
        };

        /**
         * L’enregistrement des objets associés se fait après enregistrement de l’objet édité
         * et une fois que son identifiant est récupéré.<br>
         * <a href="https://altereo-informatique.atlassian.net/browse/KIS-3135">
         *   KIS-3135|[DEA - Edition] : Edition fibre optique - Exécution de la règle métier</a>
         * @param allRecords objets créés/modifiés/supprimés
         */
        const saveAssociatedFeaturesOnPostSave = (allRecords) => {
          if (scope.editdescription.fti.rules.some(rule => rule.type === 'PostSave')) {
            const ftiuid = scope.editdescription.fti.uid;
            let feats;
            if (scope.editdescription.editType === 'add' && gaJsUtils.notNullAndDefined(allRecords, ftiuid + '.adds')
                && Array.isArray(allRecords[ftiuid].adds.features)
                && allRecords[ftiuid].adds.features.length === 1) {
              feats = allRecords[ftiuid].adds.features;

            } else if (scope.editdescription.editType === 'update' && gaJsUtils.notNullAndDefined(allRecords, ftiuid + '.updates')
                && Array.isArray(allRecords[ftiuid].updates.features)
                && allRecords[ftiuid].updates.features.length === 1) {
              feats = allRecords[ftiuid].updates.features;
            }
            if (Array.isArray(feats) && feats.length > 0) {
              EditRulesFactory.bizEditSaveAssociatedFeatures(feats, scope.editdescription);
            }
          }
        };

        /**
         * Traitement sur le bouton "Exécuter les règles métier onEnd" de l'outil "Modification géométrique":<ul><li>
         *   enlève le clignotement du bouton</li><li>
         *   masque le bouton (<code>shouldHideButton = true</code>)</li></ul>
         * KIS-3319
         */
        scope.hideExecuteEndRulesButton = () => {
          bizeditProvider.stopApplyRulesButtonBlinking(true);
        };

        /// get the config and INIT WIDGET ///
        scope.getConfig();
      },
    };
  };

  basemapwidget.$inject = [
    'gclayers',
    'gcPopup',
    'EditRulesFactory',
    'ConfigFactory',
    'ngDialog',
    '$rootScope',
    '$filter',
    '$timeout',
    'CopyPasteAttributeFactory',
    'bizeditProvider',
    'FeatureTypeFactory',
    'RightsFactory',
    'ObjectFilesFactory',
    '$q',
    'NetworkFactory',
    'layersService',
    'gaJsUtils',
    'mapJsUtils',
    'EditDescription'
    ];
  return basemapwidget;
});