'use strict';
define(function() {
  var esrisymbolstyle = function(
    EsriSymbolFactory,
    $rootScope,
    extendedNgDialog,
    gclayers,
    ngTableParams,
    ngDialog,
    $timeout,
    ParametersFactory,
    $filter,
    gaJsUtils
  ) {
    return {
      templateUrl:
        'js/XG/widgets/mapapp/esrisymbolstyle/views/esrisymbolstyle.html',
      restrict: 'A',

      link: function(scope, element, attrs, ctrl) {
        var ESRI_STYLE_PARAM_NAME = 'ESRI_STYLE_PARAM';

        var lastFtiUid = null;

        var currentLayer = null;

        var currentFti = null;

        var currentSimpleSymbol = null;

        var currentDefaultSymbol = null;

        var currentUniqValSymbols = [];

        var layerLegend = null;

        var uniqValFirstIdx = 1;

        var currentUniqValueSymbol = null;

        var currentSymbol = null;

        scope.rendererTypes = [
          { value: 'simple', label: 'Symbol unique' },
          {
            value: 'uniqueValue',
            label: "Symbol par valeurs d'attributs",
          },
        ];

        scope.slsTypes = [
          { value: 'esriSLSSolid', label: 'Ligne continue' },
          { value: 'esriSLSDash', label: 'Ligne en tirets' },
          {
            value: 'esriSLSDashDot',
            label: 'Ligne en tirets et pointillés',
          },
          {
            value: 'esriSLSDashDotDot',
            label: 'Ligne en tirets et 2 pointillés',
          },
          { value: 'esriSLSDot', label: 'En pointillés' },
          { value: 'esriSLSNull', label: 'Ligne nulle' },
        ];

        scope.smsTypes = [
          { value: 'esriSMSCircle', label: 'Cercle' },
          { value: 'esriSMSCross', label: 'Croix' },
          { value: 'esriSMSDiamond', label: 'Diamond' },
          { value: 'esriSMSSquare', label: 'Carré' },
          { value: 'esriSMSX', label: 'X' },
          { value: 'esriSMSTriangle', label: 'Triangle' },
        ];

        scope.sfsTypes = [
          { value: 'esriSFSSolid', label: 'Remplissage continu' },
          {
            value: 'esriSFSBackwardDiagonal',
            label: "Remplissage en diagonal vers l'arrière",
          },
          { value: 'esriSFSCross', label: 'Remplissage en croix' },
          {
            value: 'esriSFSDiagonalCross',
            label: 'Remplissage diagonal en croix',
          },
          {
            value: 'esriSFSForwardDiagonal',
            label: "Remplissage en diagonal vers l'avant",
          },
          {
            value: 'esriSFSHorizontal',
            label: 'Remplissage horizontal',
          },
          { value: 'esriSFSVertical', label: 'Remplissage vertical' },
          { value: 'esriSFSNull', label: 'Remplissage null' },
        ];

        scope.symbolTypes = [
          { value: 'esriSMS', label: 'Symbol point' },
          { value: 'esriSLS', label: 'Symbol ligne' },
          { value: 'esriSFS', label: 'Symbol polygone' },
          { value: 'esriPMS', label: 'Symbol image' },
          { value: 'esriPFS', label: 'Symbol polygone image' },
          { value: 'esriTS', label: 'Symbol de type Font' },
        ];

        scope.labelPlacmtPoint = [
          {
            value: 'esriServerPointLabelPlacementAboveCenter',
            label: 'Au dessus | Centre',
          },
          {
            value: 'esriServerPointLabelPlacementAboveLeft',
            label: 'Au dessus | Gauche',
          },
          {
            value: 'esriServerPointLabelPlacementAboveRight',
            label: 'Au dessus | Droite',
          },
          {
            value: 'esriServerPointLabelPlacementBelowCenter',
            label: 'Au dessous | Centre',
          },
          {
            value: 'esriServerPointLabelPlacementBelowLeft',
            label: 'Au dessous | Gauche',
          },
          {
            value: 'esriServerPointLabelPlacementBelowRight',
            label: 'Au dessous | Droite',
          },
          {
            value: 'esriServerPointLabelPlacementCenterCenter',
            label: 'Centre | Centre',
          },
          {
            value: 'esriServerPointLabelPlacementCenterLeft',
            label: 'Centre | Gauche',
          },
          {
            value: 'esriServerPointLabelPlacementCenterRight',
            label: 'Centre | Droite',
          },
        ];

        scope.labelPlacmtLine = [
          {
            value: 'esriServerLinePlacementAboveAfter',
            label: 'Au dessus | Après',
          },
          {
            value: 'esriServerLinePlacementAboveAlong',
            label: 'Au dessus | Le long',
          },
          {
            value: 'esriServerLinePlacementAboveBefore',
            label: 'Au dessus | Avant',
          },
          {
            value: 'esriServerLinePlacementAboveStart',
            label: 'Au dessous | Début',
          },
          {
            value: 'esriServerLinePlacementAboveEnd',
            label: 'Au dessous | Fin',
          },
          {
            value: 'esriServerLinePlacementBelowAfter',
            label: 'Au dessous | Après',
          },
          {
            value: 'esriServerLinePlacementBelowAlong',
            label: 'Centre | Le long',
          },
          {
            value: 'esriServerLinePlacementBelowBefore',
            label: 'Centre | Avant',
          },
          {
            value: 'esriServerLinePlacementBelowStart',
            label: 'Centre | Début',
          },
          {
            value: 'esriServerLinePlacementBelowEnd',
            label: 'Au dessous | Fin',
          },
          {
            value: 'esriServerLinePlacementCenterAfter',
            label: 'Au dessous | Après',
          },
          {
            value: 'esriServerLinePlacementCenterAlong',
            label: 'Au dessous | Le long',
          },
          {
            value: 'esriServerLinePlacementCenterBefore',
            label: 'Centre | Avant',
          },
          {
            value: 'esriServerLinePlacementCenterStart',
            label: 'Centre | Début',
          },
          {
            value: 'esriServerLinePlacementCenterEnd',
            label: 'Centre | Fin',
          },
        ];

        scope.labelPlacmtPolygon = [
          {
            value: 'esriServerPolygonPlacementAlwaysHorizontal',
            label: 'Toujours Horizontal',
          },
        ];

        scope.labelTrueFalse = [
          { value: 'true', label: 'Vrai' },
          { value: 'false', label: 'Faux' },
        ];

        scope.labelVertAlign = [
          { value: 'baseline', label: 'baseline' },
          { value: 'top', label: 'Haut' },
          { value: 'middle', label: 'Milieu' },
          { value: 'bottom', label: 'Bas' },
        ];

        scope.labelHorizAlign = [
          { value: 'left', label: 'Gauche' },
          { value: 'right', label: 'Droite' },
          { value: 'center', label: 'Centre' },
          { value: 'justify', label: 'Justifié' },
        ];

        scope.labelFontFamilies = [
          'Arial',
          'Helvetica',
          'Times New Roman',
          'Times',
          'Courier New',
          'Courier',
          'Verdana',
          'Georgia',
          'Palatino',
          'Garamond',
          'Bookman',
          'Comic Sans MS',
          'Trebuchet MS',
          'Arial Black',
          'Impact',
        ];

        scope.labelFontStyles = ['normal', 'italic', 'oblique'];

        scope.labelFontWeights = [
          { value: 'bold', label: 'Gras' },
          { value: 'bolder', label: 'Plus gras' },
          { value: 'lighter', label: 'Plus léger' },
          { value: 'normal', label: 'normal' },
        ];

        scope.labelFontDecorations = [
          { value: 'line-through', label: 'Ligne à travers' },
          { value: 'underline', label: 'Souligner' },
          { value: 'none', label: 'Aucune' },
        ];

        scope.selectfti = null;

        scope.currSymbol = {
          outline: {},
        };

        scope.symbolAttr = {
          values: {},
        };

        scope.classLabel = {
          selectedClassLabel: {},
        };

        scope.renderer = {};

        scope.labelClassInfos = [];

        scope.currlabelClassInfo = {};

        scope.currSaveParam = {};

        scope.labelEditMode = null;

        scope.uniqValData = [];

        scope.symbolFontClasses = [];

        scope.selectedUniqValueSymbol = null;

        scope.currSymbol.selectedFontClass = null;

        scope.selectedAttrValuesIdx = -1;

        scope.currentSymbolMode = null;

        scope.pickSymbolFontClasse = function(symbolFontClass) {
          scope.currSymbol.selectedFontClass = symbolFontClass;
        };

        EsriSymbolFactory.getFontClasses().then(function(res) {
          scope.symbolFontClasses = res.data;
        });

        scope.symbolFontFiles = [];

        scope.currSymbol.selectedFontFile = null;

        EsriSymbolFactory.getFontFiles().then(function(res) {
          scope.symbolFontFiles = res.data;

          //console.log(scope.symbolFontFiles);
        });

        function loadSavedParamsList() {
          ParametersFactory.getbytype(ESRI_STYLE_PARAM_NAME).then(
            function(res) {
              scope.savedStylesParams = [];

              for (var ii = 0; ii < res.data.length; ii++) {
                scope.savedStylesParams.push(res.data[ii]);
              }
            },
            function(res) {
              console.error('no config user');
            }
          );
        }

        loadSavedParamsList();

        function mapSymbolToIHM() {
          if (scope.currSymbol != null) {
            mapColorToIHM();

            outlineToIHM();
          }
        }

        function outlineToIHM() {
          if (
            !angular.isUndefined(scope.currSymbol.outline) &&
            scope.currSymbol.outline != null
          ) {
            scope.currSymbol.outline.chbx = true;

            if (!angular.isUndefined(scope.currSymbol.outline.color)) {
              var r = scope.currSymbol.outline.color[0];

              var g = scope.currSymbol.outline.color[1];

              var b = scope.currSymbol.outline.color[2];

              scope.currSymbol.outline.hexaColor = gaJsUtils.rgbToHex(r, g, b);
            }
          }
        }

        function mapColorToIHM() {
          if (
            !angular.isUndefined(scope.currSymbol.color) &&
            scope.currSymbol.color != null
          ) {
            var r = scope.currSymbol.color[0];

            var g = scope.currSymbol.color[1];

            var b = scope.currSymbol.color[2];

            scope.currSymbol.hexaColor = gaJsUtils.rgbToHex(r, g, b);

            scope.currSymbol.alpha = scope.currSymbol.color[3];
          } else {
            scope.currSymbol.alpha = 255;
          }
        }

        function mapUniqValueAttributes() {
          scope.renderer.attribute1 = findAttributeByName(
            scope.renderer.field1
          );

          scope.renderer.attribute2 = findAttributeByName(
            scope.renderer.field2
          );

          scope.renderer.attribute3 = findAttributeByName(
            scope.renderer.field3
          );
        }

        function buildUniqValuesDatatable() {
          scope.uniqValData = [];

          var legendArray = layerLegend.legend;

          for (var i = uniqValFirstIdx; i < legendArray.length; i++) {
            var legend = legendArray[i];

            var firstLegendValue = getFirstNotEmpty(legend.values);

            var thumbImgData =
              'data:' + legend.contentType + ';base64,' + legend.imageData;

            var uniqSymbol = getSymbolByUniqValue(firstLegendValue);

            var values = getSymbolValuesStr(legend.values);

            var row = {
              imgData: thumbImgData,
              value: values,
              values: legend.values,
              label: legend.label,
              symbol: uniqSymbol,
              uniqSymbol: null,
              selected: false,
            };

            scope.uniqValData.push(row);
          }

          scope.uniqValTableParams = new ngTableParams(
            {
              count: 3,
            },
            {
              total: scope.uniqValData.length,
              counts: [],

              getData: function($defer, params) {
                var data = scope.uniqValData;

                $defer.resolve(
                  data.slice(
                    (params.page() - 1) * params.count(),
                    params.page() * params.count()
                  )
                );
              },
            }
          );
        }

        function getSymbolValuesStr(values) {
          var result = '';

          for (var i = 0; i < values.length; i++) {
            var value = values[i];

            if (value != '') {
              result = result + values[i] + '; ';
            }
          }

          if (result.length > 2) {
            result = result.substring(0, result.length - 2);
          }

          return result;
        }

        function getFirstNotEmpty(values) {
          for (var i = 0; i < values.length; i++) {
            var value = values[i];

            if (value != '') {
              return value;
            }
          }

          return null;
        }

        function getCurrentStyleLegend() {
          var dynamicLayer = {
            id: currentLayer.fti.ogcId,
            source: {
              type: 'mapLayer',
              mapLayerId: currentLayer.fti.ogcId,
            },
            drawingInfo: {
              renderer: currentLayer.style,
            },
          };

          var dynamicLayerArray = [dynamicLayer];

          getLegendInfo(currentLayer.url, dynamicLayerArray);
        }

        function getSavedStyleLegend(renderer) {
          var dynamicLayer = {
            id: currentLayer.fti.ogcId,
            source: {
              type: 'mapLayer',
              mapLayerId: currentLayer.fti.ogcId,
            },
            drawingInfo: {
              renderer: renderer,
            },
          };

          var dynamicLayerArray = [dynamicLayer];

          getLegendInfo(currentLayer.url, dynamicLayerArray);
        }

        function getLayersJsonInfo(url) {
          $.get(url + '/layers?f=json').then(function(info) {
            var jsonInfo = JSON.parse(info);

            var layerInfo = getLayerInfoByName(
              jsonInfo.layers,
              currentLayer.name
            );

            if (layerInfo != null) {
              //var layersArray = [layerInfo];

              scope.renderer = layerInfo.drawingInfo.renderer;

              //console.log(layerInfo.drawingInfo.renderer);

              getLegendInfo(url, null);
            }
          });
        }

        function getLayersJsonInfoForLabel(url) {
          $.get(url + '/layers?f=json').then(function(info) {
            var jsonInfo = JSON.parse(info);

            var layerInfo = getLayerInfoByName(
              jsonInfo.layers,
              currentLayer.name
            );

            if (layerInfo != null) {
              if (
                !angular.isUndefined(layerInfo.drawingInfo.labelingInfo) &&
                layerInfo.drawingInfo.labelingInfo != null
              ) {
                scope.labelClassInfos = layerInfo.drawingInfo.labelingInfo;
              } else {
                scope.labelClassInfos = [];
              }

              openEsrilabeleditorpopup();

              //console.log(scope.labelClassInfos);
            }
          });
        }

        function refreshSymbolDynamicLegend(url) {
          var refreshSymbol;

          if (scope.currentSymbolMode == 'simpleMode') {
            refreshSymbol = currentSimpleSymbol;
          } else if (scope.currentSymbolMode == 'defaultMode') {
            refreshSymbol = currentDefaultSymbol;
          } else if (scope.currentSymbolMode == 'uniqValMode') {
            refreshSymbol = currentUniqValueSymbol.uniqSymbol;
          }

          var dynamicLayer = {
            id: currentLayer.fti.ogcId,
            source: {
              type: 'mapLayer',
              mapLayerId: currentLayer.fti.ogcId,
            },
            drawingInfo: {
              renderer: {
                type: 'simple',
                symbol: refreshSymbol,
              },
            },
          };

          var dynamicLayerArray = [dynamicLayer];

          var layersArrayStr = JSON.stringify(dynamicLayerArray);

          $.get(
            url +
              '/legend?f=json&dynamicLayers=' +
              encodeURIComponent(layersArrayStr)
          ).then(function(info) {
            var jsonInfo = JSON.parse(info);

            var refreshLayerLegend = jsonInfo.layers[0];

            var legendArray = refreshLayerLegend.legend;

            var legendElt = legendArray[0];

            if (scope.currentSymbolMode == 'simpleMode') {
              scope.renderer.simpleThumb =
                'data:' +
                legendElt.contentType +
                ';base64,' +
                legendElt.imageData;
            } else if (scope.currentSymbolMode == 'defaultMode') {
              scope.renderer.defaultThumb =
                'data:' +
                legendElt.contentType +
                ';base64,' +
                legendElt.imageData;
            } else if (scope.currentSymbolMode == 'uniqValMode') {
              currentUniqValueSymbol.imgData =
                'data:' +
                legendElt.contentType +
                ';base64,' +
                legendElt.imageData;

              scope.uniqValTableParams.reload();
            }
          });
        }

        function getLegendInfo(url, layersArray) {
          if (layersArray != null) {
            var layersArrayStr = JSON.stringify(layersArray);

            $.get(
              url +
                '/legend?f=json&dynamicLayers=' +
                encodeURIComponent(layersArrayStr)
            ).then(function(info) {
              var jsonInfo = JSON.parse(info);

              layerLegend = jsonInfo.layers[0];

              openEsrirenderereditorpopup();
            });
          } else {
            $.get(url + '/legend?f=json').then(function(info) {
              var jsonInfo = JSON.parse(info);

              layerLegend = getLayerLegendByName(
                jsonInfo.layers,
                currentLayer.name
              );

              openEsrirenderereditorpopup();
            });
          }
        }

        function getLayerInfoByName(layersInfo, name) {
          var result = null;

          layersInfo.forEach(function(l) {
            if (l.name == name) {
              result = l;
            }
          });

          return result;
        }

        function getLayerLegendByName(layersInfo, name) {
          var result = null;

          layersInfo.forEach(function(l) {
            if (l.layerName == name) {
              result = l;
            }
          });

          return result;
        }

        function findAttributeByName(attrName) {
          var result = null;

          currentLayer.fti.attributes.forEach(function(att) {
            if (att.name == attrName) {
              result = att;
            }
          });

          return result;
        }

        function getAttributeName(attr) {
          if (!angular.isUndefined(attr) && attr != null) {
            return attr.name;
          }

          return null;
        }

        function openEsrirenderereditorpopup() {
          if (layerLegend != null) {
            var legendArray = layerLegend.legend;

            if (scope.renderer.type == 'simple') {
              var legendElt = legendArray[0];

              scope.renderer.simpleThumb =
                'data:' +
                legendElt.contentType +
                ';base64,' +
                legendElt.imageData;
            } else if (scope.renderer.type == 'uniqueValue') {
              //scope.renderer.defaultSymbol
              if (
                !angular.isUndefined(scope.renderer.defaultSymbol) &&
                scope.renderer.defaultSymbol != null
              ) {
                uniqValFirstIdx = 1;

                var legendElt = legendArray[0];

                scope.renderer.defaultThumb =
                  'data:' +
                  legendElt.contentType +
                  ';base64,' +
                  legendElt.imageData;
              } else {
                uniqValFirstIdx = 0;
              }

              mapUniqValueAttributes();

              buildUniqValuesDatatable();
            }
          }

          if (scope.esrirenderereditorpopup != undefined) {
            scope.esrirenderereditorpopup.close();
          }

          scope.esrirenderereditorpopup = extendedNgDialog.openOld({
            template:
              'js/XG/widgets/mapapp/esrisymbolstyle/views/esrirenderereditorpopup.html',
            className:
              'ngdialog-theme-plain overflowY width600 nopadding miniclose',
            closeByDocument: false,
            scope: scope,
            title: $filter('translate')('esrisymbolstyle.stylepopup.title'),
            draggable: true,
          });
        }

        function openEsrilabeleditorpopup() {
          scope.classLabel = {
            selectedClassLabel: {},
          };

          if (scope.esrilabeleditorpopup != undefined) {
            scope.esrilabeleditorpopup.close();
          }

          scope.esrilabeleditorpopup = extendedNgDialog.openOld({
            template:
              'js/XG/widgets/mapapp/esrisymbolstyle/views/esrilabeleditorpopup.html',
            className:
              'ngdialog-theme-plain overflowY width800 nopadding miniclose',
            closeByDocument: false,
            scope: scope,
            title: $filter('translate')('esrisymbolstyle.labelpopup.title'),
            draggable: true,
          });
        }

        function buildUniqueValueInfos() {
          var result = [];

          for (var i = 0; i < scope.uniqValData.length; i++) {
            var loopUniqValData = scope.uniqValData[i];

            var values = loopUniqValData.values;

            for (var j = 0; j < values.length; j++) {
              var value = values[j];

              var uniSymbol;

              if (loopUniqValData.uniqSymbol == null) {
                uniSymbol = loopUniqValData.symbol;
              } else {
                uniSymbol = loopUniqValData.uniqSymbol;
              }

              var row = {
                value: value,
                label: loopUniqValData.label,
                symbol: uniSymbol,
              };

              result.push(row);
            }
          }

          return result;
        }

        function getDefaultSymbol() {
          if (currentDefaultSymbol == null) {
            return scope.renderer.defaultSymbol;
          } else {
            return currentDefaultSymbol;
          }
        }

        function getSimpleSymbol() {
          //console.log(currentSimpleSymbol);

          if (currentSimpleSymbol == null) {
            return scope.renderer.symbol;
          } else {
            return currentSimpleSymbol;
          }
        }

        scope.selectRendererchange = function() {};

        function getEsriRendererForApply() {
          var esriRenderer = null;

          if (
            !angular.isUndefined(scope.renderer.type) &&
            scope.renderer.type == 'simple'
          ) {
            var simpleSymbol = getSimpleSymbol();

            esriRenderer = {
              type: scope.renderer.type,
              symbol: simpleSymbol,
            };
          } else if (
            !angular.isUndefined(scope.renderer.type) &&
            scope.renderer.type == 'uniqueValue'
          ) {
            scope.renderer.field1 = getAttributeName(scope.renderer.attribute1);

            scope.renderer.field2 = getAttributeName(scope.renderer.attribute2);

            scope.renderer.field3 = getAttributeName(scope.renderer.attribute3);

            var uniqueValueInfos = buildUniqueValueInfos();

            var defSymbol = getDefaultSymbol();

            esriRenderer = {
              type: scope.renderer.type,
              field1: scope.renderer.field1,
              field2: scope.renderer.field2,
              field3: scope.renderer.field3,
              fieldDelimiter: scope.renderer.fieldDelimiter,
              defaultSymbol: defSymbol,
              defaultLabel: scope.renderer.defaultLabel,
              uniqueValueInfos: uniqueValueInfos,
            };

            //console.log(esriRenderer);
          }

          return esriRenderer;
        }

        scope.applyRenderer = function() {
          var esriRenderer = getEsriRendererForApply();

          if (esriRenderer != null) {
            currentLayer.style = esriRenderer;

            $rootScope.$broadcast('gcOperationalLayerChange', '', 'applyall');

            if (scope.esrirenderereditorpopup != undefined) {
              scope.esrirenderereditorpopup.close();
            }
          }
        };

        scope.defineStyle = function() {
          currentLayer = null;

          currentFti = scope.selectfti;

          gclayers.getOperationalLayerESRICollection().forEach(function(l) {
            if (l.fti.uid == scope.selectfti.uid) {
              currentLayer = l;
            }
          });

          if (currentLayer != null) {
            currentSimpleSymbol = null;

            currentDefaultSymbol = null;

            if (angular.isUndefined(currentLayer.style)) {
              getLayersJsonInfo(currentLayer.url);
            } else {
              scope.renderer = currentLayer.style;

              getCurrentStyleLegend();
            }
          }
        };

        scope.defineLabel = function() {
          currentLayer = null;

          currentFti = scope.selectfti;

          gclayers.getOperationalLayerESRICollection().forEach(function(l) {
            if (l.fti.uid == scope.selectfti.uid) {
              currentLayer = l;
            }
          });

          if (currentLayer != null) {
            scope.labelEditMode = null;

            console.log(currentLayer.label);

            if (angular.isUndefined(currentLayer.label)) {
              getLayersJsonInfoForLabel(currentLayer.url);
            } else {
              scope.labelClassInfos = currentLayer.label;

              openEsrilabeleditorpopup();
            }
          }
        };

        scope.loadSavedStylesParam = function(savedParam) {
          currentFti = savedParam.data.layer;

          currentLayer = null;

          gclayers.getOperationalLayerESRICollection().forEach(function(l) {
            if (l.fti.uid == savedParam.data.layer.uid) {
              currentLayer = l;
            }
          });

          if (currentLayer != null) {
            if (savedParam.data.type == 'renderer') {
              currentSimpleSymbol = null;

              currentDefaultSymbol = null;

              var copyRenderer = angular.copy(savedParam.data.symbol);

              scope.renderer = copyRenderer;

              getSavedStyleLegend(copyRenderer);
            } else if (savedParam.data.type == 'label') {
              scope.labelEditMode = null;

              var copyRenderer = angular.copy(savedParam.data.symbol);

              scope.labelClassInfos = copyRenderer;

              openEsrilabeleditorpopup();
            }
          }
        };

        var savedParamForDelete = null;

        scope.removeSavedStylesParam = function(savedParam) {
          savedParamForDelete = savedParam;

          $timeout(function() {
            var confirmDeleteDialg = ngDialog.open({
              template:
                'js/XG/widgets/mapapp/esrisymbolstyle/views/esristyleparamconfirmdelete.html',
              className: 'ngdialog-theme-plain',
              closeByDocument: false,
              scope: scope,
              preCloseCallback: confirmSavedParamDialogClosed,
            });
          }, 100);
        };

        function confirmSavedParamDialogClosed() {
          if (savedParamDeleteConfirmed) {
            if (savedParamForDelete != null) {
              ParametersFactory.remove(savedParamForDelete.id).then(
                function() {
                  var idx = scope.savedStylesParams.indexOf(
                    savedParamForDelete
                  );

                  scope.savedStylesParams.splice(idx, 1);

                  savedParamForDelete = null;
                },
                function() {
                  require('toastr').error(
                    $filter('translate')('elastic.search.save_nok')
                  );

                  savedParamForDelete = null;
                }
              );
            }
          }

          savedParamDeleteConfirmed = false;
        }

        var savedParamDeleteConfirmed = false;

        scope.confirmSavedParamDelete = function() {
          savedParamDeleteConfirmed = true;
        };

        scope.openSymbolEditor = function(mode) {
          scope.currentSymbolMode = mode;

          if (scope.esrisymboleditorpopup != undefined) {
            scope.esrisymboleditorpopup.close();
          }

          if (scope.currentSymbolMode == 'simpleMode') {
            scope.renderer.symbol = {
              outline: {},
            };

            scope.currSymbol = scope.renderer.symbol;
          } else if (scope.currentSymbolMode == 'defaultMode') {
            scope.currSymbol = scope.renderer.defaultSymbol;
          } else if (scope.currentSymbolMode == 'uniqValMode') {
            scope.currSymbol = scope.selectedUniqValueSymbol.symbol;

            //console.log(scope.currSymbol);
          }

          //defaultLabel

          mapSymbolToIHM();

          scope.esrisymboleditorpopup = extendedNgDialog.openOld({
            template:
              'js/XG/widgets/mapapp/esrisymbolstyle/views/esrisymboleditorpopup.html',
            className:
              'ngdialog-theme-plain overflowY width600 nopadding miniclose',
            closeByDocument: false,
            scope: scope,
            title: $filter('translate')('esrisymbolstyle.stylepopup.title'),
            draggable: true,
          });
        };

        scope.validLabelClassesInfos = function() {
          //adapt the labels array for query apply

          currentLayer.label = scope.labelClassInfos;

          $rootScope.$broadcast('gcOperationalLayerChange', '', 'applyall');

          if (scope.esrilabeleditorpopup != undefined) {
            scope.esrilabeleditorpopup.close();
          }
        };

        var currParamSaveType = null;

        scope.saveIntoParams = function(type) {
          currParamSaveType = type;

          scope.currSaveParam.name = currentFti.name + '_' + type;

          $timeout(function() {
            var paramSaveDialg = ngDialog.open({
              template:
                'js/XG/widgets/mapapp/esrisymbolstyle/views/esrisymbolparamsave.html',
              className: 'ngdialog-theme-plain',
              closeByDocument: false,
              scope: scope,
              preCloseCallback: paramSaveDialogClosed,
            });
          }, 100);
        };

        function paramSaveDialogClosed() {
          if (paramSaveConfirmed) {
            if (!paramNameExists(scope.currSaveParam.name)) {
              var paramToSave;

              if (currParamSaveType == 'renderer') {
                var esriRenderer = getEsriRendererForApply();

                paramToSave = {
                  layer: scope.selectfti,
                  type: currParamSaveType,
                  symbol: esriRenderer,
                };
              } else if (currParamSaveType == 'label') {
                paramToSave = {
                  layer: scope.selectfti,
                  type: currParamSaveType,
                  symbol: scope.labelClassInfos,
                };
              }

              ParametersFactory.add(
                paramToSave,
                ESRI_STYLE_PARAM_NAME,
                scope.currSaveParam.name
              ).then(
                function(res) {
                  scope.savedStylesParams.push(res.data);

                  require('toastr').success(
                    $filter('translate')('common.saved')
                  );
                },
                function() {
                  require('toastr').error(
                    $filter('translate')('elastic.search.save_nok')
                  );
                }
              );

              currParamSaveType = null;
            } else {
              require('toastr').error(
                $filter('translate')('esrisymbolstyle.param_name_exists')
              );
            }
          }

          paramSaveConfirmed = false;
        }

        var paramSaveConfirmed = false;

        scope.confirmParamSave = function() {
          paramSaveConfirmed = true;
        };

        function paramNameExists(name) {
          for (var i = 0; i < scope.savedStylesParams.length; i++) {
            if (scope.savedStylesParams[i].name == name) {
              return true;
            }
          }

          return false;
        }

        scope.validStyle = function() {
          currentSymbol = null;

          if (scope.currSymbol.type == 'esriSLS') {
            var slsColor;

            if (!angular.isUndefined(scope.currSymbol.hexaColor)) {
              slsColor = convertHexaColorToArray(scope.currSymbol.hexaColor);
            } else {
              slsColor = convertHexaColorToArray('#000000');
            }

            scope.currSymbol.color = slsColor;

            var slsType;

            if (!angular.isUndefined(scope.currSymbol.style)) {
              slsType = scope.currSymbol.style;
            } else {
              slsType = 'esriSLSSolid';
            }

            var slsWidth;

            if (!angular.isUndefined(scope.currSymbol.width)) {
              slsWidth = scope.currSymbol.width;
            } else {
              slsWidth = 1;
            }

            currentSymbol = {
              type: scope.currSymbol.type,
              color: slsColor,
              style: slsType,
              width: slsWidth,
            };

            refreshLegendAndClosePopup();
          } else if (scope.currSymbol.type == 'esriSMS') {
            var smsColor;

            if (!angular.isUndefined(scope.currSymbol.hexaColor)) {
              smsColor = convertHexaColorToArray(scope.currSymbol.hexaColor);
            } else {
              smsColor = convertHexaColorToArray('#000000');
            }

            scope.currSymbol.color = smsColor;

            var smsType;

            if (!angular.isUndefined(scope.currSymbol.style)) {
              smsType = scope.currSymbol.style;
            } else {
              smsType = 'esriSMSSquare';
            }

            var smsSize;

            if (!angular.isUndefined(scope.currSymbol.size)) {
              smsSize = scope.currSymbol.size;
            } else {
              smsSize = 1;
            }

            var smsXoffset;

            if (!angular.isUndefined(scope.currSymbol.xoffset)) {
              smsXoffset = scope.currSymbol.xoffset;
            } else {
              smsXoffset = 0;
            }

            var smsYoffset;

            if (!angular.isUndefined(scope.currSymbol.yoffset)) {
              smsYoffset = scope.currSymbol.yoffset;
            } else {
              smsYoffset = 0;
            }

            var smsAngle;

            if (!angular.isUndefined(scope.currSymbol.angle)) {
              smsAngle = scope.currSymbol.angle;
            } else {
              smsAngle = 0;
            }

            if (scope.currSymbol.outline && scope.currSymbol.outline.chbx) {
              var smsOutlineColor;

              if (!angular.isUndefined(scope.currSymbol.outline.hexaColor)) {
                smsOutlineColor = convertHexaColorToArray(
                  scope.currSymbol.outline.hexaColor
                );
              } else {
                smsOutlineColor = convertHexaColorToArray('#000000');
              }

              scope.currSymbol.outline.color = smsOutlineColor;

              var smsOutlineWidth;

              if (!angular.isUndefined(scope.currSymbol.outline.width)) {
                smsOutlineWidth = scope.currSymbol.outline.width;
              } else {
                smsOutlineWidth = 1;
              }

              currentSymbol = {
                type: scope.currSymbol.type,
                color: smsColor,
                style: smsType,
                size: smsSize,
                angle: smsAngle,
                xoffset: smsXoffset,
                yoffset: smsYoffset,
                outline: {
                  color: smsOutlineColor,
                  width: smsOutlineWidth,
                },
              };
            } else {
              currentSymbol = {
                type: scope.currSymbol.type,
                color: smsColor,
                style: smsType,
                size: smsSize,
                angle: smsAngle,
                xoffset: smsXoffset,
                yoffset: smsYoffset,
              };
            }

            refreshLegendAndClosePopup();
          } else if (scope.currSymbol.type == 'esriSFS') {
            var sfsType;

            if (!angular.isUndefined(scope.currSymbol.style)) {
              sfsType = scope.currSymbol.style;
            } else {
              sfsType = 'esriSFSSolid';
            }

            var sfsColor;

            if (!angular.isUndefined(scope.currSymbol.hexaColor)) {
              sfsColor = convertHexaColorToArray(scope.currSymbol.hexaColor);
            } else {
              sfsColor = convertHexaColorToArray('#000000');
            }

            scope.currSymbol.color = sfsColor;

            if (scope.currSymbol.outline.chbx) {
              var sfsOutlineType;

              if (!angular.isUndefined(scope.currSymbol.outline.style)) {
                sfsOutlineType = scope.currSymbol.outline.style;
              } else {
                sfsOutlineType = 'esriSLSSolid';
              }

              var sfsOutlineColor;

              if (!angular.isUndefined(scope.currSymbol.outline.hexaColor)) {
                sfsOutlineColor = convertHexaColorToArray(
                  scope.currSymbol.outline.hexaColor
                );
              } else {
                sfsOutlineColor = convertHexaColorToArray('#000000');
              }

              scope.currSymbol.outline.color = sfsOutlineColor;

              var sfsOutlineWidth;

              if (!angular.isUndefined(scope.currSymbol.outline.width)) {
                sfsOutlineWidth = scope.currSymbol.outline.width;
              } else {
                sfsOutlineWidth = 1;
              }

              currentSymbol = {
                type: scope.currSymbol.type,
                style: sfsType,
                color: sfsColor,
                outline: {
                  type: 'esriSLS',
                  style: sfsOutlineType,
                  color: sfsOutlineColor,
                  width: sfsOutlineWidth,
                },
              };
            } else {
              currentSymbol = {
                type: scope.currSymbol.type,
                style: sfsType,
                color: sfsColor,
              };
            }

            refreshLegendAndClosePopup();
          } else if (scope.currSymbol.type == 'esriTS') {
            if (
              scope.currSymbol.selectedFontClass != null &&
              scope.currSymbol.selectedFontFile != null
            ) {
              var encodedColor;

              if (!angular.isUndefined(scope.currSymbol.hexaColor)) {
                encodedColor = encodeURIComponent(scope.currSymbol.hexaColor);
              } else {
                encodedColor = encodeURIComponent('#000000');
              }

              var fontSize;

              if (!angular.isUndefined(scope.currSymbol.size)) {
                fontSize = scope.currSymbol.size;
              } else {
                fontSize = '30';
              }

              var smsXoffset;

              if (!angular.isUndefined(scope.currSymbol.xoffset)) {
                smsXoffset = scope.currSymbol.xoffset;
              } else {
                smsXoffset = 0;
              }

              var smsYoffset;

              if (!angular.isUndefined(scope.currSymbol.yoffset)) {
                smsYoffset = scope.currSymbol.yoffset;
              } else {
                smsYoffset = 0;
              }

              var smsAngle;

              if (!angular.isUndefined(scope.currSymbol.angle)) {
                smsAngle = scope.currSymbol.angle;
              } else {
                smsAngle = 0;
              }

              EsriSymbolFactory.encodeFont(
                scope.currSymbol.selectedFontClass,
                scope.currSymbol.selectedFontFile,
                fontSize,
                encodedColor
              ).then(function(res) {
                var imageData = res.data;

                currentSymbol = {
                  type: 'esriPMS',
                  imageData: imageData,
                  contentType: 'image/png',
                  width: fontSize,
                  height: fontSize,
                  angle: smsAngle,
                  xoffset: smsXoffset,
                  yoffset: smsYoffset,
                };

                refreshLegendAndClosePopup();
              });
            }
          }
        };

        scope.editAttributeValues = function() {
          scope.selectedAttrValuesIdx = -1;

          scope.renderer.field1 = getAttributeName(scope.renderer.attribute1);

          scope.renderer.field2 = getAttributeName(scope.renderer.attribute2);

          scope.renderer.field3 = getAttributeName(scope.renderer.attribute3);

          if (scope.editattributevaluespopup != undefined) {
            scope.editattributevaluespopup.close();
          }

          scope.editattributevaluespopup = extendedNgDialog.openOld({
            template:
              'js/XG/widgets/mapapp/esrisymbolstyle/views/esrisymbolattributevalues.html',
            className:
              'ngdialog-theme-plain overflowY width600 nopadding miniclose',
            closeByDocument: false,
            scope: scope,
            title: $filter('translate')('esrisymbolstyle.attr_values.title'),
            draggable: true,
          });
        };

        function refreshLegendAndClosePopup() {
          if (scope.currentSymbolMode == 'simpleMode') {
            currentSimpleSymbol = currentSymbol;
          } else if (scope.currentSymbolMode == 'defaultMode') {
            currentDefaultSymbol = currentSymbol;
          } else if (scope.currentSymbolMode == 'uniqValMode') {
            currentUniqValueSymbol.uniqSymbol = currentSymbol;
          }

          refreshSymbolDynamicLegend(currentLayer.url);

          if (scope.esrisymboleditorpopup != undefined) {
            scope.esrisymboleditorpopup.close();
          }
        }

        scope.addUniqValueSymbol = function() {
          var newSymbol = {
            outline: {},
          };

          var newRow = {
            imgData: '',
            value: '',
            values: [],
            label: 'new',
            symbol: newSymbol,
            uniqSymbol: null,
            selected: true,
          };

          for (var i = 0; i < scope.uniqValData.length; i++) {
            scope.uniqValData[i].selected = false;
          }

          scope.uniqValData.unshift(newRow);

          scope.selectedUniqValueSymbol = newRow;

          scope.openSymbolEditor('uniqValMode');

          currentUniqValueSymbol = scope.selectedUniqValueSymbol;

          scope.uniqValTableParams.reload();
        };

        scope.editUniqValueSymbol = function() {
          if (scope.selectedUniqValueSymbol != null) {
            scope.openSymbolEditor('uniqValMode');

            currentUniqValueSymbol = scope.selectedUniqValueSymbol;
          }
        };

        var symbolDeleteConfirmed = false;

        scope.confirmSymbolDelete = function() {
          symbolDeleteConfirmed = true;
        };

        scope.deleteUniqValueSymbol = function() {
          $timeout(function() {
            if (scope.selectedUniqValueSymbol != null) {
              var confirmDeleteDialg = ngDialog.open({
                template:
                  'js/XG/widgets/mapapp/esrisymbolstyle/views/esrisymbolconfirmdelete.html',
                className: 'ngdialog-theme-plain',
                closeByDocument: false,
                scope: scope,
                preCloseCallback: confirmDialogClosed,
              });
            }
          }, 100);
        };

        var classLabelDeleteConfirmed = false;

        scope.confirmClassLabelDelete = function() {
          classLabelDeleteConfirmed = true;
        };

        function confirmLabelDialogClosed() {
          if (classLabelDeleteConfirmed) {
            var idx = scope.labelClassInfos.indexOf(
              scope.classLabel.selectedClassLabel
            );

            scope.labelClassInfos.splice(idx, 1);

            scope.classLabel.selectedClassLabel = null;
          }

          classLabelDeleteConfirmed = false;
        }

        scope.deleteFontLabelClass = function() {
          $timeout(function() {
            if (
              !angular.isUndefined(scope.classLabel.selectedClassLabel.minScale)
            ) {
              var confirmDeleteDialg = ngDialog.open({
                template:
                  'js/XG/widgets/mapapp/esrisymbolstyle/views/esrilabelconfirmdelete.html',
                className: 'ngdialog-theme-plain',
                closeByDocument: false,
                scope: scope,
                preCloseCallback: confirmLabelDialogClosed,
              });
            }
          }, 100);
        };

        scope.addFontLabelClass = function() {
          scope.currlabelClassInfo = {
            symbol: {
              type: 'esriTS',
              alpha: 255,
              angle: 0,
            },
          };

          scope.labelEditMode = 'addMode';
        };

        scope.editFontLabelClass = function() {
          if (
            !angular.isUndefined(scope.classLabel.selectedClassLabel.minScale)
          ) {
            //console.log(scope.classLabel.selectedClassLabel);

            var copyClassLabel = angular.copy(
              scope.classLabel.selectedClassLabel
            );

            scope.currlabelClassInfo = copyClassLabel;

            bindLabelClassInfoToCurrent();

            scope.labelEditMode = 'editMode';
          }
        };

        scope.cancelLabelClasschanges = function() {
          scope.labelEditMode = null;

          scope.currlabelClassInfo = {};
        };

        scope.saveLabelClasschanges = function() {
          if (scope.labelEditMode == 'editMode') {
            var idx = scope.labelClassInfos.indexOf(
              scope.classLabel.selectedClassLabel
            );

            bindCurrentToLabelClassInfo();

            var copyClassLabel = angular.copy(scope.currlabelClassInfo);

            scope.labelClassInfos[idx] = copyClassLabel;

            scope.classLabel.selectedClassLabel = null;

            scope.labelEditMode = null;

            scope.currlabelClassInfo = {};
          } else if (scope.labelEditMode == 'addMode') {
            if (
              !angular.isUndefined(scope.currlabelClassInfo.minScale) &&
              !angular.isUndefined(scope.currlabelClassInfo.maxScale)
            ) {
              bindCurrentToLabelClassInfo();

              var copyClassLabel = angular.copy(scope.currlabelClassInfo);

              scope.labelClassInfos.push(copyClassLabel);

              scope.classLabel.selectedClassLabel = null;

              scope.labelEditMode = null;

              scope.currlabelClassInfo = {};
            }
          }
        };

        function bindLabelClassInfoToCurrent() {
          if (!angular.isUndefined(scope.currlabelClassInfo.useCodedValues)) {
            scope.currlabelClassInfo.useCodedValuesTxt = scope.currlabelClassInfo.useCodedValues.toString();
          }

          if (
            !angular.isUndefined(scope.currlabelClassInfo.symbol.rightToLeft)
          ) {
            scope.currlabelClassInfo.symbol.rightToLeftTxt = scope.currlabelClassInfo.symbol.rightToLeft.toString();
          }

          if (!angular.isUndefined(scope.currlabelClassInfo.symbol.color)) {
            var r = scope.currlabelClassInfo.symbol.color[0];

            var g = scope.currlabelClassInfo.symbol.color[1];

            var b = scope.currlabelClassInfo.symbol.color[2];

            scope.currlabelClassInfo.symbol.hexaColor = gaJsUtils.rgbToHex(r, g, b);

            scope.currlabelClassInfo.symbol.alpha =
              scope.currlabelClassInfo.symbol.color[3];
          }
        }

        function bindCurrentToLabelClassInfo() {
          if (
            !angular.isUndefined(scope.currlabelClassInfo.useCodedValuesTxt)
          ) {
            scope.currlabelClassInfo.useCodedValues =
              scope.currlabelClassInfo.useCodedValuesTxt == 'true';
          }

          if (
            !angular.isUndefined(scope.currlabelClassInfo.symbol.rightToLeftTxt)
          ) {
            scope.currlabelClassInfo.symbol.rightToLeft =
              scope.currlabelClassInfo.symbol.rightToLeftTxt == 'true';
          }

          if (!angular.isUndefined(scope.currlabelClassInfo.symbol.hexaColor)) {
            scope.currlabelClassInfo.symbol.color = convertHexaColorAlphaToArray(
              scope.currlabelClassInfo.symbol.hexaColor,
              scope.currlabelClassInfo.symbol.alpha
            );
          }
        }

        function confirmDialogClosed() {
          if (symbolDeleteConfirmed) {
            var idx = scope.uniqValData.indexOf(scope.selectedUniqValueSymbol);

            scope.uniqValData.splice(idx, 1);

            scope.selectedUniqValueSymbol = null;

            scope.uniqValTableParams.reload();
          }

          symbolDeleteConfirmed = false;
        }

        scope.selectUniqValSymbol = function(uniqValSymbol, $index) {
          if (uniqValSymbol.selected == true) {
            uniqValSymbol.selected = false;

            scope.selectedUniqValueSymbol = null;
          } else {
            for (var i = 0; i < scope.uniqValData.length; i++) {
              scope.uniqValData[i].selected = false;
            }

            uniqValSymbol.selected = true;

            scope.selectedUniqValueSymbol = uniqValSymbol;
          }
        };

        scope.selectUniqValValue = function(index) {
          scope.selectedAttrValuesIdx = index;
        };

        scope.deleteUniqValValue = function() {
          if (scope.selectedAttrValuesIdx > -1) {
            scope.selectedUniqValueSymbol.values.splice(
              scope.selectedAttrValuesIdx,
              1
            );

            scope.selectedAttrValuesIdx = -1;

            scope.selectedUniqValueSymbol.value = getSymbolValuesStr(
              scope.selectedUniqValueSymbol.values
            );
          }
        };

        scope.addUniqValValue = function() {
          var newValue = '';

          var delimiter = scope.renderer.fieldDelimiter;

          var delimiterNoSpace = delimiter.replace(/\s+/g, '');

          var nbFields = 0;

          var nbValues = 0;

          if (scope.renderer.field1 != null) {
            nbFields++;

            var val1 = scope.symbolAttr.values[scope.renderer.field1];

            if (!angular.isUndefined(val1)) {
              nbValues++;

              newValue = newValue + '' + val1;
            }
          }

          if (scope.renderer.field2 != null) {
            nbFields++;

            var val2 = scope.symbolAttr.values[scope.renderer.field2];

            if (!angular.isUndefined(val2)) {
              nbValues++;

              newValue = newValue + '' + delimiterNoSpace + '' + val2;
            }
          }

          if (scope.renderer.field3 != null) {
            nbFields++;

            var val3 = scope.symbolAttr.values[scope.renderer.field3];

            if (!angular.isUndefined(val3)) {
              nbValues++;

              newValue = newValue + '' + delimiterNoSpace + '' + val3;
            }
          }

          if (nbValues > 0 && nbValues == nbFields) {
            scope.selectedUniqValueSymbol.values.unshift(newValue);

            scope.selectedAttrValuesIdx = -1;

            scope.selectedUniqValueSymbol.value = getSymbolValuesStr(
              scope.selectedUniqValueSymbol.values
            );
          }
        };

        function getSymbolByUniqValue(value) {
          if (
            !angular.isUndefined(scope.renderer.uniqueValueInfos) &&
            scope.renderer.uniqueValueInfos != null
          ) {
            for (var i = 0; i < scope.renderer.uniqueValueInfos.length; i++) {
              var delimiter = scope.renderer.fieldDelimiter;

              var delimiterNoSpace = delimiter.replace(/\s+/g, '');

              var valNoSpace1 = scope.renderer.uniqueValueInfos[
                i
              ].value.replace(delimiter, delimiterNoSpace);

              var valNoSpace2 = value.replace(delimiter, delimiterNoSpace);

              if (valNoSpace1 == valNoSpace2) {
                return scope.renderer.uniqueValueInfos[i].symbol;
              }
            }
          }

          return null;
        }

        function componentToHex(c) {
          var hex = c.toString(16);
          return hex.length == 1 ? '0' + hex : hex;
        }

        function rgbToHex(r, g, b) {
          return (
            '#' + componentToHex(r) + componentToHex(g) + componentToHex(b)
          );
        }

        function convertHexaColorToArray(hexaCode) {
          var r = hexToR(hexaCode);
          var g = hexToG(hexaCode);
          var b = hexToB(hexaCode);

          var result = [r, g, b, scope.currSymbol.alpha];

          return result;
        }

        function convertHexaColorAlphaToArray(hexaCode, alpha) {
          var r = hexToR(hexaCode);
          var g = hexToG(hexaCode);
          var b = hexToB(hexaCode);

          var result = [r, g, b, alpha];

          return result;
        }

        function hexToR(h) {
          return parseInt(cutHex(h).substring(0, 2), 16);
        }

        function hexToG(h) {
          return parseInt(cutHex(h).substring(2, 4), 16);
        }

        function hexToB(h) {
          return parseInt(cutHex(h).substring(4, 6), 16);
        }

        function cutHex(h) {
          return h.charAt(0) == '#' ? h.substring(1, 7) : h;
        }
      },
    };
  };

  esrisymbolstyle.$inject = [
    'EsriSymbolFactory',
    '$rootScope',
    'extendedNgDialog',
    'gclayers',
    'ngTableParams',
    'ngDialog',
    '$timeout',
    'ParametersFactory',
    '$filter',
    'gaJsUtils'
  ];
  return esrisymbolstyle;
});
