'use strict';
define(() => {

  /**
   * Widget Export xlsx
   */
  class exportxlsxwidget {
    constructor(
        exportxlsxfactory,
        ImportExportFactory,
        ngDialog,
        gclayers,
        FeatureAttachmentFactory,
        FeatureTypeFactory,
        ParametersFactory,
        ConfigFactory,
        QueryFactory,
        gaDomUtils,
        mapJsUtils,
        $rootScope,
        $timeout,
        $window,
        $filter
    ) {
      return {
        templateUrl:
            'js/XG/widgets/mapapp/exportxlsx/views/exportxlsxwidget.html',
        restrict: 'AE',
        link: function (scope) {
          const MAP_MODEL_CONFIGURATION_NAME = 'MAP_MODELS_USERS';

          // Vérification que la configuration du widget est complète
          // Si oui, on récupère les valeurs possible de territoire
          scope.checkConfigAndGetTerritoryValues = (config) => {
            scope.config = config;
            if(scope.config.sheetType && scope.config.jsonFileName && scope.config.sheetModelFileName
                && scope.config.territoryComponentUid && scope.config.territoryAttributeName) {
              scope.config.complete = true;
              scope.territoryValues = [];
              scope.config.territoryValue = undefined;

              // Valeurs possibles pour le territoire
              QueryFactory.dataattribute(
                  scope.config.territoryComponentUid,
                  scope.config.territoryAttributeName
              ).then((res) => {
                scope.territoryValues = res.data;

                // Si aucune valeur possible de territoire, toastr warning le précisant
                if(scope.territoryValues.length === 0) {
                  require('toastr').warning($filter('translate')(
                      'importxlsxwidget.noPossibleValueForTerritory'));
                }
                // Si une seule valeur possible de territoire, on l'affecte automatiquement
                if(scope.territoryValues.length === 1) {
                  scope.config.territoryValue = scope.territoryValues[0];
                }
              });
            } else {
              scope.config.complete = false;
            }
          };

          /**
           * Récupération des valeurs possibles de système
           */
          scope.getSystemValues = (territoryValue) => {
            if (scope.config.jsonFileData.mainTable) {
              const ftiUid = FeatureTypeFactory.getFeatureUidByName(scope.config.jsonFileData.mainTable.tableName);
              if (ftiUid) {
                let queryCondition = `code_zone_territoire = '${territoryValue}'`; 
                QueryFactory.dataattribute(ftiUid,
                    scope.config.jsonFileData.mainTable.idField.fieldName,queryCondition
                ).then((res) => {
                  scope.systemValues = res.data;

                  // Si aucune valeur possible de systeme, toastr warning le précisant
                  if (scope.systemValues.length === 0) {
                    require('toastr').warning($filter('translate')(
                        'exportxlsxwidget.noPossibleValueForSystem'));
                  }
                  // Si une seule valeur possible de systeme, on l'affecte automatiquement
                  if (scope.systemValues.length === 1) {
                    scope.systemValue = scope.systemValues[0];
                  }
                });
              } else {
                // Si aucun uid n'est trouvé pour le nom de table
                console.error($filter('translate')('exportxlsxwidget.noUidForTableName')
                    + scope.config.jsonFileData.mainTable.tableName);
                require('toastr').error($filter('translate')('exportxlsxwidget.noUidForTableName')
                + scope.config.jsonFileData.mainTable.tableName);
              }
            }
          };

          // Récupération configuration
          scope.config = {};
          ConfigFactory.get('widgets', scope.ConfigName).then(
              res => {
                if(res && res.data && res.data !== '') {
                  scope.checkConfigAndGetTerritoryValues(res.data);
                }
              },
              () => {
                require('toastr').error($filter('translate')
                ('importexportwidget.config.getConfigErrorMsg'));
              }
          );

          // Bouton d'ouverture de la configuration
          scope.configExportXLSX = () => {
            ngDialog.open({
              template:
                  'js/XG/widgets/mapapp/exportxlsx/views/exportxlsxwidgetconfigredirection.html',
              className: 'ngdialog-theme-plain nopadding width450 miniclose',
              closeByDocument: false,
              title: $filter('translate')('exportxlsxwidget.configTitle'),
              scope: scope
            });
          };

          /**
           * Prend le screenshot voulu et lance l'export
           */
          scope.generateScreenshotAndExport = () => {
            // Génération d'une image
            scope.map.once('postcompose', (event) => {
              const canvas = event.context.canvas;
              let context = event.context.canvas.getContext('2d');
              let canvasContainer = canvas.getBoundingClientRect();
              const scaleX = canvas.width / canvasContainer.width;
              const scaleY = canvas.height / canvasContainer.height;
              let imageData = context.getImageData(0, 0, canvas.width, canvas.height);

              let newCanvas = document.createElement('canvas');
              newCanvas.width = canvas.width;
              newCanvas.height = canvas.height;

              let newContext = newCanvas.getContext('2d');

              newContext.scale(scaleX, scaleY);
              newContext.putImageData(imageData, 0, 0);
              // reset scale and draw behind existing image
              newContext.setTransform(1, 0, 0, 1, 0, 0);
              newContext.globalCompositeOperation = 'destination-over';
              // add background
              newContext.fillStyle = 'white';
              newContext.fillRect(0, 0, canvas.width, canvas.height);
              // reset the context
              newContext.globalCompositeOperation = 'source-over';
              newContext.scale(scaleX, scaleY);

              // dessin de l'échelle graphique (KIS-2839)
              const lineScale = document.querySelector('.ol-scale-line-inner');
              const lineScaleRect = lineScale.getBoundingClientRect();
              const controlX = canvasContainer.right - 10 - lineScaleRect.width;
              const controlY = canvasContainer.bottom - 10 - lineScaleRect.height;
              const controlWidth = lineScaleRect.width;
              const controlHeight = lineScaleRect.height;
              const controlText = lineScale.innerText;
              const controlStrokeStyle = 'rgba(0, 0, 0, 1)';
              const controlFillStyleText = 'rgba(0, 0, 0, 1)';
              const controlFont = '12px  \'opensans\', sans-serif';
              const controlLineWidth = 1;

              newContext.beginPath();
              newContext.moveTo(controlX, controlY);
              newContext.lineTo(controlX, controlY + controlHeight);
              newContext.lineTo(controlX + controlWidth, controlY + controlHeight);
              newContext.lineTo(controlX + controlWidth, controlY);
              newContext.strokeStyle = controlStrokeStyle;
              newContext.lineWidth = controlLineWidth;
              newContext.stroke();
              newContext.closePath();
              newContext.font = controlFont;
              newContext.textBaseline = 'middle';
              newContext.fillStyle = controlFillStyleText;

              let textString = controlText;
              let textWidth = newContext.measureText(textString).width;
              const scaleTextX = controlX + (controlWidth - textWidth) / 2;
              const scaleTextY = controlY + controlHeight / 2;
              newContext.fillText(textString, scaleTextX, scaleTextY);

              // dessin de la source (ex: "Galilée - 26/04/2023) (KIS-2839)
              const refX = canvasContainer.left + 10;
              const refY = canvasContainer.bottom - 15;
              let timezone = Intl.DateTimeFormat().resolvedOptions().timeZone;
              if (!timezone) {
                timezone = 'Europe/Paris';
              }
              const date = (new Date()).toLocaleString('fr-FR',
                  {timeZone: timezone, year: 'numeric', month: 'numeric', day: 'numeric'});
              textString = localStorage.getItem('app') + ' - ' + date;
              newContext.fillText(textString, refX, refY);

              let image = newCanvas.toDataURL('image/png');
              // Ancienne version
              // exportxlsxfactory.saveScreenshot(event.context.canvas.toDataURL('image/png')).then(imageName => {
              exportxlsxfactory.saveScreenshot(image).then(imageName => {
                window.open(exportxlsxfactory.exportXlsxFileUrl(
                    scope.territoryValue,
                    scope.systemValue,
                    imageName.data,
                    scope.ConfigName));
              },
              () => {
                require('toastr').warning($filter('translate')(
                    'importxlsxwidget.errorSavingImage'));
                window.open(exportxlsxfactory.exportXlsxFileUrl(
                    scope.territoryValue,
                    scope.systemValue,
                    undefined,
                    scope.ConfigName));
              })
            });
            scope.map.renderSync();
          };

          // A la sélection d'un élément, reset du résultat
          scope.refreshAValue = () => {
            scope.result = undefined;
            // Refresh pour que les boutons soient disponibles
            $timeout(() => {});
          };

          // Zoom sur l'élément si possible
          scope.zoomOnElement = () => {
            const fti = FeatureTypeFactory.getFeatureUidByName(scope.config.jsonFileData.mainTable.tableName);
            const where = scope.config.jsonFileData.mainTable.idField.fieldName + '=\'' + scope.systemValue + '\'';
            if (fti) {
              QueryFactory.data(fti, where, scope.map.getView().getProjection().getCode()).then(res => {
                if (Array.isArray(res.data.features) && res.data.features[0].geometry) {
                  mapJsUtils.localiseData(res.data.features[0], scope.map);
                }
              });
            }
          };

          // A la fermeture du widget
          scope.$on('openCloseTools_exportxlsxwidget', () => gclayers.clearhighLightFeatures());

          // A la fermeture de la catégorie
          scope.$on('closingCategory', () => gclayers.clearhighLightFeatures());
        }
      };
    }
  }

  exportxlsxwidget.$inject = [
    'exportxlsxfactory',
    'ImportExportFactory',
    'ngDialog',
    'gclayers',
    'FeatureAttachmentFactory',
    'FeatureTypeFactory',
    'ParametersFactory',
    'ConfigFactory',
    'QueryFactory',
    'gaDomUtils',
    'mapJsUtils',
    '$rootScope',
    '$timeout',
    '$window',
    '$filter'
  ];
  return exportxlsxwidget;
});