'use strict';
define(function() {
  var getwmswfs = function(
      gcWMS,
      FeatureTypeFactory,
      $location,
      ogcFactory,
      PortalsFactory
  ) {
    return {
      templateUrl: 'js/XG/widgets/mapapp/getwmswfs/views/getwmswfs.html',

      restrict: 'AE',
      scope: {
        fti: '=',
        viewconfig: '=?',
      },

      link: function(scope, element, attrs, ctrl) {
        scope.layerWMS;
        scope.urlWMS = '';
        scope.previewfti = scope.fti;
        //scope.viewconfig = false;
        /*
                 var catchments_url = '/services/' + PortalsFactory.getPortalId() + '/ogc/getfeat?service=WFS&version=1.0.0&request=GetFeature&typeName=' + types + '&outputformat=json&srsName=' + map.getView().getProjection().getCode() + '
                 &cql_filter=INTERSECTS
                 (geom, POLYGON((' + leftX + ' ' + bottomY + ',' + rightX + ' ' + bottomY + ',' + rightX + ' ' + topY + ',' + leftX + ' ' + topY + ',' + leftX + ' ' + bottomY + ')))'
                 */

        scope.srid;
        if (scope.previewfti.srid) {
          scope.srid = scope.previewfti.srid;
        } else {
          scope.srid = 'EPSG:3857';
        }

        // seulement pour les fti geographiques...
        if (scope.previewfti.geographic) {
          FeatureTypeFactory.getExtent(
            scope.previewfti.uid,
            scope.previewfti.srid
          ).then(
            function(res) {
              var bbox = res.data;
              scope.bbox = bbox;
              scope.urlWMS = '';
              scope.urlWFS = '';

              scope.urlWMS =
                $location.protocol() +
                '://' +
                $location.host() +
                '/geoserver/' +
                PortalsFactory.getPortalId() +
                '/wms?';
              scope.urlWMS += 'SERVICE=WMS&VERSION=1.1.0&REQUEST=GetMap&';
              scope.urlWMS +=
                'LAYERS=' +
                PortalsFactory.getPortalId() +
                ':' +
                scope.previewfti.name;
              scope.urlWMS += '&styles=' + scope.previewfti.defaultStyle;
              scope.urlWMS += '&TILED=false&type=g2c&WIDTH=1600&HEIGHT=800&';
              //scope.urlWMS += "FORMAT=image%2Fpng&TRANSPARENT=true&";
              scope.urlWMS +=
                '&BBOX=' +
                bbox[0] +
                '%2C' +
                bbox[1] +
                '%2C' +
                bbox[2] +
                '%2C' +
                bbox[3];
              scope.urlWMS += '&srs=' + scope.previewfti.srid;
              scope.urlWMS += '&format=image/png';

              scope.urlWMSPart = scope.urlWMS.substr(0, 70);
              scope.urlWMSPart += '...';
              scope.urlWFS =
                $location.protocol() +
                '://' +
                $location.host() +
                '/geoserver/' +
                PortalsFactory.getPortalId() +
                '/wfs?SERVICE=WFS&VERSION=1.1.0&';
              scope.urlWFS +=
                'request=GetFeature&typeNames=' +
                PortalsFactory.getPortalId() +
                ':' +
                scope.previewfti.name;
              scope.urlWFS += '&srsName=' + scope.previewfti.srid;
              scope.urlWFS += '&bbox=' + scope.bbox;
              scope.urlWFS += '&format=application/openlayers';
              scope.urlWFSPart = scope.urlWFS.substr(0, 70);
              scope.urlWFSPart += '...';

              //console.log(urlWFS)
            },
            function(data) {
              // @RB this is triggered whenever a featuretype is opened in the admin so i commented it out...
              //require('toastr').info(data);
            }
          );
        }

        scope.copyToClipboardWMS = function() {
          var copyElement = document.createElement('textarea');
          copyElement.style.position = 'fixed';
          copyElement.style.opacity = '0';
          copyElement.textContent = scope.urlWMS;
          var body = document.getElementsByTagName('body')[0];
          body.appendChild(copyElement);
          copyElement.select();
          document.execCommand('copy');
          body.removeChild(copyElement);
        };

        scope.copyToClipboardWFS = function() {
          var copyElement = document.createElement('textarea');
          copyElement.style.position = 'fixed';
          copyElement.style.opacity = '0';
          copyElement.textContent = scope.urlWFS;
          var body = document.getElementsByTagName('body')[0];
          body.appendChild(copyElement);
          copyElement.select();
          document.execCommand('copy');
          body.removeChild(copyElement);
        };

        scope.test1 = function() {
          FeatureTypeFactory.getExtent(
            scope.previewfti.uid,
            scope.previewfti.srid
          ).then(
            function(res) {
              var bbox = res.data;
              scope.bbox = bbox;
              var urlWFS = '';
              urlWFS =
                $location.protocol() +
                '://' +
                $location.host() +
                '/geoserver/' +
                PortalsFactory.getPortalId() +
                '/wfs?SERVICE=WFS&VERSION=1.1.0&';
              urlWFS +=
                'request=GetFeature&typeNames=' +
                PortalsFactory.getPortalId() +
                ':' +
                scope.previewfti.name;
              urlWFS += '&srsName=' + scope.previewfti.srid;
              urlWFS += '&bbox=' + scope.bbox;
              urlWFS += '&format=application/openlayers';

              console.log(url0);
            },
            function(data) {
              require('toastr').info(data);
            }
          );
        };

        scope.test = function() {
          var map = new ol.Map({
            layers: [new ol.layer.Tile({ source: new ol.source.OSM() })],
            target: 'previewmap',
            view: new ol.View({
              center: [0, 0],
              zoom: 2,
            }),
            ol3Logo: false,
          });

          if (angular.isDefined(scope.previewfti)) {
            FeatureTypeFactory.getExtent(
              scope.previewfti.uid,
              map
                .getView()
                .getProjection()
                .getCode()
            ).then(
              function(res) {
                var bbox = res.data;
                var url0 = '';
                map.getView().fit(bbox, map.getSize());
                var link;
                var l = gcWMS.getOlLayerFromFeaturetypeInfo(scope.previewfti);
                var wmsParams = {
                  LAYERS: scope.previewfti.name,
                  TILED: false,
                  type: 'g2c',
                };
                var wmsOptions = {
                  url:
                    '/geoserver/' +
                    PortalsFactory.getPortalId() +
                    '/wms?token=' +
                    '007',
                  label: scope.previewfti.alias,
                  uid: scope.previewfti.uid,
                  fti: scope.previewfti,
                  name: scope.previewfti.name,
                  theme: scope.previewfti.theme,
                  style: scope.previewfti.defaultStyle,
                  gctype: 'g2c',
                  scaleMethod: 'OGC',
                };

                url0 =
                  $location.protocol() +
                  '://' +
                  $location.host() +
                  '/geoserver/' +
                  PortalsFactory.getPortalId() +
                  '/wms?';
                url0 += 'SERVICE=WMS&VERSION=1.1.0&REQUEST=GetMap&';
                url0 +=
                  'LAYERS=' +
                  scope.previewfti.name +
                  '&styles=' +
                  scope.previewfti.defaultStyle;
                url0 += '&TILED=false&type=g2c&WIDTH=1843&HEIGHT=939&';
                url0 += 'FORMAT=image%2Fpng&TRANSPARENT=true&';
                url0 +=
                  '&CRS=EPSG%3A3857&BBOX=' +
                  bbox[0] +
                  '%2C' +
                  bbox[1] +
                  '%2C' +
                  bbox[2] +
                  '%2C' +
                  bbox[3];
                scope.urlWMS = url0;
                console.log(url0);
                //var URL = $location.protocol()+"://"+$location.host()+'/geoserver/'+PortalsFactory.getPortalId()+'/wms?token=' +'007'+'&service=WMS&version=1.1.0&request=GetMap&LAYER='+l.name+'&styles='+l.style+'&bbox='+currExtent.join(',')+'&width='+1000+'&height='+800+'&srs=EPSG:3857&format=image/svg';
                /*  if (!angular.isUndefined(l.style))
                                  {
                                      link =  $location.protocol()+"://"+$location.host()+'/geoserver/'+PortalsFactory.getPortalId()+'/wms?service=WMS&REQUEST=GetLegendGraphic&VERSION=1.0.0&FORMAT=image/png&WIDTH=20&HEIGHT=20&LAYER='+l.name+'&STYLE='+l.style;
                                  }
                                  else
                                  {
                                      link =  $location.protocol()+"://"+$location.host()+'/geoserver/'+PortalsFactory.getPortalId()+'/wms?service=WMS&REQUEST=GetLegendGraphic&VERSION=1.0.0&FORMAT=image/png&WIDTH=20&HEIGHT=20&LAYER='+l.name;
                                  }*/
                //console.log(l);
                //map.addLayer(l);
              },
              function(data) {
                require('toastr').info(data);
              }
            );
          }
        };
      },
    };
  };
  // definition les injection de singleton
  getwmswfs.$inject = [
    'gcWMS',
    'FeatureTypeFactory',
    '$location',
    'ogcFactory',
    'PortalsFactory',
  ];
  return getwmswfs;
});
