'use strict';
define(function() {
  var importTransferLayerFactory = function(PortalsFactory,$http) {

    const LATEST_CONFIG_VERSION = 1;
    let portalId = PortalsFactory.getPortalId();
    let appName = angular.module('gcMain').app;


    const getAllConfigsContent = () => {
      const url = '/services/{portalid}/{appname}/importTransferLayer/getAllConfigsContent';
      return $http.get(url);
    }

    const doTransferLayerFromWidget = (parameters) => {
      const baseUrl = '/services/{portalid}/{appname}/importTransferLayer/doTransferLayerFromWidget';
      return $http.post(baseUrl, parameters);
    }

    const downloadJournal = (fileUrl) => {
      return '/services/' + portalId + '/' + appName + '/importTransferLayer/downloadJournal?fileUrl=' + fileUrl;
    }
    /**
     * lance le transfert de couche à partir du nom de la config 
     * @param {string} appName (nullable) le nom de l'application qui contient la config
     * @param {string} configName le nom de la config à executer
     * @param {string} newFilter (nullable) le filtre qui va remplacer le filtre déja présent dans la config
     * @returns 
     */
    const doTransferLayerByConfigName = (appName, configName, newFilter) => {
      const baseUrl = '/services/{portalid}/'
        + (appName ? appName : '{appname}')
        + '/importTransferLayer/doTransferLayerByConfigName';
      const parameters =
        '?configName=' + (configName ? configName : '') +
        '&newFilter=' + (newFilter ? newFilter: '');
      return $http.get(baseUrl + parameters);
    }

    const getConfigNames = (appName) => {
      let baseUrl;
      if (appName) {
        //we need to call this function from admin and provide manually the appName sometimes
        baseUrl = '/services/{portalid}/' + appName + '/importTransferLayer/getConfigNames';
      } else {
        baseUrl = '/services/{portalid}/{appname}/importTransferLayer/getConfigNames';
      }
      return $http.get(baseUrl);
    }

    const verifyTransferLayerConfig = (sourceComponentFtid, destinationComponentFtid, filterOnData, associationToLoad, applyBusinessRules, fieldsMapping,
      defaultValues, updateFeatures, jointureSourceAttribute, jointureDestinationAttribute, deleteSourceLayer) => {
      const baseUrl = '/services/{portalid}/{appname}/importTransferLayer/verifyTransferLayerConfig';
      const parameters =  {
        sourceComponentFtid: sourceComponentFtid,
        destinationComponentFtid: destinationComponentFtid,
        filterOnData : filterOnData,
        associationToLoad: associationToLoad,
        applyBusinessRules: applyBusinessRules,
        fieldsMapping: fieldsMapping,
        defaultValues: defaultValues,
        updateFeatures: updateFeatures,
        jointureSourceAttribute: jointureSourceAttribute,
        jointureDestinationAttribute: jointureDestinationAttribute,
        filterSelection:[],
        deleteSourceLayer: deleteSourceLayer
      };
      return $http.post(baseUrl, parameters);
    }

    /**
     * mets à jour une config vers un format plus récent.
     * @param {*} config the config content as JSON
     * @returns the config updated to new format
     */
    const updateConfigToLastVersion = (config) => {
      if (config.configVersion < LATEST_CONFIG_VERSION) {
        console.error('cette config est dans une vielle version' + config.conf);
        // TODO gérer la migration vers la nouvelle version.
      } else {
        return config;
      }
    }

    /**
     * récupère les alias source et destination de la config (configName)
     * pourqu'il puisse être affichier à l'utilisateur sans excecuter la copie
     * @param {string} appName (optionel) le nom de l'application qui contient la config
     * @param {string} configName le nom de la config à executer
     * @returns 
     */
    const getComponentsAliasesFromConfigName = (appName, configName) => {
      const baseUrl = '/services/{portalid}/'
        + (appName ? appName : '{appname}')
        + '/importTransferLayer/getComponentsAliasesFromConfigName';
      const parameters =
        '?configName=' + (configName ? configName : '');
      return $http.get(baseUrl + parameters);
    };

    return {
      getAllConfigsContent: getAllConfigsContent,
      doTransferLayerFromWidget: doTransferLayerFromWidget,
      doTransferLayerByConfigName: doTransferLayerByConfigName,
      getConfigNames: getConfigNames,
      verifyTransferLayerConfig, 
      updateConfigToLastVersion: updateConfigToLastVersion,
      getComponentsAliasesFromConfigName: getComponentsAliasesFromConfigName,
      downloadJournal: downloadJournal,
      LATEST_CONFIG_VERSION: LATEST_CONFIG_VERSION
    };
  };
  importTransferLayerFactory.$inject = ['PortalsFactory','$http'];
  return importTransferLayerFactory;
});
