'use strict';
define(function() {
  var majicBatiConsult = function(MajicFactory, $q) {
    return {
      templateUrl: 'js/XG/widgets/mapapp/majic/views/majicBatiConsult.html',
      restrict: 'E',

      // scope commun

      // methode executée au chargement de la page
      link: function(scope, element, attrs, ctrl) {
        // Initialize tabs
        scope.tabsBatConsult = [
          {
            title: 'Batiment',
          },
          {
            title: 'PEV',
          },
        ];
        scope.tabsBatConsult.activeTab = 0;

        scope.tabsLocalConsult = [
          {
            title: 'Habitat',
          },
          {
            title: 'Dépendance et professionnel',
          },
          {
            title: 'Exonérations',
          },
          {
            title: 'Propriétaire',
          },
        ];
        scope.tabsLocalConsult.activeTab = 0;

        // Handler du changement de sélection d'onglet de consultation
        scope.$watch('tabsBatConsult.activeTab', function(value) {
          if (scope.tabsBatConsult.activeTab == 1) {
            // Chargement des données de l'onglet PEV pour la
            // parcelle 'selectedParc' sélectionnée
            VuePEV();
          }
        });

        var idcommune = '';
        var idparcelle = '';
        var bPEV = false;

        scope.initBatiBoolean = function() {
          bPEV = false;
        };

        scope.initBatiView = function(typeLocal) {
          scope.typeLocal = typeLocal;
          scope.tabsBatConsult.activeTab = 0;

          if (scope.selectedParc == undefined) return;
          scope.batIdCommune = idcommune = scope.selectedParc.Parcelle.substr(
            0,
            6
          );
          scope.batIdParcelle = idparcelle = scope.selectedParc.Parcelle.substr(
            6
          );

          VueBatiment(undefined, typeLocal);
        };

        // ////////////////////////////////////////////////////////////
        // Onglet Batiment
        // ///////////////////////////////////////////////////////////

        var batimentInfosResults = [];
        scope.iBati = 0;
        scope.batimentInfosResult = {};

        function VueBatiment(compte, typeLocal, pIdcommune, pIdparcelle) {
          var defer = $q.defer();
          if (scope.selectedParc != undefined) {
            idcommune = scope.selectedParc.Parcelle.substr(0, 6);
            idparcelle = scope.selectedParc.Parcelle.substr(6);
          }
          if (idcommune == undefined) {
            idcommune = pIdcommune;
            idparcelle = pIdparcelle;
          }

          if (idcommune != '') {
            MajicFactory.getbatibyid(idcommune, idparcelle, typeLocal).then(
              function(res) {
                var newLocList = [];
                scope.batimentInfosResults = batimentInfosResults = res.data;
                if (typeLocal != 'locauxDesLots')
                  scope.locauxPrincipaux = res.data;

                if (compte != undefined) {
                  for (
                    var iLoc = 0;
                    iLoc < batimentInfosResults.length;
                    iLoc++
                  ) {
                    if (compte == batimentInfosResults[iLoc].prop) {
                      newLocList.push(batimentInfosResults[iLoc]);
                    }
                  }
                  scope.batimentInfosResults = batimentInfosResults = newLocList;
                }
                changeBatiment(0, typeLocal);
                return defer.resolve();
              },
              function(reason) {
                var resultObject = reason;
                console.log('VueBatiment echec : ' + resultObject);
                require('toastr').error('VueBatiment:' + resultObject);
                return defer.reject();
              }
            );
          }
          return defer.promise;
          // }
        }
        scope.vueBatiment = function(compte, idcommune, typeLocal) {
          return VueBatiment(compte, typeLocal, idcommune, scope.batIdParcelle);
        };

        scope.getTheCoProp = function() {
          if (scope.batimentInfosResult != undefined) {
            for (var iProp = 0; iProp < scope.coprops.length; iProp++) {
              if (
                scope.coprops[iProp].compte == scope.batimentInfosResult.prop
              ) {
                scope.proprioInfosResult = scope.coprops[iProp];
                break;
              }
            }
          }
        };

        scope.getTheProp = function() {
          if (scope.batimentInfosResult != undefined) {
            scope.VueProprietaire(scope.batimentInfosResult.prop);
          }
        };

        function changeBatiment(i, typeLocal) {
          scope.batimentInfosResult = batimentInfosResults[i];
          scope.iBati = i;
          if (typeLocal == 'locauxDesLots') {
            scope.getTheCoProp();
          } else if (typeLocal == 'locauxPrincipaux') {
            scope.getTheProp();
          }
        }

        scope.BatiPrec = function() {
          if (scope.iBati <= 0) return;
          changeBatiment(--scope.iBati, scope.typeLocal);
        };
        scope.BatiSuiv = function() {
          if (scope.iBati >= batimentInfosResults.length - 1) return;
          changeBatiment(++scope.iBati, scope.typeLocal);
        };

        // ////////////////////////////////////////////////////////////
        // Onglet PEV
        // ///////////////////////////////////////////////////////////

        var pevInfosResults = [];
        var iPEV = 0;
        scope.pevInfosResult = {};

        function VuePEV() {
          if (bPEV == false) {
            if (idcommune != '') {
              bPEV = true;
              MajicFactory.getpevbyid(idcommune, idparcelle).then(
                function(res) {
                  pevInfosResults = res.data;
                  changePEV(0);
                },
                function(reason) {
                  var resultObject = reason;
                  console.log('VuePEV echec : ' + resultObject);
                  require('toastr').error('VuePEV:' + resultObject);
                }
              );
            }
          }
        }

        function changePEV(i) {
          iPEV = i;
          scope.pevInfosResult = pevInfosResults[iPEV];
        }
        scope.PevPrec = function() {
          if (iPEV <= 0) return;
          changePEV(--iPEV);
        };
        scope.PevSuiv = function() {
          if (iPEV >= pevInfosResults.length - 1) return;
          changePEV(++iPEV);
        };
      },
    };
  };
  majicBatiConsult.$inject = ['MajicFactory', '$q'];
  return majicBatiConsult;
});
