'use strict';
define(function() {
  var gcmapgeocoderreverse = function(
    kisGeocodageFactory,
    gaDomUtils,
    $timeout,
    $rootScope,
    $compile,
    $filter
  ) {
    return {
      templateUrl: 'js/XG/widgets/mapapp/map/views/gcmapgeocoderreverse.html',
      restrict: 'EA',

      link: function(scope, element, attrs, ctrl) {
        scope.isActive = false;

        scope.geocoderCfg = {};

        var btnElt = $(element.children()[0]);
        btnElt.bind('click', function($event) {
          // si $event.target.id != "toolbargeocoderreverse_btn"
          // return;

          if (scope.isActive) {
            btnElt.removeClass('btn-info');
            btnElt.addClass('btn-default');
            scope.isActive = false;
            removePopups();
            $('.mapGeocoderPicker').remove();
            map.removeInteraction(draw);
          } else {
            btnElt.removeClass('btn-default');
            btnElt.addClass('btn-info');
            scope.isActive = true;
            //map.addInteraction(scope.pointer);
            dessin();
            map.addInteraction(draw);

            /*     var geocoderPicker = '<div class="mapGeocoderPicker col-xs-12">' +
                            '<label class="col-xs-4 title">Geocoder:</label>' +
                            '<div class="col-xs-8">' +
                            '<kis-geocoder-picker res="geocoderCfg.value" hide-detail="true"></kis-geocoder-picker>' +
                            '</div>' +
                            '<div ng-if="renderPopupNum()" class="col-xs-12">' +
                            '<div class="btn btn-default btn-xs pull-right" ng-click="closeAllPopups()">' +
                            '<i class="fa fa-times" ></i>' +
                            '</div>' +
                            '</div></div>';*/

            //  angular.element(document).find('body').eq(0).append($compile(geocoderPicker)(scope));
          }
          //if(scope.pointer)
          //scope.pointer.setActive(scope.isActive);
        });

        scope.$watch(
          'geocoderCfg',
          function(x) {
            console.log(x);
          },
          1
        );

        scope.closeAllPopups = function() {
          removePopups();
        };

        var map = scope.map;
        var config = scope.config;
        var features = new ol.Collection();
        var drawStyle = new ol.style.Style({
          fill: new ol.style.Fill({
            color: 'rgba(255, 255, 255, 0.5)',
          }),
          stroke: new ol.style.Stroke({
            color: '#3498db',
            width: 2,
          }),
          image: new ol.style.Circle({
            radius: 7,
            fill: new ol.style.Fill({
              color: '#3498db',
            }),
          }),
        });

        /**
         * dessin
         */
        var draw;
        var dessin = function() {
          map.removeInteraction(draw);

          draw = new ol.interaction.Draw({
            features: features,
            type: 'Point',
            style: drawStyle,
          });
          draw.set('gctype', 'kis');
          draw.set('interaction', 'Draw');
          draw.set('widget', 'geocode');
          map.addInteraction(draw);

          draw.on('drawend', function(e) {
            if (scope.isActive == false) {
              map.removeInteraction(draw);
              return false;
            }

            var coords = e.feature.getGeometry().getCoordinates();
            var coords_4326 = ol.proj.transform(
              coords,
              map
                .getView()
                .getProjection()
                .getCode(),
              'EPSG:4326'
            );

            if (!scope.geocoderCfg.value) {
              require('toastr').error(
                $filter('translate')(
                  'common.directives.position_autocomplete.service_vide'
                )
              );
              return false;
            }
            gaDomUtils.showGlobalLoader();
            var promise = kisGeocodageFactory.reverse(
              kisGeocodageFactory.getGeocoderConfigFromId(
                scope.geocoderCfg.value
              ).url,
              coords_4326
            );

            promise.then(
              function(res) {
                gaDomUtils.hideGlobalLoader();
                var text_content = res.data.features[0].properties.label;
                setPopups(coords, text_content);
              },
              function() {
                gaDomUtils.hideGlobalLoader();
              }
            );
            /*   $timeout(function () {
                         map.removeInteraction(draw);
                         });*/
          });
        };

        /**
         * close Popup
         * @param event
         */
        scope.closeGeocodeReversePopup = function(event) {
          var popup = angular.element(event.target).parent();
          popup.remove();
        };
        /**
         * open popup
         * @param coords
         * @param text_content
         */
        var setPopups = function(coords, text_content) {
          var overlayz = [];
          // cleanup
          // removePopups();
          // style

          var coordinate = coords;
          var uniqid = 'geocoderpopup_' + Date.now();
          var tpl =
            ' <div id="' +
            uniqid +
            '" class="ol-popup annotationPopup" >' +
            '<div class="popup-content"></div>' +
            '<div class="ol-popup-closer-geocoder" ng-click="closeGeocodeReversePopup($event)"></div>' +
            '</div>';

          // angular.element(document).find('body').eq(0).append(tpl);
          angular
            .element(document)
            .find('body')
            .eq(0)
            .append($compile(tpl)(scope));

          var container = document.getElementById(uniqid);

          var content = $(container).find('.popup-content');
          var closer = $(container).find('.ol-popup-closer-geocoder');

          $(container)
            .find('.popup-content')
            .html(text_content);

          var overlay = new ol.Overlay({
            element: container,
            autoPan: true,
            insertFirst: false,
            autoPanAnimation: {
              duration: 250,
            },
          });
          overlay.set('origin', uniqid);

          map.addOverlay(overlay);
          overlay.setPosition(coordinate);
        };

        /**
         * remove all popups
         */
        var removePopups = function() {
          $('.annotationPopup').remove();
          for (var i = map.getOverlays().getLength() - 1; i >= 0; i -= 1) {
            var overlay = map.getOverlays().getArray()[i];
            if (overlay.get('origin').indexOf('geocoderpopup_') == 0) {
              map.removeOverlay(overlay);
            }
          }
        };

        /**
         * return num of popup
         * @returns {boolean}
         */
        scope.renderPopupNum = function() {
          var num = 0;
          for (var i = map.getOverlays().getLength() - 1; i >= 0; i -= 1) {
            var overlay = map.getOverlays().getArray()[i];
            if (overlay.get('origin').indexOf('geocoderpopup_') == 0) {
              num++;
            }
          }
          var res = false;
          if (num >= 2) {
            res = true;
          }
          return res;
        };
      },
    };
  };

  gcmapgeocoderreverse.$inject = [
    'kisGeocodageFactory',
    'gaDomUtils',
    '$timeout',
    '$rootScope',
    '$compile',
    '$filter',
  ];
  return gcmapgeocoderreverse;
});
