'use strict';
define(function() {
  const gcelement = function(
    FeatureAttachmentFactory,
    ngTableParams,
    $q,
    $filter,
    gaDomUtils,
    $timeout,
    $rootScope,
    ngDialog,
    QueryFactory,
    $compile,
    FeatureTypeFactory,
    UsersFactory,
    gaJsUtils,
    HtmlUtils
  ) {
    return {
      templateUrl: 'js/XG/widgets/utilities/data/views/featureattachment.html',
      restrict: 'EA',
      scope: {
        feature: '=feature',
        // allow the upload of only one file (ie previous files are
        // deleted when a new one is updated)
        singleUpload: '=?',
        // only used when the feature is not saved yet (for example when
        // created from the builder)
        featureType: '=?',
        attachmentNumber: '=?', // return the number of attachment per page
        totalAttachmentNumber: '=?', // return the number of attachment
        cannotModify: '=?',
        showExtraInformations: '=?', // show some extra informations
        // such as creation date, last
        // modified, etc..
        dossier: '=',
        checkboxChanged: '&',
        getSelectedCheckboxes: '&',
        showPhotoOnly: '=?', // show only photo
        filesList: '=?' // liste des noms de fichiers attachés
      },

      link: function(scope) {
        /* Check Autorisation d'ajout et de suppression de fichiers attachés. */
        scope.isAdmin = $rootScope.xgos.isroot || $rootScope.xgos.isadmin;

        scope.isAttachedFileManagerAutorized =
            gaJsUtils.userHasRole($rootScope.xgos.user, 'AttachedFileManager');

        // Si l'utilisateur actuel à les droits d'écriture sur le featureType,
        // il peut gérer les fichiers attachés
        if(scope.featureType && typeof scope.featureType === 'string') {
          scope.hasWriteRightsOnComponent =
              UsersFactory.userHasWriteRight($rootScope.xgos.user,
                FeatureTypeFactory.getFeatureByName(
                  scope.featureType).uid);
        }

        /* access depuis browser seulement, pas appli android */
        scope.isMobileBrowser =
          /Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(
            navigator.userAgent
          ) && typeof ancAppAndroid == 'undefined';

        scope.showExtraInformations = scope.showExtraInformations === true;

        /**
         * Récupération de la FeatureType du composant traité
         *
         * @returns FeatureType description de la couche traitée
         */
        const getFeatureType = () => {
          if (!scope.featureType || !scope.featureType.name) {
            if (scope.feature && scope.feature.featuretype) {
              scope.featureType = FeatureTypeFactory.getFeatureByName(
                scope.feature.featuretype
              );
              if (!scope.featureType) {
                console.error('Erreur de chargement du FTI de la couche traitée' );
              }
            }
          }
        };
        getFeatureType();

        if (typeof ancAppAndroid !== 'undefined')
          scope.ancAppAndroid = ancAppAndroid;

        scope.wait = true;
        scope.data = [];
        scope.currentPageData = [];
        scope.lastFile = null;
        scope.amountChecked = 0;

        scope.showPhotoOnly = false;
        var tmpId;
        var changeAttachmentIdAfterSave = false;
        var inArray = Array.prototype.indexOf
          ? function(val, arr) {
            return arr.indexOf(val);
          }
          : function(val, arr) {
            var i = arr.length;
            while (i--) {
              if (arr[i] === val) return i;
            }
            return -1;
          };

        scope.extraInformations = {};

        var valwatch = scope.$watch('feature', function(value) {
          scope.getFeatureAttachments(value);
        });


        /**
         * Si pas d'objet pour l'attachement, on se sert uniquement
         * de scope.featureType et on aliment le value (l'objet)
         * avec ce qu'il faut.
         *
         * @param {*} value
         * @returns
         */
        let getFeatAttachmentsWithoutValue = (value) => {
          if (!scope.featureType) {
            return;
          }
          // generate uniqid
          tmpId = scope.featureType.name + '.' + Date.now();
          value.featuretype = scope.featureType;

          changeAttachmentIdAfterSave = true;

          /**
          * when the new feature is saved we move the data uploaded in
          * featurename.uniqid to featurename.realid
          */
          var changeAttachmentId = scope.$watch(
            'feature.id',
            function(id) {
              // set the correct id
              if (angular.isDefined(id)) {
                // call webservice only if needed
                if (scope.currentPageData.length) {
                  FeatureAttachmentFactory.changeid(
                    scope.featureType.name,
                    tmpId,
                    getFeatureId(scope.feature, scope.featureType)
                  ).then(
                    function() {
                      $rootScope.$broadcast('changeAttachmentId_ok');
                    },
                    function() {}
                  );
                } else {
                  $rootScope.$broadcast('changeAttachmentId_ok');
                }

                // opérer au changement d'id de vers feature.id
                changeAttachmentIdAfterSave = false;
                changeAttachmentId();
              }
            },
            1
          );
        };


        scope.getFeatureAttachments = function(value) {
          if (value !== undefined) {
            let fti;
            // when feature is a featureType object,
            // gotta retrieve the feature name
            if (angular.isDefined(value.type) && value.type === 'Feature'
              && typeof value.id === 'string') {
              var tmp = value.id.split('.');
              value.featuretype = tmp[0];
              fti = FeatureTypeFactory.getFeatureByName(value.featuretype);
            }

            // Si l'utilisateur actuel à les droits d'écriture sur le featureType,
            // il peut gérer les fichiers attachés
            if(value.featuretype) {
              let ftiName;
              if (value.featuretype.name) {
                ftiName = value.featuretype.name;
              }
              else {
                ftiName = value.featuretype;
              }
              scope.hasWriteRightsOnComponent =
                  UsersFactory.userHasWriteRight($rootScope.xgos.user,
                    FeatureTypeFactory.getFeatureByName(
                      ftiName).uid);
            }

            if (value.featuretype == undefined || value.id == undefined) {
              getFeatAttachmentsWithoutValue(value);
            } else {
              fti = FeatureTypeFactory.getFeatureByName(value.featuretype);
              if (!scope.featureType) {
                // -- Cas où featureType pas positionné (intervention simple)
                scope.featureType = fti;
              }
              let promise;
              // ancAppAndroid n'est jamais défini ds la directive, je ne comprend pas l'intérêt
              if (scope.showExtraInformations && typeof ancAppAndroid === 'undefined') {
                promise = FeatureAttachmentFactory.listallinformations(
                  value.featuretype,
                  getFeatureId(value, fti)
                )
              } else {
                promise = FeatureAttachmentFactory.list(value.featuretype,
                  getFeatureId(value, fti));
              }

              promise.then(function(res) {
                prepareAttachmentTable(res.data);
              });
            }

            scope.wait = false;
          }
        };

        /**
         * Mise à jour de la liste des fichiers attachés (ex. dans l'onglet
         * "Pièces jointes" de l'IS)
         * Reformatage dans une méthode du callback success de l'appel api
         * de la méthode getFeatureAttachments
         * Le reformatage a pour seul but de pouvoir appeler ce code depuis
         * plusieurs méthodes sans duplicats.
         * Il est voulu que le code de cette méthode ait conservé les malfaçons KIS
         * @param {string[]} data tableau des noms de fichiers attachés du feature
         */
        const prepareAttachmentTable = (data) => {
          scope.totalAttachmentNumber = data.length;

          // move the extra informations to extraInformations
          // and set the data an as array of names only,
          // so the rest of the directive will still work
          if (scope.showExtraInformations && typeof ancAppAndroid == 'undefined') {
            data = data.map(function(x) {
              scope.extraInformations[x.name] = x;
              return x.name;
            });
          }

          scope.data = angular.copy(data);

          scope.tableParams = new ngTableParams(
            {
              page: 1, // show first page
              count: 10 // count per page
            },
            {
              total: scope.data.length, // length of data
              $scope: scope,
              getData: function($defer, params) {
                // use build-in angular filter
                params.total(scope.data.length);
                $defer.resolve(
                  (scope.currentPageData = scope.data.slice(
                    (params.page() - 1) * params.count(),
                    params.page() * params.count()
                  ))
                );
              }
            }
          );
          scope.tableParams.reload();

          scope.checkboxes = {
            checked: false,
            items: {},
          };

          scope.changeAllCheckboxes = function(isChecked) {
            angular.forEach(scope.data, function(item) {
              if (angular.isDefined(item)) {
                scope.checkboxes.items[item] = isChecked;
                scope.onCheckboxChange(scope.feature.id, item, isChecked);
              }
            });
          };

          // watch for data
          // checkboxes
          scope.$watch(
            'checkboxes.items',
            function() {
              if (!scope.data) return;

              var checked = 0,
                unchecked = 0,
                total = scope.data.length;
              angular.forEach(scope.data, function(item) {
                checked += scope.checkboxes.items[item] || 0;
                unchecked += !scope.checkboxes.items[item] || 0;
              });
              if (unchecked == 0 || checked == 0) {
                scope.checkboxes.checked = checked == total;
              }
              // grayed checkbox
              angular
                .element(document.getElementById('select_all'))
                .prop('indeterminate', checked != 0 && unchecked != 0);
              scope.amountChecked = checked;
            },
            true
          );

          scope.wait = false;
          try {
            let selectedCheckboxes = scope.getSelectedCheckboxes()(
              scope.feature.id
            );
            selectedCheckboxes.forEach(
              item => (scope.checkboxes.items[item] = true)
            );
          } catch (e) {}
        };

        scope.onCheckboxChange = function(featureId, document, isChecked) {
          try {
            scope.checkboxChanged()(featureId, document, isChecked);
          } catch (e) {}
        };

        scope.$on('$destroy', function() {
          valwatch();
        });

        scope.$on('refreshFeatureAttachment', function(event, args) {
          console.log(args.id, scope.feature.id);
          console.log(args.featuretype, scope.feature.featuretype);

          if (
            args &&
            args.id === scope.feature.id &&
            args.featuretype === scope.feature.featuretype
          ) {
            // trigger refresh, kinda hacky
            scope.getFeatureAttachments(scope.feature);
          }
        });

        scope.downloadAttachment = function(documentId) {
          scope.wait = true;

          FeatureAttachmentFactory.getdownloadurl(
            documentId,
            scope.featureType.name,
            getFeatureId(scope.feature, scope.featureType)
          ).then(function(res) {
            window.open(res.data);
            scope.wait = false;
          });
        };

        var setUploadListener = 0;
        scope.initFile = function(inputFile) {
          var f = inputFile.files[0];
          scope.renamedFilesToDisplay = [];
          scope.allFiles = [];
          let formData = new FormData();

          let dossierReference = scope.dossier
            ? scope.dossier.properties.ref_dossier
            : '';
          let pictureDate = moment()
            .format('DD/MM/YYYY/h/mm/ss')
            .split('/')
            .join('');

          for (
            let fileIndex = 0;
            fileIndex < inputFile.files.length;
            fileIndex++
          ) {
            let pictureName = scope.isMobileBrowser
              ? dossierReference + '_' + pictureDate + '.png'
              : inputFile.files[fileIndex].name;
            formData.append('file', inputFile.files[fileIndex], pictureName);
          }

          try {
            scope.$apply(function() {
              scope.lastFile = f;
              for (let key of formData.entries()) {
                let filename = { name: key[1].name };
                scope.renamedFilesToDisplay.push(filename);
                scope.allFiles.push(key[1]);
              }
              scope.refreshListAttachement();
            });
          } catch(err) {}

          if (!setUploadListener) {
            setUploadListener = true;
            inputFile.addEventListener(
              'click',
              function() {
                this.value = '';
              },
              false
            );
          }
        };

        scope.getPicture = function() {
          var idTosave = !changeAttachmentIdAfterSave
            ? scope.feature.id
            : tmpId;
          if (
            scope.feature.featuretype &&
            idTosave &&
            typeof ancAppAndroid !== 'undefined'
          )
            ancAppAndroid.getPicture(
              scope.feature.featuretype,
              scope.dossier.properties.ref_dossier,
              scope.feature.id
            );
        };

        scope.browseDisk = function() {
          var idTosave = !changeAttachmentIdAfterSave
            ? scope.feature.id
            : tmpId;
          if (
            scope.feature.featuretype &&
            idTosave &&
            typeof ancAppAndroid !== 'undefined'
          )
            ancAppAndroid.browseDisk(
              scope.feature.featuretype,
              scope.dossier.properties.ref_dossier,
              scope.feature.id
            );
        };

        scope.refreshListAttachement = function() {
          var idTosave = !changeAttachmentIdAfterSave
            ? scope.feature.id
            : tmpId;
          if (idTosave && scope.feature && scope.feature.featuretype) {
            scope.getFeatureAttachments(scope.feature);
          }
        };

        scope.getPicture = function() {
          var idTosave = !changeAttachmentIdAfterSave
            ? scope.feature.id
            : tmpId;
          if (
            scope.feature.featuretype &&
            idTosave &&
            typeof ancAppAndroid !== 'undefined'
          )
            ancAppAndroid.getPicture(
              scope.feature.featuretype,
              scope.dossier.properties.ref_dossier,
              scope.feature.id
            );
        };

        scope.browseDisk = function() {
          var idTosave = !changeAttachmentIdAfterSave
            ? scope.feature.id
            : tmpId;
          if (
            scope.feature.featuretype &&
            idTosave &&
            typeof ancAppAndroid !== 'undefined'
          )
            ancAppAndroid.browseDisk(
              scope.feature.featuretype,
              scope.dossier.properties.ref_dossier,
              scope.feature.id
            );
        };

        scope.$on('signatureUploaded', () => scope.refreshListAttachement());

        scope.refreshListAttachement = function() {
          var idTosave = !changeAttachmentIdAfterSave
            ? scope.feature.id
            : tmpId;
          if (idTosave && scope.feature && scope.feature.featuretype) {
            scope.getFeatureAttachments(scope.feature);
          }
        };

        /**
         * cancelAttachmentUpload
         */
        scope.cancelAttachmentUpload = function() {
          scope.lastFile = null;
        };
        scope.uploadAttachements = function() {
          for (var i = 0; i < scope.allFiles.length; i++) {
            scope.uploadAttachment(scope.allFiles[i]);
          }
        };

        /**
         * Renvoie la valeur de l'identifiant unique
         * @param feature feature geojson
         * @param fti fti de la feature
         * @param forceUsingObjectId est true si l'on souhaite récupérer la valeur de la propriété
         * objectid même en présence d'un champ identifiant personnalisé
         * @return {string}
         */
        let getFeatureId = (feature, fti, forceUsingObjectId = false) => {
          return gaJsUtils.getIdInCaseEsriId(feature, fti, null, forceUsingObjectId);
        };

        scope.uploadAttachment = (file) => {
          if (file) {
            scope.fileToUploadName = file.name;
            scope.wait = true;
            gaDomUtils.showGlobalLoader();

            for (let i = 0; i < scope.data.length; i++) {
              if (file.name === scope.data[i]) scope.data.splice(i, 1);
            }

            for (let i = 0; i < scope.currentPageData.length; i++) {
              if (file.name === scope.currentPageData[i]) {
                scope.currentPageData.splice(i, 1);
              }
            }

            getFeatureType();
            const idTosave = !changeAttachmentIdAfterSave
              ? getFeatureId(scope.feature, scope.featureType)
              : tmpId;
            if (scope.showPhotoOnly) {
              const validFileExtensions = ['.jpg', '.jpeg', '.png'];
              if (!scope.verificationExtensionPhoto(file.name,validFileExtensions)) {
                gaDomUtils.hideGlobalLoader();
                const message =
                  'Error , les extensions autorisées sont : ' +
                  validFileExtensions.join(', ');
                require('toastr').error(message);
                return;
              }
            }
            FeatureAttachmentFactory.uploadFile(
              file,
              scope.feature.featuretype,
              idTosave ,{}, scope.showPhotoOnly
            ).then(function () {
              scope.refreshListAttachement();
              scope.wait = false;
              scope.lastFile = null;
              $timeout(function () {
                gaDomUtils.hideGlobalLoader();
              }, 1000);
              scope.totalAttachmentNumber = scope.data.length;
              $rootScope.$broadcast('feature_attachment_edit', {
                action: 'add',
                feature: scope.feature,
              });

              // delete everything first
              if (scope.singleUpload) {
                angular.forEach(scope.data, function(item) {
                  if (angular.isDefined(item)) {
                    scope.checkboxes.items[item] = 1;
                  }
                });
                scope.deleteSelectedAttachments();
              }
            },
            function() {
              gaDomUtils.hideGlobalLoader();
              require('toastr').error(
                'Erreur lors de la récupération du document.'
              );
              gaDomUtils.hideGlobalLoader();
            }
            );
          }
        };

        // Disable removeBoutton attachement
        scope.disabledButtonRemoveAttachement = () => {
          let disableButton = true;
          if (scope.feature.id && angular.isArray($rootScope.xgos.user.roles)) {
            const grantedRoles = ['ANC_responsable', 'sRootUser', 'rootUser',
              'AttachedFileManager'];
            disableButton = !$rootScope.xgos.user.roles.some(
              rootRole => grantedRoles.includes(rootRole.name)) && !scope.hasWriteRightsOnComponent;
          }
          return disableButton;
        };

        scope.deleteAttachment = (documentId) => {
          const ans = confirm($filter('translate')('common.confirm_action'));
          if (ans) {
            scope.wait = true;
            if (typeof ancAppAndroid !== 'undefined') {
              const res = ancAppAndroid.removeAttachement(
                documentId,
                scope.featureType.name,
                scope.feature.id
              );
              if (res) scope.refreshListAttachement();
            }
            else {
              getFeatureType();
              FeatureAttachmentFactory.remove(
                documentId, scope.featureType.name,
                getFeatureId(scope.feature, scope.featureType)
              ).then(function(res) {
                scope.wait = false;
                if (res.data === true) {
                  for (let i = 0; i < scope.data.length; i++) {
                    if (scope.data[i] === documentId) scope.data.splice(i, 1);
                  }
                  for (let i = 0; i < scope.currentPageData.length; i++) {
                    if (scope.currentPageData[i] === documentId) {
                      scope.currentPageData.splice(i, 1);
                    }
                  }
                  scope.totalAttachmentNumber = scope.data.length;
                  $rootScope.$broadcast('feature_attachment_edit', {
                    action: 'remove',
                    feature: scope.feature
                  });
                }
                scope.refreshListAttachement();
                $rootScope.$broadcast('attachmentChanged',
                  { 'scopeId': scope.$id,
                    'removedFile': documentId,
                    'featureId': scope.feature.id
                  });
              });
            }
            scope.onCheckboxChange(scope.feature.id, documentId, false);
          }
        };

        scope.showAttachment = function(documentId) {
          if (typeof ancAppAndroid !== 'undefined') {
            gaDomUtils.showGlobalLoader();
            QueryFactory.getAttachementAndroid(
              documentId, scope.featureType.name, scope.feature.id
            ).then(
              function(res) {
                if (res.data) {
                  scope.src = res.data;
                  scope.title = documentId;
                  ngDialog.openConfirm({
                    template: 'js/XG/widgets/utilities/data/views/showimg.html',
                    className:
                      'ngdialog-theme-plain width500 nopadding miniclose',
                    scope: scope,
                  });
                }
                gaDomUtils.hideGlobalLoader();
              },
              function() {
                gaDomUtils.hideGlobalLoader();
              }
            );
          }
        };

        /**
         * deleteSelectedAttachments
         */
        scope.deleteSelectedAttachments = function() {
          var ans = confirm($filter('translate')('common.confirm_action'));
          if (ans) {
            var attachmentsToDelete = [];

            for (var j = 0; j < scope.data.length; j++) {
              var item = scope.currentPageData[j];
              if (scope.checkboxes.items[item]) attachmentsToDelete.push(item);
            }

            if (attachmentsToDelete.length > 0) {
              scope.wait = true;
              FeatureAttachmentFactory.remove(
                attachmentsToDelete,
                scope.featureType.name,
                getFeatureId(scope.feature, scope.featureType)
              ).then(function(res) {
                scope.wait = false;
                if (res.data === true) {
                  for (let j = 0; j < scope.data.length; j++) {
                    let item = scope.data[j];
                    if (scope.checkboxes.items[item]) {
                      attachmentsToDelete.push(item);
                      scope.data.splice(j, 1);
                      j--;
                    }
                  }

                  for (let j = 0; j < scope.currentPageData.length; j++) {
                    let item = scope.currentPageData[j];
                    if (scope.checkboxes.items[item]) {
                      scope.currentPageData.splice(j, 1);
                      j--;
                    }
                  }
                  scope.totalAttachmentNumber = scope.data.length;
                }
                scope.refreshListAttachement();
              });
              attachmentsToDelete.forEach(documentId =>
                scope.onCheckboxChange(scope.feature.id, documentId, false)
              );
            }
          }
        };

        scope.names = function() {
          var def = $q.defer(),
            arr = [],
            names = [];
          angular.forEach(data, function(item) {
            if (inArray(item.name, arr) === -1) {
              arr.push(item.name);
              names.push({
                id: item.name,
                title: item.name,
              });
            }
          });
          def.resolve(names);
          return def;
        };

        $timeout(function() {
          let buttonsForMobile = angular.element(
            document.querySelectorAll('.featureAttachmentButtonsMobile')
          );

          // move button Parcourir ou prendre une photo on top of tab in
          // Documents du controle
          if (
            angular.element(document).find('.buttonPlaceholder') &&
            buttonsForMobile[0] !== null &&
            buttonsForMobile[0] !== undefined &&
            angular.element(
              document.querySelector('.documentsSousPartiesPourTabs')
            ).length > 0
          ) {
            let newButtonPlaceholderDiv = document.createElement('div');
            newButtonPlaceholderDiv.classList.add('buttonPlaceholder');
            angular
              .element(document.querySelector('.spbrow h4'))[0]
              .parentElement.parentElement.prepend(newButtonPlaceholderDiv);

            if (
              document.querySelector('.buttonPlaceholder') !== null &&
              document.querySelector('.buttonPlaceholder') !== undefined
            ) {
              let buttonToBeAppended = $compile(buttonsForMobile[0])(scope)[0];
              angular
                .element(
                  document.querySelectorAll('.featureAttachmentButtonsMobile')
                )
                .remove();
              buttonToBeAppended = $compile(buttonsForMobile[0])(scope)[0];
              angular.element(
                document
                  .querySelector('.buttonPlaceholder')
                  .appendChild(buttonToBeAppended)
              );
              angular
                .element(document)
                .find('hr')
                .remove();
            }
          }

          // move button Parcourir ou prendre une photo on top of tab in
          // Documents du dossier
          if (
            angular.element(document).find('.buttonPlaceholderDocuments') &&
            buttonsForMobile[0] !== null &&
            buttonsForMobile[0] !== undefined &&
            angular.element(document.querySelector('.documentsSousParties'))
              .length > 0 &&
            $rootScope.countWhichTab !== undefined &&
            $rootScope.countWhichTab == 0
          ) {
            let newButtonPlaceholderDiv = document.createElement('div');
            newButtonPlaceholderDiv.classList.add('buttonPlaceholderDocuments');
            angular
              .element(document.querySelector('.spbrow h4'))[0]
              .parentElement.parentElement.prepend(newButtonPlaceholderDiv);

            if (
              document.querySelector('.buttonPlaceholderDocuments') !== null &&
              document.querySelector('.buttonPlaceholderDocuments') !==
                undefined
            ) {
              angular
                .element(
                  document.querySelector('.featureAttachmentButtonsMobile')
                )
                .remove();
              angular.element(
                document
                  .querySelector('.buttonPlaceholderDocuments')
                  .appendChild($compile(buttonsForMobile[0])(scope)[0])
              );
              angular
                .element(document)
                .find('hr')
                .remove();
              if ($rootScope.countWhichTab === undefined) {
                $rootScope.countWhichTab = 0;
              }
              $rootScope.countWhichTab = 1;
            }
          }
        }, 0);

        scope.$watch(
          'currentPageData',
          function(currentPageData) {
            if (currentPageData) {
              scope.attachmentNumber = currentPageData.length;
            }
            scope.filtrePhotos();
          },
          1
        );
        // fin
        scope.renameAttachment = (newName, name, conf) => {
          let ans = false;
          if (!conf) {
            ans = confirm($filter('translate')('common.confirm_action'));
          }
          if (ans || conf) {
            // Ajout de prefixe signet et l'extension de la photo
            let newNameWithPRefixAndExtension =
              scope.getNameFileAddSignetAndExtension(newName);
            scope.wait = true;
            if (typeof ancAppAndroid !== 'undefined') {
              let res = ancAppAndroid.renameAttachment(
                scope.featureAttachmentName
                  ? scope.featureAttachmentName
                  : name,
                newNameWithPRefixAndExtension,
                scope.feature.featuretype,
                scope.feature.id
              );
              if (res) scope.refreshListAttachement();
            } else {
              FeatureAttachmentFactory.rename(
                conf ? name : scope.featureAttachmentName,
                newNameWithPRefixAndExtension,
                scope.feature.featuretype,
                scope.feature.id
              ).then(function (res) {
                if (renameDialog) {
                  renameDialog.close();
                }
                if (res.data === true) {
                  scope.refreshListAttachement();
                }
              });
            }
          }
        };
        let renameDialog;
        (scope.editPhotoName = (featureAttachment) => {
          scope.featureAttachmentNewName =
            scope.getNameFileWithoutSignetAndExtension(featureAttachment);
          scope.featureAttachmentName = featureAttachment;
          renameDialog = ngDialog.open({
            template:
              'js/XG/widgets/ancapp/main/views/modals/modal.renameAttachmentFeature.html',
            className: 'ngdialog-theme-plain width600 miniclose nopadding',
            closeByDocument: false,
            scope: scope,
          });
        }),
        /**
           * Calcul du signet des photos et des labels
           *
           * @param {*} featureAttachment
           */
        (scope.getFeederKey = (featureAttachment) => {
          const nameAttachPhoto = scope.getNameFileSignet(featureAttachment);
          if (nameAttachPhoto && nameAttachPhoto.length > 0) {
            const valueImage = '#{SPECIALATTACHMENT-' + nameAttachPhoto + '}';
            const valueImageLabel =
                '#{SPECIALATTACHMENT-' + nameAttachPhoto + '_Label}';
            HtmlUtils.copyToClipboardImageLabelSignet(
              valueImage,
              valueImageLabel
            );
          } else {
            require('toastr').error('Erreur lors du calcul du signet');
            gaDomUtils.hideGlobalLoader();
          }
        });

        /**
         * Filtre les photos des autres upload
         */
        let currentPageDataPhotos = [];
        scope.filtrePhotos = () => {
          if (
            scope.currentPageData.length &&
            scope.currentPageData.length > 0
          ) {
            currentPageDataPhotos = scope.currentPageData.filter(
              (currentPage) => {
                if (scope.showPhotoOnly) {
                  return currentPage.includes('PHOTOATTACHMENT_');
                } else {
                  return !currentPage.includes('PHOTOATTACHMENT_');
                }
              }
            );
            scope.currentPageData = currentPageDataPhotos;
          }
        };
        /**
         * get Name of File Without Signet And xtension
         */
        scope.getNameFileWithoutSignetAndExtension = (x) => {
          if (scope.showPhotoOnly) {
            let name = '';
            if (x.split('_')[2] && x.indexOf(x.split('_')[2]) > 0) {
              name = x.substring(x.indexOf(x.split('_')[2]));
            }
            return scope.removeExtension(name);
          } else {
            return x;
          }
        };
        /**
         * Add Signet And extension to the Name of File
         */
        scope.getNameFileAddSignetAndExtension = (newName) => {
          if (scope.showPhotoOnly) {
            if (newName.indexOf('PHOTOATTACHMENT_') < 0) {
              const prefix = scope.getNameFileSignet(
                scope.featureAttachmentName
              );
              if (prefix != '') {
                newName = prefix + '_' + newName;
              }
            }
            const lastDotPosition = newName.lastIndexOf('.');
            if (lastDotPosition === -1) {
              newName =
                newName +
                scope.featureAttachmentName.substr(
                  scope.featureAttachmentName.lastIndexOf('.'),
                  scope.featureAttachmentName.length
                );
            }
          }
          return newName;
        };
        /**
         * Remove extension from the Name of File
         */
        scope.removeExtension = (filename) => {
          let lastDotPosition = filename.lastIndexOf('.');
          if (lastDotPosition === -1) {
            return filename;
          } else {
            return filename.substr(0, lastDotPosition);
          }
        };
        /**
         * Get signet from the Name of File
         */
        scope.getNameFileSignet = (x) => {
          if (scope.showPhotoOnly) {
            if (x.split('_')[2] && x.indexOf(x.split('_')[2]) > 0) {
              return x.substring(0, x.indexOf(x.split('_')[2]) - 1);
            }
          }
          return '';
        };
        /**
         * verification de l'extension Photo
         */
        scope.verificationExtensionPhoto = (filename,validFileExtensions) => {
          let valideExtensionPhoto = false;
          const lastDotPosition = filename.lastIndexOf('.');
          if (lastDotPosition > 0) {
            const extension = filename.substr(
              lastDotPosition,
              filename.length
            );
            valideExtensionPhoto = validFileExtensions.includes(extension.toLowerCase());
          }
          return valideExtensionPhoto;
        };

        /**
         * Recharge le HTML de la liste des fichiers attachés lorsque filesList est modifié
         */
        scope.$watch('filesList', () => {
          if (Array.isArray(scope.filesList)) {
            prepareAttachmentTable(scope.filesList);
          }
        });


        scope.$on('attachmentChanged', () => {
          scope.getFeatureAttachments(scope.feature);
        });
      }
    };
  };

  gcelement.$inject = ['FeatureAttachmentFactory', 'ngTableParams', '$q',
    '$filter', 'gaDomUtils', '$timeout', '$rootScope', 'ngDialog',
    'QueryFactory', '$compile', 'FeatureTypeFactory', 'UsersFactory'
    ,'gaJsUtils' ,'HtmlUtils'
  ];
  return gcelement;
});