'use strict';
define(function() {
  var gcdatatablecfg = function(FeatureTypeFactory, $filter) {
    return {
      templateUrl: 'js/XG/widgets/utilities/data/views/gcdatatablecfg.html',
      restrict: 'A',
      scope: {
        field: '=',
        formvariables: '=',
      },
      link: function(scope, element, attrs, ctrl) {
        // set shown attributes
        scope.$watch('field.config.attributes', function(attributes) {
          if (angular.isArray(attributes)) {
            var tmp = {};
            attributes.forEach(function(attr) {
              tmp[attr] = true;
            });
            scope.pickedAttributes = tmp;
          }
        });

        scope.sourceTypes = [
          {
            key: 'ftid',
            label: $filter('translate')(
              'tools.builder.fields.data.datatable.ft_source'
            ),
          },
          {
            key: 'data',
            label: $filter('translate')(
              'tools.builder.fields.data.datatable.data_source'
            ),
          },
        ];
        scope.sourceType = 'ftid';
        if (angular.isDefined(scope.field.config.data)) {
          scope.sourceType = 'data';
        }

        scope.$watch('sourceType', function(st) {
          // force the remove of the config.data attribute
          // so the gcdatatable knows its a ftid source
          if (st == 'ftid') {
            delete scope.field.config.data;
          }
        });

        // update the attributes list
        scope.featureAttributes = [];
        scope.$watch('field.config.ftid', function(ftid, previousftid) {
          if (angular.isUndefined(ftid)) return;
          var fti = FeatureTypeFactory.getFeatureByUid(ftid);
          if (angular.isDefined(previousftid) && previousftid != ftid) {
            scope.pickedAttributes = {};
          }
          scope.featureAttributes = fti.attributes;
        });

        scope.allAttributesAreChecked = {};
        scope.$watch(
          'pickedAttributes',
          function(attributes) {
            console.log(attributes);
            var attz = [];
            for (var i in attributes) {
              if (attributes[i] == true) attz.push(i);
            }
            scope.field.config.attributes = attz;
            scope.allAttributesAreChecked.value =
              scope.featureAttributes.length > 0 &&
              scope.featureAttributes.length ==
                scope.field.config.attributes.length;
          },
          1
        );

        /**
         * Toggle check attributes
         */
        scope.toggleCheckedAttributes = function() {
          console.log(scope.field.config.attributes.length);
          console.log(scope.allAttributesAreChecked.value);
          console.log(scope.featureAttributes);
          if (scope.allAttributesAreChecked.value == false) {
            scope.featureAttributes.forEach(function(attr) {
              scope.pickedAttributes[attr.name] = true;
            });
          } else {
            scope.pickedAttributes = {};
          }
        };
      },
    };
  };

  gcdatatablecfg.$inject = ['FeatureTypeFactory', '$filter'];
  return gcdatatablecfg;
});
