'use strict';
define(function() {
  /**
   * List of the data utilities directives
   */
  var dataDirectivesProvider = function() {
    this.$get = function($filter) {
      var gcdatatable = {
        name: 'datable',
        label: 'tools.builder.fields.data.datatable.title',
      };
      var gcdatasearch = {
        name: 'datasearch',
        label: 'tools.builder.fields.data.where.title',
      };
      var gcdatatablegeojson = {
        name: 'datablegeojson',
        label: 'tools.builder.fields.data.datatablegeojson.title',
      };
      var featureattachment = {
        name: 'dataattachement',
        label: 'tools.builder.fields.data.feature_attachement.title',
      };
      var actionfeature = {
        name: 'dataaction',
        label: 'tools.builder.fields.data.feature_action.title',
      };

      return {
        /**
         * Retrieve list of available directives
         * @returns {*[]}
         */
        getDirectives: function() {
          return [gcdatasearch, gcdatatable, featureattachment, actionfeature];
        },
      };
    };
    this.$get.$inject = ['$filter'];
  };
  return dataDirectivesProvider;
});
