'use strict';
define(function() {

  /**
   * Composant select avec autocomplete
   * Ré-utilise le sale composant bootstrap ui-select
   */
  var gccomponent = function($filter) {
    /**
     * 
     * THIS COMPONENT IS DEPRECATED. USE gcautocomplete INSTEAD
     * 
     */
    return {
      templateUrl: 'js/XG/widgets/utilities/model/views/gcautocompletedeprecated.html',
      restrict: 'EAC',
      replace: true,
      scope: {
        result: '=?res',
        list: '=?list',
        elementtype: '=?',
        attribute2display: '=?attribute2display',
        disabled: '=?disabled'
      },
      link: function(scope) {

        // cas non prévu où une valeur initiale est fournie au select
        scope.selectedElement = scope.result;

        // variable obligatoire pour le sous-composant bs
        scope.autocomplete = true;

        if (scope.selectedAutocomplete === undefined){
          scope.selectedAutocomplete = {
            selected: scope.result,
          };
        }

        if (!scope.attribute2display) {
          scope.attribute2display = 'name';
        }
        


        // liste des éléments du dropdown
        scope.elements = [];

        scope.myfilter = {
          typeInfo: scope.geomtype,
        };

        /**
         * A chaque changement de la variable 'disabled' en entrée
         * re-assigne la valeur de 'editable' gérant l'activation de l'input
         */
        scope.$watch('disabled',()=>{
          scope.editable = !scope.disabled;
        });

        /**
         * Renvoie au composant parent l'objet sélectionné dans le select
         */
        scope.selectComponentChange = () => {
          scope.result = scope.selectedElement;
        };

        /**
         * Affichage d'une propriété de chaque élément dans la liste du dropdown
         * @param x objet élément de la liste du dropdown (ex. utilisateur, rôle, groupe)
         * @return {string} login ou name, propriété qui pourra être envoyée au back 
         * pour publication
         */
        scope.translateName = (x) => {
          return scope.elementtype === 'utilisateur' ? x.login 
            : scope.attribute2display === 'alias' ? x.alias : x.name ? x.name : x;
        };

        /**
         * Assigne l'élément de la liste cliqué comme élement sélectionné présent dans l'input
         * @param x objet élément de la liste du dropdown (ex. utilisateur, rôle, groupe)
         */
        scope.selectFromAutocomplete = (x) => {
          scope.selectedElement = x.selected;
          scope.selectComponentChange();
        };

        if (scope.elementtype){
          if( scope.elementtype === 'rôle') {
            scope.placeholder = $filter('translate')('executQuery.modalAdd.selectRole');
          } else if (scope.elementtype==='attributs'){
            scope.placeholder = $filter('translate')('executQuery.modalAdd.attributes');
          } else {
            scope.placeholder = scope.elementtype === 'catégorie' ?
               $filter('translate')('executQuery.modalAdd.selectCategory') :
               $filter('translate')('executQuery.modalAdd.select') + scope.elementtype;
          }
        }

        scope.$watch('selectedAutocomplete.selected',() => {
          // au démarrage: scope.selectedAutocomplete.selected = undefined
          // si aucune valeur sélectionnée: scope.selectedAutocomplete.selected = null
          if (scope.selectedAutocomplete.selected !== undefined){
            const data = {type: scope.elementtype, selected: scope.selectedAutocomplete.selected};
            scope.$emit('autocomplete-selected', data);
          }
        });
      },
    };
  };

  gccomponent.$inject = ['$filter'];
  return gccomponent;
});
