/**
*
**/
  "use strict";
define(function () {
  var gcPropertiesLayers = function() {
  

    this.$get = function() {
      return function defineProperties(olLayer) {

        Object.defineProperties(olLayer, {
          attribution: {
            get: function() {
              return this.get('attribution');
            },
            set: function(val) {
              this.set('attribution', val);
            }
          },
          index: {
            get: function() {
              return this.get('index');
            },
            set: function(val) {
              this.set('index', val);
            }
          },
          theme: {
            get: function() {
              return this.get('theme');
            },
            set: function(val) {
              this.set('theme', val);
            }
          },
          legend: {
            get: function() {
              return this.get('legend');
            },
            set: function(val) {
               
              this.set('legend', val);
            }
          },
          visible: {
            get: function() {
              return this.getVisible();
            },
            set: function(val) {
              this.setVisible(val);
            }
          },
          maxScale: {
            get: function() {
              return this.get('maxScale');
            },
            set: function(val) {
                  var dotsPerInch = 96.0;
                  var inchesPerFoot = 12.0;   
                  var dotsPerUnit = dotsPerInch * inchesPerFoot;
                  //var scale = 256000;
                  this.setMaxResolution(val/dotsPerUnit)
                  this.set('maxScale',val);
            }
          },
          gctype: {
            get: function() {
       
              return this.get('gctype');
            },
            set: function(val) {

              this.set('gctype',val);
            }
          },
          minScale: {
            get: function() {

              return this.get('minScale');
            },
            set: function(val) {
                  var dotsPerInch = 96.0;
                  var inchesPerFoot = 12.0;   
                  var dotsPerUnit = dotsPerInch * inchesPerFoot;
                  //var scale = 256000;
                  this.setMinResolution(val/dotsPerUnit) ;
                  this.set('minScale',val);
            }
          },
          style: {
            get: function() {
              return this.get('style');
            },
            set: function(val) {
              this.set('style',val);
            if (this instanceof ol.layer.Layer) {
                var src = this.getSource();
                if (val != 'undefined' && val != "")
                {
                  src.updateParams({STYLES: val});
                }
                else 
                {
                  this.set('style','');
                  src.updateParams({STYLES: ''});
                }
                
              }
            }
          },
          cql_filter: {
            get: function() {
              return this.get('cql_filter');
            },
            set: function(val) {
              this.set('cql_filter',val);
            if (this instanceof ol.layer.Layer) {
                var src = this.getSource();
                if (val != 'undefined' && val != "")
                {
                  src.updateParams({CQL_FILTER: val});
                }
                else 
                {
                  this.set('cql_filter','1=1');
                  src.updateParams({CQL_FILTER: '1=1'});
                }
                
              }
            }
          },
          name: {
            get: function() {
              return this.get('name');
            },
            set: function(val) {
              this.set('name');
            }
          },
          fti: {
            get: function() {
              return this.get('fti');
            },
            set: function(val) {
              this.set('fti');
            }
          },
          invertedOpacity: {
            get: function() {
              return (Math.round((1 - this.getOpacity()) * 100) / 100) + '';
            },
            set: function(val) {
              this.setOpacity(1 - val);
            }
          },
          id: {
            get: function() {
              return this.get('id') || this.bodId;
            },
            set: function(val) {
              this.set('id', val);
            }
          },
          selected: {
            get: function() {
              return this.get('selected') || this.bodId;
            },
            set: function(val) {
              this.set('selected', val);
            }
          },
          bodId: {
            get: function() {
              return this.get('bodId');
            },
            set: function(val) {
              this.set('bodId', val);
            }
          },
          label: {
            get: function() {
              return this.get('label');
            },
            set: function(val) {
              this.set('label', val);
            }
          },
          url: {
            get: function() {
              return this.get('url');
            },
            set: function(val) {
              this.set('url', val);
            }
          },
          type: {
            get: function() {
              return this.get('type');
            },
            set: function(val) {
              this.set('type', val);
            }
          },
          timeEnabled: {
            get: function() {
              return this.get('timeEnabled');
            },
            set: function(val) {
              this.set('timeEnabled', val);
            }
          },
          time: {
            get: function() {
              if (this instanceof ol.layer.Layer) {
                var src = this.getSource();
                if (src instanceof ol.source.WMTS) {
                  return src.getDimensions().Time;
                } else if (src instanceof ol.source.ImageWMS ||
                    src instanceof ol.source.TileWMS) {
                  return src.getParams().TIME;
                }
              }
              return undefined;
            },
            set: function(val) {
              if (this instanceof ol.layer.Layer) {
                var src = this.getSource();
                if (src instanceof ol.source.WMTS) {
                  src.updateDimensions({'Time': val});
                } else if (src instanceof ol.source.ImageWMS ||
                    src instanceof ol.source.TileWMS) {
                  src.updateParams({'TIME': val});
                }
              }
            }
          },
          background: {
            writable: true,
            value: false
          },
          displayInLayerManager: {
            writable: true,
            value: true
          },
          preview: {
            writable: true,
            value: false
          }
        });
      };
    };




  	////////////////////////////////
 };

  gcPropertiesLayers.$inject = [];
  return gcPropertiesLayers;
});