/**
 *
 */
'use strict';
define(function() {
  var GeometryFieldCtrl = function(
    $scope,
    $rootScope,
    gclayers,
    GlobalServices
  ) {
    $scope.dialogContent =
      '<div>Confirmez vous la suppresion de [!!1!!] ?</div>';
    $scope.dialogContent += '<div>';
    $scope.dialogContent +=
      "  <button ng-click='removeAttachedFile()'>Oui</button>";
    $scope.dialogContent +=
      "  <button ng-click='cancelRemoveAttachedFile()'>Non</button>";
    $scope.dialogContent += '</div>';
    $scope.readonly =
      $scope.theField01.mode == 'readonly' ||
      $scope.theField01.fieldDesc.readonly ||
      $scope.theField01.readonly;
    $scope.drawingSketch = false;

    $scope.getMap = function(aScope) {
      if (aScope == null) return undefined;
      if (aScope.map != undefined) return aScope.map;
      else return $scope.getMap(aScope.$parent);
    };

    $scope.getLayer = function() {
      var layers = gclayers.getOperationalLayer();
      for (var ind = 0; ind < layers.length; ind++) {
        if (layers[ind].fti != undefined) {
          console.log(
            '=layers[ ind ].fti.name: [' + layers[ind].fti.name + ']'
          );
          if (
            $scope.theField01.datastoreName == layers[ind].fti.storeName &&
            $scope.theField01.featureTypeName == layers[ind].fti.name
          )
            $scope.theLayer = layers[ind];
        }
      }
    };

    $scope.map = $scope.getMap($scope);
    $scope.getLayer();

    $scope.refreshMapLater = function() {
      //$scope.map.addLayer($scope.theLayer);
      //$scope.theLayer.getSource().changed();
      var params = $scope.theLayer.getSource().getParams();
      params.t = new Date().getMilliseconds();
      $scope.theLayer.getSource().updateParams(params);
    };
    $scope.refreshMap = function() {
      //            $scope.map.removeLayer($scope.theLayer);
      // setTimeout($scope.refreshMapLater,1000);
      gclayers.refreshlayerByid($scope.theLayer.fti.uid, $scope.map);
    };

    $scope.startUpdateGeometry = function() {
      var coll = new ol.Collection();
      var olGeom, theGeom;

      if ($scope.theFeature == undefined)
        theGeom = $scope.theField01.objectField.value;
      else {
        if ($scope.theFeature.geometry != undefined)
          theGeom = $scope.theFeature.geometry;
        else theGeom = $scope.theFeature.properties['__geom__'];
      }
      if (theGeom.type == 'MultiLineString') {
        olGeom = new ol.geom.LineString(theGeom.coordinates);
      } else {
        if (
          theGeom.coordinates.length != 0 &&
          theGeom.coordinates[0].length != 0 &&
          theGeom.coordinates[0][0].length == undefined
        )
          olGeom = new ol.geom.Polygon([theGeom.coordinates]);
        else if (
          theGeom.coordinates.length != 0 &&
          theGeom.coordinates[0].length != 0 &&
          theGeom.coordinates[0][0].length != 0 &&
          theGeom.coordinates[0][0][0].length == undefined
        )
          olGeom = new ol.geom.Polygon(theGeom.coordinates);
        else olGeom = new ol.geom.Polygon(theGeom.coordinates[0]);
      }
      $scope.feature4update = new ol.Feature({
        geometry: olGeom,
        name: 'My Polygon',
      });

      gclayers
        .getDrawLayer()
        .getSource()
        .addFeature($scope.feature4update);
      coll.push($scope.feature4update);
      $scope.modifyInteraction = new ol.interaction.Modify({
        features: coll,
        // the SHIFT key must be pressed to delete vertices, so
        // that new vertices can be drawn at the same position
        // of existing vertices
        deleteCondition: function(event) {
          return (
            ol.events.condition.shiftKeyOnly(event) &&
            ol.events.condition.singleClick(event)
          );
        },
      });
      $scope.map.addInteraction($scope.modifyInteraction);
      $scope.updating = true;
    };

    $scope.cancelGeometryUpdate = function() {
      gclayers
        .getDrawLayer()
        .getSource()
        .clear();
      $scope.map.removeInteraction($scope.modifyInteraction);
      $scope.updating = false;
      $scope.refreshMap();
    };

    $scope.commitGeometryUpdate = function() {
      var coords = $scope.feature4update.getGeometry().getCoordinates();
      if ($scope.geomType == 'Point') {
        $scope.theField01.objectField.value.coordinates = [];
        $scope.theField01.objectField.value.coordinates.push(
          angular.copy(coords)
        );
      } else if ($scope.geomType == 'LineString')
        $scope.theField01.objectField.value.coordinates = angular.copy(coords);
      else
        $scope.theField01.objectField.value.coordinates = angular.copy(coords);
      //                $scope.theField01.objectField.value.coordinates = angular.copy(coords[0]);

      $scope.$parent.valueChanged();
      $scope.cancelGeometryUpdate();
    };

    $scope.stopSketchInput = function() {
      console.log('stopSketchInput');
      $scope.map.removeInteraction($scope.drawinteraction);
      $scope.drawingSketch = false;
      //-- Efface la sélection (on a pu editer l'objet en sélectionnant sur la carte par l'outil de sélection standard')
      gclayers.getselectSource().clear();
      $scope.refreshMap();
    };

    $scope.addGeometry = function() {
      var source = new ol.source.Vector();

      switch ($scope.theLayer.fti.typeInfo) {
        case 'POINT':
          $scope.geomType = 'Point';
          break;
        case 'LINE':
          $scope.geomType = 'LineString';
          break;
        case 'POLYGON':
          $scope.geomType = 'Polygon';
          break;
      }
      $scope.drawinteraction = new ol.interaction.Draw({
        source: source,
        type:
          $scope.geomType /** @type {ol.geom.GeometryType}  (typeSelect.value) LineString or Point */,
      });

      $scope.drawinteraction.on('drawend', function(evt) {
        var sketchFeature = evt.feature;
        var format = new ol.format.GeoJSON({});
        var coords = evt.feature.getGeometry().getCoordinates();
        var coordsVal;
        if ($scope.theField01.objectField.value.constructor === String) {
          $scope.theField01.objectField.value = {};
          $scope.theField01.objectField.value.type = $scope.geomType;
        }
        if ($scope.geomType == 'Point') {
          $scope.theField01.objectField.value.coordinates = [];
          $scope.theField01.objectField.value.coordinates.push(
            angular.copy(coords)
          );
          coordsVal = $scope.theField01.objectField.value.coordinates;
        } else if ($scope.geomType == 'LineString')
          coordsVal = $scope.theField01.objectField.value.coordinates = angular.copy(
            coords
          );
        else
          coordsVal = $scope.theField01.objectField.value.coordinates = angular.copy(
            coords[0]
          );

        /*                 
                 for (var ind=0;ind<coordsVal.length;ind++)
                     {
                         coordsVal[ind][0] += 835810;
                         coordsVal[ind][1] -= 6600;
                     }
  */

        $scope.$parent.valueChanged();
        $scope.stopSketchInput();
      });

      $scope.map.addInteraction($scope.drawinteraction);
      $scope.drawingSketch = true;
    };

    $scope.gotoGeometry = function() {
      GlobalServices.gotoGeometry(
        $scope,
        $scope.theField01.objectField.value.coordinates
      );
    };

    $scope.removeGeometry = function() {
      $scope.theField01.objectField.value.coordinates = null;
      $scope.$parent.valueChanged();
      $scope.refreshMap();
    };
  };

  GeometryFieldCtrl.$inject = [
    '$scope',
    '$rootScope',
    'gclayers',
    'GlobalServices',
  ];
  return GeometryFieldCtrl;
});
