/**
 *
 */
'use strict';
define(function() {
  var IntervalFieldCtrl = function($scope) {
    $scope.valueChanged = function() {
      if ($scope.copyValueToObjProperties) {
        $scope.obj.properties[$scope.att.name] =
          $scope.theField.objectField.value;
        if ($scope.$parent.valueChangedFunction)
          $scope.$parent.valueChanged($scope.obj);
      }
    };

    $scope.buildValueList = function() {
      var iVal, vMin, vMax;

      vMin = $scope.intervalDesc.min;
      if (!$scope.intervalDesc.mininclus) vMin++;
      vMax = $scope.intervalDesc.max;
      if (!$scope.intervalDesc.maxinclus) vMax--;

      for (iVal = vMin; iVal <= vMax; iVal++)
        $scope.intervalList.push({ value: iVal, code: iVal });
    };

    $scope.initialize = function() {
      $scope.intervalList = [];

      if ($scope.att != undefined) {
        $scope.theField = angular.copy($scope.att);
        $scope.theField.objectField = {};
        $scope.theField.objectField.value =
          $scope.obj.properties[$scope.att.name];
        $scope.copyValueToObjProperties = true;
      } else $scope.theField = theField01;
      if (
        $scope.theField.config != undefined &&
        $scope.theField.config.intervalDesc != undefined
      )
        $scope.intervalDesc = $scope.theField.config.intervalDesc;
      else
        $scope.intervalDesc = $scope.theField.fieldDesc.restrictions.interval;
      $scope.buildValueList();
    };

    $scope.initialize();
  };

  IntervalFieldCtrl.$inject = ['$scope'];
  return IntervalFieldCtrl;
});
