/**
 *
 */
'use strict';
define(function() {
  var ObjListContainerCtrl = function(
    $scope,
    FeatureTypeFactory,
    GlobalServices,
    QueryFactory
  ) {
    $scope.setDefaultVisibility = function() {
      $scope.style = {};
      if ($scope.cont.defaultVisibility != undefined)
        $scope.style.showGrp = $scope.cont.defaultVisibility;
      else $scope.style.showGrp = true;
    };

    $scope.getRelatedObject = function() {
      if ($scope.cont.relDesc.relation.fieldEnd != 'id') {
        //-- Relation where the ID is stored on the related object so the other object
        //-- refers the main object.
        var where =
          $scope.cont.relDesc.relation.fieldEnd + '=' + $scope.objectId;
        if ($scope.cont.where != undefined)
          where += ' and ' + $scope.cont.where;
        QueryFactory.data($scope.cont.tableDesc.uid, where).then(function(res) {
          $scope.objectList = res.data.features;
        });
      } else {
        //-- Relation where the ID is stored on the main object so the other object
        //-- is refered by the main object.
        if (
          $scope.objectFields != undefined &&
          $scope.objectFields[$scope.cont.relDesc.fieldStart] != null
        )
          QueryFactory.get(
            $scope.cont.tableDesc.uid,
            $scope.objectFields[$scope.cont.relDesc.fieldStart]
          ).then(function(res) {
            $scope.objectList = res.data.features;
          });
      }
    };

    $scope.getRelatedDescForRelation = function(
      tableDesc,
      fieldName0,
      objectFields
    ) {
      var desc,
        relations = tableDesc.relations;
      var indPt2 = fieldName0.lastIndexOf('.');
      var fn = fieldName0.substr(indPt2 + 1);

      // No description provided for the field: is it a relation ?
      for (var indFD = 0; indFD < relations.length; indFD++) {
        if (relations[indFD].name == fn) {
          desc = {};
          desc.relation = relations[indFD];
          desc.fieldDesc = {};
          desc.fieldDesc.fieldTypeIsRelation = true;

          if (
            relations[indFD].occurence != '1-1' &&
            $scope.cont.inlineInput == null
          )
            desc.fieldDesc.inlineInput = true;
          else desc.fieldDesc.inlineInput = $scope.cont.inlineInput;

          // Store relation start field value in order to be able
          // to get objects already in relation with this one.
          if (desc.objectId == null) {
            if (relations[indFD].fieldStart == 'id')
              //                                                          fieldList[ind0].objectId = QueryFactory.getFeatureId( objectFields );
              desc.objectId = $scope.objectId;
            else desc.objectId = objectFields[relations[indFD].fieldStart];
          }
          desc.field = fieldName0;
          desc.featureName = tableDesc.name;
          desc.datastoreName = tableDesc.storeName;
          return desc;
        }
      }
    };

    $scope.setDefaultVisibility();

    $scope.cont.relDesc = $scope.getRelatedDescForRelation(
      $scope.descField,
      $scope.cont.field,
      undefined
    );
    //-- If ID is provided then get related objects
    if ($scope.objectId != null && $scope.cont.relDesc != undefined) {
      $scope.cont.datastoreName = $scope.descField.storeName;
      $scope.cont.relation = $scope.cont.relDesc.relation;
      $scope.cont.objectId = $scope.objectId;
      //-- Get table description
      $scope.cont.tableDesc = FeatureTypeFactory.getFeatureTypeDesc(
        $scope.descField.storeName,
        $scope.cont.relDesc.relation.componentEnd
      );
      //-- Get related object
      $scope.getRelatedObject();
    }
  };

  ObjListContainerCtrl.$inject = [
    '$scope',
    'FeatureTypeFactory',
    'GlobalServices',
    'QueryFactory',
  ];
  return ObjListContainerCtrl;
});
