/**
 *
 */
'use strict';
define(function() {
  var SearchResultCtrl = function(
    $scope,
    ngDialog,
    EditFactory,
    QueryFactory,
    FeatureTypeFactory,
    GlobalServices,
    $timeout
  ) {
    $scope.cmdView = $scope.cmdEdit = $scope.cmdDelete = true;
    $scope.cmdView = $scope.fieldDesc.geographic;
    $scope.thisId = $scope.$id;

    $scope.objToDelete = [];
    $scope.dialogContent =
      '<div>Confirmez vous la suppresion de [!!1!!] ?</div>';
    $scope.dialogContent += '<div>';
    $scope.dialogContent += "  <button ng-click='deleteObjects()'>Oui</button>";
    $scope.dialogContent += "  <button ng-click='cancelDelete()'>Non</button>";
    $scope.dialogContent += '</div>';

    $scope.setWidgetMode = function() {
      if ($scope.searchResultConfig != undefined) {
        if ($scope.searchResultConfig.mode == 'select') {
          $scope.cmdDelete = false;
        }
      }
    };

    /**
     * TODO: comment
     */
    $scope.getValueFor = function(object, attribute) {
      var retValue = object.properties[attribute.name];
      var restr;

      if (
        attribute.restrictions != undefined &&
        attribute.restrictions.length != 0
      ) {
        for (var ind1 = 0; ind1 < attribute.restrictions.length; ind1++) {
          restr = attribute.restrictions[ind1];
          if (restr.type == 'Domain') {
            for (var propertyName in restr.listofValues) {
              if (retValue == propertyName)
                return restr.listofValues[propertyName];
            }
          }
        }
      }
      return retValue;
    };

    $scope.alert = function(message) {
      var errorMsg = '<h4>Erreur</h4> ';
      errorMsg += '<br/><h4>Details</h4>' + message;
      errorMsg += '<br/>' + res.data.errors.ERROR;
      require('toastr').error(errorMsg);
    };

    /******************************************************
     *   ----- DELETION MANAGEMENT
     */

    /**
     *     Delete all children and children's children gotten from previous searches.
     */
    $scope.InitializeRelationsTree = function(relations) {
      var ind, indObj, idList;

      if (relations == undefined) return;
      for (ind = 0; ind < relations.length; ind++) {
        //-- Call deletion for children first
        if (relations[ind].subRelationsForCascadeDelete != undefined)
          $scope.InitializeRelationsTree(
            relations[ind].subRelationsForCascadeDelete
          );
        relations[ind].done = false;
      }
    };

    /**
     *     Delete all children and children's children gotten from previous searches.
     */
    $scope.deleteAllObjects = function(relations) {
      var ind, indObj, idList;

      if (relations == undefined) return;
      for (ind = 0; ind < relations.length; ind++) {
        //-- Call deletion for children first
        if (relations[ind].subRelationsForCascadeDelete != undefined)
          $scope.deleteAllObjects(relations[ind].subRelationsForCascadeDelete);
        idList = '';
        //-- Build id list into a string
        if (relations[ind].objectLists != undefined) {
          for (
            indObj = 0;
            indObj < relations[ind].objectLists.objects.length;
            indObj++
          ) {
            if (idList != '') idList += ',';
            idList += QueryFactory.getFeatureId(
              relations[ind].objectLists.objects[indObj]
            );
          }
          if (idList != '')
            EditFactory.remove(
              relations[ind].objectLists.tableDesc.uid,
              idList
            );
        }
      }
    };

    /**
     *     Actually this is not the cascade deletion, but
     *  the cascade search of children relating to the object
     *  we want to delete.
     *  This search and delete is done only if configured
     *  in the configuration file.
     */
    $scope.cascadeDeleteForRel = function(obj, rel, tableDesc, cascadeDel) {
      var ftf, where, objField;

      //--  Get children table description and field in relation
      if (rel.componentStart == tableDesc.name) {
        ftf = FeatureTypeFactory.getFeatureTypeDesc(
          tableDesc.storeName,
          rel.componentEnd
        );
        where = rel.fieldEnd;
        objField = rel.fieldStart;
      } else {
        ftf = FeatureTypeFactory.getFeatureTypeDesc(
          tableDesc.storeName,
          rel.componentStart
        );
        where = rel.fieldStart;
        objField = rel.fieldEnd;
      }
      if (objField == 'id') where += '=' + QueryFactory.getFeatureId(obj);
      else where += '=' + obj.properties[objField];
      //-- Look for related objects
      QueryFactory.data(ftf.uid, where).then(function(res) {
        var objList = {};

        //-- We've got the related objects, so we store them
        //-- as well as their table description and
        //-- we set the done attribute to TRUE.
        objList.tableDesc = ftf;
        objList.objects = [];
        for (var ind = 0; ind < res.data.features.length; ind++)
          objList.objects.push(res.data.features[ind]);
        cascadeDel.objectLists = objList;
        cascadeDel.done = true;
        $scope.indDel++;
        $scope.cascadeDeleteFor();
      });
    };

    $scope.lookForNextCascadeDeleteRelations = function() {
      //- We have treated all the related objects of the current relation
      // so we look for another relation to work with.
      $scope.chercheCascadeTrouve = false;
      $scope.indDel = 0;
      $scope.cascadeDelParentObjects = $scope.objToDelete;
      $scope.cascadeDelTableDesc = $scope.fieldDesc;
      $scope.chercheCascadeDelSiAutre(
        $scope.searchResultCascadeDeleteRelations
      );
      if ($scope.chercheCascadeTrouve) $scope.cascadeDeleteFor();
      //-- All objects to delete have been found
      //-- so run the delete commands.
      else $scope.deleteAllObjects($scope.searchResultCascadeDeleteRelations);
    };

    /**
     *     Loop through the objects which have related children to remove.
     *  Actually the loop is not done via a for or a while operator
     *  it is done by recursive calls from query response.
     *  The latter increments the index of object list
     *  and calls this function after getting the related objects
     *  currently asked, so that we almost do it synchronously.
     */
    $scope.cascadeDeleteFor = function() {
      var indRel, cascadeDel, rel, tableDesc, obj, theRel;

      //-- Is there at least one object to treat ?
      tableDesc = $scope.cascadeDelTableDesc;
      if (
        $scope.cascadeDelParentObjects.length == 0 ||
        tableDesc.relations.length == 0
      )
        $scope.currentCascadeDeleteRelation.done = true;
      //-- Have we treated the last object ?
      if (
        $scope.indDel < $scope.cascadeDelParentObjects.length &&
        tableDesc.relations.length != 0
      ) {
        obj = $scope.cascadeDelParentObjects[$scope.indDel];
        for (indRel = 0; indRel < tableDesc.relations.length; indRel++) {
          rel = tableDesc.relations[indRel];
          cascadeDel = $scope.currentCascadeDeleteRelation;
          if (cascadeDel.name == rel.name) {
            //-- Got the relation description so call the function
            //-- that will retrieve the related objects (the children objects).
            theRel = $scope.prepareNMRelation(rel, tableDesc.name);
            $scope.cascadeDeleteForRel(obj, theRel, tableDesc, cascadeDel);
            break;
          }
        }
      } else $scope.lookForNextCascadeDeleteRelations();
    };

    $scope.duplicateRelation = function(relation) {
      var newRel = {};

      newRel.name = relation.name;
      newRel.type = relation.type;
      newRel.componentStart = relation.componentStart;
      newRel.componentEnd = relation.componentEnd;
      newRel.fieldStart = relation.fieldStart;
      newRel.fieldEnd = relation.fieldEnd;

      return newRel;
    };

    $scope.prepareNMRelation = function(relation, tableName) {
      var newRel = $scope.duplicateRelation(relation);
      if (relation.occurence == 'N-M') {
        if (newRel.componentStart == tableName) {
          newRel.componentEnd = relation.name;
          newRel.fieldStart = 'id';
        } else {
          newRel.componentStart = relation.name;
          newRel.fieldEnd = 'id';
        }
      }
      return newRel;
    };

    /**
     *      Recursively look for relation and subrelation for which
     *  we have to look for the related objects.
     */
    $scope.chercheCascadeDelSiAutre = function(relations) {
      var ind;

      if (relations == undefined) return;
      if (relations.length == 0) relations.done = true;
      for (ind = 0; ind < relations.length; ind++) {
        // done is TRUE when we already got the related objects.
        if (!relations[ind].done) {
          //-- Missing children
          $scope.currentCascadeDeleteRelation = relations[ind];
          $scope.chercheCascadeTrouve = true;
          break;
        }
      }
      for (
        ind = 0;
        ind < relations.length && !$scope.chercheCascadeTrouve;
        ind++
      ) {
        if (
          relations[ind].objectLists != undefined &&
          relations[ind].subRelationsForCascadeDelete != undefined
        ) {
          //-- Parent objects
          $scope.cascadeDelParentObjects = relations[ind].objectLists.objects;
          $scope.cascadeDelTableDesc = relations[ind].objectLists.tableDesc;
          $scope.chercheCascadeDelSiAutre(
            relations[ind].subRelationsForCascadeDelete
          );
        }
      }
    };

    /**
     *
     */
    $scope.deleteMainObjects = function() {
      var indDel, objId, ind, eltLine, eltTable;

      //-- Run deletion service.
      EditFactory.remove($scope.fieldDesc.uid, $scope.deleteIdList).then(
        function(res) {
          var objId;
          if (res.data.errors.ERROR != undefined)
            $scope.alert('La suppression a échoué !');
          else {
            //-- Deletion is OK so remove the object(s) from the displayed list
            //-- and from the scope list.
            for (indDel = 0; indDel < $scope.objToDelete.length; indDel++) {
              objId = $scope.objToDelete[indDel].id;
              for (ind = 0; ind < $scope.features.length; ind++)
                if ($scope.features[ind].id == objId) {
                  $scope.features.splice(ind, 1);
                  break;
                }
            }
            $scope.objToDelete = [];
          }
        }
      );
      ngDialog.closeAll('');
    };

    /**
     *     When user has confirmed deletion this function
     *  does the job.
     *  Until now (21/01/2015) only one object can be delete
     *  on one command, but the code is written so that it reads
     *  a list of objects to delete, and the day some check boxes
     *  are added this function will be ready.
     */
    $scope.deleteObjects = function() {
      var ind, indDel;

      //-- Prepare id list for the service.
      $scope.InitializeRelationsTree($scope.searchResultCascadeDeleteRelations);
      $scope.deleteIdList = '';
      for (ind = 0; ind < $scope.objToDelete.length; ind++) {
        if ($scope.deleteIdList != '') $scope.deleteIdList += ',';
        $scope.deleteIdList += QueryFactory.getFeatureId(
          $scope.objToDelete[ind]
        );
      }
      $scope.lookForNextCascadeDeleteRelations();
      $scope.deleteMainObjects();
    };

    $scope.cancelDelete = function() {
      $scope.objToDelete.splice(0, $scope.objToDelete.length);
      ngDialog.closeAll('');
    };

    /******************************************************
     */

    $scope.goBackToSearchResult = function() {
      $scope.displayModify = false;
      $scope.modifyChildScope.$destroy();
      var elt = document.getElementById('modifydiv_' + $scope.$id);
      var eltParent = document.getElementById('searchresultdiv_' + $scope.$id);
      eltParent.removeChild(elt);

      elt = document.getElementById('backtosearchresultbtn_' + $scope.$id);
      eltParent.removeChild(elt);

      if ($scope.refreshQueryResult != undefined) $scope.refreshQueryResult();
    };

    /**
     *     Event emitted by typeprojet directive with the function
     *  set here in the scope of typeprojet directive.
     */
    $scope.$on('goBackToSearchResult', function(event, data) {
      $scope.goBackToSearchResult();
    });

    /**
     *      Actions to take when the user activates the delete command.
     */
    $scope.deleteOnClick = function(obj) {
      var template, value, reg;

      $scope.objToDelete.push(obj);
      value = obj.properties[$scope.attributes[0].name];
      reg = new RegExp('!!1!!', 'g');
      template = $scope.dialogContent.replace(reg, value);
      ngDialog.open({ template: template, plain: true, scope: $scope });
    };

    $scope.gotoOnClick = function(obj) {
      GlobalServices.gotoGeometry($scope, obj.geometry.coordinates);
    };

    /**
     *      Actions to take when the user activates the modify command:
     *   Load typeprojet widget with the id of the object on the same
     *   line than the activated command.
     *   The configuration file name is given to the typeprojet widget.
     */
    $scope.modifyOnClick = function(obj) {
      var attSrc, attDest;
      var elt = document.getElementById('searchresultdiv_' + $scope.$id);
      //  	  	var str = '<div TypeProjetDirective my-config="'+$scope.config.updateConfigName+'" >';
      var str;
      if ($scope.searchResultProgList != undefined)
        str =
          '<div ChoixProgrammeDirective ng-show="displayModify" id="modifydiv_' +
          $scope.$id +
          '" style="max-width:900px;overflow-x:scroll;">';
      else
        str =
          '<div TypeProjetDirective ng-show="displayModify" id="modifydiv_' +
          $scope.$id +
          '" style="max-width:900px;overflow-x:scroll;">';
      str += '</div>';
      str +=
        '<button ng-click="backToSearchResult()"  ng-show="displayModify" id="backtosearchresultbtn_' +
        $scope.$id +
        '"><img src="img/common/24px-Go-previous.png" ></img></button>';
      var childScope = $scope.$new(true, $scope);
      childScope.objectId = QueryFactory.getFeatureId(obj);
      if ($scope.searchResultModifyConfig != undefined) {
        if ($scope.searchResultModifyConfig.configName != undefined)
          childScope.ConfigName = $scope.searchResultModifyConfig.configName;
        else if ($scope.searchResultModifyConfig.config != undefined)
          childScope.configFromParentDirective =
            $scope.searchResultModifyConfig.config;
        if ($scope.searchResultModifyConfig.fieldsForInheritance != undefined) {
          childScope.inheritedAttributes = [];
          for (
            var ind = 0;
            ind < $scope.searchResultModifyConfig.fieldsForInheritance.length;
            ind++
          ) {
            attSrc =
              $scope.searchResultModifyConfig.fieldsForInheritance[ind].attSrc;
            attDest =
              $scope.searchResultModifyConfig.fieldsForInheritance[ind].attDest;
            childScope.inheritedAttributes.push({
              fieldName: attDest,
              fieldValue: obj.properties[attSrc],
            });
          }
        }
      } else {
        childScope.config = {};
        childScope.config.datastoreName = $scope.fieldDesc.storeName;
        childScope.config.featureName = $scope.fieldDesc.name;
        childScope.config.setFromParent = 'true';
        childScope.config.state = 'update';
      }
      childScope.displayModify = true;
      childScope.backToSearchResult = function() {
        $scope.$emit('goBackToSearchResult', '');
      };
      $scope.modifyChildScope = childScope;
      var cmp = $scope.compile(str)(childScope);
      angular.element(elt).append(cmp);
      childScope.configName = childScope.ConfigName;
      $timeout(function() {
        $scope.$broadcast('openTools_typeprojetdirective', childScope);
      }, 250);
      $scope.displayModify = true;
    };

    $scope.setWidgetMode();
  };

  SearchResultCtrl.$inject = [
    '$scope',
    'ngDialog',
    'EditFactory',
    'QueryFactory',
    'FeatureTypeFactory',
    'GlobalServices',
    '$timeout',
  ];
  return SearchResultCtrl;
});
