'use strict';
define(function() {
  var collapseMenu = function($rootScope, UsersFactory, gcDirectivesList) {
    return {
      templateUrl: 'js/XG/containers/views/collapseMenu.html',
      controller: [
        '$scope',
        '$element',
        '$attrs',
        function($scope, $element, $attrs) {
          $scope.collapse = 'CollapseCtrl';
          $scope.currentResources = {};
          $scope.currenttool = {};
          $scope.countacc = 3;
          $scope.firstUpload = true;

          $scope.onclick = function(tool) {
            if ($scope.currenttool != tool) {
              if (angular.isDefined(tool.active) || !$scope.firstUpload) {
                tool.active = true;
                $scope.currenttool.active = false;
                $scope.firstUpload = false;
              } else {
                tool.active = !tool.active;
                $scope.currenttool.active = !$scope.currenttool.active;
              }
              console.log(
                'lance evenement ==>' +
                  'closeTools_' +
                  $scope.currenttool.directive
              );
              $scope.$broadcast(
                'closeTools_' + $scope.currenttool.directive,
                $scope.currenttool
              );
              console.log(
                'lance evenement ==>' + 'openTools_' + tool.directive
              );
              $scope.$broadcast('openTools_' + tool.directive, tool);
              $scope.currenttool = tool;

              // log user activity
              UsersFactory.user_monitoring({
                sector: $rootScope.xgos.sector,
                path: 'map',
                category: 'map_widget',
                parameters: '[Ouverture][' + tool.name + ']',
              });
            } else {
              tool.active = !tool.active;
              $scope.$broadcast('openCloseTools_' + tool.directive, tool);
            }
          };

          // alimente la liste des directives (pour voir si elles existent encore)
          // et des metadata (aide, urlwiki)
          let directivesList = gcDirectivesList.listtools();
          let directivesMetaData = gcDirectivesList.listtoolsMetaData();

          $scope.existingDirectives = {};
          $scope.widgetTooltips = {};
          directivesList.forEach(function(x) {
            $scope.existingDirectives[x.directive] = true;
          });
          for (let i in directivesMetaData) {
            $scope.widgetTooltips[i] = {
              description: directivesMetaData[i].description,
              wiki: directivesMetaData[i].wiki,
            };
          }

          /****
           *
           * toggleallDirectives
           *
           */
          function toggleallDirectives() {
            $scope.tools.map(function(tool) {
              tool.modules.map(function(module) {
                module.active = false;
              });
            });
            var elements = angular.element('#collapseMenu').find('.panel-info');
            angular.forEach(elements, function(element) {
              angular.forEach(
                angular
                  .element(element)
                  .find('.panel-collapse.collapse.am-collapse'),
                function(el) {
                  if (angular.element(el).hasClass('in')) {
                    angular
                      .element(element)
                      .find('.panel-title a')[0]
                      .click();
                  }
                }
              );
            });
          }

          $scope.onCategorieClick = function(tooc) {
            toggleallDirectives();
            if ($scope.currenttooc != tooc) {
              console.log('lance evenementr==>newCategorie');
              $scope.$broadcast('newCategorie', $scope.currenttool);
              $scope.currenttooc = tooc;
            }
          };

          $scope.removePanel = function(tool) {
            var deleteIndex = $scope.tools
              .map(function(x) {
                return x.directive;
              })
              .indexOf(tool.directive);
            $scope.tools.splice(deleteIndex, 1);
          };
        },
      ],

      restrict: 'A',
      scope: {
        map: '=map',
        tools: '=tools',
        mode: '=mode',
        panelsManager: '=panelsManager',
        menuContext: '=menuContext',
        tableheight: '=?',
      },
    };
  };
  collapseMenu.$inject = ['$rootScope', 'UsersFactory', 'gcDirectivesList'];
  return collapseMenu;
});
