'use strict';
define(function() {
  var InfoCtrl = function(
    $scope,
    $location,
    $http,
    $filter,
    $window,
    $rootScope
  ) {
    $scope.goToWiki = function() {
      $window.open(
        'http://support.altereo.fr/xwiki/wiki/kis/view/Main/',
        '_blank'
      );
    };

    $scope.goToHelpPage = function() {
      $window.open('https://mantis.altereo.fr/', '_blank');
    };

    $scope.setRedirectActions = function() {
      $scope.redirectActions = [
        {
          text:
            "<i class='fa fa-book'></i>" + $filter('translate')('common.wiki'),
          click: 'goToWiki()',
        },
        {
          text:
            "<i class='fa fa-info-circle'></i>" +
            $filter('translate')('common.help'),
          click: 'goToHelpPage()',
        },
      ];
    };
    $scope.versionTreedata = [];

    // recuperation des versions
    // il aura besoin d'utilisé la fonction de versionsFactory mais peut être qu'il aura
    // des changement à faire (j'ai pas voulu les faire en HOTFIX)
    $http.get('./versions_kis/versions.json').then(
      function(response) {
        let data = response.data;
        let status = response.status;
        if (data && status === 200) {
          $scope.versionsData = data;
          let actuelleList = $scope.versionsData.current.split('.');
          for (let version of $scope.versionsData.versions) {
            let compare = version.number.split('.');
            let valideVersion = true;
            for(let i=0;i<actuelleList.length;i++){
              if(!angular.isDefined(compare[i])){
                break;
              }else if(parseInt(actuelleList[i])>parseInt(compare[i])){
                break;
              }else if(parseInt(actuelleList[i])<parseInt(compare[i])){
                valideVersion = false;
                break;
              }
            }
            if (valideVersion) {
              let pdfLink;
              if (
                angular.isDefined(version.blank) &&
                version.blank == true
              ) {
                pdfLink = null;
              } else {
                pdfLink = './versions_kis/' + version.number + '.pdf';
                $scope.versionTreedata.push({
                  label: version.number,
                  date: version.date,
                  pdf: pdfLink,
                });
              }
            }
          }

          $scope.setRedirectActions();
        } else {
          console.log(
            '%c  cannot get version number ',
            'background: #f00; color: #fff'
          );
        }
      }
    );

    $scope.setRedirectActions();
    $rootScope.$on('$translateChangeEnd', function() {
      $scope.setRedirectActions();
    });
  };

  InfoCtrl.$inject = [
    '$scope',
    '$location',
    '$http',
    '$filter',
    '$window',
    '$rootScope',
  ];
  return InfoCtrl;
});
