'use strict';

define(function() {
  /*
   * NavigationCtrl
   */
  var NavigationCtrl = function(
    $scope,
    $location,
    PortalsFactory,
    gaJsUtils,
    $rootScope
  ) {
    /*
         Navbar groups definition
         */
    var visibilityList = function(menu) {
      var visibilityList = $rootScope.xgos.portal.parameters.visibilityList;
      if (angular.isDefined(visibilityList) && visibilityList.length > 0) {
        if (JSON.parse(visibilityList).indexOf(menu) != -1) {
          return false;
        }
      }
      return true;
    };
    $scope.rightsNavigation = {
      main_title: 'rights.title',
      icon: 'user',
      subs: [
        {
          label: 'rights.users.title',
          icon: 'users',
          target: 'users',
          visible: visibilityList('users'),
        },
        {
          label: 'rights.groups.title',
          icon: 'th-list',
          target: 'groups',
          visible: visibilityList('groups'),
        },
        {
          label: 'rights.roles.title',
          icon: 'list',
          target: 'roles',
          visible: visibilityList('roles'),
        },
        {
          label: 'rights.restriction.title',
          icon: 'ban',
          target: 'restrictions',
          visible:
            visibilityList('restrictions') && $rootScope.xgos.isadmin
        },
        {
          label: 'rights.extra_authentication.title',
          icon: 'user-plus',
          target: 'extra_authentication',
          visible:
            visibilityList('extra_authentication') &&
            gaJsUtils.checkNestedProperty(
              'portal.parameters.extra_authentication.active',
              $scope.xgos
            ) !== false,
        },
      ],
    };

    $scope.modelNavigation = {
      main_title: 'model.main',
      icon: 'hdd',
      subs: [
        {
          label: 'model.datastores.title',
          icon: 'database',
          target: 'datasources',
          visible: visibilityList('datasources'),
        },
        {
          label: 'model.featuretypes.title',
          icon: 'cube',
          target: 'features',
          visible: visibilityList('features'),
        },
        {
          label: 'model.association.title',
          icon: 'arrows-h',
          target: 'association',
          visible: visibilityList('association'),
        },
        {
          label: 'model.objectFiles.title',
          icon: 'clipboard',
          target: 'objectFiles',
          visible: visibilityList('objectFiles'),
        },
        {
          label: 'model.basemap.title',
          icon: 'square-o',
          target: 'basemap',
          visible: visibilityList('basemap'),
        },
        {
          label: 'model.units.title',
          icon: 'list',
          target: 'units',
          visible: visibilityList('units'),
        },
        {
          label: 'model.styles.title',
          icon: 'eye',
          target: 'style',
          visible: visibilityList('style'),
        },
        {
          label: 'model.network.title',
          icon: 'crop',
          target: 'networks',
          visible: visibilityList('networks'),
        },
      ],
    };

    $scope.toolsNavigation = {
      main_title: 'tools.main',
      icon: 'wrench',
      subs: [
        {
          label: 'tools.builder.title',
          icon: 'clipboard',
          target: 'builder',
          visible: visibilityList('builder'),
        },
        {
          label: 'tools.document.title',
          icon: 'pencil',
          target: 'documents',
          visible: visibilityList('documents'),
        },
        {
          label: 'tools.reports.title',
          icon: 'pencil',
          target: 'reports',
          visible: visibilityList('reports'),
        },
        {
          label: 'tools.actions.title',
          icon: 'pencil',
          target: 'actions',
          visible: visibilityList('actions'),
        },
        {
          label: 'tools.calendar.title',
          icon: 'calendar',
          target: 'calendar',
          visible:
            visibilityList('calendar') &&
            gaJsUtils.checkNestedProperty(
              'portal.parameters.calendar.active',
              $scope.xgos
            ) !== false,
        },
        {
          label: 'tools.tracker.title',
          icon: 'line-chart',
          target: 'tracker',
          visible:
            visibilityList('tracker') &&
            gaJsUtils.checkNestedProperty(
              'portal.parameters.log_tracker_active',
              $scope.xgos
            ) !== false,
        },
        {
          label: 'applications.print.title',
          icon: 'print',
          target: 'printmodel',
          visible: visibilityList('printmodel'),
        },
        {
          label: 'tools.atlas.title',
          icon: 'print',
          target: 'atlas',
          visible: visibilityList('atlas'),
        },
        {
          label: 'tools.majicedigeo.title',
          icon: 'upload',
          target: 'majicedigeo',
          visible: visibilityList('majicedigeo'),
        },
        {
          label: 'tools.portal_monitoring.title',
          icon: 'line-chart',
          target: 'portal_monitoring',
          visible:
            visibilityList('portal_monitoring') &&
            gaJsUtils.checkNestedProperty(
              'portal.parameters.portal_monitoring.active',
              $scope.xgos
            ) !== false,
        }
      ],
    };

    $scope.applicationNavigation = {
      main_title: 'applications.main',
      icon: 'picture',
      subs: [
        {
          label: 'applications.main',
          icon: 'cubes',
          target: 'applications',
          visible: visibilityList('applications'),
        },
        {
          label: 'applications.parameters.title',
          icon: 'cogs',
          target: 'parameters',
          visible: visibilityList('parameters'),
        },
      ],
    };

    $scope.mobileNavigation = {
      main_title: 'mobile.main',
      icon: 'picture',
      subs: [
        {
          label: 'mobile.form.main',
          icon: 'pencil',
          target: 'phonesform',
          visible: visibilityList('phonesform'),
        },
        {
          label: 'mobile.form_intervention.main',
          icon: 'pencil',
          target: 'phonesformintervention',
          visible: visibilityList('phonesformintervention'),
        },
        {
          label: 'mobile.phone.title',
          icon: 'mobile',
          target: 'imei',
          visible: visibilityList('imei'),
        },
      ],
    };

    $scope.licenceNavigation = {
      main_title: 'licence.main',
      icon: 'picture',
      subs: [
        {
          label: 'licence.main',
          icon: 'info',
          target: 'licence',
          visible: visibilityList('licence'),
        },
      ],
    };

    $scope.processNavigation = {
      main_title: 'process.main',
      icon: 'book',
      subs: [
        {
          label: 'process.mbtiles.main',
          icon: 'file-picture-o',
          target: 'process',
          visible: visibilityList('process'),
        },
        {
          label: 'process.geopackage.main',
          icon: 'file-picture-o',
          target: 'geopackage',
          visible: visibilityList('geopackage'),
        },
        /**
         *
         * Geopackage fait pas partie du roadmap RC 1-1-0
         */
        {
          label: 'process.docxprocess.main',
          icon: 'file-word-o',
          target: 'docxprocess',
          visible: visibilityList('docxprocess'),
        },
      ],
    };

    $scope.rootNavigation = {
      main_title: 'root.main',
      icon: 'wrench',
      subs: [
        {
          label: 'root.confguration.main',
          icon: 'file-o',
          target: 'configuration',
          visible: visibilityList('configuration'),
        },
        {
          label: 'root.logs.main',
          icon: 'file-o',
          target: 'logs',
          visible: visibilityList('logs'),
        },
        {
          label: 'tools.checkUp.title',
          icon: 'check',
          target: 'checkUp',
          visible: visibilityList('checkUp'),
        },
      ],
    };

    /**
     * Returns if the current page is the one selected in the nav bar
     *
     * @param path
     * @returns {boolean}
     */
    $scope.isCurrentPath = function(path) {
      if (typeof path == 'string') {
        return $location.path() == path;
      } else {
        return path.indexOf($location.path()) !== -1;
      }
    };
  };

  NavigationCtrl.$inject = [
    '$scope',
    '$location',
    'PortalsFactory',
    'gaJsUtils',
    '$rootScope',
  ];
  return NavigationCtrl;
});
