'use strict';
define(function() {
  var executeQueryManager = function(
    $rootScope,
    QueryFactory,
    $filter,
    panelsManager,
    AlertHpoFactory,
    DataStoreFactory,
    ngDialog,
    extendedNgDialog,
    $location,
    gclayers,
    SelectManager
  ) {
    return {
      templateUrl:
        'js/XG/modules/common/views/directives/executeQueryManagerWidget.html',
      restrict: 'EA',
      replace: true,
      link: function($scope) {
        $rootScope.$on('elementResized', function(event, args) {
          if (args.element.type == 'panel' && args.element.id == 'selecttab') {
            var currHeight =
              $scope.layerdatatable.height + args.transformation.y;
            try {
              $scope.$apply(($scope.layerdatatable.height = currHeight));
            } catch(err) {}
          }
        });

        $scope.currentAppName = localStorage.getItem('app')
          ? localStorage.getItem('app')
          : $location.search().app;
        $scope.ConfigName = $scope.ConfigName
          ? $scope.ConfigName
          : $location.search().app;
        $scope.query = 'query';
        $scope.isroot = $rootScope.xgos.isroot || $rootScope.xgos.isadmin;

        $scope.roles = $rootScope.xgos.user.roles;
        $scope.hiddenPanels = {};
        $scope.allPanelHidden = false;
        $scope.hideAllPanels = function() {
          for (var categorie in $scope.categories) {
            var titre = $scope.categories[categorie].properties.titre;
            $scope.hiddenPanels[titre] = true;
            $scope.allPanelHidden = true;
          }
        };
        $scope.showAllPanels = function() {
          $scope.hiddenPanels = {};
          $scope.allPanelHidden = false;
        };

        $scope.requeteHiddenNoRoles = {};
        $scope.catHiddenNoRoles = {};

        $scope.existRoleAdminSQL = function() {
          for (var roleIndice in $scope.roles) {
            var roleName = $scope.roles[roleIndice].name;
            if ('admin_requete_sql' === roleName) {
              $scope.isroot = true;
            }
          }
        };
        $scope.existRoleAdminSQL();
        $scope.getRolesByUidRequeteAndCat = function() {
          for (var categorieIndice in $scope.categories) {
            $scope.catHiddenNoRoles[
              $scope.categories[categorieIndice].properties.uid
            ] = false;
            var requetes =
              $scope.categories[categorieIndice].properties.requetes;
            for (var requeteIndice in requetes) {
              var uid = requetes[requeteIndice].uid;
              $scope.requeteHiddenNoRoles[uid] = false;
              var rolesRequetes = requetes[requeteIndice].roles;
              if ($scope.isNotEmpty(rolesRequetes)) {
                for (var roleIndice in $scope.roles) {
                  var roleName = $scope.roles[roleIndice].name;
                  if (rolesRequetes.indexOf(roleName) >= 0 || $scope.isroot) {
                    $scope.requeteHiddenNoRoles[uid] = true;
                    $scope.catHiddenNoRoles[
                      $scope.categories[categorieIndice].properties.uid
                    ] = true;
                  }
                }
              } else {
                $scope.requeteHiddenNoRoles[uid] = true;
                $scope.catHiddenNoRoles[
                  $scope.categories[categorieIndice].properties.uid
                ] = true;
              }
            }
          }
        };

        $scope.categories = [];
        $scope.getFilterCategories = function() {
          $scope.currentAppName = localStorage.getItem('app')
            ? localStorage.getItem('app')
            : $location.search().app;
          QueryFactory.getFilterCategories(
            $scope.currentAppName,
            $scope.ConfigName
          ).then(function(res) {
            if (res.data.length != 0) {
              $scope.categories = res.data.features;
              $scope.getRolesByUidRequeteAndCat();
            }
          });
        };
        $scope.getFilterCategories();
        /***************************************************************
         * Récupération de la liste des base de données
         **************************************************************/
        $scope.datasources = [];
        $scope.dbselector = '';
        $scope.loadDataStores = function() {
          DataStoreFactory.get().then(function(res) {
            if (res.data.length != 0) {
              for (var indice in res.data) {
                $scope.datasources[indice] = res.data[indice].name;
              }
              if (res.data.length == 1) $scope.dbselector = res.data[0].name;
            }
          });
        };
        $scope.loadDataStores();
        /***************************************************************
         * Open Dialogs
         **************************************************************/
        $scope.categorieDialog = function() {
          $scope.categorieDialogOpen = ngDialog.open({
            template:
              'js/XG/modules/common/views/modals/modal.add.categorie.html',
            className:
              'ngdialog nopadding miniclose ngdialog-overlay ngdialog-theme-plain width700 ng-$scope',
            closeByDocument: false,
            scope: $scope,
          });
        };

        $scope.queryDialog = function() {
          $scope.queryDialogOpen = ngDialog.open({
            template:
              'js/XG/modules/common/views/modals/modal.add.requete.html',
            className:
              'ngdialog nopadding miniclose ngdialog-overlay ngdialog-theme-plain width1000 ng-$scope',
            closeByDocument: false,
            scope: $scope,
          });
        };

        $scope.executeQueryDialog = function() {
          $scope.nombreLigne = [];
          $scope.executeQueryDialogOpen = ngDialog.open({
            template:
              'js/XG/modules/common/views/modals/modal.execute.requete.html',
            className:
              'ngdialog nopadding miniclose ngdialog-overlay ngdialog-theme-plain width1300 ng-$scope',
            closeByDocument: false,
            scope: $scope,
          });
        };
        $scope.executeQueryEncoursDialog = function() {
          $scope.executeQueryEncoursDialogOpen = ngDialog.open({
            template:
              'js/XG/modules/common/views/modals/modal.requete.encours.html',
            className:
              'ngdialog nopadding miniclose ngdialog-overlay ngdialog-theme-plain width400 ng-$scope',
            closeByDocument: false,
            scope: $scope,
          });
        };

        /**
         * displayQueryExemple Displays an exemple of an Query
         */
        $scope.displayQueryExemple = function() {
          ngDialog.open({
            template:
              'js/XG/modules/common/views/modals/modal.requete.example.html',
            className:
              'ngdialog ngdialog-overlay ngdialog-theme-plain width800',
            closeByDocument: false,
          });
        };

        /***************************************************************
         * Permet de mettre a jour un fichier sql
         **************************************************************/
        $scope.executeRequeteDialog = function(uid) {
          $scope.requete = {};
          QueryFactory.afficherequet(
            uid,
            $scope.currentAppName,
            $scope.ConfigName
          ).then(function(res) {
            if (res.data) {
              $scope.requete.dataBase = res.data.dataBase;
              $scope.requete.newRequete = res.data.requete;
              $scope.requete.newRequeteTitle = res.data.titre;
              $scope.requete.newRequeteDescription = res.data.description;
              $scope.requete.roles = res.data.roles;
              $scope.requete.geo = res.data.geo;
              $scope.requete.geoTableMaitre = res.data.geoTableMaitre;
              $scope.requete.newRequeteNameFile = uid;
              $scope.requete.params = res.data.params;
              $scope.requete.fieldsJson = res.data.fieldsJson;
              $scope.fakeFti = res.data.fakeFti;
              $scope.majParamList(res.data.dataBase);
            } else {
              $scope.requete.newRequete = '';
            }
          });
          $scope.executeQueryDialog();
        };

        $scope.editRequeteDialog = function(uid, titre, categorie) {
          $scope.feat = {};
          $scope.requete = {};
          $scope.editRequeteBoolean = true;
          $scope.currentCategorie = categorie;
          QueryFactory.afficherequet(
            uid,
            $scope.currentAppName,
            $scope.ConfigName
          ).then(function(res) {
            if (res.data) {
              $scope.requete.dataBase = res.data.dataBase;
              $scope.requete.newRequete = res.data.requete;
              $scope.requete.newRequeteTitle = res.data.titre;
              $scope.requete.newRequeteDescription = res.data.description;
              $scope.requete.roles = res.data.roles;
              if (res.data.geo && res.data.geo != 'false') {
                $scope.requete.geo = res.data.geo === 'true' ? true: res.data.geo;
                $scope.requete.geoTableMaitre = res.data.geoTableMaitre;
              }
              $scope.requete.newRequeteNameFile = uid;
              $scope.requete.params = res.data.params;
              $scope.requete.fieldsJson = res.data.fieldsJson;
              $scope.requete.uidCategorie = categorie.properties.uid;
              $scope.fakeFti = res.data.fakeFti;
              $scope.majParamList(res.data.dataBase);
              $scope.getCorrectOperande($scope.requete.params);
            } else {
              $scope.requete.newRequete = '';
            }
          });
          $scope.queryDialog();
        };

        $scope.ftisRequete = [];
        $scope.operateurs = [];
        $scope.addRequeteDialog = function() {
          $scope.loadDataStores();
          $scope.feat = {};
          $scope.requete = {};
          if ($scope.dbselector) {
            $scope.requete.dataBase = $scope.dbselector;
          }
          $scope.currentCategorie = {};
          $scope.editRequeteBoolean = false;
          $scope.queryDialog();
        };

        $scope.getFakeFti = function() {
          QueryFactory.afficherequet('fake').then(function(res) {
            if (res.data.length != 0) {
              $scope.fakeFtiFakeAttrLis = res.data.fakeFti;
            }
          });
        };
        $scope.getFakeFti();
        $scope.addRequeteParamDialog = function() {
          $scope.paramsRequete = {};
        };

        $scope.addRequete = function(requete, currentCategorie) {
          if (
            requete.newRequete &&
            (!$scope.startWithSelect(requete.newRequete) ||
              $scope.includeDropUpdate(requete.newRequete))
          ) {
            AlertHpoFactory.getSimpleSuccess(
              $filter('translate')('executQueryManager.alert.warning'),
              $filter('translate')(
                'La requête doit commencer par Select ou Create View et ne pas contenir ni Drop ni Update'
              ),
              false
            );
          } else {
            // catégories vide, création de la cat par défaut
            if (!$scope.isNotEmpty($scope.categories)) {
              QueryFactory.addCategorie(
                'Sans Catégorie',
                $scope.currentAppName,
                $scope.ConfigName
              ).then(function(res) {
                if (res.data.features.length != 0) {
                  $scope.getFilterCategories();
                }
              });
            }

            if (
              !$scope.isNotEmpty(currentCategorie) ||
              !$scope.isNotEmpty(currentCategorie.properties) ||
              $scope.stringEmptyOrNot(currentCategorie.properties.uid)
            ) {
              requete.uidCategorie = 'CAT-000000-000000';
            } else {
              requete.uidCategorie = currentCategorie.properties.uid;
            }
            QueryFactory.createFichSQL(
              requete,
              $scope.currentAppName,
              $scope.ConfigName
            ).then(function(res) {
              if (res.data.length != 0) {
                $scope.getFilterCategories();
                $scope.queryDialogOpen.close();
                AlertHpoFactory.getSimpleSuccess(
                  $filter('translate')('executQueryManager.alert.succes'),
                  $filter('translate')('Création requête'),
                  false
                );
              }
            });
          }
        };
        $scope.editRequete = function(requete, currentCategorie) {
          if (
            requete.newRequete &&
            (!$scope.startWithSelect(requete.newRequete) ||
              $scope.includeDropUpdate(requete.newRequete))
          ) {
            AlertHpoFactory.getSimpleSuccess(
              $filter('translate')('executQueryManager.alert.warning'),
              $filter('translate')(
                'La requête doit commencer par Select ou Create View et ne pas contenir ni Drop ni Update'
              ),
              false
            );
          } else {
            requete.uidCategorie = currentCategorie.properties.uid;
            QueryFactory.MAJFichSQL(
              requete,
              $scope.currentAppName,
              $scope.ConfigName
            ).then(function(res) {
              if (res.data.length != 0) {
                $scope.getFilterCategories();
                $scope.queryDialogOpen.close();
                AlertHpoFactory.getSimpleSuccess(
                  $filter('translate')('executQueryManager.alert.succes'),
                  $filter('translate')('MAJ requête'),
                  false
                );
              }
            });
          }
        };
        $scope.removeRequete = function(newRequeteNameFile) {
          swal(
            {
              title: 'Êtes vous sûr de vouloir supprimer la requête ?',
              type: 'warning',
              showCancelButton: true,
              confirmButtonColor: '#DD6B55',
              confirmButtonText: $filter('translate')('common.yes'),
              cancelButtonText: $filter('translate')('common.no'),
              closeOnConfirm: true,
            },
            function(isConfirm) {
              if (isConfirm) {
                QueryFactory.removeRequete(
                  newRequeteNameFile,
                  $scope.currentAppName,
                  $scope.ConfigName
                ).then(
                  function(res) {
                    if (res.data.length != 0) {
                      $scope.getFilterCategories();
                      AlertHpoFactory.getSimpleSuccess(
                        $filter('translate')('executQueryManager.alert.succes'),
                        $filter('translate')('Supression requête'),
                        false
                      );
                    }
                  },
                  function(res) {
                    AlertHpoFactory.showErrorMessage(res);
                  }
                );
              }
            }
          );
        };

        $scope.exect = {};
        $scope.testRequete = function(db, requete) {
          if (
            requete.newRequete &&
            (!$scope.startWithSelect(requete.newRequete) ||
              $scope.includeDropUpdate(requete.newRequete))
          ) {
            AlertHpoFactory.getSimpleSuccess(
              $filter('translate')('executQueryManager.alert.warning'),
              $filter('translate')(
                'La requête doit commencer par Select ou Create View et ne pas contenir ni Drop ni Update'
              ),
              false
            );
          } else {
            $scope.executeQueryEncoursDialog();
            var promise = QueryFactory.executFichSQL(db, requete, true);
            promise.then(
              function(res) {
                if ($scope.executeQueryEncoursDialogOpen) {
                  $scope.executeQueryEncoursDialogOpen.close();
                }
                AlertHpoFactory.getSimpleSuccess(
                  $filter('translate')('executQueryManager.alert.succes'),
                  $filter('translate')(
                    'executQueryManager.alert.connectionSucces'
                  ),
                  false
                );
              },
              function(res) {
                if ($scope.executeQueryEncoursDialogOpen) {
                  $scope.executeQueryEncoursDialogOpen.close();
                }
                AlertHpoFactory.showErrorMessage(res);
              }
            );
          }
        };
        $scope.nombreLigne = [];
        $scope.verifNombreResSQL = function(db, requete) {
          if (
            requete.newRequete &&
            (!$scope.startWithSelect(requete.newRequete) ||
              $scope.includeDropUpdate(requete.newRequete))
          ) {
            AlertHpoFactory.getSimpleSuccess(
              $filter('translate')('executQueryManager.alert.warning'),
              $filter('translate')(
                'La requête doit commencer par Select ou Create View et ne pas contenir ni Drop ni Update'
              ),
              false
            );
          } else {
            $scope.executeQueryEncoursDialog();
            var promise = QueryFactory.executFichSQL(db, requete, false);
            promise.then(
              function(res) {
                if (res.data != undefined) {
                  $scope.nombreLigne[requete.newRequeteNameFile] =
                    res.data.totalFeatures;
                } else {
                  $scope.nombreLigne[requete.newRequeteNameFile] = 0;
                }
                AlertHpoFactory.getSimpleSuccess(
                  $filter('translate')('executQueryManager.alert.succes'),
                  $filter('translate')(
                    'Nombre des Lignes = ' + res.data.totalFeatures
                  ),
                  false
                );
                if ($scope.executeQueryEncoursDialogOpen) {
                  $scope.executeQueryEncoursDialogOpen.close();
                }
              },
              function(res) {
                if ($scope.executeQueryEncoursDialogOpen) {
                  $scope.executeQueryEncoursDialogOpen.close();
                }
                AlertHpoFactory.showErrorMessage(res);
              }
            );
          }
        };
        $scope.executeRequete = function(db, requete) {
          if (
            requete.newRequete &&
            (!$scope.startWithSelect(requete.newRequete) ||
              $scope.includeDropUpdate(requete.newRequete))
          ) {
            AlertHpoFactory.getSimpleSuccess(
              $filter('translate')('executQueryManager.alert.warning'),
              $filter('translate')(
                'La requête doit commencer par Select ou Create View et ne pas contenir ni Drop ni Update'
              ),
              false
            );
          } else {
            $scope.exect = requete;
            if (
              requete.geo &&
              requete.geo == 'true' &&
              requete.geoTableMaitre
            ) {
              $scope.showLocalisation = 'map';
            } else {
              delete requete.geo;
              delete $scope.geoTableMaitre;
              delete $scope.showLocalisation;
            }
            $scope.executeQueryEncoursDialog();
            var promise = QueryFactory.executFichSQL(db, $scope.exect, false);
            promise.then(
              function(res) {
                if (res.data != undefined) {
                  if (res.data.totalFeatures === '0') {
                    AlertHpoFactory.getSimpleSuccess(
                      $filter('translate')('executQueryManager.alert.warning'),
                      $filter('translate')('executQueryManager.alert.vide'),
                      false
                    );
                  } else {
                    delete res.data.tablename;
                    $scope.fti = res.data.featureTypeInfo;
                    delete res.data.featureTypeInfo;
                    $scope.geoj = res.data;
                    if ($scope.executeQueryEncoursDialogOpen) {
                      $scope.executeQueryEncoursDialogOpen.close();
                    }
                    if ($scope.executeQueryDialogOpen) {
                      $scope.executeQueryDialogOpen.close();
                    }
                    $scope.vopenTabPanels();
                  }
                }
              },
              function(res) {
                if ($scope.executeQueryEncoursDialogOpen) {
                  $scope.executeQueryEncoursDialogOpen.close();
                }
                AlertHpoFactory.getSimpleFail(
                  $filter('translate')('executQueryManager.alert.fail'),
                  $filter('translate')('executQueryManager.alert.query_cannot_be_executed') +
                  '\n' + res.data,
                  true);
              }
            );
          }
        };
        $scope.validTitre = {};
        $scope.verificationTitreRequeteUsed = function() {
          $scope.$watch(
            'requete',
            function(requetePropose) {
              $scope.validTitre = true;
              for (var categorieIndice in $scope.categories) {
                var requetes =
                  $scope.categories[categorieIndice].properties.requetes;
                for (var requeteIndice in requetes) {
                  var requete = requetes[requeteIndice];
                  if (
                    requete.titre &&
                    requetePropose.newRequeteTitle &&
                    requete.titre == requetePropose.newRequeteTitle &&
                    (!requetePropose.newRequeteNameFile ||
                      (requete.uid &&
                        requete.uid.toUpperCase() !=
                          requetePropose.newRequeteNameFile.toUpperCase()))
                  ) {
                    $scope.validTitre = false;
                  }
                }
              }
            },
            1
          );
        };

        /***************************************************************
         * Permet de mettre a jour la catégorie sql
         **************************************************************/
        $scope.addCatDialog = function() {
          $scope.getFilterCategories();
          $scope.currentCategorie = {};
          $scope.validTitreCat = true;
          $scope.editCatBoolean = false;
          $scope.categorieDialog();
        };

        $scope.editCatDialog = function(categorie) {
          $scope.getFilterCategories();
          $scope.currentCategorie = {};
          $scope.validTitreCat = true;
          $scope.currentCategorie.titre = categorie.properties.titre;
          $scope.currentCategorie.uid = categorie.properties.uid;
          $scope.editCatBoolean = true;
          $scope.categorieDialog();
        };

        $scope.addCategorie = function() {
          QueryFactory.addCategorie(
            $scope.currentCategorie.titre,
            $scope.currentAppName,
            $scope.ConfigName
          ).then(function(res) {
            if (res.data.features.length != 0) {
              $scope.categorieDialogOpen.close();
              $scope.getFilterCategories();
              AlertHpoFactory.getSimpleSuccess(
                $filter('translate')('executQueryManager.alert.succes'),
                $filter('translate')('Création catégorie'),
                false
              );
            }
          });
        };
        $scope.removeCategorie = function(uidCategorie) {
          swal(
            {
              title: 'Êtes vous sûr de vouloir supprimer la catégorie ?',
              type: 'warning',
              showCancelButton: true,
              confirmButtonColor: '#DD6B55',
              confirmButtonText: $filter('translate')('common.yes'),
              cancelButtonText: $filter('translate')('common.no'),
              closeOnConfirm: true,
            },
            function(isConfirm) {
              if (isConfirm) {
                QueryFactory.removeCategorie(
                  uidCategorie,
                  $scope.currentAppName,
                  $scope.ConfigName
                ).then(
                  function(res) {
                    if (res.data.length != 0) {
                      $scope.getFilterCategories();
                      AlertHpoFactory.getSimpleSuccess(
                        $filter('translate')('executQueryManager.alert.succes'),
                        $filter('translate')('Supression catégorie'),
                        false
                      );
                    }
                  },
                  function(res) {
                    AlertHpoFactory.showErrorMessage(res);
                  }
                );
              }
            }
          );
        };

        $scope.editCategorie = function() {
          QueryFactory.editCategorie(
            $scope.currentCategorie.titre,
            $scope.currentCategorie.uid,
            $scope.currentAppName,
            $scope.ConfigName
          ).then(
            function(res) {
              if (res.data.length != 0) {
                $scope.categorieDialogOpen.close();
                $scope.getFilterCategories();
                AlertHpoFactory.getSimpleSuccess(
                  $filter('translate')('executQueryManager.alert.succes'),
                  $filter('translate')('MAJ catégorie'),
                  false
                );
              }
            },
            function(res) {
              AlertHpoFactory.showErrorMessage(res);
            }
          );
        };

        $scope.validTitreCat = {};
        $scope.verificationTitreCatRequeteUsed = function() {
          $scope.validTitreCat = true;
          for (var categorieIndice in $scope.categories) {
            var titreCat = $scope.categories[categorieIndice].properties.titre;
            var newCategorieTitre = $scope.currentCategorie.titre;
            var titreUidCat = $scope.categories[categorieIndice].properties.uid;
            var newCategorieUid = $scope.currentCategorie.uid;
            if (
              newCategorieTitre &&
              titreCat &&
              newCategorieTitre.toUpperCase() == titreCat.toUpperCase() &&
              (!newCategorieUid ||
                (titreUidCat &&
                  titreUidCat.toUpperCase() != newCategorieUid.toUpperCase()))
            ) {
              $scope.validTitreCat = false;
            }
          }
        };

        /***************************************************************
         * Récupération de la liste des tables des données et des
         * attributs
         **************************************************************/
        $scope.featureTypesList = {};
        $scope.featureTypesListFields = [];
        $scope.featureTypesListGeo = [];
        $scope.loadDataTables = function() {
          QueryFactory.getAllFeatureTypeInfo().then(function(res) {
            if (res.data.length != 0) {
              $scope.featureTypesList = res.data;
              $scope.featureTypesList.push($scope.fakeFtiFakeAttrLis);
              $scope.featureTypesList.sort();
              $scope.featureTypesListFields.push($scope.fakeFtiFakeAttrLis);
              $scope.remplirFtiBaseTable();
            }
          });
        };
        $scope.loadDataTables();
        $scope.remplirFtiBaseTable = function() {
          for (var i in $scope.featureTypesList) {
            var fti = $scope.featureTypesList[i];
            $scope.ftisRequete[fti.name] = fti;
            if (fti.geographic == true) {
              $scope.featureTypesListGeo.push(fti.name);
            }
          }
          $scope.featureTypesListGeo.sort();
        };
        $scope.setfeatureTypeAttrRestriction = function(feat) {
          var restrictedComponent = feat;
          $scope.afeatureTypeAttrRestriction = {
            table: restrictedComponent,
            keyField: {},
            valueField: {},
          };
        };

        $scope.addParamToList = function(db, param) {
          if (!(db != undefined && db !== '' && db != 0)) {
            AlertHpoFactory.alertConfirmCallback(
              $filter('translate')('executQuery.alert.error'),
              'Vous devez choisir la base de données',
              'warning',
              true,
              'ok',
              '#F50072',
              false,
              undefined,
              undefined,
              true,
              false,
              null
            );
          } else {
            var paramCurrent = {};
            if (
              angular.isUndefined($scope.requete.params) ||
              $scope.requete.params === null ||
              $scope.requete.params.length === 0
            ) {
              $scope.requete.params = [];
              paramCurrent.id = '$1';
            } else {
              var indice = parseInt($scope.requete.params.length) + parseInt(1);
              paramCurrent.id = '$' + indice;
            }
            paramCurrent.table = param.table.name;
            paramCurrent.attribut = param.attribut.name;
            var expression =
              '"' +
              param.table.name +
              '"' +
              '.' +
              '"' +
              param.attribut.name +
              '"';
            paramCurrent.expression = expression;

            $scope.requete.params.push(paramCurrent);
            $scope.majParamList(db);
          }
        };
        $scope.addfieldsJsonToList = function(fieldsJson) {
          var fieldsJsonCurrent = {};
          if (
            angular.isUndefined($scope.requete.fieldsJson) ||
            $scope.requete.fieldsJson === null ||
            $scope.requete.fieldsJson.length === 0
          ) {
            $scope.requete.fieldsJson = [];
          }
          fieldsJsonCurrent.table = fieldsJson.table.name;
          fieldsJsonCurrent.attribut = fieldsJson.attribut.name;
          $scope.requete.fieldsJson.push(fieldsJsonCurrent);
        };

        $scope.removefieldsJsonfromList = function(param) {
          var index = $scope.requete.fieldsJson.indexOf(param);
          if (index > -1) $scope.requete.fieldsJson.splice(index, 1);
        };

        $scope.removeParamFromList = function(param) {
          var index = $scope.requete.params.indexOf(param);
          if (index > -1) $scope.requete.params.splice(index, 1);
        };

        $scope.majParamList = function(db) {
          if (
            $scope.requete.params != undefined &&
            $scope.requete.params !== '' &&
            $scope.requete.params.length != 0
          ) {
            var fti = {};
            for (var i in $scope.requete.params) {
              var tableName = $scope.requete.params[i].table;
              var parameName = $scope.requete.params[i].attribut;
              if (tableName === 'kis_anc_dossier_controle_reponse') {
                fti = $scope.fakeFti;
              } else {
                fti = $scope.ftisRequete[tableName];
              }

              if ($scope.isNotEmpty(fti) && fti != false) {
                $scope.ftisRequete[tableName] = fti;
                $scope.operateurs[
                  tableName + parameName
                ] = $scope.listOperateursByAttributType(fti, parameName);
              } else {
                AlertHpoFactory.alertConfirmCallback(
                  $filter('translate')('executQuery.alert.error'),
                  $filter('translate')('executQuery.alert.ftipasValide'),
                  'warning',
                  true,
                  'ok',
                  '#F50072',
                  false,
                  undefined,
                  undefined,
                  true,
                  false,
                  null
                );

                $scope.requete.params = '';
                $scope.requete.newRequete = '';
                break;
              }
            }
          }
        };
        $scope.listOperateursByAttributType = function(fti, attributName) {
          var attributType = '';

          for (var ind = 0; ind < fti.attributes.length; ind++) {
            if (fti.attributes[ind].name == attributName) {
              attributType = fti.attributes[ind].type;

              if (attributType !== '') {
                switch (attributType) {
                  case 'text':
                    fti.attributes[ind].type = 'java.lang.String';
                    break;
                  case 'date':
                    fti.attributes[ind].type = 'java.sql.Timestamp';
                    break;
                  case 'number':
                    fti.attributes[ind].type = 'java.lang.Integer';
                    break;
                  case 'checkbox':
                  case 'radio':
                    fti.attributes[ind].type = 'java.lang.Boolean';
                    break;
                }
              }
            }
          }

          var operandsList = {
            Boolean: [
              {
                key: 'equals',
                label: 'equals',
              },
              {
                key: 'exists',
                label: 'exists',
              },
              {
                key: 'notexists',
                label: 'notexists',
              },
            ],

            Date: [
              {
                key: 'equals',
                label: 'equals',
              },
              {
                key: 'gt',
                label: 'gt;',
              },
              {
                key: 'gte',
                label: 'gte;',
              },
              {
                key: 'lt',
                label: 'lt;',
              },
              {
                key: 'lte',
                label: 'lte;',
              },
              {
                key: 'exists',
                label: 'exists',
              },
              {
                key: 'notexists',
                label: 'notexists',
              },
              {
                key: 'between',
                label: 'between',
              },
            ],

            Number: [
              {
                key: 'equals',
                label: 'equals',
              },
              {
                key: 'gt',
                label: 'gt;',
              },
              {
                key: 'gte',
                label: 'gte;',
              },
              {
                key: 'lt',
                label: 'lt;',
              },
              {
                key: 'lte',
                label: 'lte;',
              },
              {
                key: 'exists',
                label: 'exists',
              },
              {
                key: 'notexists',
                label: 'notexists',
              },
            ],

            String: [
              {
                key: 'startWith',
                label: 'startswith',
              },
              {
                key: 'endWith',
                label: 'endWith',
              },
              {
                key: 'regexp',
                label: 'regexp',
              },
              {
                key: 'inclus',
                label: 'inclus',
              },
              {
                key: 'equals',
                label: 'equals',
              },
              {
                key: 'notEquals',
                label: 'notEquals',
              },
              {
                key: 'exists',
                label: 'exists',
              },
              {
                key: 'notexists',
                label: 'notexists',
              },
            ],
          };

          var metaAttributType = '';

          if (attributType !== '') {
            switch (attributType) {
              case 'text':
              case 'java.lang.String':
              case 'java.lang.Character':
              case 'java.lang.CharSequence':
                metaAttributType = 'String';
                break;

              case 'number':
              case 'java.lang.Integer':
              case 'java.lang.Short':
              case 'java.lang.Double':
              case 'java.lang.Float':
              case 'java.math.BigDecimal':
              case 'java.lang.Long':
                metaAttributType = 'Number';
                break;

              case 'date':
              case 'java.sql.Timestamp':
              case 'java.lang.Timestamp':
              case 'java.sql.Date':
              case 'java.util.Date':
              case 'java.util.TimeZone':
                metaAttributType = 'Date';
                break;

              case 'checkbox':
              case 'radio':
              case 'java.lang.Boolean':
                metaAttributType = 'Boolean';
                break;
            }

            return operandsList[metaAttributType];
          }
        };
        /***************************************************************
         * des fonctions et filtres diverses
         **************************************************************/

        $scope.opengraph = function() {
          $scope.currentselectfti = $scope.fti;
          extendedNgDialog.open({
            template:
              'js/XG/widgets/mapapp/layerManager/views/charts/SelectedCharts.html',
            className: 'ngdialog-theme-plain width1000 nopadding miniclose',
            closeByDocument: false,
            scope: $scope,
            draggable: true,
            title: $filter('translate')('layermanager.charts'),
          });
        };

        /**
         * Zoom on features contained in $scope.geoj
         */
        $scope.zoomOnData = () => {
          SelectManager.clear();
          // le widget boite d'information n'accepte pas le format de $scope.geoj
          //  tel qu'il est donc on doit le modifier.
          // remove ftiName in attributeName. 'ASS_REGARD.DATECREAT' -> 'DATECREAT'
          const geoJson = angular.copy($scope.geoj);
          if (Array.isArray(geoJson.features) && geoJson.features[0] && geoJson.features[0].id) {
            const ftiName = geoJson.features[0].id.split('.')[0];
            geoJson.features = geoJson.features.map(feat => {
              const newProperties = {};
              for (const attributeName in feat.properties) {
                const newAttributeName = attributeName.replace(ftiName+'.', '');
                newProperties[newAttributeName] = feat.properties[attributeName];
              }
              feat.properties = newProperties;
              return feat;
            });
          }
          SelectManager.addFeaturesFromGeojson(geoJson);
          $scope.map.getView().fit(
            SelectManager.getExtent(), $scope.map.getSize());
        };

        $scope.titre = '';
        var match = function(categorie, val) {
          var regex = new RegExp(val, 'i');
          var matched = categorie.properties.titre.search(regex) == 0;
          for (var indice in categorie.properties.requetes) {
            matched =
              matched ||
              categorie.properties.requetes[indice].titre.search(regex) == 0;
          }
          return matched;
        };

        $scope.filterCategories = function(categorie) {
          if (!$scope.titre) return true;
          var matched = true;
          $scope.titre.split(' ').forEach(function(token) {
            matched = matched && match(categorie, token);
          });

          return matched;
        };

        $scope.layerdatatable = {};
        $scope.layerdatatable.height = 300;
        $scope.vopenTabPanels = function() {
          // KIS-2958
          $scope.removeFid = true;

          $scope.panelsManager.removePanel('selecttab');
          $scope.advancedFiltersConfiguration = {text: true};
          $scope.tableClassList = 'small-text-select-filter';
          $scope.datatableExportCsvInGeoJson = true;
          // -- KIS-3700: Pour exporter un CSV avec des valeurs d'attributs,
          // -- il ne faudra pas garder les IDs qui vont donner le nom de la table
          // -- au servcie d'export.
          $scope.doNotExportIds
            =  $scope.exect.newRequete.toLowerCase().includes(' join ')
              && $scope.requete.geoTableMaitre!=undefined;
          panelsManager.addPanel({
            id: 'selecttab',
            stickToRight: true,
            templateUrl:
              'js/XG/modules/common/views/directives/popexectDatatable.html',
            scope: $scope,
            stickToBorder: true,
            visible: true,
            resizable: true,
          });
        };
        $scope.closeTable = false;
        $scope.closepanel = function() {
          gclayers.clearhighLightFeatures();
          SelectManager.clear();
          panelsManager.removePanel('selecttab');
          $scope.feat = {};
        };
        $scope.isNotEmpty = function(obj) {
          var isNotEmpty = false;
          for (var key in obj) {
            if (Object.prototype.hasOwnProperty.call(obj, key)) {
              isNotEmpty = true;
            }
          }
          return isNotEmpty;
        };
        $scope.stringEmptyOrNot = function(str) {
          return str && str.trim().length === 0;
        };
        $scope.startWithSelect = function(requete) {
          return (
            requete.toLowerCase().startsWith('select') ||
            requete.toLowerCase().startsWith('create or replace view') ||
            requete.toLowerCase().startsWith('create view') ||
            requete.toLowerCase().startsWith('replace view')
          );
        };
        $scope.includeDropUpdate = function(requete) {
          return (
            requete.toLowerCase().includes('drop') ||
            requete.toLowerCase().includes('update')
          );
        };
        $scope.$watch('requete.geo', (geo) => {
          if (!geo && $scope.requete) {
            delete $scope.requete.geo;
            delete $scope.requete.geoTableMaitre;
          }
        });
        $scope.isTableRestriction = (fti, attributeName) => {
          if (fti && fti.attributes && Array.isArray(fti.attributes)) {
            let attribute = fti.attributes.find(attribute => {
              return attribute.name === attributeName;
            });
            if (attribute && attribute.restrictions
              && Array.isArray(attribute.restrictions)
              && attribute.restrictions.length > 0) {
              return attribute.restrictions[0].type === 'Tables';
            }
          }
          return false;
        };
        /**
         * select's ng-options don't handle object comparison very well
         * we can't base the ng-select on the key because the backend needs the whole object.
         * we shouldn't save the whole operator object in the backend,
         * we should just store the key.
         * @param {*} params
         */
        $scope.getCorrectOperande = (params) => {
          if (params && Array.isArray(params)) {
            for (let param of params) {
              if (param.operande && param.table && param.attribut
                && $scope.operateurs && $scope.operateurs[param.table+param.attribut] != null) {
                let goodOperator = $scope.operateurs[param.table+param.attribut].find(operator => {
                  return operator.key === param.operande.key;
                });
                if (goodOperator) {
                  param.operande = goodOperator;
                }
              }
            }
          }
        };
      },
    };
  };

  executeQueryManager.$inject = [
    '$rootScope',
    'QueryFactory',
    '$filter',
    'panelsManager',
    'AlertHpoFactory',
    'DataStoreFactory',
    'ngDialog',
    'extendedNgDialog',
    '$location',
    'gclayers',
    'SelectManager'
  ];
  return executeQueryManager;
});
