/**
 *
 */
'use strict';
if (
  !define(function() {
    /**
     * Builder Ctrl
     * @param $scope
     * @constructor
     * @param $rootScope
     * @param ngDialog
     * @param ApplicationFactory
     * @param ConfigFactory
     * @param $filter
     * @param FeatureTypeFactory
     */
    var AdminParametersCtrl = function(
      $scope,
      processFactory,
      $rootScope,
      ngDialog,
      $filter,
      gaDomUtils,
      $location,
      gaUrlUtils,
      ParametersFactory
    ) {
      /**
       * Méthode de récupération de l'ensemble des paramètres stockés.
       */
      $scope.currentResources = [];
      $scope.iswait = false;
      $scope.refreshParams = function(btn) {
        if (!btn) gaDomUtils.showGlobalLoader();
        ParametersFactory.get().then(
          function(res) {
            if (!btn) gaDomUtils.hideGlobalLoader();
            $scope.currentResources = res.data;
          },
          function(reason) {
            if (!btn) gaDomUtils.hideGlobalLoader();
            var resultObject = reason;
            console.log('Get parameters echec : ' + resultObject);
            require('toastr').error('Get parameters echec :' + resultObject);
          }
        );
      };

      $scope.refreshParams(true);

      $scope.deleteProcess = () => {
        if($scope.edit_resource.type ==='MAP_MODELS_USERS' && $scope.edit_resource.state !== 'private'){
          swal(
            {
              title: $filter('translate')('layermanager.deleteModelAllUser'),
              type: 'warning',
              showCancelButton: true,
              confirmButtonColor: '#DD6B55',
              confirmButtonText: $filter('translate')('common.yes'),
              cancelButtonText: $filter('translate')('common.no'),
              closeOnConfirm: true,
              closeOnClickOutside: false,
            },(confirmOk) => {
              if (confirmOk) {
                deleteProcess();
              }
          });
        } else {
          deleteProcess();
        }
        
      };

      let deleteProcess = () =>{
        ParametersFactory.remove($scope.edit_resource.id).then(
          function(res) {
            if (res && res.data && JSON.parse(res.data)) {
              var index;
              for (var i = 0; i < $scope.currentResources.length; i++) {
                if ($scope.currentResources[i].id === $scope.edit_resource.id) {
                  index = i;
                  break;
                }
              }
              $scope.currentResources.splice(index, 1);
            } else {
              require('toastr').error(
                'Suppression du paramètre id:' +
                  $scope.edit_resource.id +
                  ': en echec . Uniquement le créateur du paramètre peut le supprimer.'
              );
            }
          },
          function(reason) {
            var resultObject = reason;
            console.log(
              'deleteParam id:' +
                $scope.edit_resource.id +
                ' en echec . ' +
                resultObject
            );
            require('toastr').error(
              'Suppression du paramètre id:' +
                $scope.edit_resource.id +
                ': en echec .' +
                resultObject
            );
          }
        );
      }

      /** show parameter data in a popup **/
      $scope.showData = function() {
        $scope.displayData = $scope.edit_resource.data;
        ngDialog.open({
          template:
            'js/XG/modules/dbparameters/views/modal/modal.print_data.html',
          className: 'ngdialog-theme-plain',
          closeByDocument: false,
          scope: $scope,
        });
      };

      $scope.openPublishInfos = function() {
        ngDialog.open({
          template: 'js/XG/modules/dbparameters/views/publishInfosPopup.html',
          scope: $scope,
          controller: 'publishController',
          closeByDocument: false,
          data: $scope.edit_resource,
        });
      };

      $scope.disablePublish = function(curent) {
        if (
          curent &&
          curent.login !== $rootScope.xgos.user.login &&
          !$rootScope.xgos.isroot &&
          !$rootScope.xgos.isSuperAdmin
        ) {
          return true;
        } else {
          return false;
        }
      };

      $scope.disableDelete = function() {
        if (
          $scope.edit_resource &&
          $scope.edit_resource.login !== $rootScope.xgos.user.login &&
          !$rootScope.xgos.isroot &&
          !$rootScope.xgos.isSuperAdmin
        ) {
          return true;
        } else {
          return false;
        }
      };

      /**
       * Réécrit dans le paramètre les valeurs de date en millisecondes si les valeurs sont un objet Date.
       * @param {type} param
       * @returns {undefined}
       */
      function transformDateValues(param) {
        if (param.datecreation instanceof Object) {
          param.datecreation = param.datecreation.getTime();
        }
        if (param.datemodification instanceof Object) {
          param.datemodification = param.datemodification.getTime();
        }
      }

      //Modification des date des paramètres: coté serveur:
      // la date de creation n'est pas écrite
      // et la date de modificaton est affecté à la date du jour.
      function saveParam(param) {
        ParametersFactory.update(param, param.id).then(
          function(res) {
            require('toastr').info('Parametre ' + param.id + ' sauvegardé !');
          },
          function(reason) {
            //En cas d'erreur de la mise à jour
            getParamById(param);
            var resultObject = reason;
            console.log('saveParam echec : ' + resultObject);
            require('toastr').error('saveParam echec :' + resultObject);
          }
        );
      }

      /**
       * Récupére les valeurs initiales du paramètre 'param'.
       * @param {type} param
       * @returns {undefined}
       */
      function getParamById(param) {
        ParametersFactory.getbyid(param.id).then(
          function(result) {
            var key;
            var resultParam = result.data;
            for (key in resultParam) {
              param[key] = resultParam[key];
            }
          },
          function(reason) {
            console.log(
              'Impossible de Récupérer les valeurs initiales du paramètre : ' +
                id
            );
            require('toastr').error(
              'Impossible de Récupérer les valeurs initiales du paramètre : ' +
                id
            );
          }
        );
      }

      /**
       * Handler de clic sur le bouton de sauvegarde des modifications du paramètre.
       * @param {type} param
       * @returns {undefined}
       */
      $scope.editEndParam = function() {
        $scope.temp_edit_resource = angular.copy($scope.edit_resource);
        //Retransformation eventuelle des valeurs de type date en milliseconde si le composant de date à écrit un objet Date au lieu d'un nombre de millisecondes.
        transformDateValues($scope.temp_edit_resource);

        //Confirmation de sauvegarde des modifications
        $scope.confirmMsg =
          'Edition du paramètre ' + $scope.temp_edit_resource.name;
        var ngDialogPromise = ngDialog.openConfirm({
          template:
            'js/XG/modules/dbparameters/views/modal/modal.edit_data.html',
          scope: $scope,
          showClose: false,
        });

        ngDialogPromise.then(
          function(data) {
            $scope.edit_resource = angular.copy(data);
            saveParam($scope.edit_resource);
            require('toastr').info('Succès de la mise à jour');
          },
          function(data) {
            //require('toastr').info(data);
          }
        );
      };

      $scope.editListCfg = {
        dataModule: 'adminparam',
        resource_type: 'parameters',
        cols: [
          'id',
          'type',
          'name',
          'file',
          'datecreation',
          'datemodification',
          'description',
          'login',
        ],

        removeFunction: $scope.deleteProcess,
        disabledDelete: $scope.disableDelete,
        editFunction: $scope.showData,
        addResourceButton: false,
        colTypes: {
          datecreation: 'date',
          datemodification: 'date'
        },
        sort: true,
        extraGlobalActions: [
          {
            icon: "<i class='fa fa-refresh'></i>",
            label: 'common.featuretypes.refresh',
            fn: $scope.refreshParams,
          },
        ],
        extraActions: [
          {
            icon: "<i class='fa fa-globe'></i>",
            label: 'adminparam.btn_info',
            fn: $scope.openPublishInfos,
            disableFn: $scope.disablePublish,
          },
          {
            icon: "<i class='fa fa-edit'></i>",
            label: 'adminparam.btn_save',
            fn: $scope.editEndParam,
            disableFn: $scope.disablePublish,
          },
        ],
      };
    };

    AdminParametersCtrl.$inject = [
      '$scope',
      'processFactory',
      '$rootScope',
      'ngDialog',
      '$filter',
      'gaDomUtils',
      '$location',
      'gaUrlUtils',
      'ParametersFactory',
    ];
    return AdminParametersCtrl;
  })
) {
}
