"use strict";
define(function () {

  var gcelement = function (FeatureTypeFactory, $filter, EditTypesFactory) {
    return {
      templateUrl: 'js/XG/modules/edit/views/rules/cfg/cfg.allowDelete.html',
      restrict: 'E',

      scope: {
        currentfeaturetype: "=currentfeaturetype",
        rule: "=rule"
      },
      link: function (scope, element, attrs, ctrl) {

        scope.result = {};
        scope.rule.name = "AllowDelete";
        scope.rule.type = "OnStart";
        if (scope.rule.parameters === undefined)
          scope.rule.parameters = {};

        if (scope.rule.parameters.shareObjects === undefined) {
          scope.rule.parameters.shareObjects = [];
        }


        var editTypesSource = [EditTypesFactory.editTypes.delete];

        if (scope.rule.editTypes === undefined) {
          scope.rule.editTypes = [];
          //Par défaut, tous les type d'édition sont activés
          angular.forEach(editTypesSource, function (editType, index) {
            scope.rule.editTypes.push(editType);
          });
        }

        scope.editTypeList = {
          leftData: editTypesSource,
          leftDisplayAttribute: 'label',
          rightData: scope.rule.editTypes,
          rightDisplayAttribute: 'label',
          leftTitle: "Disponibles",
          rightTitle: 'A Executer',
          source: 'left'
        };

        scope.condSpatiale = {
          nom: "Seulement si 2 linéaires",
          // lignes : [uid1, uid2],
          message: "Impossible de supprimer cet élément"
        };

        scope.editTypeList.leftTitle = $filter('translate')('rulecfg.common.availableEditTypes');
        scope.editTypeList.rightTitle = $filter('translate')('rulecfg.common.executeEditTypes');

        if (FeatureTypeFactory.resources.featuretypes.length == 0) {
          FeatureTypeFactory.get().then(function () {
            scope.featureTypes = angular.copy(FeatureTypeFactory.resources.featuretypes);
          });
        } else {
          scope.featureTypes = angular.copy(FeatureTypeFactory.resources.featuretypes);
        }


        //Ajout d'un type de linéaire 
        scope.addShareObject = function () {
          if (scope.selectedlayer == null) return;
          var sourceArray = scope.rule.parameters['shareObjects'];

          if (sourceArray.includes(scope.selectedlayer.name)) {
            require('toastr').warning($filter('translate')('rulecfg.common.existingLayer'));
          } else {
            sourceArray.push(scope.selectedlayer.name);
          }
        };

        scope.removeShareObject = function (sourceIndex) {
          scope.rule.parameters['shareObjects'].splice(sourceIndex, 1);;
        };

        scope.onLayerChange = function (f) {
          scope.selectedlayer = f;
        };

      }
    };
  };

  gcelement.$inject = ['FeatureTypeFactory', '$filter', 'EditTypesFactory'];
  return gcelement;

});