'use strict';
define(function() {
  var gcelement = function(
    FeatureTypeFactory,
    EditTypesFactory,
    $translate,
    $filter,
    RuleCfgFactory
  ) {
    return {
      templateUrl:
        'js/XG/modules/edit/views/rules/cfg/cfg.setAttributeByConcat.html',
      restrict: 'E',
      scope: {
        currentfeaturetype: '=currentfeaturetype',
        rule: '=?rule',
        mode: '=?',
      },
      link: function(scope) {
        scope.rule.name = 'SetAttributeByConcat';
        scope.rule.type = 'OnPostValidation';

        var editTypesSource = [
          EditTypesFactory.editTypes.add,
          EditTypesFactory.editTypes.update,
          EditTypesFactory.editTypes.updateattributes,
          EditTypesFactory.editTypes.import,
        ];

        scope.canEditVariableName = scope.mode === 'add' || !(scope.currentfeaturetype.rules || []).filter(
          rule => rule.parameters.formula && rule.parameters.formula.numerotation.parts.filter(part => part.key === 'variable' && part.format === scope.rule.parameters.variableName).length
        ).length;

        if (scope.rule.editTypes === undefined) {
          scope.rule.editTypes = [];
          //Par défaut, tous les type d'édition sont activés
          angular.forEach(editTypesSource, function(editType, index) {
            scope.rule.editTypes.push(editType);
          });
        }
        scope.editTypeList = {
          leftData: editTypesSource,
          leftDisplayAttribute: 'label',
          rightData: scope.rule.editTypes,
          rightDisplayAttribute: 'label',
          source: 'left',
        };
        $translate('rulecfg.common.availableEditTypes').then(function(res) {
          scope.editTypeList.leftTitle = res;
        });
        $translate('rulecfg.common.executeEditTypes').then(function(res) {
          scope.editTypeList.rightTitle = res;
        });

        scope.$watch('editTypeList.rightData', (newVal) => {
          scope.featureRulesVariables = angular.copy(scope.currentfeaturetype.rules || [])
            .filter(rule => (
              rule.parameters && 
              rule.parameters.variableName &&
              rule.parameters.variableName !== scope.rule.parameters.variableName &&
              newVal.filter(
                type => rule.editTypes.find(ruleType => ruleType.name === type.name)
              ).length === newVal.length // Search if edit types are existing
            ))
            .map(rule => rule.parameters.variableName);
        }, true);

        // Formula terms
        scope.possibleTypes = [
          {
            key: 'separator',
            label: $filter('translate')(
              'rulecfg.setattributebyconcat.separator'
            ),
          },
          {
            key: 'attribut',
            label: $filter('translate')(
              'rulecfg.setattributebyconcat.attribut'
            ),
          },
          {
            key: 'value',
            label: $filter('translate')('rulecfg.setattributebyconcat.value'),
          },
          {
            key: 'variable',
            label: 'variable',
          },
        ];
        scope.partsPreview = '';

        // set attributes list
        scope.attributes = scope.currentfeaturetype.attributes;

        RuleCfgFactory.initFormula(scope);

        scope.moveNumerotationpart = function(direction, index) {
          if (
            (index === 0 && direction === 'up') ||
            (index === scope.formula.numerotation.parts.length - 1 &&
              direction === 'down')
          ) {
            return false;
          }

          var newIndex = direction === 'up' ? index - 1 : index + 1;
          scope.formula.numerotation.parts.splice(
            index,
            0,
            scope.formula.numerotation.parts.splice(newIndex, 1)[0]
          );
        };

        scope.removePartFromNumerotationCfg = function(index) {
          scope.formula.numerotation.parts.splice(index, 1);
        };

        function setFormulaViewer(numerotation) {
          var partsPreview = [];

          if (!numerotation) {
            numerotation = formula.numerotation;
          }
          numerotation.parts.forEach(function(p) {
            if (p.key === 'attribut') {
              partsPreview.push('$[' + p.format);
            } else {
              partsPreview.push(p.format);
            }
          });
          scope.rule.parameters.formula = scope.formula;
          return partsPreview.join(numerotation.separator);
        }

        scope.addNumerotationPart = function() {
          scope.formula.numerotation.parts.push({
            key: ' ',
            format: ' ',
          });
        };

        scope.$watch(
          'formula.numerotation',
          function(num) {
            if (angular.isDefined(num.parts)) {
              scope.partsPreview = setFormulaViewer(num);
            }
          },
          1 // listener function
        );

        scope.$watch(
          'targetField',
          function(selectedValue) {
            scope.rule.parameters.targetField = selectedValue;
          },
          1
        );
      },
    };
  };

  gcelement.$inject = [
    'FeatureTypeFactory',
    'EditTypesFactory',
    '$translate',
    '$filter',
    'RuleCfgFactory',
  ];
  return gcelement;
});
