'use strict';
define(function() {
  var featuretypePreview = function(
    gcWMS,
    FeatureTypeFactory,
    gaJsUtils,
    DataStoreFactory
  ) {
    return {
      templateUrl:
        'js/XG/modules/model/views/directives/featuretypePreview.html',
      restrict: 'EA',
      scope: {
        previewfti: '=',
      },
      link: function(scope) {
        function getEsriWMSParams(typeNames, opacityValue, filtert) {
          var dynamicLayers = [];
          for (var i = 0; i < typeNames.length; i++) {
            var dynamicLayerEntry = {
              id: typeNames[i],
              source: {
                type: 'mapLayer',
                mapLayerId: 1,
              },
            };
            var filter = filtert[i];
            if (filter != null && filter != '1=1')
              dynamicLayerEntry.definitionExpression = filter;
            var opacity = opacityValue[i];
            if (opacity != null)
              dynamicLayerEntry.drawingInfo = {
                transparency: opacity == 1 ? 0 : 100 - opacity * 100,
              };
            dynamicLayers.push(dynamicLayerEntry);
          }
          return {
            dynamicLayers: angular.toJson(dynamicLayers),
            tiled: true,
            tilesorigin: '-20037508.342789236,-20037508.342789236',
            type: 'esri'
          };
        }

        var generateWmsLayer = function(params, options, tiled) {
          options.toto = 'titi';
          var layer =
            tiled == undefined || tiled
              ? generateTiledWmsLayer(params, options)
              : generateImageWmsLayer(params, options);
          if (options.directUrl) layer.set('directUrl', options.directUrl);

          return layer;
        };

        var generateTiledWmsLayer = function(params, options) {
          options = options || {};
          var attributions;
          var source, layer;
          if (options.gctype == 'esri') {
            source = new olkis.KISTileArcGISRest({
              params: params,
              url: options.url,
              crossOrigin: 'anonymous',
              extent: options.extent,
              attributions: attributions,
              ratio: options.ratio || 1,
            });
            /*
             * source.getRequestUrl_ = function(tileCoord, tileSize,
             * tileExtent, pixelRatio, projection, params) {
             * console.log("GET REQUEST URL"); var urls = this.urls;
             * if (!urls) { return undefined; } // ArcGIS Server
             * only wants the numeric portion of the projection ID.
             * var srid = projection.getCode().split(':').pop();
             * params['SIZE'] = tileSize[0] + ',' + tileSize[1];
             * params['BBOX'] = tileExtent.join(','); params['DPI'] =
             * Math.round( params['DPI'] ? params['DPI'] *
             * pixelRatio : 90 * pixelRatio ); var url; if
             * (urls.length == 1) { url = urls[0]; } else { var
             * index = ol.math.modulo(ol.tilecoord.hash(tileCoord),
             * urls.length); url = urls[index]; } var modifiedUrl =
             * url .replace(/MapServer\/?$/, 'MapServer/export')
             * .replace(/ImageServer\/?$/,
             * 'ImageServer/exportImage'); return
             * ol.uri.appendParams(modifiedUrl, params); };
             */
          } else
            source = new ol.source.TileWMS({
              params: params,
              url: options.url,
              extent: options.extent,
              attributions: attributions,
              ratio: options.ratio || 1,
            });
          if (angular.isDefined(params.STYLES)) {
            layer = new ol.layer.Tile({
              id: options.layerinWMS,
              url: options.url,
              type: 'WMS',
              layersg: params.LAYERS,
              opacity: options.opacity,
              visible: options.visible,
              attribution: options.attribution,
              fti: options.fti,
              style: params.STYLES,
              name: options.name,
              source: source,
            });
          } else {
            layer = new ol.layer.Tile({
              id: options.layerinWMS,
              url: options.url,
              type: 'WMS',
              layersg: params.LAYERS,
              opacity: options.opacity,
              visible: options.visible,
              attribution: options.attribution,
              fti: options.fti,
              // style: params.STYLES,
              name: options.name,
              source: source,
            });
          }
          layer.preview = options.preview;
          layer.displayInLayerManager = !layer.preview;
          layer.label = options.label;
          return layer;
        };

        function getFtiDataStore(fti) {
          if (
            DataStoreFactory.resources &&
            DataStoreFactory.resources.datastores
          )
            for (
              var i = 0;
              i < DataStoreFactory.resources.datastores.length;
              i++
            ) {
              var dataStore = DataStoreFactory.resources.datastores[i];
              if (fti.storeName == dataStore.name) return dataStore;
            }

          return null;
        }

        function getLinkUrl(dataStore) {
          if (dataStore.useproxy && dataStore.proxykey)
            return '../esriproxy/' + dataStore.proxykey + '/MapServer';
          else dataStore.url;
        }

        function getEsriInfo() {
          var wmsLink,
            fti = scope.previewfti;
          var ftiDataStore = getFtiDataStore(scope.previewfti);
          wmsLink = ftiDataStore ? getLinkUrl(ftiDataStore) : fti.wms;
          return {
            url: wmsLink,
            directurl: ftiDataStore ? ftiDataStore.url : fti.wms,
            tiled: ftiDataStore ? ftiDataStore.tiled : fti.isTiledMap,
          };
        }

        function getEsriLayer() {
          var l,
            mme = {
              fti: scope.previewfti,
            };
          mme.theme = 'preview';

          l = gcWMS.getOlLayerFromMapModelElement(mme);
          var wmsParams,
            tiled = true,
            esriInfo = getEsriInfo();
          var layerinWMS = [l];
          var reflayerinWMS = [l];
          wmsParams = getEsriWMSParams([mme.fti.name], 1, [null], 'none');
          var wmsOptions = {
            url: esriInfo.url,
            directUrl: esriInfo.directurl,
            layerinWMS: {
              mode: 'WMS',
              refLayer: reflayerinWMS,
              type: 'GROUP',
              activeLayer: layerinWMS,
              indexWms: 0,
              rejected: [],
            },
            grouptype: 'GROUP,' + 0,
            gctype: 'esri',
          };
          l = generateWmsLayer(wmsParams, wmsOptions, tiled);
          return l;
        }

        if (angular.isDefined(scope.previewfti)) {
          var map = new ol.Map({
            layers: [
              new ol.layer.Tile({
                source: new ol.source.OSM(),
              }),
            ],
            target: 'previewmap',
            view: new ol.View({
              //projection: 'EPSG:26191',
              center: [0, 0],
              zoom: 2,
            }),
            ol3Logo: false,
          });

          FeatureTypeFactory.getExtent(
            scope.previewfti.uid,
            map
              .getView()
              .getProjection()
              .getCode()
          ).then(
            function(res) {
              var bbox = res.data;
              map.getView().fit(bbox, map.getSize());
              var l;
              if (scope.previewfti.type == 'esri') {
                console.log(
                  'ATTENTION :: GET projection from esri fti data store and use it in the view'
                );

                l = getEsriLayer();
              } else {
                l = gcWMS.getOlLayerFromFeaturetypeInfo(scope.previewfti);
              }
              map.addLayer(l);
              l.getSource().setImageLoadFunction(gaJsUtils.customLoader);
            },
            function(data) {
              require('toastr').info(data);
            }
          );
        }
      },
    };
  };

  featuretypePreview.$inject = [
    'gcWMS',
    'FeatureTypeFactory',
    'gaJsUtils',
    'DataStoreFactory',
  ];
  return featuretypePreview;
});
