/////////////////////////////////////////////////////////////
// Gestion de la configuration des règles métiers.
/////////////////////////////////////////////////////////////
'use strict';
define(function() {
  var gcelement = function(
    ngTableParams,
    ngDialog,
    $filter,
    DocumentFactory,
    gaDomUtils,
    FilesFactory,
    ReportIndicatorFactory,
    ReportFactory,
    ApplicationFactory,
    DataStoreFactory
  ) {
    return {
      templateUrl:
        'js/XG/modules/model/views/directives/featuretypeactionsJasper.html',
      restrict: 'E',
      scope: {
        currentFormData: '=currentformdata',
        fti: '=fti',
      },
      link: function(scope) {
        ApplicationFactory.get().then(function(res) {
          scope.appnames = res.data
            .map(function(x) {
              if (x.type === 'MapApp') return x.name;
            })
            .filter(function(x) {
              if (x) return x;
            });
        });

        if (angular.isUndefined(scope.currentFormData.rapports))
          scope.currentFormData.rapports = [
            { id: Math.floor(Math.random() * 10000) },
          ];

        scope.currentFormData.actionType = $filter('translate')(
          'model.featuretypes.actions.jasper'
        );
        scope.currentFormData.typeInfo = 'JASPER';
        if (scope.currentFormData.currentComponent) {
          scope.types = [
            $filter('translate')('model.featuretypes.actions.JasperModel'),
            $filter('translate')('model.featuretypes.actions.PortalModel'),
          ];
        } else {
          scope.types = [
            $filter('translate')('model.featuretypes.actions.JasperModel'),
            $filter('translate')('model.featuretypes.actions.PortalModel'),
            $filter('translate')('model.featuretypes.actions.StaticModel'),
          ];
        }

        /**
         * Paramètres du tableau listant les règles associées au currentfeaturetype passé à cette directive
         */
        scope.tableParams = new ngTableParams(
          {
            page: 1, // show first page
            count: 10, // count per page
          },
          {
            total: 0, // length of data
            getData: ($defer, params) => {
              if (scope.currentFormData && scope.currentFormData.rapports){
                const displayedTab = scope.currentFormData.rapports.slice(
                    (params.page() - 1) * params.count(),
                    params.page() * params.count()
                );
                params.total(scope.currentFormData.rapports.length); // set total for recalc pagination
                $defer.resolve(displayedTab);
              }
            },
          }
        );

        scope.updateForCurrentComponent = function() {
          if (scope.currentFormData.currentComponent) {
            if (
              scope.currentFormData.rapports &&
              scope.currentFormData.rapports.length >= 2
            ) {
              var ans = window.confirm(
                $filter('translate')(
                  'model.featuretypes.actions.modificationLost'
                )
              );
              ans
                ? (scope.currentFormData.rapports = [
                  scope.currentFormData.rapports[0],
                ])
                : (scope.currentFormData.currentComponent = false);
            }
            scope.types = [
              $filter('translate')('model.featuretypes.actions.JasperModel'),
              $filter('translate')('model.featuretypes.actions.PortalModel'),
            ];
            scope.tableParams.reload();
          } else {
            scope.types = [
              $filter('translate')('model.featuretypes.actions.JasperModel'),
              $filter('translate')('model.featuretypes.actions.PortalModel'),
              $filter('translate')('model.featuretypes.actions.StaticModel'),
            ];
            scope.tableParams.reload();
          }
        };

        scope.rapportMove = function(idx, direction) {
          if (idx !== -1) {
            var rapport = scope.currentFormData.rapports[idx];
            rapport.$selected = false;
            if (direction === 'up') {
              scope.currentFormData.rapports.splice(idx, 1);
              scope.currentFormData.rapports.splice(idx - 1, 0, rapport);
            } else {
              scope.currentFormData.rapports.splice(idx, 1);
              scope.currentFormData.rapports.splice(idx + 1, 0, rapport);
            }
            scope.currentFormData.rapports.map(function(x, i) {
              if (i !== idx) x.$selected = false;
            });
          }
          scope.tableParams.reload();
        };

        scope.selectRapport = function(idx) {
          scope.currentFormData.rapports.map(function(x, i) {
            i === idx ? (x.$selected = true) : (x.$selected = false);
          });
        };

        scope.removeRapport = function(idx) {
          scope.currentFormData.rapports.splice(idx, 1);
          if (idx === 0 && scope.currentFormData.rapports.length === 0)
            scope.currentFormData.rapports = [
              { id: Math.floor(Math.random() * 10000) },
            ];
          scope.tableParams.reload();
        };

        scope.addRapport = () => {
          if (scope.currentFormData && !scope.currentFormData.rapports){
            scope.currentFormData.rapports = [];
          }
          scope.currentFormData.rapports.push({
            id: Math.floor(Math.random() * 10000),
          });
          scope.tableParams.reload();
        };

        scope.typeChanged = function(rapport) {
          switch (rapport.type) {
          case $filter('translate')('model.featuretypes.actions.PortalModel'):
            rapport.typeInfo = 'PortalModel';
            DocumentFactory.getlisttemplate().then(
              function(res) {
                rapport.files = res.data.map(function(x) {
                  return x.name;
                });
              },
              function() {
                require('toastr').error('error');
              }
            );
            break;
          case $filter('translate')('model.featuretypes.actions.StaticModel'):
            rapport.typeInfo = 'StaticModel';
            FilesFactory.getfilesstatic(scope.fti.name).then(
              function(res) {
                rapport.files = res.data;
              },
              function() {
                require('toastr').error('error');
              }
            );
            break;
          case $filter('translate')('model.featuretypes.actions.JasperModel'):
            rapport.typeInfo = 'JasperModel';
            rapport.files = [];
            ReportIndicatorFactory.getAllReportNamesFromApplication(
              rapport.appname,
              true
            ).then(
              (res) => {
                if (res.data){
                  // noms de fichiers sans extension
                  // les fichiers dont le nom commence par "_sub" sont exclus
                  rapport.files = res.data.filter((r) => {
                    if (r.name) {
                      return r.name.substring(0, 3) !== 'sub_';
                    }
                    else {
                      return r.substring(0, 3) !== 'sub_';
                    }
                  }).map((r) => {
                    if (r.name) {
                      return r.name.substring(0, r.name.length - 7);
                    }
                    else {
                      return r;
                    }
                  }
                  );

                  // récupération des noms d'application
                  if (DataStoreFactory.resources.datastores.length === 0) {
                    DataStoreFactory.get().then(
                      ds => {
                        DataStoreFactory.resources.datastores = ds.data;
                        scope.datastores = DataStoreFactory.resources.datastores.map(
                          x => x.name
                        );
                      },
                      () =>{
                        require('toastr').error(
                          $filter('translate')('tools.reports.app_error')
                        );
                      }
                    );
                  }else{
                    scope.datastores = DataStoreFactory.resources.datastores.map(
                      x => x.name
                    );
                  }
                }

              },
              () => {
                require('toastr').error(
                  $filter('translate')('tools.reports.retrieve_error')
                );
              }
            );
            break;
          }
        };

        scope.uploadedFile = function(input) {
          var file = input.files[0];
          var formdata = new FormData();
          formdata.append('file', file);
          FilesFactory.uploadfilestatic(
            scope.fti.name,
            file.name,
            formdata
          ).then(
            function() {
              if (file.name === '' || file.name === null) return;
              var idx;
              for (var i = 0; i < scope.currentFormData.rapports.length; i++) {
                if (scope.currentFormData.rapports[i].$selected) {
                  idx = i;
                  break;
                }
              }
              scope.currentFormData.rapports[idx].fileUploaded = file;

              scope.currentFormData.rapports[idx].file = file.name;
              if (
                angular.isUndefined(scope.currentFormData.rapports[idx].files)
              )
                scope.currentFormData.rapports[idx].files = [];
              scope.currentFormData.rapports[idx].files.push(file.name);
              scope.tableParams.reload();
              gaDomUtils.hideGlobalLoader();
            },
            function() {
              gaDomUtils.hideGlobalLoader();
              require('toastr').error('error');
            }
          );
        };

        scope.attributes = {};
        var aliases = ['Identifiant'];
        var names = ['id'];
        scope.fti.attributes.map(function(x) {
          if (Object.keys(scope.attributes).indexOf(x.type) === -1)
            scope.attributes[x.type] = [];
          scope.attributes[x.type].push(x.alias);
          aliases.push(x.alias);
          names.push(x.name);
        });

        scope.changeJasperReport = function(rapport) {
          if (
            rapport.type ===
              $filter('translate')('model.featuretypes.actions.JasperModel') ||
            rapport.typeInfo === 'JasperModel'
          )
            ReportFactory.getParams(rapport.file, rapport.appname,true).then(
              function(res) {
                rapport.parameters = res.data.map(function(x) {
                  x.possibleAttributes = [];
                  x.possibleAttributes.push('Identifiant');
                  if (x.type === 'java.lang.String'){
                    // si le paramètre est de type string on propose tous les attributs
                    Object.values(scope.attributes).forEach(attributesByType => {
                      x.possibleAttributes.push(...attributesByType);
                    });
                  }else{
                    // sinon on propose uniquement les attributs de même type
                    x.possibleAttributes = x.possibleAttributes.concat(
                      scope.attributes[x.type]
                    );
                  }
                  x.id = Math.floor(Math.random() * 100000);
                  return x;
                });
                if (res.data.length > 0) scope.openParametes(rapport);
              },
              function() {
                require('toastr').error('error');
              }
            );
        };

        /**
         * Paramètres du tableau listant les règles associées au currentfeaturetype passé à cette directive
         */

        scope.saisieModes = [
          $filter('translate')('model.featuretypes.actions.saisieAttribut'),
          $filter('translate')('model.featuretypes.actions.saisieUtilisateur'),
          $filter('translate')('model.featuretypes.actions.saisieStatic'),
          $filter('translate')('model.featuretypes.actions.saisieVariable')
        ];

        scope.tableParamsParameters = new ngTableParams(
          {
            page: 1, // show first page
            count: 10, // count per page
          },
          {
            total: 0, // length of data
            getData: function($defer, params) {
              var displayedTab = scope.rapportParameters.parameters.slice(
                (params.page() - 1) * params.count(),
                params.page() * params.count()
              );

              params.total(scope.rapportParameters.parameters.length); // set total for recalc pagination
              $defer.resolve(displayedTab);
            },
          }
        );

        scope.changedParameters = (parameter) => {
          switch (parameter.saisieMode) {
          case $filter('translate')(
            'model.featuretypes.actions.saisieAttribut'
          ):
            parameter.typeInfo = 'saisieAttribut';
            break;
          case $filter('translate')(
            'model.featuretypes.actions.saisieUtilisateur'
          ):
            parameter.typeInfo = 'saisieUtilisateur';
            break;
          case $filter('translate')(
            'model.featuretypes.actions.saisieStatic'
          ):
            parameter.typeInfo = 'saisieStatic';
            break;
          case $filter('translate')(
            'model.featuretypes.actions.saisieVariable'
          ):
            parameter.typeInfo = 'saisieVariable';
            break;
          }
        };


        scope.validerParameters = function() {
          scope.rapportParameters.parameters = scope.rapportParameters.parameters.map(
            function(x) {
              if (
                x.saisieMode ===
                  $filter('translate')(
                    'model.featuretypes.actions.saisieAttribut'
                  ) ||
                x.typeInfo === 'saisieAttribut'
              ) {
                var idx = aliases.indexOf(x.attributAlias);
                x.attribut = names[idx];
              }
              return x;
            }
          );
          for (var i = 0; i < scope.currentFormData.rapports.length; i++) {
            if (
              scope.currentFormData.rapports[i].id ===
              scope.rapportParameters.id
            ) {
              scope.currentFormData.rapports[i].parameters = angular.copy(
                scope.rapportParameters.parameters
              );
              break;
            }
          }
          scope.tableParams.reload();
        };

        scope.closeDiag = function() {
          scope.p.close();
        };


        scope.jasperParamsOk = () => {
          const params = scope.rapportParameters.parameters;
          for (let ind = 0; ind < params.length; ind++) {
            if (params[ind].saisieMode == 'Variable'
            && !params[ind].value) {
              return false;
            }
          }
          return true;
        };


        scope.openParametes = function(rapport) {
          scope.rapportParameters = angular.copy(rapport);
          scope.p = ngDialog.open({
            template:
              'js/XG/modules/model/views/modals/modal.featuretypes.actions.parameters.html',
            scope: scope,
            closeByDocument: false,
            className: 'ngdialog-theme-plain width800',
            //preCloseCallback : scope.closeDiag
          });
        };
        scope.isEsriType =
          scope.$parent.$parent.currentfeaturetype.type === 'esri';

        // formats possibles d'export d'un rapport Jasper
        // -- kis-3722 nouvelle liste de formats: pdf, rtf, docx, xlsx, odt, ods
        scope.formats = ['pdf', 'rtf', 'docx', 'xlsx', 'odt', 'ods'];
      },
    };
  };

  gcelement.$inject = [
    'ngTableParams',
    'ngDialog',
    '$filter',
    'DocumentFactory',
    'gaDomUtils',
    'FilesFactory',
    'ReportIndicatorFactory',
    'ReportFactory',
    'ApplicationFactory',
    'DataStoreFactory'
  ];
  return gcelement;
});
