'use strict';
define(function() {
  var Ogc = function(
      $http,
      $filter,
      gcRestrictionProvider,
      $q
  ) {
    var Ogc = {};
    /**
     * Class : Ogc
     * Factory WebServices
     */

    /**
     * Function: proxy
     */
    function proxy(url) {
      var promise = $http.get(
        '/services/{portalid}/ogc/proxy?f=json' + '&url=' + url
      );

      return promise;
    }
    /**
     * Function: wfs
     */
    function wfs() {
      var promise = $http.get('/services/{portalid}/ogc/wfs?f=json');

      return promise;
    }
    /**
     * Function: getfeatures
     *
     * Example:
     * service=WFS
     * version=1.0.0,
     * request=GetFeature
     * typeName=FeatureTypeInfo.uid
     * outputformat=json
     * srsName= map.getView().getProjection().getCode()
     * cql_filter=INTERSECTS(geom, POLYGON((' + leftX + ' ' + bottomY + ','
     *   + rightX + ' ' + bottomY + ',' + rightX + ' ' + topY + ',' + leftX
     *   + ' ' + topY + ',' + leftX + ' ' + bottomY + ')))'
     *
     */
    var QueryDataDefers = [];

    function createDefer(defer) {
      var int = Math.round(Math.random() * 10e7);
      QueryDataDefers.push({
        idx: int,
        defer: defer,
      });
      return int;
    }

    function dataResultAndroid(res, int) {
      var defer;
      try {
        var index;
        for (var i = 0; i < QueryDataDefers.length; i++) {
          var d = QueryDataDefers[i];
          if (d.idx === int) {
            defer = d.defer;
            index = i;
            break;
          }
        }

        var response = {
          data: res,
        };
        try {
          if (response.data && typeof response.data == 'string')
            response.data = JSON.parse(response.data);
        }
        catch (e) {
          e.stack;
        }
        defer.resolve(response);
      }
      catch (e) {
        e.stack;
        defer.reject();
      }
      QueryDataDefers.splice(index, 1);
    }

    /**
     *
     * @param {string} request valeurs possible: 'GetFeature' ou 'GetCount'
     * @param {string} service wfs
     * @param {string} version
     * @param {string} typeName
     * @param {string} outputformat json
     * @param {string} srsName srid
     * @param {string} cql_filter clause where
     * @param {string|null} fil_cql_filter
     * @param {string|null} resolution
     * @param {boolean} force_render_features
     * @param {boolean} useMode Facultatif, prend une des valeurs des modes
     *                          de restriction soit "query", "edition"
     *                          ou "viewer"
     * @return {*}
     */
    function getfeatures(
      request,
      service,
      version,
      typeName,
      outputformat,
      srsName,
      cql_filter,
      fil_cql_filter,
      resolution,
      force_render_features, useMode, additional_filters
    ) {
      if (typeof ogcAndroid !== 'undefined') {
        var ok = $q.defer();
        var int = createDefer(ok);
        ogcAndroid.getFeatures(typeName, cql_filter, int);
        return ok.promise;
      } else {
        var promise = $http.get('/services/{portalid}/ogc/getfeat?f=json'
          + '&request=' + request
          + '&service=' + service
          + '&version=' + version
          + '&typeName=' + typeName
          + '&outputformat=' + outputformat
          + '&srsName=' + srsName
          + '&cql_filter=' + cql_filter
          + '&fil_cql_filter=' + fil_cql_filter
          + '&resolution=' + resolution
          + '&force_render_features=' + force_render_features
          + '&usemode=' + (useMode? useMode:'')
          + '&additional_filters=' + (additional_filters === undefined ? '' : additional_filters)
        );
        promise.then(
          function() {
            // service level logic if any
          },
          function(result) {
            gcRestrictionProvider.showDetailsErrorMessage(result);
          }
        );
        return promise;
      }
    }

    /**
     * Function: getfeaturesp
     */
    function getfeaturespost(
      senddata,
      typeName,
      srsName
    ) {
      var promise = $http.post(
        '/services/{portalid}/ogc/getfeatp?f=json' +
          '&typeName=' +
          typeName +
          '&srsName=' +
          srsName,
        senddata
      );
      promise.then(
        function() {
          // service level logic if any
        },
        function(result) {
          gcRestrictionProvider.showDetailsErrorMessage(result);
        }
      );
      return promise;
    }
    /**
     * Function: getmapobject
     */
    function getmapobject(
      LAYERS,
      STYLES,
      FORMAT,
      SRS,
      SCALE,
      WIDTH,
      HEIGHT,
      WHERE,
      featid
    ) {
      var promise = $http.get(
        '/services/{portalid}/ogc/{featid}/wmsobjet?f=json' +
          '&LAYERS=' +
          LAYERS +
          '&STYLES=' +
          STYLES +
          '&FORMAT=' +
          FORMAT +
          '&SRS=' +
          SRS +
          '&SCALE=' +
          SCALE +
          '&WIDTH=' +
          WIDTH +
          '&HEIGHT=' +
          HEIGHT +
          '&WHERE=' +
          WHERE +
          '&featid=' +
          featid
      );

      return promise;
    }
    /**
     * Function: getmap
     */
    function getmap() {
      var promise = $http.get('/services/{portalid}/ogc/wms?f=json');

      return promise;
    }

    /**
     * Recherche des objets intersectés par le rectangle de sélection
     * @param {number[]} extent intéraction de dessin de polygone
     * @param {string} srid code de la projection de la carte (ex. EPSG:2154)
     * @param {string} ftiuid uid du fti de l'objet editdescription
     * @param useMode
     * @return {Promise} contenant les objets intersectés par le rectangle de sélection
     */
    const findIntersectedFeaturesByRectangle = (extent, srid, ftiuid, useMode) => {
      //Recherche des objets intersectés par le rectangle
      const Xmin = extent[0];
      const Ymin = extent[1];
      const Xmax = extent[2];
      const Ymax = extent[3];
      const cql_filter = 'INTERSECTS(geom, POLYGON((' + Xmin + ' ' + Ymin + ','
        + Xmax + ' ' + Ymin + ','
        + Xmax + ' ' + Ymax + ','
        + Xmin + ' ' + Ymax + ','
        + Xmin + ' ' + Ymin + ')))';
      return getfeatures('GetFeature', 'WFS', '1.0.0', ftiuid,
        'json', srid, cql_filter, null, null, false, useMode);
    };

    /**
     * Recherche des objets intersectés par le polygone de sélection
     * @param {ol.geom.Polygon} polygon geométrie du polygone de sélection
     * @param {string} srid code de la projection de la carte (ex. EPSG:2154)
     * @param {string} ftiuid uid du fti de l'objet editdescription
     * @return {Promise} contenant les objets intersectés par le polygone de sélection
     */
    const findIntersectedFeaturesByPolygon = (polygon, srid, ftiuid) => {
      const multicoords = polygon.getCoordinates();
      //Formatage de la geométrie et construction du filtre de recherche de features
      const coords = multicoords[0];
      let polygonCoordsString = '';
      for (const coord of coords) {
        polygonCoordsString += coord[0] + ' ' + coord[1] + ',';
      }
      polygonCoordsString = polygonCoordsString.substring(0, polygonCoordsString.length - 1);

      const cql_filter = 'INTERSECTS(geom, POLYGON((' + polygonCoordsString + ')))';
      return getfeatures('GetFeature', 'WFS', '1.0.0', ftiuid,
        'json', srid, cql_filter, null, null, false);
    };

    return {
      Ogc: Ogc,
      proxy: proxy,
      getfeatures: getfeatures,
      getfeaturespost: getfeaturespost,
      wfs: wfs,
      getmapobject: getmapobject,
      getmap: getmap,
      dataResultAndroid: dataResultAndroid,
      findIntersectedFeaturesByRectangle: findIntersectedFeaturesByRectangle,
      findIntersectedFeaturesByPolygon: findIntersectedFeaturesByPolygon
    };
  };
  Ogc.$inject = [
    '$http',
    '$filter',
    'gcRestrictionProvider',
    '$q'
  ];
  return Ogc;
});
