'use strict';

/**
 * @ngdoc controller
 * @name modules.authentication.controller:CheckUpCtrl
 * @description
 * The CheckUpCtrl controller
 */

define(function() {
  var CheckUpCtrl = function(
    $filter,
    $timeout,
    $scope,
    CheckUpFactory,
    DataStoreFactory,
    gaDomUtils
  ) {

    $scope.checkupData = {};
    $scope.checkupData.running = false;
    $scope.checkupData.storeName = '';
    $scope.screenToDisplay = 'launch';
    $scope.filterResults = 'all';

    DataStoreFactory.get().then(() => {
      $scope.datastores = DataStoreFactory.resources.datastores;
      if (Array.isArray($scope.datastores) && $scope.datastores.length > 0) {
        $scope.checkupData.storeName = $scope.datastores[0].name;
      }
    }, () =>{
      $scope.datastores = null;
    });

    gaDomUtils.showGlobalLoader();
    CheckUpFactory.getCheckupList().then((res) => {
      gaDomUtils.hideGlobalLoader();
      if (res.data && res.data.checkupables) {
        $scope.checkupList = res.data.checkupables;
        $scope.enableAllCheckups(true);
      } else {
        const mess = 'getCheckupList() -> no checkup found';
        console.error(mess);
        require('toastr').error(mess);
      }
    }, (error) => {
      gaDomUtils.hideGlobalLoader();
      const mess = 'getCheckupList() returned error:' + JSON.stringify(error);
      console.error(mess);
      require('toastr').error(mess);
    });


    $scope.enableAllCheckups = (enable) => {
      $scope.allCheckupsEnabled = enable != undefined ?
        enable : $scope.allCheckupsEnabled;
      for(let checkup of $scope.checkupList) {
        checkup.enabled = $scope.allCheckupsEnabled;
      }
    };

    $scope.getEnabledCheckups = () => {
      let enabledCheckups = [];
      for(let checkup of $scope.checkupList) {
        if (checkup.enabled === true) {
          enabledCheckups.push(checkup.className);
        }
      }
      return enabledCheckups;
    };

    $scope.startCheckUp = (clean) => {
      if($scope.checkupData.storeName) {
        CheckUpFactory.startCheckUp($scope.checkupData.storeName, clean,
          $scope.getEnabledCheckups())
          .then(
            (res) => {
              if(res) {
                $scope.checkupData.status = $filter('translate')('tools.checkUp.startCheckUp');
                $scope.checkupData.running = true;
                $scope.screenToDisplay = 'result';
                checkUpData();
              }
              else {
                $scope.checkupData.status
                  = $filter('translate')('tools.checkUp.failedStartCheckUp');
              }
            },
            () => {
              $scope.checkupData.status = $filter('translate')('tools.checkUp.failedStartCheckUp');
            }
          );
      } else {
        console.error('no storename provided');
      }
    };


    function checkUpData() {
      CheckUpFactory.getCheckUpData().then(res => {
        // Si le checkup a été arrété, on ignore le resultat
        if($scope.checkupData.running){
          switch (res.status) {
            case 200:// http status "ok"
              $scope.checkupData.running = false;
              break;
            case 202:// http status "accepted"
              // checkup is running
              break;
            default:
              $scope.checkupData.running = false;
          }
          $scope.checkupData.queryAnswer = res.data;
          $scope.checkupData.status = res.data.status ? res.data.status : '';
          if ($scope.checkupData.running) {
            $timeout(checkUpData, 1000);
          }
        }

      }, () => {
        $scope.checkupData.running = false;
      });
    }


    $scope.stopCheckUp = function() {
      swal(
        {
          title: $filter('translate')(
            'tools.checkUp.interruptCheckUp'
          ),
          type: 'warning',
          showCancelButton: true,
          confirmButtonColor: '#DD6B55',
          confirmButtonText: $filter('translate')('common.yes'),
          cancelButtonText: $filter('translate')('common.no'),
          closeOnConfirm: true,
        },
        (isConfirm) => {
          if (isConfirm) {
            CheckUpFactory.stopCheckUp().then(
              (res) => {
                if(res) {
                  $scope.checkupData.running = false;

                } else {
                  console.error($filter('translate')('tools.checkUp.failedStopCheckUp'));
                }
              },
              () => {
                console.error($filter('translate')('tools.checkUp.failedStopCheckUp'));
              }
            );
          }
        }
      );
    };

    $scope.cleanOutputBox = function() {
      $scope.checkupData.queryAnswer = {};
      $scope.screenToDisplay = 'launch';
    };

    $scope.isStatusDisplayed = (status) => {
      switch($scope.filterResults) {
        case 'all':
          return true;
        case 'filterWarnings':
          if (status === 'succès' || status === 'non applicable' || status === 'non implémenté') {
            return false;
          } else {
            return true;
          }
        case 'filterErrors':
          if (status === 'erreur' || status === 'crash du checkup'
            || status === 'Réparation incomplète') {
            return true;
          } else {
            return false;
          }
        default:
          console.error("checkupctrl, this filter doesn't exist");
          return true;
      }
    };

  };
  CheckUpCtrl.$inject = [
    '$filter',
    '$timeout',
    '$scope',
    'CheckUpFactory',
    'DataStoreFactory',
    'gaDomUtils'
  ];
  return CheckUpCtrl;
});
