'use strict';

define(() => {
  const importParcelleCtrl = function(
    scope,
    $rootScope,
    BacAppFactory,
    AncAppFactory,
    $http,
    gaDomUtils,
    ngTableParams,
    ngDialog
  ) {
    const AppFactory = scope.apptype == 'bac' ? BacAppFactory : AncAppFactory;
    const parcellesCfg = AppFactory.appCfg.main.parcellesCfg;

    const apiRenneUrlPrefix = `/services/{portalid}/${$rootScope.xgos.sector}app/${AppFactory.appCfg.appname}`;

    onInit();

    scope.onCommuneChanged = () => {
      scope.showSections = false;
      scope.showParcelles = false;

      scope.selected.section = false;
      scope.selected.parcelles = [];

      scope.parcelles = [];
      resetParcellesTableData();

      if (scope.selected && scope.selected.commune) {
        getSections().then(sections => {
          scope.sections = sections;
          scope.showSections = true;
        });
      }
    };

    scope.onSectionChanged = () => {
      scope.showParcelles = false;
      scope.selected.parcelles = [];
      if (scope.selected && scope.selected.section) {
        getParcelles().then(parcelles => {
          scope.showParcelles = true;

          scope.parcelles = parcelles;
          resetParcellesTableData();
        });
      }
    };

    scope.onParcelleChanged = () => {
      scope.selected.parcelles = scope.parcelles.filter(
        parcelle => parcelle.selected
      );
    };

    scope.importParcelles = () => {
      importParcelles().then(res => {
        scope.closeThisDialog(res);
      });
    };

    scope.showParcelleDetails = parcelleId => {
      getParcelle(parcelleId).then(res => {
        let parcelleDetailsDialog;
        parcelleDetailsDialog = ngDialog.open({
          template:
            'js/XG/widgets/ancapp/main/views/modals/modal.parcelle.map.html',
          controller: 'importParcelleMapCtrl',
          className: 'ngdialog-theme-plain width800 miniclose nopadding',
          closeByDocument: false,
          scope: scope,
          data: {
            parcelle: res.data,
          },
        });
      });
    };

    scope.toggleFilters = () => {
      scope.parcellesFilters = {};
      scope.showParcelleFilters = !scope.showParcelleFilters;
    };

    scope.$watch(
      'parcellesFilters',
      () => {
        scope.filteredParcelles = getFilteredParcelles();
        scope.parcellesTableParams.reload();
      },
      true
    );

    function onInit() {
      scope.selected = {};
      scope.communes = [];
      scope.sections = [];
      scope.parcelles = [];
      scope.filteredParcelles = getFilteredParcelles();

      scope.parcellesFilters = {};
      initParcellesTable();
      getCommunes().then(communes => {
        scope.communes = communes;
      });
    }

    function initParcellesTable() {
      scope.parcellesTableParams = new ngTableParams(
        {
          page: 1, // show first page
          count: 10, // count per page
          total: scope.filteredParcelles.length, // length of data
        },
        {
          getData: function($defer, params) {
            if (params.settings().$scope == null) {
              params.settings().$scope = scope;
            }
            $defer.resolve(
              scope.filteredParcelles.slice(
                (params.page() - 1) * params.count(),
                params.page() * params.count()
              )
            );
            params.total(scope.filteredParcelles.length);
          },
        }
      );
      scope.$watch('parcellesTableParams.$params.page', () =>
        resetSelectedParcelles()
      );
      scope.$watch('parcellesTableParams.$params.count', () =>
        resetSelectedParcelles()
      );
    }

    function resetSelectedParcelles() {
      scope.parcelles = scope.parcelles.map(parcelle =>
        Object.assign(parcelle, { selected: false })
      );
      scope.onParcelleChanged();
    }

    function getFilteredParcelles() {
      return scope.parcelles.filter(
        parcelle =>
          (!scope.parcellesFilters.id ||
            (parcelle.idParc &&
              parcelle.idParc
                .toString()
                .toLowerCase()
                .indexOf(scope.parcellesFilters.id.toString().toLowerCase()) !==
                -1)) &&
          (!scope.parcellesFilters.numero ||
            (parcelle.numero &&
              parcelle.numero
                .toString()
                .toLowerCase()
                .indexOf(
                  scope.parcellesFilters.numero.toString().toLowerCase()
                ) !== -1))
      );
    }

    function getCommunes() {
      gaDomUtils.showGlobalLoader();
      const queryParams = getQueryParamsForRennes();
      return $http
        .get(`${apiRenneUrlPrefix}/getCommunes?${queryParams}`)
        .then(result => (result && result.data) || [])
        .catch(err => {
          const retry = window.confirm(
            `Une erreur s'est produite lors de l'import de la communes, veuillez réessayer ?`
          );
          if (retry) {
            return getCommunes();
          }
          require('toastr').error(
            `L’import des communes a echoué. Veuillez réessayer plus tard.`,
            '',
            { positionClass: 'toast-bottom-left' }
          );
          scope.closeThisDialog(false);
        })
        .finally(() => gaDomUtils.hideGlobalLoader());
    }

    function getSections() {
      gaDomUtils.showGlobalLoader();
      const queryParams = getQueryParamsForRennes();
      return $http
        .get(
          `${apiRenneUrlPrefix}/getCommunes/${scope.selected.commune.idComm}/getSections?${queryParams}`
        )
        .then(result => (result && result.data) || [])
        .catch(() => {
          const retry = window.confirm(
            `Une erreur s'est produite lors de l'import de la sections, veuillez réessayer ?`
          );
          if (retry) {
            return getSections();
          }
          require('toastr').error(
            `L’import des sections a echoué. Veuillez réessayer plus tard.`,
            '',
            { positionClass: 'toast-bottom-left' }
          );
          return [];
        })
        .finally(() => gaDomUtils.hideGlobalLoader());
    }

    function getParcelles() {
      gaDomUtils.showGlobalLoader();
      const queryParams = getQueryParamsForRennes();
      return $http
        .get(
          `${apiRenneUrlPrefix}/getSections/${scope.selected.section.idSect}/getParcelles?${queryParams}`
        )
        .then(result => (result && result.data) || [])
        .catch(() => {
          const retry = window.confirm(
            `Une erreur s'est produite lors de l'import de la parcelles, veuillez réessayer ?`
          );
          if (retry) {
            return getParcelles();
          }
          require('toastr').error(
            `L’import des parcelles a echoué. Veuillez réessayer plus tard.`,
            '',
            { positionClass: 'toast-bottom-left' }
          );
          return [];
        })
        .finally(() => gaDomUtils.hideGlobalLoader());
    }

    function getParcelle(parcelleId) {
      gaDomUtils.showGlobalLoader();
      const queryParams = getQueryParamsForRennes();
      return $http
        .get(`${apiRenneUrlPrefix}/getParcelle/${parcelleId}?${queryParams}`)
        .catch(err => {
          const retry = window.confirm(
            `Une erreur s'est produite lors de l'import de la parcelle, veuillez réessayer ?`
          );
          if (retry) {
            return getParcelle(parcelleId);
          }
          require('toastr').error(
            `L’import de parcelle a echoué. Veuillez réessayer plus tard.`,
            '',
            { positionClass: 'toast-bottom-left' }
          );
          throw err;
        })
        .finally(() => gaDomUtils.hideGlobalLoader());
    }

    function resetParcellesTableData() {
      scope.filteredParcelles = getFilteredParcelles();
      scope.parcellesTableParams.page(1);
      scope.parcellesTableParams.reload();
    }

    function importParcelles() {
      gaDomUtils.showGlobalLoader();
      scope.selected.parcelles = scope.selected.parcelles.map(parcelle => {
        parcelle.selected = undefined;
        return parcelle;
      });
      const queryParams = getQueryParamsForRennes();
      return $http
        .post(
          `${apiRenneUrlPrefix}/storeChosenParcelles?${queryParams}`,
          scope.selected
        )
        .catch(err => {
          const retry = window.confirm(
            `Une erreur s'est produite lors de l'import, veuillez réessayer.`
          );
          if (retry) {
            return importParcelles();
          }
          require('toastr').error(
            `L’import des parcelles a echoué. Veuillez réessayer plus tard.`,
            '',
            { positionClass: 'toast-bottom-left' }
          );
          throw err;
        })
        .finally(() => gaDomUtils.hideGlobalLoader());
    }

    function getQueryParamsForRennes() {
      return `f=json&appname=${AppFactory.appCfg.appname}&url=${parcellesCfg.api_cadastre.url}`;
    }
  };
  importParcelleCtrl.$inject = [
    '$scope',
    '$rootScope',
    'BacAppFactory',
    'AncAppFactory',
    '$http',
    'gaDomUtils',
    'ngTableParams',
    'ngDialog',
  ];
  return importParcelleCtrl;
});
