'use strict';
define(function() {
  var ancNavigation = function(
      $location,
      ApplicationFactory,
      $sce,
      $window,
      $rootScope,
      ThemesFactory,
      PortalsFactory
  ) {
    return {
      templateUrl:
        'js/XG/widgets/ancapp/main/views/directives/anc_navigation.html',
      restrict: 'EA',
      scope: {},
      link: function(scope) {
        scope.togglenav = false;

        scope.navigation = [
          {
            key: 'home',
            label: 'Accueil',
            goto: '/anc/',
            icon: 'home',
            description: 'Accueil',
          },
          {
            key: 'folder',
            label: 'Dossiers',
            goto: '/anc/reports/',
            icon: 'folder',
            description: 'La gestion des filières et des contrôles',
          },
          {
            key: 'documents',
            label: 'Documents',
            goto: '/anc/documents/',
            icon: 'folder-open-o',
            description: 'Rapports, Documents, Notices',
          },
          {
            key: 'dashboard',
            label: 'Tableaux de bord',
            goto: '/anc/dashboard/',
            icon: 'pie-chart',
            description: "Bilan d'activité",
          },
          {
            key: 'mails',
            label: 'Publipostage',
            goto: '/anc/mails/',
            icon: 'envelope-o',
            description: 'Gestion et envoi des courriers et des avis ',
          },
          {
            key: 'config_mobile',
            label: 'Mobilite',
            goto: '/anc/config_mobile/',
            icon: 'mobile',
            description: 'Gestion des tournées',
          },
        ];

        // if there is a BAC / MAP app on the same portal
        var bacApp;
        var mapApp;
        ApplicationFactory.get().then(function() {
          bacApp = ApplicationFactory.resources.applications.filter(
            function(x) {
              return x.type == 'BacApp';
            }
          );
          mapApp = ApplicationFactory.resources.applications.filter(
            function(x) {
              return x.type == 'MapApp';
            }
          );
        });

        const checkIfFacturationWIdgetInNavigation = (navigation) => {
            facturationIs = false;
            if (Array.isArray(navigation) && navigation.length > 0) {
              for (let eachOne in navigation) {
                if (eachOne['key'] === 'facturation') {
                  facturationIs = true;
                  break;
                }
              }
            }
            return facturationIs
        }
        // admins only
        var navigationset = false;
        let addOnglets = scope.$on('AncAppCfgSet', function(event, args) {          
          if (!navigationset) { 
            if (args.cfg.hasAccess.facturation) {
              scope.navigation.push({
                key: 'facturation',
                label: 'Facturation',
                goto: '/anc/facturation/',
                icon: 'files-o',
                description: 'Gestion des factures',
              });
            }
            if (args.cfg.isAdmin) {
              scope.navigation.push({
                key: 'admin',
                label: 'Administration',
                goto: '/anc/admin/',
                icon: 'gears',
                description: "Administration de l'application",
              });
            } 
            
            if (args.cfg.allowedtoopenbac ==  true){
              scope.navigation.push({
                key: 'bacanc',
                label: 'BAC',
                goto: '/bac/',
                icon: 'exchange',
                description: "Administration de l'application",
                gotoapp_name: bacApp[0].name,
                
              });
            };

            if (args.cfg.hasAccess.mapApp === true) {
              
              scope.navigation.push({
                key: 'ancbacmap',
                label: 'CARTO',
                goto: '/map',
                icon: 'exchange',
                
                description: $sce.trustAsHtml(
                  "Accès à l'application <em>" + mapApp[0].name + '</em>'
                ),
              
                gotoapp_name: mapApp[0].name,
              });
            }
            navigationset = true;
          }
        });

        scope.$on('$destroy', function() {
          addOnglets();
        });

        scope.mode = 'reduced';
        /**
         * set the navigation class (mini or full) according to current route
         */
        var setNavigationClass = function(path) {
          scope.mode = $location.path() == '/anc/' ? 'expanded' : 'reduced';
        };
        scope.$on('resetAncNavigation', function(event, args) {
          setNavigationClass();
        });
        setNavigationClass();

        /**
         * setCurrent navigation item
         */
        var setCurrentItemClass = function() {
          scope.navigation.forEach(function(i) {
            i.current = i.goto == $location.path();
          });
        };
        setCurrentItemClass();

        /**
         * goto navigation item path
         * @param item
         */
        scope.goto = function(item) {
          if (item.key == 'ancbac') {
            $window.open(
              '#/bac/?portal=' +
                PortalsFactory.getPortalId() +
                '&app=' +
                item.gotoapp_name
            );
            return;
          } else if (item.key == 'ancbacmap') {
            $window.open(
              '#/map?portal=' +
                PortalsFactory.getPortalId() +
                '&app=' +
                item.gotoapp_name
            );
            return;
          } else if (item.key == 'bacanc') {
            $window.open(
              '#/bac/?portal=' +
                PortalsFactory.getPortalId() +
                '&app=' +
                item.gotoapp_name
            );
            return;
          } 

          $location.path(item.goto);
          setNavigationClass();
          setCurrentItemClass();
          scope.togglenav = false;
        };

        scope.getCurrentPageLabel = function() {
          var titre = '';
          scope.navigation.forEach(function(i) {
            if (i.goto == $location.path()) {
              titre = i.label;
            }
          });

          return titre;
        };

        /**
         * Au changement du bouton toggle switch du thème,<ul><li>
         * Enregistre le nouveau thème dans l'utilisateur</li><li>
         * Met à jour l'utilisateur</li></ul>
         */
        scope.addThemeToUser = () => {
          ThemesFactory.addDarkOrDefaultThemeToUser();
        };
      },
    };
  };

  ancNavigation.$inject = [
    '$location',
    'ApplicationFactory',
    '$sce',
    '$window',
    '$rootScope',
    'ThemesFactory',
    'PortalsFactory'
  ];
  return ancNavigation;
});
