'use strict';
define([
  'angular',
  /**
   * Controller
   */
  'widgets/hpoapp/main/controllers/gcMainHpoController',

  /**
   * directives
   */
  'widgets/hpoapp/main/directives/hpoNavigation',
  'widgets/hpoapp/main/directives/navGroupSeppri',

  /**
   * Factories
   */
  'widgets/hpoapp/main/factory/AlertHpoFactory',
  'widgets/hpoapp/main/factory/HpoAppFactory',
  'widgets/hpoapp/main/factory/HpoUserAppFactory',
  'widgets/indigauapp/main/factory/CarteUserAppFactory',

  /**
   * Providers
   */
  'widgets/hpoapp/main/providers/InitProvider',

  /**
   * dependencies
   */
  'angular-strap',
  'angular-strap.tpl',
  'angular-route',
  'ngDragDrop',
], function(
  angular,
  gcMainHpoController,
  hpoNavigation,
  navGroupSeppri,
  AlertHpoFactory,
  HpoAppFactory,
  HpoUserAppFactory,
  CarteUserAppFactory,
  InitProvider
) {
  // generation du module
  var gcMain = angular.module('gcMainHpo', [
    'model',
    'ga_urlutils_service',
    'ngRoute',
    'ngDragDrop',
  ]);

  /**
   * Controller
   */
  gcMain.controller('gcMainHpoController', gcMainHpoController);

  /**
   * Directives
   */
  gcMain.directive('hpoNavigation', hpoNavigation);
  gcMain.directive('navGroupSeppri', navGroupSeppri);

  /**
   * Factories
   */
  gcMain.factory('AlertHpoFactory', AlertHpoFactory);
  gcMain.factory('HpoAppFactory', HpoAppFactory);
  gcMain.factory('HpoUserAppFactory', HpoUserAppFactory);
  gcMain.factory('IndCarteUserAppFactory', CarteUserAppFactory);

  /**
   * Providers
   */
  gcMain.provider('InitProvider', InitProvider);

  return gcMain;
});
