'use strict';
define(function() {
  var HpoAppModelServices = function(
    $http,
    FeatureTypeFactory,
    $filter,
    $rootScope,
    $location,
    InitProvider,
    $timeout,
    $q,
    gaDomUtils
  ) {
    /**
     * [createNewModel description]
     * @param  {[type]} hpoConfig [description]
     * @return {[type]}           [description]
     */
    function createNewModel(hpoConfig) {
      var deferred = $q.defer();
      var promise = $http.post(
        '/services/{portalid}/hpomodelservices/{appname}/model/create/',
        hpoConfig
      );
      promise.then(
        function(res) {
          checkLoadDataThread(res.data, deferred, 0);
        },
        function(res) {
          deferred.reject(res);
        }
      );
      return deferred.promise;
    }

    /**
     * [updateModel description]
     * @param  {[type]} hpoConfig [description]
     * @return {[type]}           [description]
     */
    function updateModel(hpoConfig) {
      var deferred = $q.defer();
      var promise = $http.post(
        '/services/{portalid}/hpomodelservices/{appname}/model/update/',
        hpoConfig
      );
      promise.then(
        function(res) {
          checkLoadDataThread(res.data, deferred, 0);
        },
        function(res) {
          deferred.reject(res);
        }
      );
      return deferred.promise;
    }

    function checkLoadDataThread(threadid, deferred, count) {
      var promise = $http.get(
        '/services/{portalid}/hpomodelservices/{appname}/model/checkDataLoading?f=json' +
          '&threadid=' +
          threadid
      );
      promise.then(
        function(res0) {
          if (res0 && res0.data) {
            var jsRes = res0.data;
            gaDomUtils.setGlobalLoaderScaleBar(jsRes.progress,jsRes.progressMax/jsRes.progressPercentage);
            if (jsRes.alive) {
              // require('toastr').info($filter('translate')('importexportwidget.importing'));
              var delay = 5000;
              if (count < 3) delay = 1000;
              $timeout(function() {
                checkLoadDataThread(threadid, deferred, ++count);
              }, delay);
            } else {
              if (jsRes.status == 400) {
                deferred.resolve({ data: jsRes.error });
              } else {
                deferred.resolve({
                  data: jsRes.result,
                  status: jsRes.status,
                });
              }
            }
          } else {
            deferred.reject(res0);
          }
        },
        function(res) {
          deferred.reject(res);
        }
      );
    }

    function getModel(uid, identifiant, uidjeu) {
      var promise = $http.get(
        '/services/{portalid}/hpomodelservices/{appname}/model/get?uid=' +
          uid +
          '&identifiant=' +
          identifiant +
          '&uidjeu=' +
          uidjeu
      );
      promise.then(function(res) {});
      return promise;
    }

    function getCalage(
      uid,
      identifiant,
      identifiantmodel,
      uidjeu,
      uidmodel,
      uidcalagesynthese,
      uidvalidation,
      rerun
    ) {
      if (!angular.isDefined(rerun)) rerun = false;
      var promise = $http.get(
        '/services/{portalid}/hpomodelservices/{appname}/calage/get?uid=' +
          uid +
          '&identifiant=' +
          identifiant +
          '&identifiant_model=' +
          identifiantmodel +
          '&uidjeu=' +
          uidjeu +
          '&uidmodel=' +
          uidmodel +
          '&uidcalagesynthese=' +
          uidcalagesynthese +
          '&rerun=' +
          rerun +
          '&uidvalidation=' +
          uidvalidation
      );
      promise.then(function(res) {});
      return promise;
    }

    function getValidation(
      uid,
      identifiant,
      identifiantmodel,
      uidjeu,
      uidmodel
    ) {
      var deferred = $q.defer();
      var promise = $http.get(
        '/services/{portalid}/hpomodelservices/{appname}/validation/get?uid=' +
          uid +
          '&identifiant=' +
          identifiant +
          '&identifiant_model=' +
          identifiantmodel +
          '&uidjeu=' +
          uidjeu +
          '&uidmodel=' +
          uidmodel
      );
      promise.then(
        function(res) {
          checkLoadDataThread(res.data, deferred, 0);
        },
        function(res) {
          deferred.reject(res);
        }
      );
      return deferred.promise;
    }

    function getPrevision(
      uid,
      identifiant,
      identifiantmodel,
      identifiantcalage,
      uidjeu,
      uidmodel,
      uidcalage,
      rerun
    ) {
      if (!angular.isDefined(rerun)) rerun = false;
      var promise = $http.get(
        '/services/{portalid}/hpomodelservices/{appname}/prevision/get?uid=' +
          uid +
          '&identifiant=' +
          identifiant +
          '&identifiant_model=' +
          identifiantmodel +
          '&identifiant_calage=' +
          identifiantcalage +
          '&uidjeu=' +
          uidjeu +
          '&uidmodel=' +
          uidmodel +
          '&uidcalage=' +
          uidcalage +
          '&rerun=' +
          rerun
      );
      promise.then(function(res) {});
      return promise;
    }

    /**
     * [createNewModel description]
     * @param  {[type]} hpoConfig [description]
     * @return {[type]}           [description]
     */
    function createJeu(hpoConfig) {
      var deferred = $q.defer();
      var promise = $http.post(
        '/services/{portalid}/hpomodelservices/{appname}/jeu/create/',
        hpoConfig
      );
      promise.then(
        function(res) {
          checkLoadDataThread(res.data, deferred, 0);
        },
        function(res) {
          deferred.reject(res);
        }
      );
      return deferred.promise;
    }

    /**
     * [updateModel description]
     * @param  {[type]} hpoConfig [description]
     * @return {[type]}           [description]
     */
    function updateJeu(hpoConfig) {
      var deferred = $q.defer();
      var promise = $http.post(
        '/services/{portalid}/hpomodelservices/{appname}/jeu/update/',
        hpoConfig
      );
      promise.then(
        function(res) {
          checkLoadDataThread(res.data, deferred, 0);
        },
        function(res) {
          deferred.reject(res);
        }
      );
      return deferred.promise;
    }

    /**
     * [updateModel description]
     * @param  {[type]} hpoConfig [description]
     * @return {[type]}           [description]
     */
    function updateAllFeatures(hpoConfig) {
      var deferred = $q.defer();
      var promise = $http.post(
        '/services/{portalid}/hpomodelservices/{appname}/jeu/updateAll/',
        hpoConfig
      );
      promise.then(
        function(res) {
          checkLoadDataThread(res.data, deferred, 0);
        },
        function(res) {
          deferred.reject(res);
        }
      );
      return deferred.promise;
    }

    /**
     * [updateModel description]
     * @param  {[type]} hpoConfig [description]
     * @return {[type]}           [description]
     */
    function getJeuInformation(uid, identifiant) {
      var promise = $http.get(
        '/services/{portalid}/hpomodelservices/{appname}/jeu/get?uid=' +
          uid +
          '&identifiant=' +
          identifiant
      );
      promise.then(function(res) {});
      return promise;
    }

    /**
     * [updateModel description]
     * @param  {[type]} hpoConfig [description]
     * @return {[type]}           [description]
     */
    function getData(
      identifiant,
      fti,
      where,
      crs,
      page,
      count,
      liaison_filter,
      case_sensitive,
      sort,
      staging,
      tablename
    ) {
      if (where === undefined) where = '';
      if (crs === undefined) crs = '';
      if (liaison_filter === undefined) liaison_filter = '';
      if (case_sensitive === undefined) case_sensitive = false;
      if (sort === undefined) sort = '';
      var sendata = {
        identifiant: identifiant,
        fti: fti,
        where: where,
        crs: crs,
        page: page,
        count: count,
        liaison_filter: liaison_filter,
        case_sensitive: case_sensitive,
        sort: sort,
        staging: staging,
      };
      if (!tablename) tablename = '';
      var promise = $http.post(
        '/services/{portalid}/hpomodelservices/{appname}/jeu/getData?tablename=' +
          tablename,
        sendata
      );
      promise.then(function(res) {});
      return promise;
    }

    /**
     * [updateModel description]
     * @param  {[type]} hpoConfig [description]
     * @return {[type]}           [description]
     */
    function removeFeatures(identifiant, name, id) {
      var promise = $http.post(
        '/services/{portalid}/hpomodelservices/{appname}/remove/feature?name=' +
          name +
          '&identifiant=' +
          identifiant,
        id
      );
      promise.then(function(res) {});
      return promise;
    }

    /**
     * [updateModel description]
     * @param  {[type]} hpoConfig [description]
     * @return {[type]}           [description]
     */
    function validationAire(sendata, pourcentage) {
      var promise = $http.post(
        '/services/{portalid}/hpomodelservices/{appname}/validation/aire?',
        sendata
      );
      promise.then(function(res) {});
      return promise;
    }

    /**
     * [updateModel description]
     * @param  {[type]} hpoConfig [description]
     * @return {[type]}           [description]
     */
    function addFeatures(fti, features, identifiant) {
      var sendata = {
        fti: fti,
        features: features,
      };
      var promise = $http.post(
        '/services/{portalid}/hpomodelservices/{appname}/add/features?identifiant=' +
          identifiant,
        sendata
      );
      promise.then(function(res) {});
      return promise;
    }

    /**
     * [updateModel description]
     * @param  {[type]} hpoConfig [description]
     * @return {[type]}           [description]
     */
    function updateFeatures(fti, features, identifiant) {
      var sendata = {
        fti: fti,
        features: features,
      };
      var promise = $http.post(
        '/services/{portalid}/hpomodelservices/{appname}/update/features?identifiant=' +
          identifiant,
        sendata
      );
      promise.then(function(res) {});
      return promise;
    }

    /**
     * Function: exportLayersFeatures
     */
    function exportLayersFeatures(
      exportFormat,
      srid,
      attributes,
      whereClause,
      identifiant,
      tableName
    ) {
      //bbox
      var senddata = attributes;
      if (!tableName) tableName = '';

      var deferred = $q.defer();
      var promise = $http.post(
        '/services/{portalid}/hpomodelservices/{appname}/export/exportLayersFeatures?f=json' +
          '&exportFormat=' +
          exportFormat +
          '&srid=' +
          srid +
          '&whereClause=' +
          whereClause +
          '&identifiant=' +
          identifiant +
          '&table_name=' +
          tableName,
        senddata
      );
      promise.then(
        function(res) {
          checkLoadDataThread(res.data, deferred, 0);
        },
        function(res) {
          deferred.reject(res);
        }
      );
      return deferred.promise;
    }

    function getJeuValueDate(sendata, identifiant) {
      var promise = $http.post(
        '/services/{portalid}/hpomodelservices/{appname}/jeu/getValueDate?identifiant=' +
          identifiant,
        sendata
      );
      promise.then(function(res) {});
      return promise;
    }

    function checkDateFormat(ftiuid, attribute, format) {
      var promise = $http.get(
        '/services/{portalid}/hpomodelservices/{appname}/check/dateformat?ftiuid=' +
          ftiuid +
          '&attribute=' +
          attribute +
          '&format=' +
          format
      );
      promise.then(function(res) {});
      return promise;
    }

    /**
     * [createCalage crée un calage et lance le calcul]
     * @param  {[type]} hpoConfig [HpoModel]
     * @return {[type]}           [promesse]
     */
    function createCalage(hpoConfig) {
      var promise = $http.post(
        '/services/{portalid}/hpomodelservices/{appname}/calage/add/',
        hpoConfig
      );
      promise.then(function(res) {});
      return promise;
    }

    /**
     * [createCalage crée un calage et lance le calcul]
     * @param  {[type]} hpoConfig [HpoModel]
     * @return {[type]}           [promesse]
     */
    function createPrevision(hpoConfig) {
      var promise = $http.post(
        '/services/{portalid}/hpomodelservices/{appname}/prevision/add/',
        hpoConfig
      );
      promise.then(function(res) {});
      return promise;
    }

    function getAvailablePrevions(
      uidcomposant,
      uidprevision,
      uidjeu,
      uidmodel,
      where
    ) {
      if (!where) where = '';
      var promise = $http.get(
        '/services/{portalid}/hpomodelservices/{appname}/prevision/available?uidcomposant=' +
          uidcomposant +
          '&uidprevision=' +
          uidprevision +
          '&uidjeu=' +
          uidjeu +
          '&uidmodel=' +
          uidmodel +
          '&where=' +
          where
      );
      promise.then(function(res) {});
      return promise;
    }

    function updateValue(
      ftiuidcalage,
      ftiuidvalidation,
      identifiant,
      key,
      fieldtype,
      value
    ) {
      var promise = $http.get(
        '/services/{portalid}/hpomodelservices/{appname}/validation/updateValue?ftiuidcalage=' +
          ftiuidcalage +
          '&ftiuidvalidation=' +
          ftiuidvalidation +
          '&identifiant=' +
          identifiant +
          '&key=' +
          key +
          '&fieldtype=' +
          fieldtype +
          '&value=' +
          value
      );
      promise.then(function(res) {});
      return promise;
    }

    return {
      createNewModel: createNewModel,
      getModel: getModel,
      getCalage: getCalage,
      getValidation: getValidation,
      getPrevision: getPrevision,
      updateModel: updateModel,
      createJeu: createJeu,
      updateJeu: updateJeu,
      updateAllFeatures: updateAllFeatures,
      getJeuInformation: getJeuInformation,
      getData: getData,
      removeFeatures: removeFeatures,
      addFeatures: addFeatures,
      updateFeatures: updateFeatures,
      exportLayersFeatures: exportLayersFeatures,
      getJeuValueDate: getJeuValueDate,
      checkDateFormat: checkDateFormat,
      createCalage: createCalage,
      createPrevision: createPrevision,
      validationAire: validationAire,
      getAvailablePrevions: getAvailablePrevions,
      updateValue: updateValue,
      checkLoadDataThread: checkLoadDataThread,
    };
  };
  HpoAppModelServices.$inject = [
    '$http',
    'FeatureTypeFactory',
    '$filter',
    '$rootScope',
    '$location',
    'InitProvider',
    '$timeout',
    '$q',
    'gaDomUtils',
  ];
  return HpoAppModelServices;
});
