'use strict';
define(function() {
  var gcelement = function(
    EditRulesFactory,
    ogcFactory,
    EditTypesFactory,
    gcStyleFactory,
    gcPopup,
    gclayers,
    $translate,
    SelectManager,
    gcInteractions,
    $timeout,
    CopyPasteAttributeFactory,
    $filter,
    bizeditProvider,
    ObjectFilesFactory,
    mapJsUtils,
    $q,
    FeatureAttachmentFactory,gaJsUtils,
    $rootScope,
    RightsFactory
  ) {
    return {
      templateUrl:
        'js/XG/widgets/mapapp/bizedition/views/bizeditattributes.html',
      restrict: 'E',
      scope: {
        map: '=map',
        selectfti: '=selectfti', //couche sélectionné
        editdescription: '=editdescription', //objet contenant les informations sur les édition en cours
        isActive: '=isactive',
        menuContext: '=menucontext',
        toolbarwidget: '=?toolbarwidget',
        createeditdescription: '&',
        reset: '&',
        uploadfile: '=?',
        updatesToSave: '&updatestosave',
        saveinProgress: '=?' //spinner du widget
      },

      link: function(scope) {
        scope.isActive = false;
        var format = new ol.format.GeoJSON();
        var map = scope.map;
        /**
         * SelectionMode: outil utilisé pour sélectionner les objets à éditer
         * normal: dessin d'un cadre
         * polygon: dessin d'un polygon
         * query; récupération d'une sélection courante (après l'utilisation du requeteur)
         */
        scope.selectionMode = { value: 'normal' };

        /**
         * new: chaque nouvelle sélection remplace les objet sélectionné préalablement.
         * add: chaque nouvelle sélection ajoute les objets à la liste des objets édités.
         */
        scope.selectionType = { value: 'new' };

        var noResultMsg = 'No Result';
        $translate('bizedition.attributesPopupNoResult').then(function(res) {
          noResultMsg = res;
        });

        /**
         * Méthode appelée au clic sur le bouton correspondant à cette directive.
         * @returns {undefined}
         */
        scope.startAction = function() {
          //Activation si désactivé et desactivation si activé
          scope.reset();
          scope.isActive = !scope.isActive;
          draw.setActive(scope.isActive);
          if (scope.isActive) {
            console.log(scope.menuContext);
            if (scope.menuContext && scope.menuContext.length > 2) {
              scope.menuContext.splice(0, scope.menuContext.length - 2);
            }
          }
          dragBox.setActive(scope.isActive);
          if (!scope.isActive) {
            return;
          }

          //Initialisation du tableau des objets séléctionnés pour être édités.
          scope.selectedFeatures = [];

          //Appel de la méthode du widget créant l'Object contenant les informations sur l'édition en cours.
          scope.createeditdescription();

          // rather than calling scope.apply in scope.createeditdescription() (function is located in bizeditwidget.js)
          // we ask angular to wait for the current digest cycle to end
          // after digest cycle has ended, our variables are set
          $timeout(() => {
            scope.editdescription.editType =
              EditTypesFactory.editTypes.updateattributes.name;
            scope.editdescription.fti = scope.selectfti;

            var promise = EditRulesFactory.executeInitRules(
              scope.editdescription,
              scope.selectfti,
              map
            );
            promise.then(function() {
              scope.selectfeaturesToUpdate();
            });
          });
        };

        /**
         * Active une méthode de sélection de features
         * @returns {undefined}
         */
        scope.selectfeaturesToUpdate = function() {
          //Si option de sélection de features par dessin d'un polygone
          if (scope.selectionMode.value === 'polygon') {
            map.removeInteraction(dragBox);
            gcInteractions.setCurrentToolBar(scope.toolbarwidget);
            map.addInteraction(draw);

            //Enregistrement de la reference vers l'interaction pour la retirer de la carte au besoin.
            scope.editdescription.interactions.push(draw);
          } else if (scope.selectionMode.value === 'query') {
            map.removeInteraction(dragBox);
            map.removeInteraction(draw);
            var res = {};
            res.data = SelectManager.getFeaturesByftiType(scope.selectfti.name);
            onSelectionResult(res);
          }
          //Sinon, selection par cadre
          else {
            map.removeInteraction(draw);
            gcInteractions.setCurrentToolBar(scope.toolbarwidget);
            map.addInteraction(dragBox);
            //Enregistrement de la reference vers l'interaction pour la retirer de la carte au besoin.
            scope.editdescription.interactions.push(dragBox);
          }
        }; //end selectfeaturesToUpdate

        //Interaction de dessin d'un cadre pour sélectionner des features sur la carte.
        var dragBox = new ol.interaction.DragBox({
          condition: function(evt) {
            //MacEnvironments don't get here because the event is not
            //recognized as mouseEvent on Mac by the google closure.
            //We have to use the apple key on those devices
            return (
              evt.originalEvent.ctrlKey || scope.isActive
            ); /* ||
                      (gaBrowserSniffer.mac && evt.originalEvent.metaKey);*/
          },
          style: gcStyleFactory.getStyle('selectrectangle'),
        });

        dragBox.set('gctype', 'kis');
        dragBox.set('interaction', 'Select');
        dragBox.set('widget', 'Edition');

        //Interaction de dessin d'un polygone pour sélectionner des features sur la carte.
        var draw = new ol.interaction.Draw({
          type: 'Polygon',
        });

        draw.set('gctype', 'kis');
        draw.set('interaction', 'Draw');
        draw.set('widget', 'Edition');
        draw.setActive(scope.isActive);
        dragBox.setActive(scope.isActive);

        //Les handlers de fin de sélection
        dragBox.on('boxend', function() {
          //Fermeture de l'eventuelle popup déjà ouverte.
          if (scope.p != undefined && scope.p.element != null) {
            scope.p.destroy();
            delete scope.p;
          }

          //Recherche des objets intersectés par l'intersection
          const extent = dragBox.getGeometry().getExtent();
          const srid = map.getView().getProjection().getCode();
          const ftiuid = scope.editdescription.fti.uid;
          ogcFactory.findIntersectedFeaturesByRectangle(extent, srid, ftiuid).then(
            onSelectionResult);
        }); //en dragBox.end

        /**
         * Handler de fin de dessin de polygone de sélection d'objet sur la carte.
         * Permettre de requeter les objets features de la couche sélectionnée, situés à l'intérieur du dessin.
         */
        draw.on('drawend', function(evt) {
          //Fermeture de l'eventuelle popup déjà ouverte.
          if (scope.p != undefined && scope.p.element != null) {
            scope.p.destroy();
            delete scope.p;
          }

          //Récupération de la géométrie dessinée
          const polygon = evt.feature.getGeometry();
          const srid = map.getView().getProjection().getCode();
          const ftiuid = scope.editdescription.fti.uid;
          ogcFactory.findIntersectedFeaturesByPolygon(polygon, srid, ftiuid).then(
            onSelectionResult,
            error => {
              console.error('ogcFactory.getfeatures, error:' + error);
              require('toastr').error(error);
            });
        });

        /**
         * Utilitaire: indique si le feature passé en paramètre appartient déjà à la sélection.
         * @param {type} feature
         * @returns {Boolean}
         */
        function isFeatureToAdd(feature) {
          for (var i = 0; i < scope.selectedFeatures.length; i++) {
            if (feature.getId() == scope.selectedFeatures[i].getId()) {
              return false;
            }
          }
          return true;
        }

        function mergedSavedObjWithCurrentObj() {
          if (scope.selectedFeatures.length === 1) {
            const uId = scope.editdescription.fti.uid;
            var currentObj = scope.multipleEditValues;
            var savedObj = CopyPasteAttributeFactory.GetStoredObject(uId);
            for (let prop in savedObj) {
              if (!Object.prototype.hasOwnProperty.call(currentObj, 'prop')) {
                currentObj[prop] = savedObj[prop];
              }
            }
            scope.multipleEditValues = currentObj;
          }
        }

        function onSelectionResult(res) {
          if (scope.p) {
            const confirmation = window.confirm($filter('translate')('bizedition.replacePopupWarning'));
            if (!confirmation) {
              return;
            }
            scope.p.destroy();
            delete scope.p;
          }
          //Decodage de la featureCollection, retourne un tableau de ol.feature
          /**
           * Object indexé par les numéro de ligne et dont la valeur vaut true si la ligne est en mode édition
           */
          scope.editableLines = {};
          //Edition multiple avec le premier tableau de la popup
          scope.multipleEditValues = {};

          require('toastr').clear();
          if (res.data.features == undefined || res.data.features.length == 0) {
            require('toastr').warning(noResultMsg);
            return;
          }

          //Si au moins un objet feature trouvé,
          if (res.data.features != undefined && res.data.features.length > 0) {
            //Decodage de la featureCollection, (le decodage retourne un tableau de ol.feature)
            if (scope.selectionType.value == 'new') {
              scope.selectedFeatures = format.readFeatures(res.data);
            }
            //Si la sélection actuelle d'objets doit s'ajouter à la précedente sélection
            else if (scope.selectionType.value == 'add') {
              //Récupération de la nouvelle sélection
              var partialSelection = format.readFeatures(res.data);
              //Filtrage pour ne récupérer que des nouveaux features non précedement sélectionnés
              partialSelection = partialSelection.filter(isFeatureToAdd);
              //Ajout des nouveaux features à la sélection
              scope.selectedFeatures = scope.selectedFeatures.concat(
                partialSelection
              );
            }
            //Par defaut, nouvelle sélection
            else {
              scope.selectedFeatures = format.readFeatures(res.data);
            }

            let promises = [];
            if(Array.isArray(scope.selectedFeatures) && scope.selectedFeatures.length>0){
              for (let i=0;i<scope.selectedFeatures.length;i++) {
                let editDescription = angular.copy(scope.editdescription);
                editDescription.editedfeature = angular.copy(scope.selectedFeatures[i]);
                let promise = EditRulesFactory.executeEndRules(
                  editDescription,
                  editDescription.fti,
                  map
                ).then(()=> {
                  scope.selectedFeatures[i] = editDescription.editedfeature;
                });
                promises.push(promise);
              }
            }
            $q.all(promises).then(() => {
              scope.editdescription.messages = [];
              scope.featuretoattach = {
                id: res.data.features[0].id,
              };

              //merged copied object with existing one
              mergedSavedObjWithCurrentObj();
              if (scope.selectedFeatures.length > 1) {
                let xWarningMsg = '!';
                $translate('bizedition.multipleSelection').then(function(
                  res
                ) {
                  xWarningMsg = res;
                });
                $timeout(function() {
                  require('toastr').warning(
                    $filter('translate')(xWarningMsg)
                  );
                }, 1000);
              }
              scope.featModif = {};
              scope.configurationTab = false;
                ObjectFilesFactory.getObjectFilesFiltredByAuthorizedAttributes(
                  scope.selectfti.uid).then(res =>{
                    if (typeof res === 'object' && res != null && res.active) {
                      scope.configurationTab = res;
                    }
                }).finally(() => {
                  let hasTabs = false;
                  let popupWidth = null;
                  if (gaJsUtils.notNullAndDefined(scope.configurationTab) && typeof scope.configurationTab !== 'boolean'
                      && Array.isArray(scope.configurationTab.configuration)
                      && scope.configurationTab.configuration.length > 0) {
                    hasTabs = true;
                    const firstConf = scope.configurationTab.configuration[0];
                    if (firstConf.popupWidth > 0 && firstConf.popupWidth < window.innerWidth) {
                      popupWidth = firstConf.popupWidth;
                    }
                  }

              scope.isAdmin = $rootScope.xgos.isroot || $rootScope.xgos.isadmin;
              scope.authorizedReadAttributes = RightsFactory.getUserWriteOrReadRightsAttributes($rootScope.xgos.user, scope.editdescription.fti, scope.isAdmin, true);
              scope.authorizedWriteAttributes = RightsFactory.getUserWriteOrReadRightsAttributes($rootScope.xgos.user, scope.editdescription.fti, scope.isAdmin);
              scope.authorizedWriteAttributesNames = scope.authorizedWriteAttributes.map(att => att.name);
              ObjectFilesFactory.getObjectFilesFiltredByAuthorizedAttributes(
                scope.selectfti.uid, scope.authorizedReadAttributes).then(res =>{
                scope.configurationTab = res;
              });
              scope.p = gcPopup.open({
                    template:
                        'js/XG/widgets/mapapp/bizedition/views/attributes_popup.html',
                  scope: scope,
                  title: $filter('translate')(
                    'bizedition.multiattributesPopupTitle'
                  ),
                  minWidth: hasTabs ? 430 : 400,
                  minHeight: 300,
                  className: 'multi-attr-edit' + (hasTabs ? ' objectFilePopup' : ' nomaximize'),
                  minimizeMaximize: true,
                  showClose: true,
                  resizable: false,
                  width: popupWidth
                });
                // Ajustement de la hauteur du tab-content dans le cas de plusieurs lignes d'onglets
                if (hasTabs) {

                  // sélecteur de la règle CSS que l'on va modifier
                  // on ne peut pas modifier directement le style de l'élement HTML car il est modifiable
                  // par le redimensionnement vertical
                  const cssRuleIdentifier
                    = '.gcPopup.objectFilePopup .popup-template .bizAttPopupMainDiv .scrolledTabs .tab-content';
                  bizeditProvider.adjustObjectFileTabContentHeight(
                    scope.p.popup.iddiv, cssRuleIdentifier,'scrolledTabs', 3);
              }
              });

              //Mise en evidence des features sélectionnés
              gclayers.getselectSource().clear();
              gclayers.getselectSource().addFeatures(scope.selectedFeatures);

              //'multipleEditValues' contiendra les valeurs courantes attributaire du 1er feature sélectionné,
              // dès l'ouverture de la popup d'édition attributaire.
              if (scope.selectedFeatures.length > 0) {
                var attrValues = scope.selectedFeatures[0].getProperties();
                angular.forEach(attrValues, function(value, key) {
                  scope.multipleEditValues[key] = value;
                });
              }
              //Pour chaque feature, construction de l'objet temporaire destiné à contenir les valeurs attributaires
              // KIS-3110 - INUTILE!!! Les valeurs attributaires sont stockées dans multipleEditValues!!!
              // (y'avait qu'à comprendre les 4 lignes précédentes...)
              // @see formField.res dans attributes_popup.html
              // L'utilité de la propriété f.currentProperties est nulle ici.
              for (var i = 0; i < scope.selectedFeatures.length; i++) {
                let f = scope.selectedFeatures[i];
                f.currentProperties = f.getProperties();
              }

              //EditDescription
              //Suppression des eventuels precedents features presents dans editDescription
              scope.editdescription.editedfeature = undefined;
              scope.editdescription.relatedfeatures.splice(0);
              scope.editdescription.shareObjects.splice(0);

              if (scope.selectedFeatures.length > 0) {
                scope.editdescription.editedfeature =
                    scope.selectedFeatures[0];

                for (let i = 1; i < scope.selectedFeatures.length; i++) {
                  var newObject = {
                    shareObject: '',
                    editType:
                        EditTypesFactory.editTypes.updateattributes.name,
                    feature: scope.selectedFeatures[i],
                    fti: scope.editdescription.fti,
                  };
                  scope.editdescription.relatedfeatures.push(newObject);
                }
              }
            },
            function(errorReason) {
              console.error(
                'EditRulesFactory.executeEndRules, error:' + errorReason
              );
              require('toastr').error('executeEndRules error.');
            }
            );
          }
        }

        scope.resetCopiedObject = function() {
          const uId = scope.editdescription.fti.uid;
          const tmpObj = CopyPasteAttributeFactory.GetStoredObject(uId);
          if (tmpObj.objectIsCopied === true) {
            let attrValues = scope.selectedFeatures[0].getProperties();
            scope.multipleEditValues = attrValues;
          }
          scope.isAttributePopupOpen = false;
        };

        /**
         * Méthode à revoir
         * Evaluer si elle est toujours d'actualité depuis KIS-3110
         */
        scope.updateAllSelectedFeatures = function() {
          angular.forEach(scope.multipleEditValues, function(
            value,
            key
          ) {
            if (scope.selectedFeatures.length === 1) {
              if (!(value instanceof ol.geom.Geometry)) {
                //Affectation des valeurs attributaires à chaque feature à partir des attributs temporaires.
                for (
                  var i = 0;
                  i < scope.selectedFeatures.length;
                  i++
                ) {
                  var f = scope.selectedFeatures[i];
                  f.currentProperties[key] = value;
                }
              }
            } else {
              if (scope.featModif[key] == true) {
                if (!(value instanceof ol.geom.Geometry)) {
                  //Affectation des valeurs attributaires à chaque feature à partir des attributs temporaires.
                  for (
                    let i = 0;
                    i < scope.selectedFeatures.length;
                    i++
                  ) {
                    const f = scope.selectedFeatures[i];
                    console.log(scope.featModif);
                    f.currentProperties[key] = value;
                  }
                }
              }
            }
          });
        };

        // CODE POUBELLE A SUPPRIMER SI AUCUNE REGRESSION
        /*        // get the attribute Types
        scope.displayAttributesType = {};
        if (angular.isArray(scope.selectfti.attributes)) {
          scope.selectfti.attributes.map(function(a) {
            var fieldType = '';
            switch (a.type) {
              case 'java.util.Date':
              case 'java.sql.Timestamp':
              case 'java.sql.Time':
              case 'java.sql.Date':
                fieldType = 'date';
                break;
              case 'java.lang.Double':
              case 'java.lang.Float':
              case 'java.math.BigDecimal':
              case 'java.lang.Integer':
                fieldType = 'number';
                break;
              case 'java.lang.Boolean':
                fieldType = 'boolean';
                break;
              default:
                fieldType = 'string';
                break;
            }
            scope.displayAttributesType[a.name] = {
              type: a.type,
              fieldType: fieldType,
            };
          });
        }*/

        scope.resetMultipleEditComponent = function() {
          scope.multipleEditValues = {};
        };
        /**
         * Toggle Edit mode for a specific line
         * @param index
         */
        scope.toggleEdit = function(index) {
          if (Object.prototype.hasOwnProperty.call(scope.editableLines, 'index')) {
            delete scope.editableLines[index];
          } else {
            scope.editableLines[index] = true;
          }
        };
        /**
         * Update a feature
         * @param obj
         * @param $index
         */
        scope.updateData = function(obj, $index) {
          scope.toggleEdit($index);
        };

        /**
         * Au clic sur le bouton de validation de la popup d'édition multiple
         * KIS-3279: rassemble le code éparpillé dans cette méthode
         */
        scope.confirm = function() {

          if (bizeditProvider.checkMandatory(scope, scope.editdescription.fti.attributes,
            scope.selectedFeatures.length, scope.featModif, scope.multipleEditValues)) {

            // méthode appelée obsolète?
            scope.updateAllSelectedFeatures();

            //Fermeture de la popup
            scope.p.destroy();
            delete scope.p;
            gclayers.clearhighLightFeatures();

            //Affectation des valeurs attributaires à chaque feature à partir des attributs temporaires.
            //Rappel: les attributs modifiés dans la popup "attribute_popup.html" sont contenus
            //dans "multipleEditValues"
            if (Array.isArray(scope.selectedFeatures) && scope.selectedFeatures.length === 1) {

              const selectedFeat = scope.selectedFeatures[0];

              // isole la géométrie de l'objet pour restauration après récupération des propriétés de multipleEditValues
              const selectedGeometry = selectedFeat.getGeometry().clone();

              // Dans OpenLayers 4.6.5, setProperties ne supprime pas une propriété existante devenue null.
              // @see https://github.com/openlayers/openlayers/blob/v4.6.5/src/ol/object.js#L170
              mapJsUtils.clearFeatureProperties(selectedFeat);

              // KIS-3110: édition attributaire en masse => les objets ne doivent pas prendre la géométrie du premier !
              const properties = Object.assign({}, scope.multipleEditValues);
              properties.geometry = selectedGeometry;

              selectedFeat.setProperties(properties);
            } else {

              const attachmentTypes = ['g2c.attachment', 'g2c.attachments'];
              let hasAttachmentChange = false;
              const attachedFilenames = [];

              // sélection multiple: on ne modifie que les propriétés cochées
              // KIS-3132: modifie en bloc un attribut uniquement si sa case est cochée
              for (const [propname, isModified] of Object.entries(scope.featModif)) {

                if (isModified) {

                  // modification de la propriété de chaque objet openlayers sélectionné (i.e "modification en bloc")
                  for (const selectedFeat of scope.selectedFeatures) {
                    selectedFeat.set(propname, scope.multipleEditValues[propname]);
                  }

                  // liste les fichiers attachés pour les objets liés
                  const attribute = scope.selectfti.attributes.find(attr => attr.name === propname);
                  if (attribute) {
                    if (attachmentTypes.includes(attribute.type)) {
                      const isMultiAttachment = attribute.type === attachmentTypes[1];
                      if (!isMultiAttachment) {

                        // attachment simple => 1 seul nom de fichier dans la valeur d'attribut
                        if (!attachedFilenames.includes(scope.multipleEditValues[propname])) {
                          attachedFilenames.push(scope.multipleEditValues[propname]);
                        }
                      } else {

                        // attachment multi => plusieurs noms de fichiers dans la valeur d'attribut
                        const filenames = scope.multipleEditValues[propname].split(',');
                        for (const filename of filenames) {
                          if (!attachedFilenames.includes(filename)) {
                            attachedFilenames.push(filename);
                          }
                        }
                      }
                      if (!hasAttachmentChange) {
                        hasAttachmentChange = true;
                      }
                    }
                  }
                }
              }

              // KIS-3279: les fichiers doivent être copiés dans les ATTACHMENT pour chaque objet lié
              if (hasAttachmentChange) {
                // spinner du widget
                scope.saveinProgress = true;

                // construit la requête de copie des fichiers attachés pour chaque objet
                const promises = [];
                const source = bizeditProvider.buildRequestParameter(scope.selectedFeatures[0]);

                // on ne traite pas l'objet principal qui possède déja les fichiers attachés (cas i=0)
                for (let i = 1; i < scope.selectedFeatures.length; i++) {
                  const destination = bizeditProvider.buildRequestParameter(scope.selectedFeatures[i]);
                  promises.push(
                    FeatureAttachmentFactory.copyFilesToFeature(source, destination, attachedFilenames, false));
                }
                $q.all(promises).finally(
                  () => {
                    scope.saveinProgress = false;
                  }
                );
              }
            }

            //Marquage des features comme ayant leurs attributs validés.
            for (let i = 0; i < scope.selectedFeatures.length; i++) {
              scope.selectedFeatures[i].attrEdited = true;
            }

            // active le bouton "Valider" du widget
            scope.updatesToSave({ newValue: true });

            // Exécute règles postValidation de l'objet principal
            EditRulesFactory.executePostValidationRules(scope.editdescription, scope.editdescription.fti, map);

            // Exécute règles postValidation des objets liés
            if(Array.isArray(scope.editdescription.relatedfeatures) && scope.editdescription.relatedfeatures.length>0){
              for (const relatedFeat of scope.editdescription.relatedfeatures) {
                relatedFeat.editedfeature = relatedFeat.feature;
                relatedFeat.shareObjects = [];
                relatedFeat.relatedfeatures = [];
                EditRulesFactory.executePostValidationRules(relatedFeat, relatedFeat.fti, map);
              }
            }
          }
        };

        /**
         * Handler d'annulation par l'utilisateur de la prise en compte de l'édition attributaire dans la popup
         * @param {type} res
         * @returns {undefined}
         */
        scope.closeThisDialog = function() {
          //Fermeture de la popup
          scope.p.destroy();
          delete scope.p;
          gclayers.clearhighLightFeatures();
        };

        scope.localisedata = function(obj) {
          gclayers.clearhighLightFeatures();
          gclayers.addhighLightFeature(obj);
        };
      },
    };
  };

  gcelement.$inject = [
    'EditRulesFactory',
    'ogcFactory',
    'EditTypesFactory',
    'gcStyleFactory',
    'gcPopup',
    'gclayers',
    '$translate',
    'SelectManager',
    'gcInteractions',
    '$timeout',
    'CopyPasteAttributeFactory',
    '$filter',
    'bizeditProvider',
    'ObjectFilesFactory',
    'mapJsUtils',
    '$q',
    'FeatureAttachmentFactory', 'gaJsUtils',
    '$rootScope',
    'RightsFactory'
  ];
  return gcelement;
});