'use strict';
define(function() {
  var importexportwidget = function(
    ConfigFactory,
    ImportExportFactory,
    FeatureTypeFactory,
    EditFactory,
    $translate,
    ngDialog,
    gclayers,
    SridFactory,
    $rootScope,
    ParametersFactory,
    gcRestrictionProvider,
    gaJsUtils,
    gaDomUtils,
    $filter,
    $interval,
    $q,
    PortalsFactory,
    RightsFactory,
    RegionalFactory
  ) {
    /* Recuperation des labels pour les titres des onglets et le labels des formats export */
    let title_tab_import = 'Import';
    $translate('importexportwidget.tab_import').then(function(res) {
      title_tab_import = res;
    });
    let title_tab_export = 'Export';
    $translate('importexportwidget.tab_export').then(function(res) {
      title_tab_export = res;
    });
    let kml = 'KML';
    $translate('importexportwidget.exp_formats_choise_list.kml').then(function(
      res
    ) {
      kml = res;
    });
    let gml = 'GML';
    $translate('importexportwidget.exp_formats_choise_list.gml').then(function(
      res
    ) {
      gml = res;
    });
    let csv = 'CSV';
    $translate('importexportwidget.exp_formats_choise_list.csv').then(function(
      res
    ) {
      csv = res;
    });
    let shapefile = 'Shape';
    $translate('importexportwidget.exp_formats_choise_list.shapefile').then(
      function(res) {
        shapefile = res;
      }
    );
    let gps = 'Format GPS';
    $translate('importexportwidget.exp_formats_choise_list.gps').then(function(
      res
    ) {
      gps = res;
    });
    let dxf = 'Format DXF';
    $translate('importexportwidget.exp_formats_choise_list.dxf').then(function(
      res
    ) {
      dxf = res;
    });

    let corresp_destination = 'aucun';
    $translate('importexportwidget.corresp_destination').then(function(res) {
      corresp_destination = res;
    });
    // Fin de la recuperation des traductions

    return {
      templateUrl:
        'js/XG/widgets/mapapp/importexport/views/importexportwidget.html',
      restrict: 'A',

      link: function(scope, element, attrs) {
        scope.geographicFormat = {
          currentsridName: scope.map.getView().getProjection().getCode()
        };
        scope.isActive = false;
        scope.attachmentFilePaths = {};
        // quick fix by @RB for siroco to allow to pass export=false and remove the export tab
        // if you change this please tell me
        if (attrs.export == 'false') {
          scope.tabs = [{ title: title_tab_import }];
        } else {
          scope.tabs = [
            { title: title_tab_import },
            { title: title_tab_export },
          ];
        }
        if (attrs.showfilter == 'false') {
          scope.showFilter = false;
        } else {
          scope.showFilter = true;
        }
        if (attrs.dontshowtabs == 'true') {
          scope.dontshowtabs = true;
        } else {
          scope.dontshowtabs = false;
        }
        scope.simpleconf = {};
        if (attrs.casesensitive == 'false') {
          scope.simpleconf.casesensitive = false;
        } else {
          scope.simpleconf.casesensitive = true;
        }

        scope.exportData = {
          gpkgFilename: ''
        };

        scope.$watch('simpleconf.casesensitive', function() {
          scope.caseSensitiveMatchingChanged();
        });

        scope.$watch('featureTypes', function() {
          let featureTypes = retriveAttributesToExport(
            scope.featureTypes
          );

          const existingFilePaths = Object.assign({}, scope.attachmentFilePaths);
          scope.attachmentFilePaths = {};

          featureTypes.map(featureType => {
            const uid = featureType.uid;

            scope.attachmentFilePaths[uid] = {
              name: featureType.name,
              filePaths: []
            };

            featureType.mapping.forEach(attr => {
              if(attr.type != 'g2c.attachment' && attr.type != 'g2c.attachments')
                return;

              let attributeFilePath = {
                name: attr.name,
                include: false,
                path: '',
              };

              if(existingFilePaths[uid]){
                const found = existingFilePaths[uid].filePaths.find(el => el.name === attr.name);

                if(found)
                  attributeFilePath = found;
              }
              scope.attachmentFilePaths[uid].filePaths.push(attributeFilePath);
            });
          });
        }, true);

        if (attrs.showaliases == 'true') {
          scope.simpleconf.showaliases = true;
        } else {
          scope.simpleconf.showaliases = false;
        }
        if (attrs.destftiuid != undefined) {
          scope.simpleconf.destftiuid = attrs.destftiuid;
        }

        if (angular.isDefined(attrs.savemapping)) {
          scope.save_mapping = attrs.savemapping;

          scope.loadMapping = function(data) {
            var mapping = angular.copy(data.data);

            scope.impCorrespAttrArray.forEach(function(x, i) {
              if (mapping[x.source])
                scope.impCorrespAttrArray[i].destination = mapping[x.source];
              scope.destAttChanged(scope.impCorrespAttrArray[i]);
            });
            $translate('common.configuration_loaded').then(function(res) {
              require('toastr').success(res);
            });
          };

          scope.saveMapping = function(data) {
            var correspondances = {};
            scope.impCorrespAttrArray.forEach(function(x) {
              correspondances[x.source] = x.destination;
            });
            console.log(correspondances);
            ParametersFactory.add(
              correspondances,
              scope.save_mapping,
              data
            ).then(function() {
              $translate('common.configuration_saved').then(function(res) {
                $rootScope.$broadcast('refreshParameterMappingList', {
                  type: scope.save_mapping,
                });
                require('toastr').success(res);
              });
            });
          };
        }

        scope.tabs.activeTab = 0;

        scope.featuresToImport = [];

        scope.exportFormats = gaJsUtils.sortByKey([
          { value: 'KML', label: kml },
          { value: 'GML', label: gml },
          { value: 'CSV', label: csv },
          { value: 'SHAPEFILE', label: shapefile },
          { value: 'MapInfo File', label: 'MapInfo File' },
          { value: 'GPS', label: gps },
          { value: 'DXF', label: dxf },
          { value: 'GPKG', label: 'Geopackage'}
        ], 'value');

        scope.conf = {
          showDifferencial: false,
          showCancelReplace: false,
          showGPSImport: false,
          srcTableId: '',
          dstTableId: '',
          gpsfieldname: '',
          gpsnewrow: '',
          gpsupdatedrow: '',
        };

        scope.srids = SridFactory.sridsList;

        ConfigFactory.get('IMPEXP', 'mainConfig').then(function(res) {
          var data = res.data;
          scope.conf.showDifferencial = data.showDifferencial;
          scope.conf.showCancelReplace = data.showCancelReplace;
          scope.conf.showGPSImport = data.showGPSImport;
          scope.conf.srcTableId = data.srcTableId;
          scope.conf.dstTableId = data.dstTableId;
          scope.conf.gpsfieldname = data.gpsfieldname;
          scope.conf.gpsnewrow = data.gpsnewrow;
          scope.conf.gpsupdatedrow = data.gpsupdatedrow;
        });

        scope.featureTypes = [];
        scope.selectAllAttributes = true;
        scope.importedFeatures = [];
        scope.destinationFeatures = [];
        scope.checkExportStatus = [];
        scope.exportTablesOnly = false;
        /**
         * [getFeatureTypesData description]
         * @return {[type]} [description]
         */
        scope.getFeatureTypesData = function() {
          if (FeatureTypeFactory.resources.featuretypes.length > 0) {
            scope.feat = FeatureTypeFactory.resources.featuretypes;

            scope.initfeatureTypesArray();
          } else {
            FeatureTypeFactory.get().then(function() {
              scope.feat = FeatureTypeFactory.resources.featuretypes;

              scope.initfeatureTypesArray();
            });
          }
        };
        /**
         * [checkLayersSelection description]
         * @return {[type]} [description]
         */
        scope.checkLayersSelection = function() {
          for (var i = 0; i < scope.featureTypes.length; i++) {
            var ft = scope.featureTypes[i];

            if (ft.include == true) {
              return true;
            }
          }

          return false;
        };


        /**
         * Vérifie si un composant est accessible selon les droits et son état
         *
         * @param {Object} featureType - Le composant à vérifier
         * @param {boolean} isGeographic - Indique si le type doit être géographique
         * @param {boolean} isAdmin - Indique si l'utilisateur est administrateur
         * @param {Object} user - L'utilisateur courant
         * @returns {boolean} true si le composant est accessible, false sinon
         * @description
         * - Vérifie d'abord que le composant correspond àà un objet géographique
         *   ou à une table sans géométrie
         * - Vérifie les droits de lecture/écriture de l'utilisateur sur le composant
         * - Pour les composants géographiques, vérifie également qu'ils sont publiés
         * @see KIS-3819 - Les composants géographiques non publiés sont exclus
         */
        const isFeatureTypeOk = (featureType, isGeographic, isAdmin, user) => {
          let ok = featureType.geographic === isGeographic
              && RightsFactory.isAllowedToReadOrWriteFeatureType(featureType,
                isAdmin, user, true);
          if (ok && isGeographic && !featureType.published) {
            // -- KIS-3819: Si le composant est Géographique, on ne l'accepte que s'il est publié
            ok = false;
          }
          return ok;
        };


        /**
         * Initialise la liste des composants/tables disponibles à l'export
         * (liste de l'autocomplete).
         * N'affiche que les composants/attributs pour lesquels
         * l'utilisateur possède le droit de lecture
         * @param {boolean} isGeographic est true si on souhaite filtrer
         * les composants spatiaux, sinon on filtre uniquement les tables
         */
        scope.initfeatureTypesArray = (isGeographic = true) => {
          // construit les objets composants/tables à partir des fti de FeatureTypeFactory
          const user = $rootScope.xgos && $rootScope.xgos.user ? $rootScope.xgos.user : null;
          const isAdmin = $rootScope.xgos && ($rootScope.xgos.isroot || $rootScope.xgos.isadmin);

          for (const featureType of scope.feat) {

            // ajoute les composants ou tables dont l'utilisateur a le droit en lecture
            if (isFeatureTypeOk(featureType, isGeographic, isAdmin, user)) {
              const newAttributes = [];

              let featureAttributes;
              if ($rootScope.xgos) {
                // KIS-3198: l'utilisateur n'a pas forcément besoin
                // du droit d'écriture pour pouvoir choisir les attributs
                // qu'il exporte ou non du composant
                featureAttributes
                  = RightsFactory.getUserWriteOrReadRightsAttributes(
                    $rootScope.xgos.user, featureType, isAdmin, true);
              } else {
                featureAttributes = [];
                console.error('$rootScope.xgos = ', $rootScope.xgos);
              }
              for (const attrib of featureAttributes) {
                const newAttribute = {
                  name: attrib.name,
                  include: true,
                  type: attrib.type,
                };

                newAttributes.push(newAttribute);
              }

              const newFeatureType = {
                name: featureType.name,
                uid: featureType.uid,
                attributes: newAttributes,
                include: false,
                alias: featureType.alias
              };

              scope.featureTypes.push(newFeatureType);
            }
          }

          scope.isLayerSelected = scope.checkLayersSelection();
        };

        scope.getFeatureTypesData();

        scope.filesToImport = [];

        scope.selectedLayer = null;
        scope.selectedLayerName = null;
        scope.selectedAttributes = [];

        scope.cqlExportFilterQuery = '';
        scope.importFilters = {
          spatial:'',
          attribute:null
        };
        scope.selectedFormat = null;
        scope.layersToExport = '';
        scope.attributesToExport = [];
        scope.strAttributesToExport = '';

        scope.waitExport = false;
        scope.waitImport = false;
        scope.isLayerSelected = false;
        scope.isFormatSelected = false;

        scope.uploadProcessID = -1;

        scope.selectedImpFeature = null;
        scope.importDestFeature = null;
        scope.selectImpAttributes = [];
        scope.impCorrespAttrArray = [];

        scope.srcsrid = '';

        scope.nbImportedRows = -1;

        scope.useCancelReplace = false;
        scope.useDifferencial = false;
        scope.applyRules = false;
        scope.useGPSImport = false;

        /**
         * [findLayerByName description]
         * @param  {[type]} layerName   [description]
         * @param  {[type]} layersArray [description]
         * @return {[type]}             [description]
         */
        function findLayerByName(layerName, layersArray) {
          for (var i = 0; i < layersArray.length; i++) {
            var layer = layersArray[i];

            var loopLayerName = layer.name;

            if (loopLayerName == layerName) {
              return layer;
            }
          }

          return null;
        }
        /**
         * [refreshBtnAvailabilty description]
         * @return {[type]} [description]
         */
        scope.refreshBtnAvailabilty = function() {
          scope.selectedLayer = findLayerByName(
            scope.selectedLayerName,
            scope.featureTypes
          );

          if (scope.selectedLayer != null) {
            scope.selectedAttributes = scope.selectedLayer.attributes;
          } else {
            scope.selectedAttributes = [];
          }

          scope.disableAddbtn =
            scope.selectedLayer == null || scope.selectedLayer.include === true;

          scope.disableRetrivebtn =
            scope.selectedLayer == null || scope.selectedLayer.include === false;

          scope.selectAllAttributes = true;
        };

        scope.refreshBtnAvailabilty();

        /**
         * [retriveLayersToExport description]
         * @param  {[type]} layersArray [description]
         * @return {[type]}             [description]
         */
        function retriveLayersToExport(layersArray) {
          var result = '';

          for (var i = 0; i < layersArray.length; i++) {
            var layer = layersArray[i];

            if (layer.include == true) {
              if (result == '') {
                result = result + layer.uid;
              } else {
                result = result + ';' + layer.uid;
              }
            }
          }

          return result;
        }
        /**
         * [retriveAttributesToExport description]
         * @param  {[type]} layersArray [description]
         * @return {[type]}             [description]
         */
        function retriveAttributesToExport(layersArray) {
          var result = [];

          for (var i = 0; i < layersArray.length; i++) {
            var layer = layersArray[i];

            if (layer.include == true) {
              var attributes = layer.attributes;

              var layerAttributes = [];

              var layerAttributesMapping = [];

              for (var j = 0; j < attributes.length; j++) {
                var attribute = attributes[j];

                if (attribute.include == true) {
                  layerAttributes.push(attribute.name);
                  var at = angular.copy(attribute);
                  layerAttributesMapping.push(at);
                }
              }

              var strLayerAttributes = arrayToString(layerAttributes);

              var objAttribByLayer = {
                uid: layer.uid,
                attributes: strLayerAttributes,
                name: layer.name,
                alias: layer.alias,
                mapping: layerAttributesMapping,
                filePaths: scope.attachmentFilePaths[layer.uid]
                  ? scope.attachmentFilePaths[layer.uid].filePaths : []
              };

              result.push(objAttribByLayer);
            }
          }

          return result;
        }
        /**
         * [arrayToString description]
         * @param  {[type]} inArray [description]
         * @return {[type]}         [description]
         */
        function arrayToString(inArray) {
          var result = '';

          for (var i = 0; i < inArray.length; i++) {
            var str = inArray[i];

            if (result == '') {
              result = result + str;
            } else {
              result = result + ';' + str;
            }
          }

          return result;
        }

        /**
         * [initDestinationFeatures description]
         * @return {[type]}         [description]
         */
        function initDestinationFeatures() {
          scope.destinationFeatures = [];
          const user = $rootScope.xgos && $rootScope.xgos.user ? $rootScope.xgos.user : null;
          const isAdmin = $rootScope.xgos && ($rootScope.xgos.isroot || $rootScope.xgos.isadmin);

          if (scope.simpleconf.destftiuid !== undefined) {
            for (const fti of scope.feat) {

              // ajoute les composants ou tables dont l'utilisateur a le droit en écriture
              // -- KIS-3819: Si le composant est Géographique, on ne l'accepte que s'il est publié
              if (scope.selectedImpFeature.typeInfo === fti.typeInfo &&
                fti.uid === scope.simpleconf.destftiuid
                  && RightsFactory.isAllowedToReadOrWriteFeatureType(fti, isAdmin, user)
                  && (fti.published || !fti.geographic)) {
                scope.destinationFeatures.push(fti);
                scope.importDestFeature = scope.destinationFeatures[0];
                scope.destinationLayerChange();
                break;
              }
            }
          } else {
            for (const fti of scope.feat) {

              // ajoute les composants ou tables dont l'utilisateur a le droit en écriture
              // -- KIS-3819: Si le composant est Géographique, on ne l'accepte que s'il est publié
              if (scope.selectedImpFeature.typeInfo === fti.typeInfo
                  && RightsFactory.isAllowedToReadOrWriteFeatureType(fti, isAdmin, user)
                  && (fti.published || !fti.geographic)) {
                scope.destinationFeatures.push(fti);
              }
            }
          }
        }

        /**
         * [addLayerButtonClick description]
         */
        scope.addLayerButtonClick = function() {
          scope.selectedLayer.include = true;

          scope.refreshBtnAvailabilty();

          scope.isLayerSelected = scope.checkLayersSelection();
        };
        /**
         * [retriveLayerButtonClick description]
         * @return {[type]} [description]
         */
        scope.retriveLayerButtonClick = function() {
          scope.selectedLayer.include = false;

          scope.refreshBtnAvailabilty();

          scope.isLayerSelected = scope.checkLayersSelection();
        };

        /**
         * [layerListChange description]
         * @return {[type]} [description]
         */
        scope.layerListChange = function() {
          scope.refreshBtnAvailabilty();
        };
        /**
         * [formatListChange description]
         * @return {[type]} [description]
         */
        scope.formatListChange = function() {
          scope.isFormatSelected = scope.selectedFormat != null;
        };

        /**
         * propagate the dropzone when ready
         * we need to broadcast it since this directive declares its own scope
         * @type {number}
         */
        var bubbleDzUp = 0;
        scope.$watch('dropzoneComponent', function(dz) {
          if (angular.isDefined(dz)) {
            if (!bubbleDzUp) {
              $rootScope.$broadcast('importexportwidget_dropzone_ready', {
                dz: dz,
                destftiuid: scope.destftiuid,
              });
              bubbleDzUp = 1;
            }
          }
        });

        /**
         * [clearDropzone description]
         * @return {[type]} [description]
         */
        scope.clearDropzone = function() {
          if (scope.dropzoneComponent.files.length > 0) {
            scope.dropzoneComponent.removeAllFiles();

            scope.selectedImpFeature = null;

            scope.importDestFeature = null;

            scope.impCorrespAttrArray = [];

            scope.importedFeatures = [];

            scope.destinationFeatures = [];

            scope.nbImportedRows = -1;
            if (scope.useSpatialFilter.import || scope.useSpatialFilter.export) {
              gclayers.getDrawLayer().getSource().clear();
            }
            scope.useSpatialFilter = {
              import: false,
              export: false
            };
            scope.importFilters = {
              spatial: '',
              attribute: null
            };
          }
        };

        /**
         * Ouvre l'IHM de choix du format csv en entrée.
         * @returns {undefined}
         *
         */
        var ngDialogPromise;
        scope.columnDelimiter = ',';
        scope.decimalDelimiter = '.';

        function openCsvFormat() {
          ngDialogPromise = ngDialog.openConfirm({
            template:
              'js/XG/widgets/mapapp/importexport/views/csvFormatPrompt.html',
            scope: scope,
            showClose: false,
          });
          ngDialogPromise.then(
            function(data) {
              scope.columnDelimiter = data.charAt(0);
              scope.decimalDelimiter = data.charAt(1);
              ImportExportFactory.loadSchemaCsv(
                scope.uploadProcessID,
                scope.columnDelimiter,
                scope.decimalDelimiter
              ).then(function(importResult) {
                scope.importedFeatures = importResult.data;
                scope.destinationFeatures = [];
                scope.nbImportedRows = -1;
              });
            },
            function() {}
          );
        }

        /**
         * [importFile description]
         * @return {[type]} [description]
         *
         *
         */
        var fileExtension = '';
        scope.importFile = function() {
          if (scope.replaceMode != undefined)
            scope.simpleconf.replaceMode = scope.replaceMode;
          if (scope.dropzoneComponent.files.length > 0) {
            var firstFileName = scope.dropzoneComponent.files[0].name;
            fileExtension = firstFileName.substring(
              firstFileName.lastIndexOf('.') + 1,
              firstFileName.length
            );

            if (fileExtension == 'csv') {
              openCsvFormat();
            } else {
              ImportExportFactory.loadSchema(scope.uploadProcessID).then(
                function(importResult) {
                  console.log(importResult.data);

                  scope.importedFeatures = importResult.data;

                  scope.destinationFeatures = [];

                  scope.nbImportedRows = -1;

                  if (scope.importedFeatures.length == 1) {
                    scope.selectedImpFeature = scope.importedFeatures[0];
                    scope.selectedImpLayerChange();
                  }
                }
              );
            }
          }
        };

        var save_srcsrid;

        /**
         * [selectedImpLayerChange description]
         * @return {[type]} [description]
         */
        scope.selectedImpLayerChange = function() {
          scope.srcsrid = scope.selectedImpFeature.srid;
          save_srcsrid = angular.copy(scope.srcsrid);

          scope.selectImpAttributes = scope.selectedImpFeature.attributes;

          initDestinationFeatures();

          if (scope.impCorrespAttrArray.length != 0)
            scope.impCorrespAttrArray.splice(
              0,
              scope.impCorrespAttrArray.length
            );

          for (var i = 0; i < scope.selectImpAttributes.length; i++) {
            var attribute = scope.selectImpAttributes[i];

            var attribCorresp = {
              source: attribute.name,
              source_type: attribute.type,
              destination: '',
              choices: [],
            };

            scope.impCorrespAttrArray.push(attribCorresp);
          }
          if (scope.simpleconf.destftiuid != undefined)
            scope.destinationLayerChange();
        };

        /**
         *     Appelé une fois que les correpondances automatiques
         *  ont été réalisées afin d'enlever de celles-ci les chamsp
         *  déjà attribués.
         */
        scope.caseSensitiveRefreshAllAttLists = function() {
          for (var i = 0; i < scope.impCorrespAttrArray.length; i++) {
            var attribCorresp = scope.impCorrespAttrArray[i];
            scope.destAttChanged(attribCorresp);
          }
        };

        /**
         *     Appelé quand l'option de sensibilité à la casse a été modifiée.
         *  recherche de correspondance de nom d'attribut.
         */
        scope.caseSensitiveMatchingChanged = function() {
          if (scope.impCorrespAttrArray.length > 0) {
            //-- Pour chaque champ de la source
            for (var i = 0; i < scope.impCorrespAttrArray.length; i++) {
              var attribCorresp = scope.impCorrespAttrArray[i];

              if (attribCorresp.destination != corresp_destination) continue;

              var destValue = false;

              //-- Rechercher un nom de champ correspondant
              for (var j = 1; j < attribCorresp.choices.length; j++) {
                //-- J commence à 1 car l'élement  est "Aucun"
                if (attribCorresp.source === attribCorresp.choices[j].name) {
                  attribCorresp.destination = attribCorresp.choices[j].name;
                  destValue = true;
                  break;
                } else if (!scope.simpleconf.casesensitive) {
                  if (
                    attribCorresp.source.toLowerCase() ===
                    attribCorresp.choices[j].name.toLowerCase()
                  ) {
                    attribCorresp.destination = attribCorresp.choices[j].name;
                    destValue = true;
                    break;
                  }
                }
              }

              if (!destValue) attribCorresp.destination = corresp_destination;

              //-- Sauvegarde de la valeur du champ destination
              //-- pour rendre à nouveau disponible le dit champ
              //-- si une autre affectation est faite sur cette source.
              attribCorresp.prevDest = attribCorresp.destination;
            }
            scope.caseSensitiveRefreshAllAttLists();
          }
        };

        const processAttributes = (isDestinationLayerChange) => {
          let destAttributes = scope.importDestFeature.attributes;
          let choice;

          //-- Pour chaque champ de la source
          for (let i = 0; i < scope.impCorrespAttrArray.length; i++) {
            let attribCorresp = scope.impCorrespAttrArray[i];

            let destValue = false;
            // Déterminez le type du champ source
            const sourceType = attribCorresp.source_type;
            // Filtrer les champs de destination en fonction du type du champ source
            const compatibleTypes = getCompatibleTypes(sourceType);

            //-- Construire la liste des champs disponibles du composant destination
            attribCorresp.choices = [];

            choice = {
              name: corresp_destination,
              alias: corresp_destination,
            };
            attribCorresp.choices.push(choice);

            for (let j = 0; j < destAttributes.length; j++) {
              let destAttribute = destAttributes[j];
              if(compatibleTypes.includes(destAttribute.type)){
                choice = { name: destAttribute.name };
                choice.alias = destAttribute.alias;
                choice.type = destAttribute.type;
                attribCorresp.choices.push(choice);
              }
              if (
                attribCorresp.source === destAttribute.name ||
                attribCorresp.source === destAttribute.name.substr(0, 10)
              ) {
                attribCorresp.destination = destAttribute.name;
                destValue = true;
              } else if (!scope.simpleconf.casesensitive) {
                if (
                  attribCorresp.source.toLowerCase() ===
                  destAttribute.name.toLowerCase()
                ) {
                  attribCorresp.destination = destAttribute.name;
                  destValue = true;
                }
              }
            }
            if(isDestinationLayerChange) {
              if (!destValue) attribCorresp.destination = corresp_destination;
              //-- Sauvegarde de la valeur du champ destination
              //-- pour rendre à nouveau disponible le dit champ
              //-- si une autre affectation est faite sur cette source.
              attribCorresp.prevDest = attribCorresp.destination;
            } else {
              attribCorresp.destination = corresp_destination;
            }
          }
        };

        /**
         * Retourne la liste des types de champs de destination compatibles
         * avec le type de champ source en paramètre.
         * @param {string} sourceType Type du champ source
         * @returns {string[]} Liste des types compatibles
         */
        const getCompatibleTypes = (sourceType) => {
          switch (sourceType) {
            case 'java.lang.String':
              return ['java.lang.String'];
            case 'java.lang.Integer':
              return ['java.lang.Integer', 'java.lang.Double', 'java.lang.String'];
            case 'java.lang.Double':
              return ['java.lang.Double', 'java.lang.String'];
            case 'java.util.Date':
            case 'java.sql.Timestamp':
              return ['java.util.Date', 'java.sql.Timestamp', 'java.lang.String'];
            case 'java.lang.Boolean':
              return ['java.lang.Boolean'];
            default:
              return ['java.lang.String'];
          }
        };
        /**
         * [destinationLayerChange description]
         * @return {[type]} [description]
         */
        scope.destinationLayerChange = function() {
          if (scope.impCorrespAttrArray.length > 0) {
            processAttributes(true);
            scope.caseSensitiveRefreshAllAttLists();
          }
        };

        /**
         *     On cherche la description du champ qui était
         *  choisi avant la nouvelle sélection.
         */
        scope.getAttPreviousChoice = function(impCorrespAttr) {
          var choice = null,
            attribCorresp,
            eq;

          if (impCorrespAttr.prevDest != corresp_destination) {
            for (var i = 0; i < scope.impCorrespAttrArray.length; i++) {
              attribCorresp = scope.impCorrespAttrArray[i];
              eq =
                attribCorresp.source.toString() ==
                impCorrespAttr.source.toString();
              if (eq) {
                for (var j = 0; j < attribCorresp.choices.length; j++) {
                  if (
                    attribCorresp.choices[j].name == impCorrespAttr.prevDest
                  ) {
                    choice = angular.copy(attribCorresp.choices[j]);
                    break;
                  }
                }
                break;
              }
            }
          }

          return choice;
        };

        /**
         *     Appelé quand une valeur est choisie dans la liste des attributs
         *  disponibles pour être mis en correspondance.
         *  Si une valeur est choisie, on l'enlève des autres listes d'attributs
         *  car celui choisi devieNt indisponible.
         *  On ajoute celui qui était précédemment choisie dans les autres listes
         *  d'attributs, car il est désormais disponible.
         */
        scope.destAttChanged = function(impCorrespAttr) {
          var attribCorresp,
            choice = null;
          //-- enlever des valeurs disponibles pour les autres
          //-- correspondances celle qui vient d'être choisie.
          if (impCorrespAttr.destination != corresp_destination)
            for (var i = 0; i < scope.impCorrespAttrArray.length; i++) {
              attribCorresp = scope.impCorrespAttrArray[i];
              if (attribCorresp.source != impCorrespAttr.source) {
                for (var j = 0; j < attribCorresp.choices.length; j++) {
                  if (
                    attribCorresp.choices[j].name == impCorrespAttr.destination
                  ) {
                    attribCorresp.choices.splice(j, 1);
                    break;
                  }
                }
              }
            }

          //-- Remettre en disponible la valeur précédente
          //--  de cette correspondance dans les autres.
          choice = scope.getAttPreviousChoice(impCorrespAttr);
          if (choice != null && choice.name != impCorrespAttr.destination)
            for (let k = 0; k < scope.impCorrespAttrArray.length; k++) {
              attribCorresp = scope.impCorrespAttrArray[k];
              if (
                attribCorresp.source.toString() !=
                impCorrespAttr.source.toString()
              ) {
                let l;
                for (l = 0; l < attribCorresp.choices.length; l++) {
                  if (attribCorresp.choices[l].name == choice.name) break;
                }
                if (l === attribCorresp.choices.length) {
                  attribCorresp.choices.push(choice);
                }
              }
            }

          //-- Sauvegarde de la nouvelle valeur du champ destination
          //-- pour rendre à nouveau disponible le dit champ
          //-- si une autre affectation est faite sur cette source.
          impCorrespAttr.prevDest = impCorrespAttr.destination;
        };

        /**
         * [validateCorrespondence description]
         * @return {[type]} [description]
         */
        scope.validateCorrespondence = function() {
          scope.waitImport = true;

          var sourceFeatureType = scope.selectedImpFeature.name;
          var destFeatureType = scope.importDestFeature.uid;

          var attrCorrespArray = [];

          for (var i = 0; i < scope.impCorrespAttrArray.length; i++) {
            var attrCorresp = scope.impCorrespAttrArray[i];

            var correspObj = {
              source: attrCorresp.source,
              destination: attrCorresp.destination,
            };

            attrCorrespArray.push(correspObj);
          }

          // @RB 10/2016 force srid if it was set in parent scope
          // if not, use the saved version extracted during importFile
          scope.save_srcsrid = save_srcsrid;
          if (
            angular.isDefined(scope.forceIEWSrcSrid) &&
            angular.isDefined(scope.forceIEWSrcSrid.name) &&
            scope.forceIEWSrcSrid.name.indexOf('EPSG:') == 0
          ) {
            scope.srcsrid = scope.forceIEWSrcSrid.name;
          }

          var strAttrCorrespArray = JSON.stringify(attrCorrespArray);

          if (fileExtension == 'csv') {
            ImportExportFactory.loaddataCsv(
              scope.uploadProcessID,
              sourceFeatureType,
              destFeatureType,
              strAttrCorrespArray
            ).then(onLoadDataResult);
          } else {

            // construit la clause à partir du filtre attributaire et du polygone dessiné
            let cqlFilter = buildSpatialAndAttributeFilter();

            if (scope.simpleconf.replaceMode === true) {
              //-- Si mode replace, on supprimele contenu du feature type avant de faire l import.
              EditFactory.deleteWhere(destFeatureType, '1=1').then(
                () => {
                  loadData(sourceFeatureType, destFeatureType, strAttrCorrespArray, cqlFilter);
                },
                (error) => {
                  gcRestrictionProvider.showDetailsErrorMessage(error);
                }
              );
            } else {
              loadData(sourceFeatureType, destFeatureType, strAttrCorrespArray, cqlFilter);
            }
          }
        };

        /**
         * Importe les entités du fichier shape. Méthode de formatage
         * pour éviter la duplication de code.
         * @param {object} sourceFeatureType fti source
         * @param {object} destFeatureType fti de destination
         * @param {string[]} strAttrCorrespArray table de mappage entre attributs
         * @param {string} cqlFilter clause where pour filtrer l'import des entités
         */
        const loadData = (sourceFeatureType, destFeatureType, strAttrCorrespArray, cqlFilter) => {
          // isUsingProgress est true pour masquer des messages inutiles en cours d'import
          ImportExportFactory.loaddata(
            scope.uploadProcessID,
            sourceFeatureType,
            destFeatureType,
            strAttrCorrespArray,
            scope.srcsrid,
            cqlFilter,
            scope.useCancelReplace,
            scope.useDifferencial,
            scope.applyRules,
            scope.useGPSImport,
            scope.conf.srcTableId,
            scope.conf.dstTableId,
            scope.conf.gpsfieldname,
            scope.conf.gpsnewrow,
            scope.conf.gpsupdatedrow,
            undefined,
            undefined,
            undefined,
            true,
            undefined,
            undefined,
            undefined
          ).then(onLoadDataResult);
        };

        var onLoadDataResult = function(loadResult) {
          scope.nbImportedRows = loadResult.data;
          $rootScope.$broadcast('importexportwidget_importdone', {
            nbImportedRows: scope.nbImportedRows,
          });
          // recherche le rang d'un fti en se basant sur l'uid
          const idxImpFti = scope.importedFeatures.findIndex(
            fti => fti.uid === scope.selectedImpFeature.uid);
          if (idxImpFti > -1) {
            scope.importedFeatures.splice(idxImpFti, 1);

            scope.selectedImpFeature = null;

            scope.importDestFeature = null;

            scope.impCorrespAttrArray = [];

            scope.destinationFeatures = [];

            if (scope.importedFeatures.length == 0) {
              scope.dropzoneComponent.removeAllFiles();
            }
          }
          scope.waitImport = false;
          scope.useSpatialFilter.import = false;
          scope.importFilters = {
            spatial: '',
            attribute: null
          };
        };
        /**
         * [unselectCorrespondence description]
         * @return {[type]} [description]
         */
        scope.unselectCorrespondence = function() {
          // KIS-3682: On reformule la liste avec tous les attributs
          // mais sans faire de correspondance
          if (scope.impCorrespAttrArray.length > 0) {
            processAttributes(false);
          }
        };

        /**
         * [cancelCorrespondence description]
         * @return {[type]} [description]
         */
        scope.cancelCorrespondence = function() {
          scope.selectedImpFeature = null;

          scope.importDestFeature = null;

          scope.impCorrespAttrArray = [];

          scope.importedFeatures = [];

          scope.destinationFeatures = [];

          scope.nbImportedRows = -1;

          if (scope.useSpatialFilter.import) {
            gclayers.getDrawLayer().getSource().clear();
          }
          scope.importFilters.attribute = null;
          scope.useSpatialFilter = {
            import: false,
            export: false
          };
        };

        /**
         * Exporte dans un thread séparé les couches dans le format défini (selectedFormat)
         * et dans une projection définie si le format le requiert
         * (geographicFormat.currentsridName | specialcsv.currentsridName)
         * @return {Promise}
         */
        scope.exportLayers = () => {

          // on vérifie la présence d'un SRID (il doit avoir été selectionné
          // parmi les options proposées)
          const csvSridNotDefinedOrEmpty = (scope.selectedFormat === 'CSV'
                  && scope.specialcsv.geometrie !== 'ne pas exporter la géométrie')
              && !scope.srids.includes(scope.specialcsv.currentsridName);

          const formatRequireSrid = scope.selectedFormat === 'GML' || scope.selectedFormat
              === 'SHAPEFILE' || scope.selectedFormat === 'MapInfo File' || scope.selectedFormat
              === 'GPS' || scope.selectedFormat === 'DXF';

          const sridNotDefinedOrEmpty = !scope.srids.includes(
            scope.geographicFormat.currentsridName);

          // si aucun SRID sélectionné alors on affiche un warning et on ne poursuit pas l'export
          if (csvSridNotDefinedOrEmpty || (sridNotDefinedOrEmpty && formatRequireSrid)) {
            require('toastr').warning($filter('translate')('importexportwidget.noSridSelected'));
            return;
          }

          scope.waitExport = true;

          scope.layersToExport = retriveLayersToExport(scope.featureTypes);

          scope.attributesToExport = retriveAttributesToExport(
            scope.featureTypes
          );

          scope.strAttributesToExport = JSON.stringify(
            scope.attributesToExport
          );

          var cqlFilter = scope.cqlExportFilterQuery;

          if (!scope.useSpatialFilter.export) {
            cqlFilter = '';
          }

          // récupère le type de géométrie si CSV, sinon special = ''
          const special = getSpecialCsv();

          // encodage de texte et séparateur de champ CSV définis
          // dans les paramètres régionaux du portail
          const {encoding, separator}
            = RegionalFactory.getPortalRegionalData($rootScope.xgos.portal);

          gaDomUtils.showGlobalLoader();
          let deferred = $q.defer();
          ImportExportFactory.exportLayersFeatures(
            scope.selectedFormat,
            scope.geographicFormat.currentsridName,
            scope.layersToExport,
            scope.strAttributesToExport,
            cqlFilter,
            special,
            scope.map.getView().getProjection().getCode(),
            encoding,
            separator,
            scope.exportData.gpkgFilename
          ).then(res => {
            if (res.data.etat !== 'RUNNING' && res.data.etat !== 'FINISHED') {
              scope.conversionIsRunning = false;
            } else {
              scope.checkProcessInProgress(res.data, undefined, false, deferred);
            }
          },
          // err
          () => {
            gaDomUtils.hideGlobalLoader();
            require('toastr').error(
              $filter('translate')('importexportwidget.attachments.network_error')
            );

            scope.waitExport = false;
          }
          );
          return deferred.promise;
        };

        scope.configImportExportWidget = function() {
          console.log('Ok');

          ConfigFactory.get('IMPEXP', 'mainConfig').then(function(res) {
            console.log(res);

            var data = res.data;
            scope.conf.showDifferencial = data.showDifferencial;
            scope.conf.showCancelReplace = data.showCancelReplace;

            ngDialog.open({
              template:
                'js/XG/widgets/mapapp/importexport/views/importExportWidgetConfig.html',
              className: 'ngdialog-theme-plain width800 nopadding miniclose',
              closeByDocument: false,
              scope: scope,
            });
          });
        };

        const isEmpty = (value) => value === undefined || value.trim() === '';
        scope.saveImportExportConfig = function() {
          if(scope.conf.showGPSImport &&
              (isEmpty(scope.conf.gpsfieldname)  ||
               isEmpty(scope.conf.gpsnewrow) ||
               isEmpty(scope.conf.gpsupdatedrow)
              )
          ){
            require('toastr').warning($filter('translate')('importexportwidget.config.warningGpsimport'));
            return;
          }
          if(scope.conf.showDifferencial &&
              (isEmpty(scope.conf.dstTableId) ||
               isEmpty(scope.conf.srcTableId)
              )
          ){
            require('toastr').warning($filter('translate')('importexportwidget.config.warningDifferencialimport'));
            return;
          }
          ConfigFactory.add(scope.conf, 'IMPEXP', 'mainConfig').then(function(
            res
          ) {
            if ((typeof res.data === 'boolean' && res.data) || res.data === 'true') {
              require('toastr').success($filter('translate')('importexportwidget.config.SaveSuccessMsg'));
            } else {
              require('toastr').error($filter('translate')('importexportwidget.config.SaveErrorMsg'));
            }
            ngDialog.close();
          });
        };

        scope.filterChboxChange = function(value) {
          if (value == false) {
            gclayers
              .getDrawLayer()
              .getSource()
              .clear();
            var btnElt = $('#exp_cql_spatial_filter_comp');
            btnElt.find('button').each(function() {
              if ($(this).hasClass('btn-info')) {
                $(this).removeClass('btn-info');
                $(this).addClass('btn-default');
              }
            });
            scope.isActive = false;
            scope.map.getInteractions().forEach(function(interaction) {
              if (interaction.T === 'Polygon')
                scope.map.removeInteraction(interaction);
            });
          }
        };

        scope.useCancelReplaceChboxChange = function(value) {
          if (value == true) {
            scope.useDifferencial = false;
            scope.useGPSImport = false;
          }
        };

        scope.useDifferencialChboxChange = function(value) {
          if (value == true) {
            alert($filter('translate')('importexportwidget.extraDiffrencialConfirm'));
            scope.useCancelReplace = false;
            scope.useGPSImport = false;
          }
        };

        scope.useGPSImportChboxChange = function(value) {
          if (value == true) {
            scope.useCancelReplace = false;
            scope.useDifferencial = false;
          }
        };

        scope.selectOrDeselectAllAttributes = function(value) {
          if (!scope.selectedAttributes) {
            scope.selectedLayer = findLayerByName(
              scope.selectedLayerName,
              scope.featureTypes
            );

            if (scope.selectedLayer != null) {
              scope.selectedAttributes = scope.selectedLayer.attributes;
            }
          }

          for (var i = 0; i < scope.selectedAttributes.length; i++)
            scope.selectedAttributes[i].include = value;
        };

        scope.propertiestoexclude = {};
        scope.getReturnedTemplate = function(data) {
          if (data) {
            scope.attributesToExport.map(function(x) {
              if (x && x.uid === scope.layersToExport && x.mapping)
                x.mapping.map(function(y) {
                  if (y) {
                    data.savedata.map(function(k) {
                      if (k && k.uid === scope.layersToExport && k.mapping)
                        k.mapping.map(function(z) {
                          if (y.name === z.name) Object.assign(y, z);
                        });
                    });
                  }
                });
            });
          }
        };
        scope.mappingExportLayers = function() {
          scope.layersToExport = retriveLayersToExport(scope.featureTypes);

          scope.attributesToExport = retriveAttributesToExport(
            scope.featureTypes
          );

          scope.strAttributesToExport = JSON.stringify(
            scope.attributesToExport
          );

          var cqlFilter = scope.cqlExportFilterQuery;

          if (!scope.useExportSpatialFilter) {
            cqlFilter = '';
          }

          if (scope.layersToExport) {
            scope.ConfigNameExport =
              'config_export_mapping_' + scope.layersToExport;
          } else {
            scope.ConfigNameExport = 'config_export_mapping';
          }

          var dial = ngDialog.openConfirm({
            template:
              'js/XG/widgets/mapapp/importexport/views/importExportWidgetAdvanced.html',
            className: 'ngdialog-theme-plain width800 nopadding miniclose',
            closeByDocument: false,
            scope: scope,
          });
          dial.then(function(data) {
            scope.waitExport = true;
            const useddata = JSON.stringify(data);

            // récupère le type de géométrie si CSV, sinon special = ''
            const special = getSpecialCsv();

            ImportExportFactory.exportLayersFeatures(
              scope.selectedFormat,
              scope.geographicFormat.currentsridName,
              scope.layersToExport,
              useddata,
              cqlFilter,
              special,
              scope.map.getView().getProjection().getCode()
            ).then(
              (res) => {
                if (res.data.etat !== 'RUNNING' && res.data.etat !== 'FINISHED') {
                  scope.conversionIsRunning = false;
                } else {
                  scope.checkProcessInProgress(res.data, undefined, true);
                }
              },
              // err
              (error) => {
                console.log(error);
                scope.waitExport = false;
              }
            );
          });
        };

        function checkAttachments(processId) {
          return ImportExportFactory.checkExportStatus(processId)
            .then(res => {
              const data = res.data;
              scope.checkExportStatus = data;

              switch(data.attachmentsReady){
                case 'true':
                  openAttachmentsDialog();
                  break;
                case 'false':
                  setTimeout(() => checkAttachments(processId), 3000)
                  break;
                case 'N/A':
                  gaDomUtils.hideGlobalLoader();
              }

              return data;
            })
            .catch(res => {
              gaDomUtils.hideGlobalLoader();
              require('toastr').error(
                $filter('translate')('importexportwidget.attachments.network_error')
              );

              scope.waitExport = false;
            });
        }

        const openAttachmentsDialog = () => {
          gaDomUtils.hideGlobalLoader();

          ngDialog.openConfirm({
            template:
                'js/XG/widgets/mapapp/importexport/views/exportWidgetAttachmentTable.html',
            className: 'ngdialog-theme-plain width800 nopadding miniclose',
            closeByDocument: false,
            scope: scope,
          });
        };

        scope.downloadAttachment = (attachmentId) => {
          const downloadurl =
              '/services/' +
              localStorage.portal +
              '/export/downloadexportedfile?f=json' +
              '&exportedFileId=' +
              attachmentId;

          window.open(downloadurl);
        };

        scope.emptyAnalysisTools = function(attributesToExport) {
          if (attributesToExport && attributesToExport.length > 0) {
            attributesToExport.map(function(x) {
              if (x && x.mapping && x.mapping.length > 0) {
                x.mapping.map(function(mapi) {
                  if (mapi && mapi.mapping) mapi.mapping = undefined;
                });
              }
            });
            require('toastr').info(
              $filter('translate')('importexportwidget.mapping.initconfi')
            );
          }
        };

        scope.filterFunc = gaJsUtils.filterFunc;
        scope.checkMapping = function(attribute) {
          attribute.mapping =
            (scope.selectedFormat === 'SHAPEFILE' ||
              scope.selectedFormat === 'GPS') &&
            attribute.mapping &&
            attribute.mapping.length > 10
              ? attribute.mapping.substring(0, 10)
              : attribute.mapping;
        };

        scope.specialcsv = {
          geometrie: $filter('translate')(
            'importexportwidget.specialcsv.nothing'
          ),
          currentsridName: scope.map.getView().getProjection().getCode(),
        };
        scope.csvoptions = [
          $filter('translate')('importexportwidget.specialcsv.nothing'),
          'XY',
          'WKT',
        ];

        // conteneur de l'intervale de répétition de l'appel api
        let stop;

        /**
         * Appel Api à intervale régulier pour évaluer l'état du processus d'export
         * @param process processus de l'appel api précédent
         * @param intervalMsec intervale entre 2 appels api en msec
         * @param withCorrespondance est true si l'utilisateur a cliqué
         * sur "export avec correspondance".
         * Est false si l'utilisateur a cliqué sur "valider"
         * @param deffered objet permettant de retourner une promise
         * @see ImportExportFactory.getProgressionExport
         */
        scope.checkProcessInProgress = (process, intervalMsec, withCorrespondance, deffered) => {
          if (intervalMsec === undefined){
            intervalMsec = 750;
          }
          scope.intervalCounter = 0;

          // les dates sont gérées comme dans tout processus (cf. edigeo, itv...)
          // mais non utilisées dans le cas présent
          if (process.creation){
            process.creation = $filter('date')(new Date(process.creation), 'dd MMM yyyy HH:MM');
          }

          // fonction contenant un appel api (getProgressionExport)
          // qui est exécutée à intervale régulier (intervalMsec)
          stop = $interval(function () {
            if (process.creation){
              process.creation = new Date(process.creation).getTime();
            }
            if (process.end){
              process.end = new Date(process.end).getTime();
            }
            ImportExportFactory.getProgressionExport(process).then(
              (res) => {
                if (res.data.etat === 'FINISHED') {

                  // stoppe la répétition des appels api
                  $interval.cancel(stop);

                  // affiche l'alerte taustr succès/erreur
                  scope.getResponseFile(res.data);

                  if (withCorrespondance){
                    // récupère le nom du fichier à télécharger
                    // dans la propriété "extraInfo" du processus renvoyé
                    const resultFileName = res.data.extraInfo;
                    const portalid = PortalsFactory.getPortalId();

                    const downloadurl =
                          '/services/' + portalid + '/export/downloadexportedfile?f=json' +
                          '&exportedFileId=' +
                          resultFileName;

                    window.open(downloadurl);
                    scope.waitExport = false;

                    // masque le spinner
                  }else{
                    const processId = res.data.extraInfo;

                    checkAttachments(processId)
                      .then(data => {
                        // Start download of the exported file
                        scope.downloadAttachment(data.export.id);
                        scope.waitExport = false;
                      });
                  }
                } else if (scope.loadingLaunched && res.data.etat === 'FAILED') {
                  // affiche l'alerte taustr, stoppe la répétition
                  // de l'appel api et masque le spinner
                  exportFileFailed(stop);
                } else {

                  //-- Toujours en train de tourner
                  if (scope.intervalCounter > 100 && intervalMsec < 90000) {

                    //-- Au plus c'est long, au moins on va interroger
                    //-- le serveur fréquemment sur l'état d'avancement.
                    $interval.cancel(stop);
                    scope.checkProcessProgression(process, 2 * intervalMsec,
                      withCorrespondance, deffered);
                    scope.intervalCounter = 0;
                  }
                }
              },
              () => {
                if (scope.loadingLaunched) {
                  gaDomUtils.removeLocalLoader('.' + scope.widgetName);
                  $interval.cancel(stop);
                  require('toastr').error(
                    $filter('translate')('tools.majicedigeo.edigeo.loadfailed')
                  );
                  scope.conversionIsRunning = false;
                }
              }
            );
          }, intervalMsec);
        };

        /**
         * Affiche une alerte en cas de succès ou d'erreur de l'export
         * lorsque l'état du processus renvoyé du back est 'FINISHED' ou 'FAILED'
         * @param process processus d'export recupéré du back par checkProcessInProgress
         * @see checkProcessInProgress
         */
        scope.getResponseFile = (process) => {
          switch (process.etat) {
            case 'FINISHED':
              require('toastr').success('Export terminé avec succés');
              break;
            case 'FAILED':
              require('toastr').error(process.reason);
              break;
          }
        };

        /**
         * Lorsque le processus a un état 'FAILED'
         * Stoppe la répétition de l'appel api (ImportExportFactory.getProgressionExport)
         * Affiche une alerte d'erreur
         * Masque le spinner
         * @param repeat fonction $interval dont l'exécution est répétée à intervale régulier
         * @see checkProcessInProgress
         */
        function exportFileFailed(repeat) {
          $interval.cancel(repeat);
          require('toastr').error(
            $filter('translate')('tools.majicedigeo.edigeo.loadfailed')
          );
          scope.conversionIsRunning = false;
          scope.waitExport = false;
        }

        /**
         * Au clic sur la checkbox "Exporter des composants non-géographiques"
         * de l'onglet "Export"<ul><li>
         * Vide le tableau des composants</li><li>
         * Enlève l'éventuel composant sélectionné de l'autocomplete</li><li>
         * Vide la liste des attributs cochés/décochés
         * du composant sélectionné</li><li>
         * Vide la liste des attributs sélectionnés</li><li>
         * Lance l'initialisation du tableau des composants</li></ul>
         */
        scope.onExportTablesChange = () => {

          // le tableau de destination doit être vidé après chaque modification de exportTablesOnly
          // et avant chaque initialisation de la liste de l'autocomplete
          if (scope.featureTypes.length > 0) {
            scope.featureTypes.splice(0,scope.featureTypes.length);
          }
          // vide la liste des attributs cochés/décochés
          scope.selectedAttributes = [];
          // vide l'autocomplete
          scope.selectedLayerName = null;

          // quand on coche "Exporter des composants non-géographiques"
          if (scope.exportTablesOnly) {

            // le format CSV est automatiquement sélectionné
            scope.selectedFormat =  'CSV';
            scope.isFormatSelected = true;
          }

          // lance l'initialisation de la liste des composants/tables de l'autocomplete
          scope.initfeatureTypesArray(!scope.exportTablesOnly);
        };

        scope.useSpatialFilter = {
          import: false,
          export: false
        };

        /**
         * Lors de l'import d'un fichier,
         * au clic sur le bouton "Valider" dans le schéma des correspondances des attributs.<br>
         * Effectue un appel API pour compter le nombre de features contenues dans le fichier à importer
         * puis ouvre une popup pour que l'utilisateur confirme/annule l'import des entités.
         */
        scope.askToConfirmImport = () => {
          /**
           * KIS-3616: Contrôler l'existence des champs de jointure
           * On verifie que le champ srcId existe dans le Shapefile
           * et que le champ destId existe dans le composant
           */
          const srcIdInLayer  = scope.selectedImpFeature.attributes.some(
            (att) => att.name === scope.conf.srcTableId);
          const destIdInFeature = scope.importDestFeature.attributes.some(
            (att) => att.name === scope.conf.dstTableId);
          //Afficher le warning selon l'attribut manquant et on ne poursuit pas l'import
          // Les attributs ne sont vérifiés que lorsque les deux cases à cocher (interface et configuration) sont activées.
          if(scope.useDifferencial && scope.conf.showDifferencial){
            if(!srcIdInLayer && !destIdInFeature){
              const warningMsg = $filter('translate')('importexportwidget.srcDestIdsWarning').
                replace('$1',scope.conf.srcTableId).
                replace('$2',scope.conf.dstTableId);
              require('toastr').warning(warningMsg);
              return;
            } else if(!srcIdInLayer){
              require('toastr').warning($filter('translate')('importexportwidget.srcIdWarning').replace(
                '$1',scope.conf.srcTableId));
              return;
            }else if(!destIdInFeature) {
              require('toastr').warning($filter('translate')('importexportwidget.destIdWarning').replace(
                '$1',scope.conf.dstTableId));
              return;
            }
          }
          //Former la liste des correspondances
          var attrCorrespArray = [];

          for (var i = 0; i < scope.impCorrespAttrArray.length; i++) {
            var attrCorresp = scope.impCorrespAttrArray[i];

            var correspObj = {
              source: attrCorresp.source,
              destination: attrCorresp.destination,
            };

            attrCorrespArray.push(correspObj);
          }
          var strAttrCorrespArray = JSON.stringify(attrCorrespArray);

          const cqlFilter = buildSpatialAndAttributeFilter();
          ImportExportFactory.countFeaturesFromFile(scope.uploadProcessID, scope.selectedImpFeature.name, cqlFilter).then(
            (res) => {
              if (Number.isInteger(res.data)) {
                scope.toImportFeaturesCount = res.data;
                //KIS-3827: Ajouter une étape de vérification des mappings dans le processus d'import
                ImportExportFactory.checkMapping(
                    scope.uploadProcessID,
                    scope.importDestFeature.uid,
                    strAttrCorrespArray,
                    scope.impCorrespAttrArray).then(
                   (res)=> {
                     if(res.data.length === 1){
                        // Une seule variable
                        scope.messageToShow = $filter('translate')('importexportwidget.confirmImport.single', { 
                            attr: res.data[0] 
                        });
                      } else if(res.data.length > 1){
                        // Plusieurs variables : on joint les noms avec des virgules
                        scope.messageToShow = $filter('translate')('importexportwidget.confirmImport.multiple', { 
                            attrs: res.data.join(', ') 
                        });
                      }
                    }
                );
                ngDialog.open({
                  template:
                        'js/XG/widgets/mapapp/importexport/views/modals/modal.import.confirmation.html',
                  className: 'ngdialog-theme-plain miniclose nopadding width600',
                  closeByDocument: false,
                  scope: scope,
                });
              }
            },
            (err) => {
              if (err.data) {
                if (err.data.details && Array.isArray(err.data.details) && err.data.details.length > 0) {
                  console.error(err.data.details.shift());
                }
                if (err.data.message) {
                  require('toastr').error($filter('translate')(err.data.message));
                }
              }
            }
          );
        };

        /**
         * Construit le filtre cql pour requêter le fichier à importer
         * @return {string} clause where contenant le filtre spatial et le filtre attributaire associés avec un opérateur "AND"
         */
        const buildSpatialAndAttributeFilter = () => {
          let cqlFilter = scope.importFilters.spatial;
          console.log(scope.importFilters.spatial);

          const hasAttributeFilter = 'useDataFilter' in scope
              && typeof scope.useDataFilter === 'boolean'
              && scope.useDataFilter === true
              && typeof scope.importFilters.attribute === 'string'
              && scope.importFilters.attribute.length > 0;

          if (!scope.useSpatialFilter.import) {
            cqlFilter = '';
          }

          if (hasAttributeFilter) {
            cqlFilter = scope.importFilters.attribute;
            if (scope.useSpatialFilter.import && scope.importFilters.spatial && scope.importFilters.spatial.length > 0) {
              cqlFilter += ' AND ' + scope.importFilters.spatial;
            }
          }
          return cqlFilter;
        };

        /**
         * Après un 1er import réussi,  au second dépôt de fichiers dans la dropzone,
         * masque le texte "N entités importées" affiché en vert
         */
        scope.cleanLastImport = () => {
          scope.nbImportedRows = -1;
          // Nettoie la console après log inutile de la dropzone au dépôt de fichiers
          console.clear();
        };

        /**
         * Défini le type de géométrie d'un export csv
         * Affecte la variable de l'input du srid du csv à la variable du srid de destination
         * @return {string} type de géométrie si export csv, sinon ''
         */
        const getSpecialCsv = () => {
          let specialcsv = '';
          if (scope.selectedFormat === 'CSV' && scope.specialcsv && scope.specialcsv.geometrie) {
            specialcsv =
                scope.specialcsv.geometrie ===
                $filter('translate')('importexportwidget.specialcsv.nothing') ? '' : scope.specialcsv.geometrie;
            if (scope.specialcsv.currentsridName) {
              scope.currentsridName = scope.specialcsv.currentsridName;
            }
          }
          return specialcsv;
        };

        /**
         * Détermine si des attributs de type attachment(s) ont été sélectionnés pour l'export
         * Cette méthode est utilisée pour afficher ou masquer un bloc du template concernant les pièces jointes
         * @returns {boolean} Vrai si des attributs de type pièce jointe sont sélectionnés et si le format d'export est compatible
         */
        scope.hasSelectedAttachmentAttributes = () => {
          const attachmentTypes = ['g2c.attachment', 'g2c.attachments'];
          const isValidFormat = ['CSV', 'SHAPEFILE', 'GPKG'].includes(
            scope.selectedFormat);

          if (!isValidFormat || !Array.isArray(scope.featureTypes)) {
            return false;
          }

          return scope.featureTypes.some(
            ft => ft.include && Array.isArray(ft.attributes)
                  && ft.attributes.some(attr => attachmentTypes.includes(attr.type)));
        };
      },
    };
  };

  importexportwidget.$inject = [
    'ConfigFactory',
    'ImportExportFactory',
    'FeatureTypeFactory',
    'EditFactory',
    '$translate',
    'ngDialog',
    'gclayers',
    'SridFactory',
    '$rootScope',
    'ParametersFactory',
    'gcRestrictionProvider',
    'gaJsUtils',
    'gaDomUtils',
    '$filter',
    '$interval',
    '$q',
    'PortalsFactory',
    'RightsFactory',
    'RegionalFactory'
  ];

  return importexportwidget;
});
