/** @module layerManager */
'use strict';
define(function() {
  var templatebasewidget = function(
    $rootScope,
    gcWFS,
    gclayers,
    gcPopup,
    ConfigFactory,
    extendedNgDialog,
    EditFactory,
    $filter,
    SelectManager,
    QueryFactory,
    gaDomUtils,
    ActionsManager,
    ngDialog,
    gaJsUtils,
    ApplicationFactory,
    $timeout,
    RolesFactory,
    $window,
    legendService,
    FeatureTypeFactory,
    PortalsFactory,
    layersService
  ) {
    return {
      /** @property {String} templateUrl Url of the directive UI */
      templateUrl:
        'js/XG/widgets/mapapp/layerManager/views/layerManagerwidget.html',
      /** @type {String} [description] */
      restrict: 'A',

      /**
       * link
       *
       * @param scope
       * @param element
       * @param attrs
       * @param ctrl
       */
      link: function(scope, element, attrs) {
        scope.configf = {
          view: {
            FDP: true,
            Technic: true,
            ModelMap: true,
          },
        };
        scope.hasStyleManager = () => {
          return ($rootScope.xgos.isroot || $rootScope.xgos.isadmin ||
                  $rootScope.xgos.user.roles.findIndex(
                    (role)=> role.name === 'StyleManager') !== -1);
        };
        scope.openConfig = function() {
          scope.getConfig();
          ngDialog.openConfirm({
            template:
              'js/XG/widgets/mapapp/layerManager/views/modal/configuration.html',
            className:
              'ngdialog-theme-plain overflowY width800 nopadding miniclose',
            closeByDocument: false,
            scope: scope,
            draggable: {
              title: 'Configuration',
            },
          });
        };

        scope.getConfig = function() {
          ConfigFactory.get('widgets', scope.ConfigName)
            .then((res) => {
              if (
                res.data !== undefined &&
                res.data !== '' &&
                res.status == 200
              ) {
                scope.configf = res.data;

                // affichage des représentations par défaut des couches
                if (scope.configf.hasOwnProperty('iconMode') && scope.configf.iconMode) {

                  // indique l'activation de la fonctionnalité d'affichage de l'image du style des couches
                  scope.iconMode = true;

                  // exécute l'affichage de l'image du style des couches
                  showLayersIcon(5);
                }

                if (
                  scope.configf
                  && scope.configf.view
                  && scope.configf.view.legendactive
                ) {
                  scope.globalLegendPopup();
                }
              }
              console.info('Configuration de layermanagerwidget chargée : ', scope.configf);
            },
            (reason) => {
              console.error('Configuration de bizeditwidget non chargée: '
                      + reason);
            })
            .catch(err => {
              err.stack;
            });
        };
        scope.getConfig();
        scope.addConfig = () => {

          // affichage des représentations par défaut des couches
          if (scope.configf.iconMode && !scope.iconMode) {
            scope.iconMode = true;
            showLayersIcon(5);
          }
          // masque les représentations par défaut des couches
          if (!scope.configf.iconMode && scope.iconMode) {
            scope.iconMode = false;
            hideLayersIcon();
          }

          ConfigFactory.add(scope.configf, 'widgets',
            scope.ConfigName);
        };
        scope.models = {
          selected : null,
          lists : {
            A : [ {
              label : 'Item A1',
            }, {
              label : 'Item A2',
            }, {
              label : 'Item A3',
            }, ],
            B : [ {
              label : 'Item B1',
            }, {
              label : 'Item B2',
            }, {
              label : 'Item B3',
            }, ],
          },
        };


        // Model to JSON for demo purpose
        scope.$watch(
          'models',
          function(model) {
            scope.modelAsJson = angular.toJson(model, true);
          },
          true
        );

        // @RB : allow to display a reduce button (used in siroco) only
        // if reduce is an attribute of the directive
        // ex : <div layermanagerwidget id="siroco_layermanager"
        // reduce></div>
        if (Object.prototype.hasOwnProperty.call(attrs, 'reduce')) {
          scope.layerManagerIsReduced = false;
          scope.showReduceButton = true;
          scope.$watch(
            'tabs.activeTab',
            function() {
              scope.layerManagerIsReduced = false;
            },
            1
          );
        }

        var map = scope.map;
        scope.legendurl =
          '/services/' +
          PortalsFactory.getPortalId() +
          '/geoserver/ows?service=WMS&REQUEST=GetLegendGraphic&VERSION=1.0.0&FORMAT=image/png&WIDTH=20&HEIGHT=20&LAYER=';
        // The ngRepeat collection is the map's array of layers.
        // ngRepeat
        // uses $watchCollection internally. $watchCollection watches
        // the
        // array, but does not shallow watch the array items! The array
        // items are OpenLayers layers, we don't want Angular to shallow
        // watch them.
        scope.tabs = [
          {
            title: 'layermanager.theme',
          },
          {
            title: 'layermanager.affichage',
          },
          {
            title: 'layermanager.mapconfig',
          },
        ];



        scope.currentuser = $rootScope.xgos.user;
        scope.tabs.activeTab = 0;
        scope.wheretab;
        scope.filtertemp = {
          filter: '',
        };
        scope.expression = {
          filter: '',
        };
        // console.clear();
        scope.grouplayers = gclayers.getGroupLayer();
        scope.hiddenPanels = {};
        scope.allPanelHidden = false;
        scope.allLayersVisible = false;
        scope.allLayersSelectable = false;
        scope.hideAllPanels = function() {
          for (var title in scope.grouplayers) {
            scope.hiddenPanels[title] = true;
            scope.allPanelHidden = true;
          }
        };
        // fermer tous les groupes de thèmes
        scope.hideAllPanels();
        scope.showAllPanels = function() {
          scope.hiddenPanels = {};
          scope.allPanelHidden = false;
        };


        scope.grouplayersarray = [];
        let grouplayerstoAry = () => {
          scope.grouplayersarray = [];
          angular.forEach(scope.grouplayers, function (val, key) {
            scope.grouplayersarray.push({title: key, lay: val});
          });
        };

        /**
         * Dans le cas de KIS-INDIGAU, gclayers.layersGroupedByStore
         * n'est pas prêt à l'instanciation du widget. On attend donc
         * que "gclayers.layersGroupedByStore soit prêt pour ce cas."
         */
        let initLg = () => {
          if (gclayers.layersGroupedByStore && Object.keys(scope.grouplayers).length!=0) {
            console.log('initLg -> exec');
            scope.layerGroups = gclayers.layersGroupedByStore.layerGroups;
            scope.lg4ui = gclayers.layersGroupedByStore.layerGroups4ui;
            grouplayerstoAry();
          }
          else {
            if (Object.keys(scope.grouplayers).length==0) {
              scope.grouplayers = gclayers.getGroupLayer();
            }
            $timeout(initLg, 250);
          }
          var appname = gaJsUtils.getAppName();
          ApplicationFactory.getbyname(appname).then((res) => {
            scope.isFeatureTypesFiltered = res.data
            && res.data.filterLayers && res.data.filterLayers.useFilter;
          });
        };
        initLg();


        scope.OpenDataTabale = function(layer) {
          $rootScope.panelsManager.removePanel('donnees');
          const login = $rootScope.xgos.user.login;

          // gestion de l'activation du bouton d'édition de la datatable (basé sur editFtiGranted)
          // editFtiGranted est true si l'utilisateur est root ou bien si le fti est contenu
          // dans les autorisations d'un de ses rôles
          RolesFactory.getRolesByUser(login).then(
            (res) => {
              const panelScope = $rootScope.$new();
              panelScope.map = scope.map;
              panelScope.roles = res.data;
              panelScope.coordsshow = true;
              panelScope.layer = layer;
              panelScope.currlayer = layer;
              panelScope.currentfti = layer.get('fti');
              panelScope.ftiuid = panelScope.currentfti.uid;
              panelScope.wheretab = '1=1';
              panelScope.currentselectedActionOnComponentTable = {
                value: {},
              };              // the default height of the datatable
              panelScope.layerdatatable = {};
              panelScope.layerdatatable.height = 320;
              panelScope.filtertemp = scope.filtertemp;
              $rootScope.panelsManager.addPanel({
                id: 'donnees',
                stickToRight: true,
                templateUrl:
                      'js/XG/widgets/mapapp/layerManager/views/popoverDatatable.html',
                scope: panelScope,
                stickToBorder: true,
                visible: true,
                resizable: true,
              });
            },
            ()=>{
              require('toastr').error(
                $filter('translate')('rights.roles.retrieve_error')
              );
            }
          );
        };

        scope.config = {
          fullfilter: '',
        };

        scope.zoomOndata = function() {
          gaDomUtils.showGlobalLoader();
          SelectManager.clear();
          QueryFactory.data(
            scope.currlayer.fti.uid,
            scope.config.fullfilter,
            scope.map
              .getView()
              .getProjection()
              .getCode(),
            '',
            '',
            ''
          ).then(
            function(res) {
              gaDomUtils.hideGlobalLoader();
              SelectManager.addFeaturesFromGeojson(res.data);
              scope.map
                .getView()
                .fit(SelectManager.getExtent(), scope.map.getSize());
            },
            function() {
              gaDomUtils.hideGlobalLoader();
            }
          );
        };

        $rootScope.$on('changeLayerManagerCurrlayer', function(event, args) {
          scope.currlayer = args;
        });

        scope.openSldEditor = function() {
          extendedNgDialog.open({
            template:
              'js/XG/widgets/mapapp/layerManager/views/popoverSldEditor.html',
            className:
              'ngdialog-theme-plain overflowY width800 nopadding miniclose',
            closeByDocument: false,
            scope: scope,
            title: $filter('translate')('model.styles.editor.title'),
            draggable: true,
          });
        };

        /**
         * Construit le ng-class de l'icône de visibilité d'un thème (fa-eye)
         * @param {string} themeTitle nom du thème de couches du géocatalogue
         * @return {string} classes css à affecter à l'icône fontawesome
         *  de la visibilité d'un thème du géocatalogue
         */
        scope.getLayersThemeVisibility = (themeTitle) => {
          let iconClass = 'fa-eye';
          if (scope.grouplayers && Array.isArray(scope.grouplayers[themeTitle])) {
            // isole les couches du thème
            const themeLayers = scope.grouplayers[themeTitle].filter(
              layer => layer.theme === themeTitle);

            // isole les couches visibles du thème
            const visibleLayers = themeLayers.filter(layer => layer.visible);

            // compare la taille du tableau de couches visibles du thème
            // à la taille du tableau de toutes les couches du thème
            if (visibleLayers.length === 0) {
              iconClass += '-slash no-visible-layer';
            } else if (visibleLayers.length < themeLayers.length) {
              iconClass += '-slash';
            }
          }
          return iconClass;
        };

        scope.themeLayersInfo = function(check, title) {
          var allOk = true;

          scope.grouplayers[title].forEach(function(l) {
            // Specific ANC.
            // We do not want users to modify branch element &&
            // delete grouplayer if empty.
            // if(angular.isDefined(l)) {
            // if(l.name.indexOf('kis_anc_ef') == 0)
            // scope.grouplayers[title].splice(scope.grouplayers[title].indexOf(l),
            // 1);
            // if(scope.grouplayers[title].length == 0)
            // delete scope.grouplayers[title];

            // }

            if (check == 'visible') {
              if (l.theme == title && !l.visible) allOk = false;
            }
            if (check == 'selectable') {
              if (l.theme == title && !l.selected) {
                allOk = false;
              }
            }
          });

          return allOk;
        };

        /**
         * Set all the layers to selectable
         *
         * @param title
         * @param forceSelectable
         */
        scope.selectAllFilter = function(title, forceSelectable) {
          var selectable = function() {
            scope.grouplayers[title].forEach(function(l) {
              if (!l.selected) {
                l.selected = true;
                l.visible = true;
                gclayers.addToSelectFilter(l);
              }
            });
          };
          var unselectable = function() {
            scope.grouplayers[title].forEach(function(l) {
              if (l.selected) {
                l.set('selected', false);
                gclayers.removeSelectFilter(l);
              }
            });
          };

          if (typeof forceSelectable != 'undefined') {
            if (forceSelectable) selectable();
            if (!forceSelectable) unselectable();
          } else {
            var selectAll = scope.themeLayersInfo('selectable', title);
            if (!selectAll) {
              selectable();
            } else {
              unselectable();
            }
          }

          $rootScope.$broadcast('gcOperationalLayerChange', '', 'applyall');
        };
        /**
         * Set all the layers to visible
         *
         * @param title
         * @param forceVisible
         */
        scope.visibleAllFilter = function(title, forceVisible) {
          var toggleVisible = function(v) {
            scope.grouplayers[title].forEach(function(l) {
              if (l.theme == title) {
                l.visible = v;
                // apply to selectable
                if (!l.visible) {
                  l.selected = v;
                  gclayers.removeSelectFilter(l);
                }
              }
            });
          };

          var visiblity =
            typeof forceVisible != 'undefined'
              ? forceVisible
              : !scope.themeLayersInfo('visible', title);
          toggleVisible(visiblity);

          $rootScope.$broadcast('gcOperationalLayerChange', '', 'applyall');
        };

        /**
         * Configure group layer opacity
         *
         * @param title
         */
        scope.configGroupOpacity = function(title) {
          scope.currTitle = title;
          scope.layerGroupOpacity = {
            value: 0,
          };

          if (scope.groupOpacityConfigPopup != undefined) {
            scope.groupOpacityConfigPopup.close();
          }
          scope.groupOpacityConfigPopup = extendedNgDialog.open({
            template:
              'js/XG/widgets/mapapp/layerManager/views/popoverGroupOpacityConfig.html',
            className:
              'ngdialog-theme-plain overflowY width800 nopadding miniclose',
            closeByDocument: false,
            scope: scope,
            title: $filter('translate')(
              'layermanager.popoverGroupOpacityConfig_title'
            ),
            draggable: true,
          });
        };

        scope.updateGroupLayerOpacity = function(currTitle) {
          // console.log (currTitle);

          scope.grouplayers[currTitle].forEach(function(l) {
            if (l.theme == currTitle) {
              l.invertedOpacity = scope.layerGroupOpacity.value / 100;
            }
          });

          $rootScope.$broadcast('gcOperationalLayerChange', '', 'applyall');
        };

        /*
         * Show the legend popup
         */
        var legendpopup, legendpopuplistener;
        scope.globalLegendPopup = function() {
          if (legendpopup) {
            // Close popup if already open
            return legendpopup.close();
          }
          scope.displayCompleteLegend = false;
          legendpopup = extendedNgDialog.open({
            className: 'ngdialog-theme-plain width300 nopadding miniclose',
            closeByDocument: false,
            draggable: true,
            title: $filter('translate')('legend.widgetname'),
            scope: scope,
            // Based on the legendListAll directive from the
            // Legend widget
            template:
              'js/XG/widgets/mapapp/layerManager/views/popupLegend.html',
          });
          legendpopuplistener = $rootScope.$on('ngDialog.closed', function(
            evt,
            elem
          ) {
            if (legendpopup.id === elem.attr('id')) {
              legendpopup = undefined;
              legendpopuplistener();
            }
          });
        };
        scope.globalSelectAllFilter = function() {
          for (var title in scope.grouplayers) {
            scope.selectAllFilter(title, scope.allLayersSelectable);
          }
          scope.allLayersSelectable = !angular.copy(scope.allLayersSelectable);
          if (!scope.allLayersSelectable)
            scope.allLayersVisible = scope.allLayersSelectable;
        };
        scope.globalvisibleAllFilter = function() {
          // Parcourir grouplayers, en excluant "Techniques", et mettre à jour
          // le filtre de visibilité pour chaque groupe
          Object.keys(scope.grouplayers).filter(group => group !== "Techniques").forEach(
            title => {
              scope.visibleAllFilter(title, scope.allLayersVisible);
            });
          scope.allLayersVisible = !angular.copy(scope.allLayersVisible);
          if (scope.allLayersVisible)
            scope.allLayersSelectable = scope.allLayersVisible;
        };

        scope.updateLayer = (layer) => {
          //-- Le refraichisssement d'une couche de la carte
          //-- peut se faire comme si on modifié sa visiilité car
          //-- cette fonction vérifie si le layer est déjà visible et
          //-- reconstruit ses caractéristiques.
          $rootScope.$broadcast('gcOperationalLayerChange', layer, 'visibility');
        };

        /**
         * Au clic sur le bouton "Sélection" (curseur souris) d'une couche
         * dans le gestionnaire de couches
         * Ajoute/enlève la couche dans le tableau de couches sélectionnables
         * <code>SelectFilter</code> de la directive gclayers.
         * Définit la couche courante sélectionnable ou non-sélectionnable
         * {@link gclayers.addToSelectFilter}
         *
         * @param {ol.layer.Vector | ol.layer.Tile} layer couche openlayers
         *  présente dans le géocatalogue
         */
        scope.addToSelectFilter = function(layer) {
          // KIS-3548: un composant KIS absent de Geoserver ne doit pas être sélectionnable
          if (Object.prototype.hasOwnProperty.call(layer, 'locked') && layer.locked) {
            return;
          }
          if (!layer.selected) {
            layer.selected = true;
            if (!layer.getVisible()) {
              scope.setVisibilityLayer(layer);
            }
            gclayers.addToSelectFilter(layer);

            // KIS-2853: rend la couche de sélection visible dès qu'une couche est sélectionnable
            const allowedGcTypes = ['esri', 'g2c'];
            if (layer.get('name') !== 'Selection' && allowedGcTypes.includes(layer.get('gctype'))) {
              layersService.enableSelectLayerVisible(scope.map);
            }
          } else {
            layer.set('selected', false);
            gclayers.removeSelectFilter(layer);
          }
        };


        function getLayerGroupByName(layerGroupName) {
          for (let il2 = 0; il2 < scope.layerGroups.length; il2++) {
            if (layerGroupName == scope.layerGroups[il2].group) {
              return scope.layerGroups[il2];
            }
          }
        }

        /**
         * Move the layer in the drawing priority list.
         * If delta > 0 the layer takes more priority.
         *
         * @param {olLayer}
         *            layer
         * @param {Integer}
         *            delta
         * @return {[type]}
         */
        scope.moveLayer = (layer, delta, type, group4ui, iLyr) => {
          let index = {};
          let layers;
          if (type === 'esri') {
            layers = gclayers
              .getOperationalLayerESRICollection();
          } else {
            layers = gclayers
              .getOperationalLayerg2cCollection();
          }
          const group = getLayerGroupByName(group4ui.group);
          const lyr = group.layers[iLyr];
          index = layers.getArray().indexOf(lyr);
          layers.removeAt(index);
          layers.insertAt(index + delta, lyr);
          lyr.index = index + delta;
          const lyr4ui = group4ui.layers4ui[iLyr];
          group4ui.layers4ui.splice(iLyr, 1);
          group4ui.layers4ui.splice(iLyr + delta, 0, lyr4ui);
          group.layers.splice(iLyr, 1);
          group.layers.splice(iLyr + delta, 0, lyr);

          const fullList = gclayers.getOperationalLayerCollection();
          let curIndexOfLayer1 = getIndexOfLayer(
            layers.getArray()[index + delta], fullList);
          fullList.removeAt(curIndexOfLayer1);
          fullList.insertAt(curIndexOfLayer1 + delta, lyr);

          //-- Rafraichissement du layer OpenLayers contenant cette couche KIS.
          $rootScope.$broadcast('gcOperationalLayerChange', lyr, 'priority');
        };

        function getIndexOfLayer(layer, layerList) {
          let arr;
          if (layerList.getArray) {
            arr = layerList.getArray();
          }
          else {
            arr = layerList;
          }
          for (let iLyr = 0; iLyr < arr.length; iLyr++) {
            if (layer == arr[iLyr])
              return iLyr;
          }
          return -1;
        }


        /**
         * Déplacement d'un groupe de couche dans l'ordre de priorité de dessin.
         * delta = -1 ou +1 pour descendre ou monter dans la priorité.
         * IL faut actualiser 2 listes celles utilisée pour le dessin
         * de la carte et celle utiliser pour l'IHM (drag & drop).
         *
         * @param {*} layerGroup
         * @param {*} delta
         * @param {*} type
         * @param {*} index
         */
        scope.moveLayerGroup = (layerGroup, delta, type, index) => {
          let newIndex = index + delta;
          if (newIndex < 0) newIndex = 0;
          if (newIndex >= scope.layerGroups.length)
            newIndex = scope.layerGroups.length - 1;

          const grp = scope.layerGroups[index];
          scope.layerGroups.splice(index,1);
          scope.layerGroups.splice(newIndex,0,grp);

          const grp4ui = scope.lg4ui[index];
          scope.lg4ui.splice(index,1);
          scope.lg4ui.splice(newIndex,0,grp4ui);

          $rootScope.$broadcast('gcOperationalLayerOnInit',true);
          //$rootScope.$broadcast('gcOperationalLayerChange', undefined, 'priority');
        };


        function orderLayerGroups() {
          let il1;
          const newLgList = [];
          for (il1 = 0; il1 < scope.lg4ui.length; il1++) {
            newLgList.push(getLayerGroupByName(scope.lg4ui[il1].group));
          }
          scope.layerGroups.splice(0, scope.layerGroups.length);
          for (il1 = 0; il1<newLgList.length; il1++) {
            scope.layerGroups.push(newLgList[il1]);
          }
        }

        function orderLayersOfLayerGroup(lg4ui, layerGroup) {
          let il1, il2;
          const newLayerList = [];
          for (il1 = 0; il1<lg4ui.layers4ui.length; il1++) {
            for (il2 = 0; il2 < layerGroup.layers.length; il2++) {
              if (lg4ui.layers4ui[il1].ftiUid == layerGroup.layers[il2].fti.uid) {
                newLayerList.push(layerGroup.layers[il2]);
                break;
              }
            }
          }
          layerGroup.layers.splice(0, layerGroup.layers.length);
          for (il1 = 0; il1<newLayerList.length; il1++) {
            layerGroup.layers.push(newLayerList[il1]);
          }
        }

        scope.dropLayerGroupSuccess = () => {
          orderLayerGroups();
          $rootScope.$broadcast('gcOperationalLayerOnInit', true);
        };

        scope.dropLayerSuccess = (layerGroup) => {
          const theLayerGrp = getLayerGroupByName(layerGroup.group);
          orderLayersOfLayerGroup(layerGroup,theLayerGrp);
          $rootScope.$broadcast('gcOperationalLayerChange',
            theLayerGrp.layers[0], 'priorityAll');
        };

        /**
         * [isBodLayer description]
         *
         * @param {layer}
         *            layer
         * @return {Boolean}
         */
        scope.isBodLayer = function(layer) {
          // return !!gaLayers.getLayer(layer.bodId);
        };
        /**
         * [addWfsLayertoMap description]
         *
         * @param {[type]}
         */
        scope.addWfsLayertoMap = function(fti) {
          console.log('applyall');
          var olLayer = gcWFS.getOlLayerFromFeaturetypeInfo(scope.fti);
          map.addLayer(olLayer);
        };
        scope.clearFilterPopover = function() {
          scope.currlayer.cql_filter = '';
          if (
            $rootScope.xgos &&
            $rootScope.xgos.sector === 'hpo' &&
            $rootScope.xgos.hpo
          ) {
            // require('toastr').info($filter('translate')('hpo.common.utilisercefilter'));
            $rootScope.xgos.hpo.clauseWhere = '1=1';
            if (scope.map && scope.map.getView)
              $rootScope.xgos.hpo.srid = scope.map
                .getView()
                .getProjection()
                .getCode();
          }
        };
        scope.setFilter = function(layer) {
          layer.cql_filter = angular.copy(scope.tmp.showCqlFilter);
          if (
            $rootScope.xgos &&
            $rootScope.xgos.sector === 'hpo' &&
            $rootScope.xgos.hpo
          ) {
            // require('toastr').info($filter('translate')('hpo.common.utilisercefilter'));
            $rootScope.xgos.hpo.clauseWhere = layer.cql_filter;
            if (scope.map && scope.map.getView)
              $rootScope.xgos.hpo.srid = scope.map
                .getView()
                .getProjection()
                .getCode();
          }
        };
        scope.clearFilter = function(layer) {
          /* layer.set('cql_filter','undefined'); */
          layer.set('cql_filter', '1=1');
        };

        scope.opacityValues = [
          {
            key: '1',
            value: '100%',
          },
          {
            key: '0.95',
            value: '95%',
          },
          {
            key: '0.9',
            value: '90%',
          },
          {
            key: '0.85',
            value: '85%',
          },
          {
            key: '0.8',
            value: '80%',
          },
          {
            key: '0.75',
            value: '75%',
          },
          {
            key: '0.7',
            value: '70%',
          },
          {
            key: '0.65',
            value: '65%',
          },
          {
            key: '0.6',
            value: '60%',
          },
          {
            key: '0.55',
            value: '55%',
          },
          {
            key: '0.5',
            value: '50%',
          },
          {
            key: '0.45',
            value: '45%',
          },
          {
            key: '0.4',
            value: '40%',
          },
          {
            key: '0.35',
            value: '35%',
          },
          {
            key: '0.3',
            value: '30%',
          },
          {
            key: '0.25',
            value: '25%',
          },
          {
            key: '0.2',
            value: '20%',
          },
          {
            key: '0.15',
            value: '15%',
          },
          {
            key: '0.1',
            value: '10%',
          },
          {
            key: '0.05',
            value: '5%',
          },
          {
            key: '0',
            value: '0%',
          },
        ];
        if ($rootScope.xgos.portal.parameters.geonetwork != undefined) {
          scope.geonetworkActive =
            $rootScope.xgos.portal.parameters.geonetwork.active;
        }
        scope.acceesGeonetwork = function(name) {
          scope.baseUrlGeonetWork =
            $rootScope.xgos.portal.parameters.geonetwork.url;
          // scope.codeGeonetworkPortal =
          // $rootScope.xgos.portal.parameters.geonetwork.code;

          scope.getJSONetwork = function(url, callback) {
            var xhr = new XMLHttpRequest();
            xhr.open('GET', url, true);
            xhr.responseType = 'json';
            xhr.onload = function() {
              var status = xhr.status;
              if (status == 200) {
                callback(null, xhr.response);
              } else {
                callback(status);
              }
            };
            xhr.send();
          };
          scope.getJSONetwork(
            scope.baseUrlGeonetWork +
              'xml.search?title=' +
              name +
              '&_content_type=json',
            function(err, data) {
              if (scope.baseUrlGeonetWork) {
                var uid = data.metadata['geonet:info'].uuid;
                window.open(
                  scope.baseUrlGeonetWork + 'catalog.search#/metadata/' + uid
                );
              } else {
                require('toastr').error('error');
              }
            }
          );
        };
        scope.popupMetatdata = function(layer) {
          // recupérer les paramètres de l'application courante
          scope.showLinkWmsWfs;
          var appname = gaJsUtils.getAppName();
          // -- Récupération de la configuration de l'application.'
          ApplicationFactory.getbyname(appname).then(function(res) {
            var app = res.data;
            // -- droit sur affichage lien wms wfs
            scope.showLinkWmsWfs = app.wmswfs;
            scope.currlayer = layer;
            legendService.getArcGISLayerLegend(layer, layer.getProperties().theme, []);
            console.log('popupmetadata');
            if (scope.metadatapopup != undefined) {
              scope.metadatapopup.close();
            }

            scope.token = localStorage.auth_token;
            scope.metadatapopup = gcPopup.open({
              scope: scope,
              title: $filter('translate')('layermanager.popupmetadata_title'),
              template:
                'js/XG/widgets/mapapp/layerManager/views/popupMetatdata.html',
              showClose: true,
            });
          });
        };
        scope.popupLayerManager = function(layers) {
          scope.currlayer = layers;

          /*
           * scope.layermanagerpopup = gcPopup.open( { scope :scope,
           * title : '{{"layermanager.popoverlayermanager_title" |
           * translate}}',
           * template:'js/XG/widgets/mapapp/layerManager/views/popoverlayermanager.html',
           * showClose : true
           *
           * });
           */

          scope.layeropacity = {
            value: Math.round(scope.currlayer.invertedOpacity * 100 * 2) / 2,
          };
          scope.$watch(
            'layeropacity',
            function() {
              scope.currlayer.invertedOpacity = scope.layeropacity.value / 100;
            },
            1
          );
          scope.change_filter = function() {
            var attributesexists = scope.currlayer.fti.attributes
              .map(function(x) {
                var indexAlias = scope.tmp.showCqlFilter.indexOf(x.alias);
                var indexName = scope.tmp.showCqlFilter.indexOf(x.name);
                if (indexAlias !== -1 || indexName !== -1) return x;
              })
              .filter(function(x) {
                if (x) return x;
              });
            // Change filter
            if (attributesexists.length > 0) {
              var cql_name = '';
              var operators = [
                '+',
                '-',
                '/',
                '%',
                '=',
                '>',
                '<',
                '<>',
                '>=',
                '<=',
                'LIKE',
                'IN'
              ].reverse();
              var keepGoing = true;
              angular.forEach(operators, function(op) {
                if (keepGoing) {
                  angular.forEach(scope.currlayer.fti.attributes, function(x) {
                    if (
                      x.alias ==
                      scope.tmp.showCqlFilter
                        .split(' ' + op + ' ')[0]
                        .replace(/\'/g, '')
                        .replace(/\"/g, '')
                    ) {
                      cql_name = x.name;
                    }
                  });
                  if (cql_name == '') {
                    angular.forEach(scope.currlayer.fti.attributes, function(
                      x
                    ) {
                      if (
                        x.name ==
                        scope.tmp.showCqlFilter
                          .split(' ' + op + ' ')[0]
                          .replace(/\'/g, '')
                          .replace(/\"/g, '')
                      ) {
                        cql_name = x.name;
                      }
                    });
                  }
                  if (cql_name != '') {
                    scope.currlayer.cql_filter =
                      cql_name +
                      ' ' +
                      op +
                      ' ' +
                      scope.tmp.showCqlFilter.split(' ' + op + ' ')[1];
                    keepGoing = false;
                  }
                }
              });
            } else {
              scope.currlayer.cql_filter = scope.tmp.showCqlFilter;
            }

            if (
              $rootScope.xgos &&
              $rootScope.xgos.sector === 'hpo' &&
              $rootScope.xgos.hpo
            ) {
              // require('toastr').info($filter('translate')('hpo.common.utilisercefilter'));
              $rootScope.xgos.hpo.clauseWhere = scope.currlayer.cql_filter;
              if (scope.map && scope.map.getView)
                $rootScope.xgos.hpo.srid = scope.map
                  .getView()
                  .getProjection()
                  .getCode();
            }

            $rootScope.$broadcast(
              'gcOperationalLayerChange',
              scope.currlayer,
              'cql_filter'
            );
          };

          scope.$watch('currlayer.cql_filter', function(cql_filter) {
            scope.tmp.showCqlFilter = cql_filter;
            // console.log(scope.tmp.showCqlFilter);
          });
          // TODO: Fix that if possible, its a workaround to reset the
          // showmaxscale
          // had to use a showMaxScale variable which is only used for
          // the display
          // Setting maxScale to undefined doesn't work
          // so we actually set to a huge value (999999999999) and
          // display '' in the field
          scope.tmp = {
            showMaxScale:
              scope.currlayer.maxScale !== 999999999999
                ? angular.copy(scope.currlayer.maxScale)
                : undefined,
            showMinScale: scope.currlayer.minScale
              ? angular.copy(scope.currlayer.minScale)
              : undefined,
          };
          scope.scaleErrors = false;
          var scaleErrorsCheck = function() {
            var cmpMax = parseInt(scope.currlayer.maxScale, 10);
            scope.scaleErrors = parseInt(scope.currlayer.minScale, 10) > cmpMax;
          };
          /*
           * scope.$watch('currlayer.minScale', function(minScale){
           * if(typeof minScale=='undefined' || minScale == null ) {
           * minScale = undefined; return; }; scaleErrorsCheck(); },
           * 1);
           */

          scope.$watch('tmp.showMinScale', function(showMinScale) {
            if (typeof showMinScale == 'undefined') return;

            if (showMinScale == null) {
              scope.currlayer.minScale = undefined;
            } else {
              scope.currlayer.minScale = showMinScale;
            }
            scaleErrorsCheck();
          });

          scope.$watch('tmp.showMaxScale', function(showMaxScale) {
            if (typeof showMaxScale == 'undefined') return;

            if (showMaxScale == null) {
              scope.currlayer.maxScale = 999999999999;
            } else {
              scope.currlayer.maxScale = showMaxScale;
            }
            scaleErrorsCheck();
          });

          // set as defaut style or the select wont be initialized
          // with the correct value
          if (scope.currlayer.style) {
            scope.currlayer.fti.defaultStyle = scope.currlayer.style;
          }

          // console.log(scope.layermanagerpopup);
          if (scope.layermanagerpopup != undefined) {
            scope.layermanagerpopup.close();
          }
          scope.layermanagerpopup = extendedNgDialog.open({
            template:
              'js/XG/widgets/mapapp/layerManager/views/popoverlayermanager.html',
            className:
              'ngdialog-theme-plain overflowY width800 nopadding miniclose',
            closeByDocument: false,
            scope: scope,
            title: $filter('translate')(
              'layermanager.popoverlayermanager_title'
            ),
            draggable: true,
          });
        };


        /*
         * Show or hide the given layer (eye icon)
         */
        scope.setVisibilityLayer = (layer) => {
          // KIS-3548: un composant KIS absent de Geoserver ne doit pas être visible
          if (layer.locked) {
            const label = layer.name ? layer.name : layer.label;
            const error = $filter('translate')('common.featuretypes.layerAbsentInGeoserver').replace('$1', label);
            require('toastr').error(error);
            return;
          }
          layer.setVisible(!layer.visible);
          if (layer.theme.toUpperCase() === 'WEBBACKGROUND') {
            if (!layer.visible) {
              layer.active = layer.visible;
            }
            // Bad idea:
            // $rootScope.$broadcast('gcBackGroundLayerChange',
            // layer);
          } else {
            // apply to selectable
            if (!layer.visible && layer.selected) {
              layer.selected = false;
              gclayers.removeSelectFilter(layer);
            }
            //            $rootScope.$broadcast('gcOperationalLayerChange', '', 'applyall');
            $rootScope.$broadcast('gcOperationalLayerChange', layer,
              'visibility');
          }
        };

        scope.popupConfig = function() {
          scope.configpopup = gcPopup.open({
            scope: scope,
            title: $filter('translate')('layermanager.popupConfig_title'),
            template:
              'js/XG/widgets/mapapp/layerManager/views/popupConfig.html',
            showClose: true,
          });
        };

        // close all the cfg popovers
        scope.closeCfgPopovers = function() {
          $('.layerManagerWidget .popover').remove();
        };

        scope.$on('gaLayersChange', function(event, data) {
          // We remove all bod layers from the map that
          // don't have a layers definition
          removeNonExistantBodLayers();

          scope.map.getLayers().forEach(function(olLayer) {
            if (scope.isBodLayer(olLayer)) {
              olLayer.label = gaLayers.getLayerProperty(olLayer.bodId, 'label');
            }
          });
        });

        $rootScope.$on('changeLayerManagerCurrlayer', function(event, args) {
          scope.currlayer = args;
        });

        $rootScope.$on('initFilterTemp', function() {
          scope.filtertemp.filter = '';
        });

        scope.$on('closeTools_layermanagerwidget', function(event, arg) {
          if (arg.directive === 'layermanagerwidget') {
            if (!arg.active) {
              scope.tabs.activeTab = 0;
              scope.closeCfgPopovers();
            }
          }
        });


        scope.$on('openTools_layermanagerwidget', function(event, arg) {
          if (arg.directive === 'layermanagerwidget') {
            scope.tabs.activeTab = 0;
          }
        });

        scope.$on('updateLayersManagers', () => {
          scope.grouplayers = gclayers.getGroupLayer();
          grouplayerstoAry();
          scope.layers = gclayers.getOperationalLayer();
          scope.layersg2c = gclayers.getOperationalLayerg2c();
          scope.layersESRI = gclayers.getOperationalLayerESRI();

          // reset l'affichage des images du style des couches
          hideLayersIcon();
          showLayersIcon(1);
        });

        scope.$on('openCloseTools_layermanagerwidget', function(event, arg) {
          if (arg.directive === 'layermanagerwidget') {
            if (!arg.active) {
              scope.tabs.activeTab = 0;
              scope.closeCfgPopovers();
            }
          }
        });

        // @commente et remplace au dessus
        // -- Je ne sais pas pourquoi ni comment mais il y a
        // quelquechose
        // -- qui change la valeur par défaut de scope.tabs.activeTab.
        // -- Comme il n y a pas de raison qu'aucun onglet du
        // géocatalogue ne soit actif,
        // -- si la valeur change pour quelquechose qui n'est pas un
        // onglet, on force le premier onglet.
        /*
         * scope.$watch('tabs.activeTab', function(p1){ if
         * (scope.tabs.activeTab==undefined || scope.tabs.activeTab==-1)
         * scope.tabs.activeTab=0; },1);
         */
        scope.filterFunc = gaJsUtils.filterFunc;
        scope.filterLayers = '';

        /**
         * Détecte si la couche possède un fitre
         * Responsable de l'affichage en gras de la couche quand celle-ci est filtrée
         * @param {*} layer couche openlayers du gestionnaire de couche
         * @returns true si la propriété cql_filter est définie et personnalisée
         * @see ng-class="{'layer-filtered': isFiltered(layer)}"
         */
        scope.isFiltered = (layer) => {
          return layer.cql_filter && layer.cql_filter !== '' && layer.cql_filter !== '1=1';
        };

        /**
         * Ouvre le wiki personnalisé de la datatable dans un nouvel onglet du navigateur.<br>
         * Le wiki personnalisé de la datatable est défini dans la configuration du layermanager.<br>
         * Le bouton n'est accessible uniquement si la propriété <code>wiki</code> existe
         */
        scope.openDatatableWiki = () => {
          $window.open(scope.configf.wiki);
        };


        /**
         * Supprime le filtrage quand on appuie sur la touche "escape"
         * Uniquement lors du 1er caractère écrit:<ul><li>
         * Sauvegarde l'état de d'affichage des groupes</li><li>
         * Dégroupe tous les groupes de couches</li><ul>
         * @param event keydown event
         */
        scope.onFilterKeydown = (event) => {
          // reset si escape
          scope.filterLayers = event.keyCode === 27 ? '' : scope.filterLayers;

          if (!scope.filterState && scope.filterLayers.length > 0) {
            // initialise filterState pour ne plus exécuter après le 1er caractère saisi
            scope.filterState = true;
            if (Object.keys(scope.hiddenPanels).length > 0) {
              scope.hiddenPanelsPrevState = angular.copy(scope.hiddenPanels);
            }
            // modifie la variable allPanelHidden
            scope.showAllPanels();
          }
        };


        /**
         * Au clic sur le bouton supprimer (croix) de la zone de saisie du filtre des couches
         */
        scope.resetFilter = () => {
          scope.filterLayers = '';
          scope.onFilterKeyup();
        };


        /**
         * Affichage des miniatures de la représentation par défaut des couches
         * En présence d'un style, c'est la représentation par défaut qui est affichée
         * @param {number} tries nombre de tentatives en attendant que le widget ne se charge
         * @param {boolean} bypassThumbnailDef n'exécute pas la création de la propriété "thumbnail" (utile quand on souhaite préserver la pté existante)
         */
        const showLayersIcon = (tries, bypassThumbnailDef = false) => {
          if (scope.iconMode && !scope.layerIconsRendered) {

            //méthode interne #1
            // copie l'url de l'image contenue dans legend
            // et modification pour tenter d'obtenir un meilleur rendu
            const defineLayersThumbnail = (groupLayers) => {
              for (const layers of Object.values(groupLayers)) {
                for (const layer of layers) {
                  if (layer.legend) {
                    // KIS-3611: affiche la représentation d'une couche ArcGIS
                    if (layer.gctype === 'esri') {
                      layersService.getArcGisLegendInfo(layer.legend).then(
                        res => {
                          if (Array.isArray(res.data.layers) && res.data.layers.length > 0) {
                            const layerGraphic = res.data.layers[0];
                            if (Array.isArray(layerGraphic.legend) && layerGraphic.legend.length > 0) {
                              layer.thumbnail = layerGraphic.legend[0].url;
                            }
                          }
                        }
                      );
                    } else {
                      layer.thumbnail = layer.legend.replace('{portalid}',
                        localStorage.getItem('portal')).concat(
                        '&FORMAT=image/svg+xml&TRANSPARENT=true');

                      // KIS-3464: quand le composant n'a pas de style on affiche le style par défaut de geoserver
                      const layerStyle = getLayerThumbStyle(layer);

                      // prise en compte du style actuel (navigation hors de la rubrique du géocatalogue et retour dans le géocatalogue)
                      const urlParts = layer.thumbnail.split('&');
                      const stylePartIndex = urlParts.findIndex(part => part.includes('STYLE='));
                      const currentStyle = 'STYLE=' + layerStyle;
                      urlParts.splice(stylePartIndex, 1, currentStyle);
                      layer.thumbnail = urlParts.join('&');
                    }
                  }
                }
              }
            };


            //méthode interne #2
            // Remplace l'image brouillon présente dans le template
            // par une image aux bonnes dimensions et bien positionnée en début de ligne
            const reworkThumbnails = (tries) => {
              if (tries >= 0) {
                const layerManager = document.getElementById('inner_lmw');
                if (layerManager) {

                  // l'observer permet de détecter la visibilité des groupes dans le viewport
                  const observer = new IntersectionObserver((entries) => {
                    entries.forEach((entry) => {
                      if (entry.target.id === 'inner_lmw' && entry.isIntersecting) {

                        processImageLayers(layerManager, scope.grouplayers, 10);

                        // indique l'affichage effectif des images du style des couches
                        scope.layerIconsRendered = true;

                        // Arrête de surveiller les intersections pour cet observateur spécifique
                        observer.disconnect();
                      }
                    });
                  });
                  observer.observe(layerManager);
                } else {
                  // attend l'affichage du widget pour créer l'observer
                  $timeout(() => {
                    reworkThumbnails(--tries);
                  });
                }
              }
            };

            //méthode interne #3
            // Construit l'image du style de chaque couche à partir de l'image masquée qui contient la totalité de la légende de la couche
            // Fonction récursive tant que la totalité des images n'est pas téléchargée.
            const processImageLayers = (layerManager, groupLayers, tries) => {
              if (tries >= 0) {
                const pendingGroupImagesLayers = {};
                for (const [category, layers] of Object.entries(groupLayers)) {
                  for (const layer of layers) {
                    const layerProperties = layer.getProperties();
                    let reworkedImage;
                    const escapedLayerName = CSS.escape(layer.name); // Échappe les caractères spéciaux
                    const originalImage = layerManager.querySelector('#' + escapedLayerName);
                    if (originalImage && originalImage.getAttribute('loaded') != null) {
                      const line = originalImage.closest('li');

                      if (gaJsUtils.notNullAndDefined(layerProperties.style) && layerProperties.style.length > 0) {

                        // les images des styles catégorisés/personnalisés sont rognées
                        // et seule la 1ère image du style catégorisé est préservée (représentation par défaut)
                        reworkedImage = gaJsUtils.resizeImage(originalImage, 20, 20);
                      } else {

                        // les images des couches sans styles sont copiées directement
                        reworkedImage = new Image(); // Créer une nouvelle instance de HTMLImageElement
                        reworkedImage.src = originalImage.src; // Copier la source de l'image
                        reworkedImage.alt = originalImage.alt; // Copier l'attribut alt si nécessaire
                      }
                      if (reworkedImage) {

                        // tooltip au survol
                        reworkedImage.title = $filter('translate')('layermanager.infolayer');

                        // récupère le nom de la couche dans l'id
                        reworkedImage.id = originalImage.id + '_rw';

                        // Ouvre l'éditeur SLD au clic sur l'image
                        reworkedImage.addEventListener('click', () => {
                          scope.popupMetatdata(layer);
                        });

                        // affecte une classe css pour l'alignement de l'image dans la ligne
                        reworkedImage.classList.add('layer-thumbnail');

                        // Insère l'image au début de la ligne du géocatalogue avant le nom de couche
                        const firstChild = line.firstChild;
                        line.insertBefore(reworkedImage, firstChild);
                      }
                    } else {
                      if (!pendingGroupImagesLayers[category]) {
                        pendingGroupImagesLayers[category] = [];
                      }
                      pendingGroupImagesLayers[category].push(layer);
                    }
                  }
                }
                if (Object.keys(pendingGroupImagesLayers).length > 0) {
                  $timeout(() => {
                    processImageLayers(layerManager, pendingGroupImagesLayers, --tries);
                  }, 300);
                }
              }
            };

            // traitement de l'affichage des icones de couches
            if (!bypassThumbnailDef) {
              defineLayersThumbnail(scope.grouplayers);
            }
            $timeout(()=> {
              // modifie la taille des images après que le rendu des images masquées soit effectif
              reworkThumbnails(tries);
            });
          }
        };

        /**
         * Supprime l'image du style des couches du DOM
         */
        const hideLayersIcon = () => {
          for (const layers of Object.values(scope.grouplayers)) {
            for (const layer of layers) {

              // supprime l'image du style de la couche
              const layerImage = document.getElementById(layer.name + '_rw');
              if (layerImage) {
                layerImage.remove();
              }

            }
            // indique l'absence des images des styles
            scope.layerIconsRendered = false;
          }
        };

        /**
         * Mise à jour du style du composant au changement du select
         * @see popupMetatdata.html
         * @param {object} layer couche du géocatalogue
         */
        scope.updateStyle = (layer) => {
          if (layer.fti.type === 'g2c') {
            layer.thumbnail = scope.legendurl + layer.name +'&token='+ scope.token + '&STYLE=' + layer.style + '&TRANSPARENT=true';
          } else if (layer.fti.type === 'esri') {
            layer.thumbnail = 'data:image/jpeg;base64, ' + layer.legendData.legend[0].imageData;
          } else {
            layer.thumbnail = layer.fti.wms+'?service=WMS&REQUEST=GetLegendGraphic&VERSION=1.0.0&FORMAT=image/png&WIDTH=20&HEIGHT=20&LAYER='+layer.fti.name+'&token='+scope.token;
          }

          // supprime l'attribut "loaded" de l'image masquée de la légende de la couche
          const hiddenLayerImage = document.getElementById(layer.name);
          if (hiddenLayerImage && hiddenLayerImage.getAttribute('loaded')) {
            hiddenLayerImage.removeAttribute('loaded');
          }

          // reset l'affichage des images du style des couches
          hideLayersIcon();
          showLayersIcon(1, true);

          // envoie un évènement à gcmap pour maj de la carte
          scope.updateLayer(layer);
        };

        /**
         * Ajoute un attribut à l'image de légende après téléchargement.
         * C'est nécessaire pour l'affichage des images de styles de couches.
         * L'affichage doit attendre le téléchargement avant de mettre à jour l'image.
         * @param {HTMLImageElement} img image masquée contenant la légende complète de la couche
         */
        scope.setImageAsLoaded = (img) =>  {
          img.setAttribute('loaded', 'true');
        };

        /**
         * Récupère le nom du style à afficher dans la représentation de la couche
         * Par ordre de priorité: style > defaultStyle  > style geoserver
         * @param  {object} layer couche openlayers à laquelle des propriétés ont été ajoutées (comme le fti)
         * @return {string} nom du style à inclure dans la propriété thumbnail de la layer.
         * Cette propriété thumbnail sera utilisé pour récupérer l'image dans un attribut ng-src
         */
        const getLayerThumbStyle = (layer) => {

          if (!layer.fti) {
            layer.fti = FeatureTypeFactory.getFeatureByName(layer.name);
          }

          if (gaJsUtils.notNullAndDefined(layer.style) && layer.style.length > 0) {
            // style du modèle de carte
            return layer.style;
          } else if (gaJsUtils.notNullAndDefined(layer.fti) && layer.fti.defaultStyle.length > 0) {
            // style par défaut du fti
            return layer.fti.defaultStyle;
          }

          // style geoserver
          return layer.fti.typeInfo.toLowerCase();
        };
      },
    };
  };

  templatebasewidget.$inject = ['$rootScope', 'gcWFS', 'gclayers', 'gcPopup',
    'ConfigFactory', 'extendedNgDialog', 'EditFactory', '$filter',
    'SelectManager', 'QueryFactory', 'gaDomUtils',
    'ActionsManager', 'ngDialog', 'gaJsUtils', 'ApplicationFactory', '$timeout',
    'RolesFactory', '$window', 'legendService', 'FeatureTypeFactory', 'PortalsFactory', 'layersService'
  ];
  return templatebasewidget;
});
