'use strict';
define(function() {
  var selectfeaturetreewidget = function(
    $http,
    extendedNgDialog,
    ParametersFactory,
    EditFactory,
    SelectManager,
    gclayers,
    QueryFactory,
    $translate,
    GeometryFactory,
    gcPopup,
    FeatureTypeFactory,
    ChartsFactory,
    $filter,
    $timeout,
    $rootScope,
    FeatureAttachmentFactory,
    gcStyleFactory,
    FontAwesomeFactory,
    ActionsFactory,
    gaJsUtils,
    ChartLocaliseFactory,
    ActionsManager,
    gcRestrictionProvider,
    mapJsUtils,
    RolesFactory,
    RightsFactory,
    AssociationFactory,
    PortalsFactory,
    ObjectFilesFactory,
    $window
  ) {
    /* Recuperation des labels pour les titres des onglets */
    let title_tab_info = 'Information';
    $translate('selectfeaturetree.tab_information').then((res) => {
      title_tab_info = res;
    });
    let title_tab_rel = 'Relation';
    $translate('selectfeaturetree.tab_relation').then((res) => {
      title_tab_rel = res;
    });
    let title_tab_attach = 'Attachments';
    $translate('selectfeaturetree.tab_attachment').then((res) => {
      title_tab_attach = res;
    });
    let statis = 'statistique';
    $translate('selectfeaturetree.statistique').then((res) => {
      statis = res;
    });
    // Fin de la recuperation des traductions
    return {
      templateUrl:
        'js/XG/widgets/mapapp/selectFeatureTree/views/selectfeaturetreewidget.html',
      controller: [
        '$scope',
        '$element',
        '$attrs',
        function($scope) {

          $scope.feattree = {};
          $scope.featdata = [];
          $scope.result = {};
          $scope.countFeatures = 0;
          $scope.currentselect = {};
          $scope.currentselectfti = null;
          $scope.relatedfeature = {};
          $scope.tableResult = {
            elements: {
              features: [],
            },
          };
          // liste des composants comportant des objets reliés à l'objet en cours
          $scope.availableRelatedFeatureIds = [];
          $scope.currentselectedActionOnComponentTable = {
            value: {},
          };
          // les variables qui definissent les titres sont recuperees dans la fonctions precedente
          $scope.tabs = [
            {
              title: title_tab_info,
            },
            {
              title: title_tab_rel,
            },
            {
              title: title_tab_attach,
            },
          ];

          $scope.tabs.activeTab = 0;
          $scope.csvseparator = ';';
        },
      ],
      restrict: 'A',
      link: function(scope, elt) {
        let map = scope.map;

        // Si un objet est selectionné, on active les boutons d'export
        scope.objectIsSelected = false;

        scope.result = SelectManager.getfeatures();
        updateCountFeatures();
        scope.fontAwesome = FontAwesomeFactory.FontAwesomeFactory.map((x) => {
          return x.unicode + ' ' + x.name.replace('fa-', '');
        });

        function updateCountFeatures() {
          let subCountFeatures = 0;
          if (angular.isDefined(scope.result.realTotalFeatures)) {
            angular.forEach(scope.result.realTotalFeatures, (value, key) => {
              subCountFeatures += value;
            });
          }

          scope.countFeatures =
            subCountFeatures > 0
              ? subCountFeatures
              : scope.result.totalFeatures;
        }

        function getDefaultTemplate() {
          let style;
          switch (scope.currentselectfti.typeInfo) {
            case 'POINT':
              style = {
                type: scope.currentselectfti.typeInfo,
                image: {
                  fill: {
                    color: '#ffff00',
                  },
                  radius: 10,
                },
              };
              break;
            case 'LINE':
              style = {
                type: scope.currentselectfti.typeInfo,
                stroke: {
                  color: '#ff8000',
                  width: 5,
                },
              };
              break;
            case 'POLYGON':
              style = {
                type: scope.currentselectfti.typeInfo,
                fill: {
                  color: '#ffff00',
                },
                stroke: {
                  color: '#ff8000',
                  width: 5,
                },
              };
              break;
          }
          return style;
        }

        function getDefaultStyle(styleTemplate) {
          let style;
          switch (styleTemplate.type) {
            case 'POINT':
              switch (styleTemplate.styleChoice) {
                case $filter('translate')('annotations.circle'):
                  style = {
                    image: new ol.style.Circle({
                      radius: styleTemplate.image.radius,
                      fill: new ol.style.Fill({
                        color: styleTemplate.image.fill.color,
                      }),
                    }),
                  };
                  break;
                case $filter('translate')('annotations.icon'):
                {
                  const unicodeindex = scope.fontAwesome.indexOf(
                    styleTemplate.text
                  );
                  const unicode =
                      FontAwesomeFactory.FontAwesomeFactory[unicodeindex].unicode;
                  style = {
                    text: new ol.style.Text({
                      text: String.fromCharCode(
                        unicode.replace('&#x', '0x').replace(';', '')
                      ),
                      font:
                          'normal ' +
                          styleTemplate.image.radius +
                          'px FontAwesome',
                      textBaseline: 'Bottom',
                      fill: new ol.style.Fill({
                        color: styleTemplate.image.fill.color,
                      }),
                    }),
                  };
                }
              }
              break;
            case 'LINE':
              style = {
                stroke: new ol.style.Stroke({
                  color: styleTemplate.stroke.color,
                  width: styleTemplate.stroke.width,
                }),
              };
              break;
            case 'POLYGON':
              style = {
                fill: new ol.style.Fill({
                  color: styleTemplate.fill.color,
                }),
                stroke: new ol.style.Stroke({
                  color: styleTemplate.stroke.color,
                  width: styleTemplate.stroke.width,
                }),
              };
              break;
          }
          return new ol.style.Style(style);
        }
        //GESTION DES CHART DIAGRAMME
        scope.selectChart = { config: {}, data: {} };
        scope.vopenPie = () => {
          // je recupere le geojson que je veux representer
          scope.selectChart.data = SelectManager.getFeaturesByftiType(
            scope.currentselectfti.name
          );
          scope.selectChart.config.ftiUidData = scope.currentselectfti.uid;
          scope.selectChart.config.ftiNameData = scope.currentselectfti.name;
          if (scope.stylepopover) scope.stylepopover.close();
          scope.chartpopover = extendedNgDialog.open({
            template:
              'js/XG/widgets/mapapp/selectFeatureTree/views/panel/popoverChart.html',
            className:
              'ngdialog-theme-plain overflowY width400 nopadding miniclose',
            closeByDocument: false,
            scope: scope,
            title: $filter('translate')('annotations.style'),
            draggable: true,
          });
        };

        scope.styleFunction = (feature) => {
          return [
            new ol.style.Style({
              image: new ol.style.Icon({
                scale: 1,
                src: feature.get('icon'),
              }),
            }),
          ];
        };

        scope.applyCharts = () => {
          ChartLocaliseFactory.datastats(scope.selectChart).then((rdata) => {
            const vectorSource = new ol.source.Vector({
              features: new ol.format.GeoJSON().readFeatures(rdata.data),
            });

            const vectorLayer = new ol.layer.Vector({
              source: vectorSource,
              style: scope.styleFunction,
            });

            scope.map.addLayer(vectorLayer);
          });
        };

        // GESTION DES STYLES
        scope.vopenStyle = () => {
          scope.pointsTypes = [
            $filter('translate')('annotations.circle'),
            $filter('translate')('annotations.icon'),
          ];
          scope.fontAwesome = FontAwesomeFactory.FontAwesomeFactory.map((x) => {
            return x.unicode + ' ' + x.name.replace('fa-', '');
          });
          scope.geoj = SelectManager.getFeaturesByftiType(
            scope.currentselectfti.name
          );
          if (angular.isDefined(scope.geoj.features[0].kiscurrentstyle)) {
            scope.styleTemplate = angular.copy(
              scope.geoj.features[0].kiscurrentstyle
            );
          } else {
            scope.styleTemplate = getDefaultTemplate();
          }
          if (scope.stylepopover) scope.stylepopover.close();
          scope.stylepopover = extendedNgDialog.open({
            template:
              'js/XG/widgets/mapapp/selectFeatureTree/views/panel/popoverStyle.html',
            className:
              'ngdialog-theme-plain overflowY width400 nopadding miniclose',
            closeByDocument: false,
            scope: scope,
            title: $filter('translate')('annotations.style'),
            draggable: true,
          });
        };

        scope.config = {
          fullfilter: {},
        };
        scope.zoomOndata = () => {
          scope.displayAttributesType = {};
          gclayers.clearhighLightFeatures();
          scope.currentselectfti.attributes.map((a) => {
            let fieldType;
            let displayKey = false;

            switch (a.type) {
              case 'java.util.Date':
              case 'java.sql.Timestamp':
              case 'java.sql.Time':
              case 'java.sql.Date':
                fieldType = 'date';
                break;
              case 'java.lang.Double':
              case 'java.lang.Float':
              case 'java.math.BigDecimal':
              case 'java.lang.Integer':
                fieldType = 'number';
                break;
              case 'java.lang.Boolean':
                fieldType = 'boolean';
                break;
              case 'ObjectsArray':
                fieldType = 'ObjectsArray';
                displayKey = a.key;
                break;
              default:
                fieldType = 'string';
                break;
            }

            scope.displayAttributesType[a.name] = {
              type: a.type,
              fieldType: fieldType,
              filterType: a.filterType || 'default',
            };

            if (displayKey) {
              scope.displayAttributesType[a.name].key = displayKey;
            }
          });
          scope.fc = {
            type: 'FeatureCollection',
            features: scope.geoj.features.filter((item) => {
              let showItem = true;

              for (let index in scope.config.fullfilter) {
                const c = scope.config.fullfilter[index],
                  value = c.value,
                  symbol = c.symbol;

                if (value) {
                  if (scope.displayAttributesType[index].fieldType !== 'date') {
                    const cmp = '' + item.properties[index];
                    if (scope.config.case) {
                      if (!Object.prototype.hasOwnProperty.call(item.properties, index)
                        || !cmp.includes(value)) {
                        showItem = false;
                      }
                    } else {
                      if (!Object.prototype.hasOwnProperty.call(item.properties, index) ||
                        !cmp.toLocaleLowerCase().includes(value.toLocaleLowerCase())) {
                        showItem = false;
                      }
                    }
                  } else {
                    const dateCmp = new Date(value);
                    const dateLigne = new Date(item.properties[index]);
                    if (dateCmp.getTime() > 0 && dateLigne.getTime() > 0) {
                      if (symbol === '=')
                        showItem = dateLigne.getTime() === dateCmp.getTime();
                      if (symbol === '>')
                        showItem = dateLigne.getTime() > dateCmp.getTime();
                      if (symbol === '<')
                        showItem = dateLigne.getTime() < dateCmp.getTime();
                      if (symbol === '>=')
                        showItem = dateLigne.getTime() >= dateCmp.getTime();
                      if (symbol === '<=')
                        showItem = dateLigne.getTime() <= dateCmp.getTime();
                      if (symbol === 'between') {
                        const dateMax = new Date(c.valuemax);
                        if (dateMax.getTime() > 0) {
                          showItem =
                            dateLigne.getTime() >= dateCmp.getTime() &&
                            dateLigne.getTime() <= dateMax.getTime();
                        }
                      }
                    }
                  }
                }
              }
              if (showItem) return item;
            }),
          };

          const geojsonreader = new ol.format.GeoJSON();
          const g = geojsonreader.readFeatures(scope.fc);
          const extent = ol.extent.createEmpty();
          g.forEach((feature, index) => {
            ol.extent.extend(extent, feature.getGeometry().getExtent());
            gclayers.addhighLightFeatures(scope.fc.features[index].id);
          });
          scope.map.getView().fit(extent, scope.map.getSize());
        };

        scope.applyFeature = () => {
          const style = getDefaultStyle(scope.styleTemplate);
          const features = gclayers.getselectSource().getFeatures();
          const Ids = scope.geoj.features.map((x) => {
            return x.id;
          });
          SelectManager.getfeatures().features.map((x) => {
            if (Ids.indexOf(x.id) !== -1) {
              x.kiscurrentstyle = angular.copy(scope.styleTemplate);
            }
          });
          features.map((feature) => {
            if (Ids.indexOf(feature.getId()) !== -1) feature.setStyle(style);
          });
        };

        scope.cancelStyle = () => {
          const features = gclayers.getselectSource().getFeatures();
          const Ids = SelectManager.getFeaturesByftiType(
            scope.currentselectfti.name
          ).features.map((x) => {
            delete x.kiscurrentstyle;
            return x.id;
          });
          features.map((feature) => {
            if (Ids.indexOf(feature.getId()) !== -1)
              feature.setStyle(gcStyleFactory.getStyle('select'));
          });
          scope.styleTemplate = getDefaultTemplate();
        };

        /**
         * [vopenStats Ouverture de la page des statistique]
         * @return {nothig} [nothing]
         */
        scope.vopenStats = () => {
          console.log(scope.result);
          const result = scope.result;
          if (result && result.features && result.features.length > 0) {
            result.features.map((f)  =>  {
              if (f && f.id && f.id.indexOf('.') !== -1) {
                const index = FeatureTypeFactory.resources.featuretypes
                  .map((x) =>{
                    return x.name;
                  })
                  .indexOf(f.id.split('.')[0]);
                if (index !== -1) {
                  const fti = FeatureTypeFactory.resources.featuretypes[index];
                  f.uid = fti.uid;
                }
              }
            });
            result.srid = map.getView().getProjection().getCode();
            ChartsFactory.datastats(result).then((res) => {
              scope.resstats = res.data;
              if (scope.resstats.length) {
                scope.resstats = scope.resstats.map((statistic) => {
                  const statisticGeometryType = FeatureTypeFactory.resources.featuretypes.find(
                    (feature) => feature.name === statistic.name
                  ).typeInfo;
                  const toDisplayStatistic = {
                    name: statistic.name,
                    size: statistic.size,
                    type: statisticGeometryType,
                  };
                  switch (statisticGeometryType) {
                    case 'POLYGON':
                      toDisplayStatistic.area =
                      Math.round(statistic.area * 100) / 100 + ' ' + 'm²';
                      toDisplayStatistic.perimeter =
                      Math.round(statistic.perimeter * 100) / 100 + ' ' + 'm';
                      break;
                    case 'LINE':
                      toDisplayStatistic.perimeter =
                      Math.round(statistic.perimeter * 100) / 100 + ' ' + 'm';
                      break;
                  }
                  return toDisplayStatistic;
                });
              }
              extendedNgDialog.open({
                template:
                    'js/XG/widgets/mapapp/selectFeatureTree/views/panel/popoverStatistiques.html',
                className:
                    'ngdialog-theme-plain overflowY width400 nopadding miniclose',
                closeByDocument: false,
                scope: scope,
                title: statis,
                draggable: true,
              });
            });
          }
        };

        scope.openhyperlink = (link) => {
          if (angular.isDefined(link)) {
            window.open(link);
          }
        };

        scope.viewsattachement = (name, fti, feature) => {
          let id = gaJsUtils.getIdInCaseEsriId(feature, fti);
          FeatureAttachmentFactory.getdownloadurl(name, fti.uid, id).then(
            (res) => {
              console.log(res);
              window.open(escape(res.data));
            }
          );
        };

        /**
         * [ContainfeatureClass description]
         * @param {[type]}
         */
        scope.containfeatureClass = (featuretypename) => {
          for (let i = 0, length = scope.featdata.length; i < length; i++) {
            if (scope.featdata[i].label == featuretypename) {
              return true;
            }
            // `chunk` is each member of the array.
          }
          return false;
        };

        //data for datatable
        scope.saveSelect = false;
        scope.openSelect = false;
        scope.collectionList = [];
        scope.selectedCollec = null;
        scope.editmode = false;
        scope.filtertemp = { filter: '' };
        scope.expression = { filter: '' };
        scope.visibleInfo = false;

        scope.openeditmode = () => {
          if (scope.editmode) {
            scope.editmode = false;
          } else {
            scope.editmode = true;
          }
        };

        scope.opengraph = () => {
          console.log(scope.result);
          extendedNgDialog.open({
            template:
              'js/XG/widgets/mapapp/layerManager/views/charts/SelectedCharts.html',
            className:
              'ngdialog-theme-plain overflowY width1000 nopadding miniclose',
            closeByDocument: false,
            scope: scope,
            title: $filter('translate')('layermanager.charts'),
            draggable: true,
          });
        };

        scope.openExpressionUpdate = () => {
          extendedNgDialog.open({
            template:
              'js/XG/widgets/mapapp/selectFeatureTree/views/panel/popoverExpressionUpdate.html',
            className:
              'ngdialog-theme-plain overflowY width400 nopadding miniclose',
            closeByDocument: false,
            scope: scope,
            title: 'Calculatrice Expressions',
            draggable: true,
          });
        };

        scope.updateAttribute = (att) => {

          // KIS-2993: mise à jour d'un attribut restreint (Table ou Domain)
          const attribute = scope.currentselectfti.attributes.find(attr => attr.name === att);
          const hasRestriction = attribute !== undefined && attribute.restrictions.length > 0;

          if (attribute) {
            swal(
              {
                title: $filter('translate')('layermanager.updateAttribute.title'),
                text: $filter('translate')('layermanager.updateAttribute.text1') + attribute.alias
                      + $filter('translate')('layermanager.updateAttribute.text2'),
                type: 'warning',
                showCancelButton: true,
                confirmButtonColor: 'rgb(92, 184, 92)',
                confirmButtonText: $filter('translate')('common.ok'),
                cancelButtonText: $filter('translate')('common.cancel'),
                closeOnConfirm: true,
              },
              (isConfirm) => {
                if (isConfirm) {
                  scope.submitUpdateAttribute(att, hasRestriction);
                }
              });
          } else {
            require('toastr').error(
              $filter('translate')('layermanager.no_attribute_layer')
            );
          }
        };


        /**
         * KIS-3537: code en triple
         * @param att
         * @param hasRestriction
         */
        scope.submitUpdateAttribute = (att, hasRestriction) => {
          const sdata = {
            attribute: att,
            listfid: SelectManager.getFeaturesIdByftiType(scope.currentselectfti.name),
            expression: hasRestriction ? `'${scope.expression.filter}'` : scope.expression.filter,
          };
          console.log(sdata);
          EditFactory.updateexpression(sdata, scope.currentselectfti.uid).then(
            (res) => {
              scope.geoj = res.data;
              SelectManager.updateFeaturesIdByftiType(
                scope.currentselectfti.name,
                res.data
              );
            }
          );
        };

        scope.closepanel = () => {
          gclayers.clearhighLightFeatures();
          console.log('closepanels');
          scope.panelsManager.removePanel('selecttab');
          scope.tabs.activeTab = 0;
        };

        scope.layerdatatable = {};
        scope.vopenTabPanels = () => {
          const geometryExtent = SelectManager.getExtent();
          const ftiSelFeatures = SelectManager.getFeaturesByftiType(
            scope.currentselectfti.name
          );
          if (
            angular.isDefined(geometryExtent) &&
            angular.isDefined(ftiSelFeatures.rTotalFeatures) &&
            ftiSelFeatures.rTotalFeatures > 0
          ) {
            const leftX = geometryExtent[0];
            const bottomY = geometryExtent[1];

            const rightX = geometryExtent[2];
            const topY = geometryExtent[3];

            const exGeomCql =
              'POLYGON((' +
              leftX +
              ' ' +
              bottomY +
              ',' +
              rightX +
              ' ' +
              bottomY +
              ',' +
              rightX +
              ' ' +
              topY +
              ',' +
              leftX +
              ' ' +
              topY +
              ',' +
              leftX +
              ' ' +
              bottomY +
              '))';

            scope.where = 'INTERSECTS(geom, ' + exGeomCql + ')';
          } else {
            scope.where = false;
            scope.geoj = ftiSelFeatures;
            scope.datatableExportCsvInGeoJson = true;
          }
          // the default height of the datatable
          scope.layerdatatable.height = 320;

          scope.ftiForDatatable = angular.copy(scope.currentselectfti);

          scope.datatableInitialWhereClause = scope.whereClause;
          scope.panelsManager.removePanel('selecttab');
          scope.panelsManager.addPanel({
            id: 'selecttab',
            stickToRight: true,
            templateUrl:
              'js/XG/widgets/mapapp/selectFeatureTree/views/panel/popoverDatatable.html',
            scope: scope,
            stickToBorder: true,
            visible: true,
            resizable: true,
          });

          // update table height when element is resized
          $rootScope.$on('elementResized', (event, args) => {
            console.log(event);
            console.log(args);
            if (
              args.element.type == 'panel' &&
              args.element.id == 'selecttab'
            ) {
              const currHeight =
                scope.layerdatatable.height + args.transformation.y;
              $timeout(function () {
                scope.layerdatatable.height = currHeight;
              });
            }
          });
        };

        scope.vsaveSelection = () => {
          if (scope.saveSelect == true) {
            scope.saveSelect = false;
            scope.openSelect = false;
          } else {
            scope.saveSelect = true;
            scope.openSelect = false;
          }
        };

        let refreshCollection = () => {
          return ParametersFactory.getbytype('selection').then((res) => {
            scope.collectionList = res.data;
          });
        };

        scope.vopenSelection = () => {
          if (scope.openSelect == true) {
            scope.openSelect = false;
            scope.saveSelect = false;
          } else {
            refreshCollection().then(() => {
              scope.openSelect = true;
              scope.saveSelect = false;
            });
          }
        };

        /**
         * [saveSelection description]
         * @return {[type]} [description]
         */
        scope.saveSelection = () => {
          // already exist ?
          refreshCollection().then(() => {
            const found = scope.collectionList
              .map((x) => {
                return x.name;
              })
              .indexOf(scope.selectname);

            if (found == -1) {
              ParametersFactory.add(
                SelectManager.getfeatures(),
                'selection',
                scope.selectname
              ).then((res) => {
                scope.selectname = '';
                scope.currentSelection = res.data;
                require('toastr').success($filter('translate')('common.saved'));
                scope.saveSelect = false;
              });
            } else {
              // confirm
              const ans = confirm($filter('translate')('query.confirm_update'));
              if (ans) {
                // update
                ParametersFactory.getbyid(scope.collectionList[found].id).then(
                  (res) => {
                    const newObj = res.data;
                    newObj.data = SelectManager.getfeatures();
                    ParametersFactory.update(newObj, newObj.id).then((res) => {
                      refreshCollection();
                      scope.currentSelection = res.data;
                      require('toastr').success(
                        $filter('translate')('common.saved')
                      );
                      scope.saveSelect = false;
                    });
                  }
                );
              }
            }
          });
        };

        /**
         * [removeSelection description]
         * @return {[type]} [description]
         */
        scope.removeSelection = () => {
          console.log(scope.selectedCollec);

          const ans = confirm(
            $filter('translate')('selectfeaturetree.confirm_delete_selection')
          );
          if (ans) {
            scope.visibleInfo = false;
            scope.tabs.activeTab = 0;
            ParametersFactory.remove(scope.selectedCollec.id).then(function (
              res
            ) {
              scope.vopenSelection();
              scope.selectedCollec = null;
              SelectManager.clear();
              scope.currentselect = null;
              scope.currentselectfti = null;
            });
          }
        };

        scope.openSelection = () => {
          console.log(scope.selectedCollec, 'selectedCollec');
          scope.selectname = scope.selectedCollec.name;
          scope.currentSelection = scope.selectedCollec;
          SelectManager.addFeaturesFromGeojson(scope.selectedCollec.data);

          const features = gclayers.getselectSource().getFeatures();

          const infos = [];
          scope.selectedCollec.data.features.map((x) => {
            if (x.kiscurrentstyle) {
              infos.push({
                id: x.id,
                styleTemplate: x.kiscurrentstyle,
              });
            }
          });
          features.map((feature) => {
            const index = infos
              .map((x) => {
                return x.id;
              })
              .indexOf(feature.getId());
            if (index !== -1) {
              feature.setStyle(getDefaultStyle(infos[index].styleTemplate));
              scope.styleTemplate = infos[index].styleTemplate;
            }
          });
          scope.localiseSelection();
        };

        scope.localise = (feature) => {
          let currentFeature = null;
          if (feature && feature.id) {
            mapJsUtils.localiseData(feature, scope.map);
          } else {
            if (scope.currentselect && scope.currentselect.id) {
              currentFeature = gclayers
                .getselectSource()
                .getFeatureById(scope.currentselect.id);
            }
            if (currentFeature) {
              gaJsUtils.localiseGeom(currentFeature.getGeometry(), scope.map);
            } else {
              if (scope.result && scope.result.features) {
                let id = null;
                if (scope.currentselect && scope.currentselect.id) {
                  id = scope.currentselect.id;
                }
                let idx = scope.result.features
                  .map((x) => {
                    return x.id;
                  })
                  .indexOf(id);
                if (idx > -1) {
                  mapJsUtils.localiseData(
                    scope.result.features[idx],
                    scope.map
                  );
                }
              }
            }
          }
        };

        scope.getfeatureClass = (featuretypename) => {
          for (let i = 0, length = scope.featdata.length; i < length; i++) {
            if (scope.featdata[i].label == featuretypename) {
              return scope.featdata[i];
            }
            // `chunk` is each member of the array.
          }
          return null;
        };

        scope.clear = () => {
          SelectManager.clear();

          scope.objectIsSelected = false;

          scope.currentselect = {};

          scope.currentselectfti = {};
          gclayers.clearhighLightFeatures();
        };

        scope.removeselect = () => {
          SelectManager.removefeatures(scope.currentselect.id);
          scope.currentselect = {};
          scope.objectIsSelected = false;
          gclayers.clearhighLightFeatures();
          $timeout(() => {
            scope.feattree.expand_all();
          });
        };

        scope.getHeader = () => {
          const arrayheaderdata = [];
          angular.forEach(scope.currentselect.properties, (value, key) => {
            arrayheaderdata.push(key);
          });
          return arrayheaderdata;
        };

        scope.localiseSelection = () => {
          const selectedFeatures = scope.result.features;
          if (selectedFeatures) {
            const featuresExtents = [];
            const format = new ol.format.GeoJSON();
            for (let i = 0; i < selectedFeatures.length; i++) {
              const featureGeometry = selectedFeatures[i].geometry;
              featuresExtents.push(featureGeometry);
            }

            GeometryFactory.union(featuresExtents).then((res) => {
              const geometry = format.readGeometry(res.data);
              const extent = geometry.getExtent();
              const dx = extent[2] - extent[0];
              extent[0] -= dx * 0.1;
              extent[2] += dx * 0.1;
              map.getView().fit(extent, map.getSize());
            });
          }
        };

        scope.getattributefti = (name) => {
          for (let i = 0; i < scope.currentselectfti.attributes.length; i++) {
            if (scope.currentselectfti.attributes[i].name == name) {
              return scope.currentselectfti.attributes[i];
            }
          }
          return null;
        };

        /**
         * Rendu de la valeur d'un domaine sur la datatable
         * @param  {obj} att [Définition du fti]
         * @param  {obj} propName [clé de la propriété]
         * @return [string]     [valeur de la clé du domaine]
         */
        scope.renderRestrict = (att, propName) => {
          for (let i = att.restrictions.length - 1; i >= 0; i--) {
            if (propName != undefined)
              if (att.restrictions[i].type == 'Domain') {
                // Récupère l'objet restriction de type Domain
                // Test si plusieurs domaines afin d'être sur qu'il renvoie quelquechose
                if (
                  att.restrictions[i].listofValues != undefined &&
                  att.restrictions[i].listofValues[propName] !== undefined
                )
                  // Renvoi la valeur de la clé recherchée
                  return $filter('translate')(
                    'features.' +
                      scope.currentselectfti.name +
                      '.domaine.' +
                      att.name +
                      '.' +
                      propName
                  ).indexOf('features.') === -1
                    ? $filter('translate')(
                      'features.' +
                          scope.currentselectfti.name +
                          '.domaine.' +
                          att.name +
                          '.' +
                          propName
                    )
                    : att.restrictions[i].listofValues[propName];
              }
          }
          return propName;
        };

        let oldBranch = {};

        scope.selecttype = (branch) => {
          if (JSON.stringify(oldBranch) === JSON.stringify({})) {
            oldBranch = branch;
          } else if (JSON.stringify(oldBranch) != JSON.stringify(branch)) {
            oldBranch.expanded == false;
            scope.visibleInfo = false;
            scope.tabs.activeTab = 0;
            oldBranch = branch;
          }
          if (!branch.expanded) {
            scope.visibleInfo = false;
            scope.tabs.activeTab = 0;
          }
          const oldFtiName = scope.currentselectfti ? scope.currentselectfti.name.slice() : null;

          scope.currentselectfti = gclayers.getOperationalLayerByName(
            branch.data.featuretype
          );

          scope.adjustWidthAfterFtiChange = oldFtiName !== scope.currentselectfti.name;

          scope.hasComponentActions = false;
          scope.hasObjectActions = false;
          const authorizedAttributes = RightsFactory.getUserWriteOrReadRightsAttributes($rootScope.xgos.user, scope.currentselectfti,
            isAdmin, true);
          scope.currentselectfti.attributes = authorizedAttributes;
          scope.configurationTab = false;
          ObjectFilesFactory.getObjectFilesFiltredByAuthorizedAttributes(
            scope.currentselectfti.uid, authorizedAttributes).then(
            res => {
              if (typeof res === 'object' && res != null && res.active) {
                scope.configurationTab = res;
                const popupPanel = elt[0].closest('.popupPanel');
                if (typeof popupPanel.style.minWidth === 'string' && popupPanel.style.minWidth.length > 0) {
                  popupPanel.style.width = popupPanel.style.minWidth;
                } else {
                  popupPanel.style.width = '430px';
                }
              }
            },
            () => {
              console.info('le composant ' + scope.currentselectfti.alias + ' ne possède pas de fiche-objet');
            });

          scope.objectActions = [];
          scope.componentActions = [];
          if (
            scope.currentselectfti &&
            scope.currentselectfti.actions &&
            scope.currentselectfti.actions.length > 0
          ){
            RolesFactory.filterActionsByRoles($rootScope.xgos.user.login, scope.currentselectfti.actions).then(
              res => {
                for (const role of res) {
                  if (role.currentComponent) {
                    scope.componentActions.push(role)
                    scope.hasComponentActions = true;
                  } else {
                    scope.objectActions.push(role);
                    scope.hasObjectActions = true;
                  }
                }
              }
            );
          }

          // @RB @CD
          // on ne permet pas l'utilisation des details d'interventions ici, c'est uniquement depuis les is
          if (scope.objectActions.length) {
            scope.objectActions = scope.objectActions.filter((x) => {
              return x.typeInfo !== 'IS_DETAIL';
            });
          }
          if (!branch.feat) {
            // KIS-2881: au clic sur un groupe on vide la couche highlight
            gclayers.clearhighLightFeatures();
            scope.isFeatureSelected = false;
          }
        };

        scope.attachmentIsImage = (fn) => {
          if (fn == undefined) return false;
          const fnlc = fn.toLowerCase();
          if (fnlc.endsWith('.jpeg')) return true;
          if (fnlc.endsWith('.jpg')) return true;
          if (fnlc.endsWith('.png')) return true;
          if (fnlc.endsWith('.gif')) return true;
          return false;
        };

        /**
         *     Si le nom de fichier en paramètre a une extension connue
         *  de fichier ilmage, on télécharge l'image afin d'en afficher uneminiature.
         *
         */
        scope.loadPicture = (fti, feat, fn) => {
          if (fn != undefined && fn != '' && scope.attachmentIsImage(fn)) {
            FeatureAttachmentFactory.getcontent(
              fn,
              fti.name,
              feat.id,
              'base64;thumbnail'
            ).then((res) => {
              if (res.data != 'fichier inexistant')
                scope.pictures[fn] = 'data:image/jpeg;base64,' + res.data;
            });
          }
        };

        /**
         *     Récupération des images afin de pouvoir
         *  les afficher en tant que miniature.
         */
        scope.loadPictures = (fti, feat) => {
          let iatt, att, picNames, ipicname;

          if (scope.pictures != undefined) delete scope.pictures;
          scope.pictures = {};

          for (iatt = 0; iatt < fti.attributes.length; iatt++) {
            att = fti.attributes[iatt];
            if (feat.properties[att.name] != undefined) {
              if (att.type == 'g2c.attachment')
                scope.loadPicture(fti, feat, feat.properties[att.name]);
              else if (att.type == 'g2c.attachments') {
                picNames = feat.properties[att.name].split(',');
                for (ipicname = 0; ipicname < picNames.length; ipicname++) {
                  if (picNames[ipicname] != '')
                    scope.loadPicture(fti, feat, picNames[ipicname]);
                }
              }
            }
          }
        };

        /**
         * format length output
         * @param {ol.geom.LineString} line
         * @return {string}
         */
        scope.formatLength = (length) => {
          let output;
          if (length > 1000) {
            output = Math.round((length / 100) * 10) / 100 + ' ' + 'km';
          } else {
            output = Math.round(length * 100) / 100 + ' ' + 'm';
          }
          return output;
        };

        /**
         * format length output
         * @param {ol.geom.Polygon} polygon
         * @return {string}
         */
        scope.formatArea = (area) => {
          let output;
          if (area > 10000) {
            output = Math.round((area / 1000000) * 100) / 100 + ' ' + 'km²';
          } else {
            output = Math.round(area * 100) / 100 + ' ' + 'm²';
          }
          return output;
        };

        scope.refreshPage = (branch, page) => {
          console.log(page);
          const npage = page - 1;
          const ftiAlias = branch.data.featuretype;

          const index = FeatureTypeFactory.resources.featuretypes
            .map((x) => {
              return x.name;
            })
            .indexOf(ftiAlias);
          const fti = FeatureTypeFactory.resources.featuretypes[index];

          const geometryExtent = SelectManager.getExtent();

          const leftX = geometryExtent[0];
          const bottomY = geometryExtent[1];

          const rightX = geometryExtent[2];
          const topY = geometryExtent[3];
          const catchments_url =
            '/services/' +
            PortalsFactory.getPortalId() +
            '/ogc/getfeat?service=WFS&version=1.0.0&request=GetFeature&typeName=' +
            fti.uid +
            '&page=' +
            npage +
            '&count=10&outputformat=json&srsName=' +
            scope.map.getView().getProjection().getCode() +
            '&cql_filter=INTERSECTS(geom, POLYGON((' +
            leftX +
            ' ' +
            bottomY +
            ',' +
            rightX +
            ' ' +
            bottomY +
            ',' +
            rightX +
            ' ' +
            topY +
            ',' +
            leftX +
            ' ' +
            topY +
            ',' +
            leftX +
            ' ' +
            bottomY +
            ')))';

          const promise = $http.get(catchments_url);

          promise.then(
            (res) => {
              branch.children = [];
              angular.forEach(res.data.features, (feat) => {
                const pair = getPairFromFeatId(feat.id);
                branch.children.push({
                  label: 'features.' + pair[0] + '.alias ',
                  children: [],
                  data: {
                    properties: feat['properties'],
                    id: feat.id,
                    labelid: pair[1],
                    featuretype: pair[0],
                  },
                  feat: feat,
                  onSelect: scope.selectbranch,
                  onHighlight: scope.hightlightbranch,
                });
              });
              branch.page = npage;
              branch.nPages = generatePagesArray(branch.page, branch.realCount);
            },
            (result) => {
              gcRestrictionProvider.showDetailsErrorMessage(result);
              if (SelectManager.getpop()) {
                try {
                  SelectManager.getpop().destroy();
                } catch (e) {
                  SelectManager.setpop(null);
                }
              }
              if (gclayers.getLayerWFS() != null) {
                map.removeLayer(gclayers.getLayerWFS());
              }

              gclayers.clearhighLightFeatures();
              gclayers.setLayerWFS(null);
              SelectManager.clear();
            }
          );
        };

        let setAttributsDeriveCenter = selectedFeature => {
          if (scope.currentselectfti
            && scope.currentselectfti.typeInfo !== 'POINT') {
            let fea = selectedFeature
              ? selectedFeature
              : gclayers
                .getselectSource()
                .getFeatureById(scope.currentselect.id);
            let selectExtent = fea.getGeometry().getExtent();
            scope.attributsderivecenter = ol.extent.getCenter(selectExtent);
            let f = JSON.parse(new ol.format.GeoJSON().writeFeature(fea));
            if (!f.properties) f.properties = {};
            if (!f.uid) f.uid = scope.currentselectfti.uid;
            const srid = map.getView().getProjection().getCode();
            ChartsFactory.areaperimeter(
              {
                type: 'FeatureCollection',
                features: [f],
                srid: srid,
              },
              true
            ).then((res) => {
              const data = res.data[0];
              let children = [];
              switch (scope.currentselectfti.typeInfo) {
                case 'POLYGON':
                  children = [
                    {
                      label:
                        $filter('translate')('measure.center') +
                        ' ' +
                        '( ' +
                        scope.attributsderivecenter[0] +
                        ' , ' +
                        scope.attributsderivecenter[1] +
                        ' )',
                    },
                    {
                      label:
                        $filter('translate')('measure.tbtooltiparea') +
                        ' ' +
                        Math.round(data.area * 100) / 100 +
                        ' ' +
                        'm²',
                    },
                    {
                      label:
                        $filter('translate')('measure.tbtooltipperimeter') +
                        ' ' +
                        Math.round(data.perimeter * 100) / 100 +
                        ' ' +
                        'm',
                    },
                  ];
                  break;
                case 'LINE':
                  children = [
                    {
                      label:
                        $filter('translate')('measure.center') +
                        ' ' +
                        '( ' +
                        scope.attributsderivecenter[0] +
                        ' , ' +
                        scope.attributsderivecenter[1] +
                        ' )',
                    },
                    {
                      label:
                        $filter('translate')('measure.tbtooltiplength') +
                        ' ' +
                        Math.round(data.perimeter * 100) / 100 +
                        ' ' +
                        'm',
                    },
                  ];
                  break;
              }
              scope.attributsderivedata = [
                {
                  label: $filter('translate')(
                    'selectfeaturetree.attributderive'
                  ),
                  children: children,
                },
              ];
              scope.attributsderivefeattree = {};
            });
          }
          else {
            let fea = selectedFeature
              ? selectedFeature
              : gclayers
                .getselectSource()
                .getFeatureById(scope.currentselect.id);
            if (
              fea &&
              fea.getGeometry() &&
              fea.getGeometry().getCoordinates()
            ) {
              scope.attributsderivecenter = fea.getGeometry().getCoordinates();
              scope.attributsderivedata = [
                {
                  label: $filter('translate')(
                    'selectfeaturetree.attributderive'
                  ),
                  children:  [
                    {
                      label:
                        $filter('translate')('measure.center') +
                        ' ' +
                        '( ' +
                        scope.attributsderivecenter[0] +
                        ' , ' +
                        scope.attributsderivecenter[1] +
                        ' )',
                    },
                  ],
                },
              ];
              scope.attributsderivefeattree = {};
            }
          }
        };

        const isAdmin = $rootScope.xgos.isroot || $rootScope.xgos.isadmin;
        let setCurrentFti = () => {
          scope.currentselectfti = FeatureTypeFactory.resources.featuretypes.find(
            feat => feat.name === scope.currentselect.featuretype);
          const authorizedAttributes = RightsFactory.getUserWriteOrReadRightsAttributes($rootScope.xgos.user,
            scope.currentselectfti, isAdmin, true);
          scope.currentselectfti.attributes = authorizedAttributes;
          scope.configurationTab = false;
          ObjectFilesFactory.getObjectFilesFiltredByAuthorizedAttributes(
            scope.currentselectfti.uid, authorizedAttributes).then(res => {
            if (typeof res === 'object' && res != null && res.active) {
              scope.configurationTab = res;
            }
          });

          //-- Chargement des miniatures des images des pi?ces jointe de type image
          scope.loadPictures(scope.currentselectfti, scope.currentselect);

          // init avant la recupération des association
          scope.associatedValues = [];
          scope.tabs = scope.tabs.filter((tab) => tab.type !== 'association');
          scope.tabs.activeTab = 0;
          scope.selectedAssociation = {};
          // recupérer les associations est ajouté les catégories dans les tabs
          if(gaJsUtils.notNullAndDefined($rootScope.xgos, 'portal.parameters.mainDB')){
            AssociationFactory.getAllAssociatedValues(
              $rootScope.xgos.portal.parameters.mainDB,
              scope.currentselect.id
            ).then(res => {
              scope.associatedValues = res.data;
              Object.keys(scope.associatedValues).forEach(asso => {
                scope.tabs.push({title:asso, type:'association'});
              })
            })
          }

          QueryFactory.relation(
            scope.currentselectfti.uid,
            '*',
            gaJsUtils.getIdInCaseEsriId(scope.currentselect,  scope.currentselectfti, null),
            '',
            undefined,
            undefined,
            scope.map.getView().getProjection().getCode()
          ).then((res) => {
            scope.relatedfeature = res.data;

            // retrieve filterable components
            if (scope.relatedfeature.totalFeatures > 0) {
              scope.relatedfeature.features.forEach((rf) => {
                scope.availableRelatedFeatureIds.push(rf.id.split('.')[0]);
              });

              scope.availableRelatedFeatureIds = gaJsUtils.arrayUnique(
                scope.availableRelatedFeatureIds
              );
            }
          });
          angular.forEach(scope.currentselectfti.relations, (value) => {
            if (value.type == 'REL_WS') {
              let modified_url = value.url;
              angular.forEach(scope.currentselect.properties, (value, key) => {
                let attm = '{' + key + '}';
                modified_url = modified_url.replace(attm, value);
              });
              scope.getWSe(modified_url).then((res) => {
                scope.wsfeature[value.name] = { data: res.data, rel: value };
              });
            }
          });
        };

        // récupération du total des features de la tab
        scope.getTotalAssociation = (tabTitle) => {
          if (scope.associatedValues) {
            let total = 0;
            for (const featureCollection of Object.values(scope.associatedValues[tabTitle])) {
              total += featureCollection.features.length;
            }
            return total;
          }
        };


        scope.selectedRelatedFeature = {};
        /**
         * filterBySelectedRelatedFeature
         * filter relations list by selected component
         */
        scope.filterBySelectedRelatedFeature = (x) => {
          if (scope.selectedRelatedFeature.tpl) {
            return x.id.indexOf(scope.selectedRelatedFeature.tpl) === 0;
          }
          return true;
        };

        scope.selectbranch = (branch) => {
          scope.wsfeature = {};
          scope.relatedfeature = {};
          scope.currentselect = branch.data;
          scope.objectIsSelected = true;
          scope.arraydata = [];
          scope.visibleInfo = true;
          scope.tabs.activeTab = 0;
          scope.arraydata.push(scope.currentselect.properties);

          gclayers.clearhighLightFeatures();
          let selectedFeature;
          if (branch.feat) {
            let format = new ol.format.GeoJSON();
            let copy = gaJsUtils.getCleanFeature(branch.feat);
            selectedFeature = format.readFeature(copy);
            let geom = selectedFeature.getGeometry();
            if (branch.data.crs && branch.data.crs.length != 0) {
              let srsSrc = branch.data.crs.properties.name;
              let srsDst = scope.map.getView().getProjection().getCode();
              if (srsSrc !== srsDst) {
                geom.transform(srsSrc, srsDst);
              }
              gaJsUtils.localiseGeom(geom, scope.map);
            }
            // KIS-2881: highlight feature
            gclayers.addhighLightFeature(selectedFeature);

            // KIS-3830: Il est souhaité pouvoir exécuter également
            // l’action RAPPORT pour chaque objet individuellement
            // dans le cas où elle est proposée sur la portée globale de la sélection
            if (scope.hasComponentActions) {
              scope.objectActions.push(...scope.componentActions.filter(
                  action => action.actionType === $filter('translate')(
                      'model.featuretypes.actions.jasper')));
              scope.hasObjectActions = true;
            }
          }
          scope.isFeatureSelected = !!branch.feat;

          setAttributsDeriveCenter(selectedFeature);
          setCurrentFti();

          if (scope.adjustWidthAfterFtiChange) {
            adjustPopupToObjectFileWidth(10);
          }
        };

        /**
         * Lorsque l'objet sélectionné dans l'arbre fait partie d'un composant pour lequel une fiche-objet existe.
         * Ajuste la largeur de la popup à la largeur paramétrée dans la configuration de la fiche-objet
         * @param tries nombre de tentatives en attendant que l'appel api soit effectué (ObjectFilesFactory.getObjectFilesFiltredByAuthorizedAttributes)
         */
        const adjustPopupToObjectFileWidth = (tries) => {
          const popupPanel = elt[0].closest('.popupPanel');
          scope.adjustWidthAfterFtiChange = false;
          if (typeof scope.configurationTab === 'boolean') {
            if (tries!==0) {
              $timeout(() => {
                adjustPopupToObjectFileWidth(popupPanel, --tries);
              });
            }
          } else if (scope.configurationTab !== undefined
              && Array.isArray(scope.configurationTab.configuration)
              && scope.configurationTab.configuration.length > 0
              && scope.configurationTab.configuration[0].popupWidth > 0
              && scope.configurationTab.configuration[0].popupWidth < window.innerWidth) {
            if (popupPanel) {
              popupPanel.style.width = scope.configurationTab.configuration[0].popupWidth + 'px';
            }
          } else if (typeof popupPanel.style.minWidth === 'string' && popupPanel.style.minWidth.length > 0) {
            popupPanel.style.width = popupPanel.style.minWidth;
          } else {
            popupPanel.style.width = '430px';
          }
        };

        scope.summaryWS = (feat, rel) => {
          let summary = angular.copy(rel.attributeview);
          angular.forEach(feat.properties, (value, key) => {
            const attm = '{' + key + '}';
            summary = summary.replace(attm, value);
          });
          return summary;
        };

        scope.getWSe = (url) => {
          return $http.get('/services/ogc/proxy?url=' + url);
        };

        scope.openlinkWS = (link, feat) => {
          let linkurl = angular.copy(link);
          angular.forEach(feat.properties, (value, key) => {
            const attm = '{' + key + '}';
            linkurl = linkurl.replace(attm, value);
          });

          scope.getWSe(linkurl).then((res) => {
            scope.selectlink = res.data;
            gcPopup.open({
              scope: scope,
              title: relatedFeaturePopUpTitle,
              template: 'js/XG/biz/wshtml/views/' + 'link.html',
              showClose: true,
            });
          });
        };

        scope.openpageWS = (html, feat) => {
          scope.selectWsFeat = feat;
          gcPopup.open({
            scope: scope,
            title: relatedFeaturePopUpTitle,
            template: 'js/XG/biz/wshtml/views/' + html,
            showClose: true,
          });
        };

        scope.viewRelatedFeature = (relatedFeature) => {
          const relatedFeatureFTIName = relatedFeature.id.split('.')[0];
          if (
            FeatureTypeFactory.resources.featuretypes == undefined ||
            FeatureTypeFactory.resources.featuretypes.length == 0
          )
            FeatureTypeFactory.get().then(() => {
              for (
                let i = 0;
                i < FeatureTypeFactory.resources.featuretypes.length;
                i++
              )
                if (
                  FeatureTypeFactory.resources.featuretypes[i].name ==
                  relatedFeatureFTIName
                )
                  scope.relatedFeaturefti =
                    FeatureTypeFactory.resources.featuretypes[i];
            });
          else {
            for (
              let i = 0;
              i < FeatureTypeFactory.resources.featuretypes.length;
              i++
            )
              if (
                FeatureTypeFactory.resources.featuretypes[i].name ==
                relatedFeatureFTIName
              )
                scope.relatedFeaturefti =
                  FeatureTypeFactory.resources.featuretypes[i];
          }
        };

        let relatedFeaturePopUpTitle;
        $translate('selectfeaturetree.relatedFeaturePopUpTitle').then((res) => {
          relatedFeaturePopUpTitle = res;
        }
        );

        scope.relatedFeaturePopups = {}; 
        scope.viewfihelink = (relatedFeature) => {
          scope.viewRelatedFeature(relatedFeature);

          const relatedFeatureId = relatedFeature.id;
          // Si une popup pour ce feature existe déjà, la fermer
          if (scope.relatedFeaturePopups[relatedFeatureId]) {
            scope.relatedFeaturePopups[relatedFeatureId].close();
            delete scope.relatedFeaturePopups[relatedFeatureId];
          }

          // KIS-3689 : Créer un nouveau scope enfant
          const childScope = scope.$new(true);

          // Copier les variables nécessaires
          childScope.relatedFeaturefti = scope.relatedFeaturefti;
          childScope.relatedFeature = relatedFeature;
          const popup = gcPopup.open({
            scope: childScope,
            title: relatedFeaturePopUpTitle,
            template:
              'js/XG/widgets/mapapp/selectFeatureTree/views/relatedFeaturePopUp.html',
            showClose: true,
            minimizeMaximize: true,
            resizable: true,
            width: 'auto',
            height: 'auto',
            className: 'attribute-popup nomaximize',
          });

          // Sauvegarder la popup
          scope.relatedFeaturePopups[relatedFeatureId] = popup;
        };

        let exportPopUpTitle = 'Exporter';
        $translate('selectfeaturetree.exportpopuptitle').then((res) =>{
          exportPopUpTitle = res;
        });

        scope.isGeomFeature = (relatedFeature) => {
          return relatedFeature.geometry !== undefined;
        };

        scope.exportSelection = () =>{
          extendedNgDialog.open({
            template:
              'js/XG/widgets/mapapp/selectFeatureTree/views/dxfExport.html',
            className:
              'ngdialog-theme-plain overflowY width400 nopadding miniclose export-selection',
            closeByDocument: false,
            scope: scope,
            title: exportPopUpTitle,
            draggable: true,
          });
        };

        ActionsManager.setMap(scope.map);

        /*
         * Add Action OUS
         */
        scope.executeAction = () => {
          ActionsManager.executeAction(
            scope.currentselectedActionOnObject,
            scope.objectActions,
            scope.currentselect,
            scope.currentselectfti,
            scope.result,
            scope.relatedfeature, scope
          );
        };

        scope.executeActionOnComponent = () => {
          // -- Espace de travail partagé avec le ActionsManager
          scope.ws = {};
          scope.geoj = SelectManager.getFeaturesByftiType(
            scope.currentselectfti.name
          );
          ActionsManager.executeActionOnComponent(
            scope.currentselectedActionOnComponent,
            scope.componentActions,
            scope.currentselectfti,
            scope.geoj,
            scope.result,
            scope.relatedfeature,
            scope.ws
          );
        };

        scope.currentselectedActionOnComponent = undefined;
        scope.currentselectedActionOnObject = undefined;
        scope.currentselectedActionOnGlobal = undefined;

        scope.validAction = true;
        let watchValidAction = scope.$watch(
          'currentselectedActionOnObject',
          (newval) => {
            if (newval && newval !== '') {
              scope.validAction = false;
              watchValidAction();
            }
          }
        );

        scope.validActionOnComponent = true;
        let watchValidActionOnComponent = scope.$watch(
          'currentselectedActionOnComponent',
          (newval) => {
            if (newval && newval !== '') {
              scope.validActionOnComponent = false;
              watchValidActionOnComponent();
            }
          }
        );

        scope.validActionOnGlobal = true;
        let validateActionOnGlobal = scope.$watch(
          'currentselectedActionOnGlobal',
          (newval) => {
            if (newval && newval !== '') {
              scope.validActionOnGlobal = false;
              validateActionOnGlobal();
            }
          }
        );
        ActionsFactory.getconf().then((res) =>{
          if (res.data.etat === 'fini') {
            scope.globalActions = res.data.data;
            console.info('actions globales chargées');
          }
        });

        scope.executeActionOnGlobal = () =>{
          ActionsManager.executeActionOnGlobal(
            scope.currentselectedActionOnGlobal,
            scope.result
          );
        };

        scope.executeActionOnComponentTable = () =>{
          ActionsManager.executeActionOnComponent(
            scope.currentselectedActionOnComponentTable.value,
            scope.componentActions,
            scope.currentselectfti,
            scope.tableResult.elements,
            scope.result,
            []
          );
        };

        function sortLayersByLabel(layer1, layer2) {
          const index1 = layer1.label;
          const index2 = layer2.label;
          if (index1 == null) return -1;
          else if (index2 == null) return 1;
          else if (index1 < index2) return -1;
          return 1;
        }

        /**
         * Dans le cas de certains noms en provenance de ESRI,
         * le nom de la couche est construit avec des points
         * exemple: sig.reseau.eaua,
         * il faut donc prendre seulement le dernier point
         * comme séparateur (voir expérience avec Nevers).
         */
        const getPairFromFeatId = (featid) => {
          const pair = [];
          if (featid) {
            const iDot = featid.lastIndexOf('.');
            pair.push(featid.substring(0, iDot));
            pair.push(featid.substring(iDot + 1));
          }
          return pair;
        };


        function generatePagesArray(currentPage, totalItems) {
          const pageSize = 10;
          let maxBlocks, maxPage, maxPivotPages, minPage, numPages, pages;
          maxBlocks = 11;
          pages = [];
          numPages = Math.ceil(totalItems / pageSize);
          if (numPages > 1) {
            pages.push({
              type: 'prev',
              number: Math.max(1, currentPage - 1),
              active: currentPage > 1,
            });
            pages.push({
              type: 'first',
              number: 1,
              active: currentPage > 1,
            });
            maxPivotPages = Math.round((maxBlocks - 5) / 2);
            minPage = Math.max(2, currentPage - maxPivotPages);
            maxPage = Math.min(
              numPages - 1,
              currentPage + maxPivotPages * 2 - (currentPage - minPage)
            );
            minPage = Math.max(
              2,
              minPage - (maxPivotPages * 2 - (maxPage - minPage))
            );
            let i = minPage;
            while (i <= maxPage) {
              if (
                (i === minPage && i !== 2) ||
                (i === maxPage && i !== numPages - 1)
              ) {
                pages.push({
                  type: 'more',
                  active: false,
                });
              } else {
                pages.push({
                  type: 'page',
                  number: i,
                  active: currentPage !== i,
                });
              }
              i++;
            }
            pages.push({
              type: 'last',
              number: numPages,
              active: currentPage !== numPages,
            });
            pages.push({
              type: 'next',
              number: Math.min(numPages, currentPage + 1),
              active: currentPage < numPages,
            });
          }
          return pages;
        }

        /**
         * Evenement recuperer sur la selection
         * @param  {[type]}
         * @return {[type]}
         */
        let destroyevent = scope.$on('gcSelectChange', () =>{
          scope.result = {};
          scope.featdata = [];
          scope.result = SelectManager.getfeatures();

          let i = false;
          angular.forEach(scope.result.features, (feat) =>{
            //-var pair = feat.id.split(".");
            var pair = getPairFromFeatId(feat.id);
            if (!i) {
              scope.currentselect = {};
              // gclayers.addhighLightFeatures(feat.id);
            }
            const fti = FeatureTypeFactory.getFeatureByName(pair[0]);
            i = true;
            //Si il exite deja
            if (scope.containfeatureClass('features.' + pair[0] + '.alias ')) {
              scope
                .getfeatureClass('features.' + pair[0] + '.alias ')
                ['children'].push({
                  label: QueryFactory.getObjectId(feat, fti),
                  children: [],
                  data: {
                    properties: feat['properties'],
                    id: feat.id,
                    labelid: pair[1],
                    featuretype: pair[0],
                  },
                  feat: feat,
                  onSelect: scope.selectbranch,
                  onHighlight: scope.hightlightbranch,
                });
            } else {
              //Si il n'existe pas
              const rootFTreeItem = {
                label: 'features.' + pair[0] + '.alias ',
                onSelect: scope.selecttype,
                data: { featuretype: pair[0] },
                children: [],
              };

              if (
                angular.isDefined(scope.result.realTotalFeatures) &&
                angular.isDefined(scope.result.realTotalFeatures[pair[0]]) &&
                scope.result.realTotalFeatures[pair[0]] > 10
              ) {
                rootFTreeItem.page = 0;
                var realCount = scope.result.realTotalFeatures[pair[0]];
                rootFTreeItem.realCount = realCount;
                rootFTreeItem.pages = Math.ceil(realCount / 10);
                rootFTreeItem.canUsePages = true;
                rootFTreeItem.onRefreshPage = scope.refreshPage;
                rootFTreeItem.nPages = generatePagesArray(0, realCount);
              }

              scope.featdata.push(rootFTreeItem);

              rootFTreeItem['children'].push({
                label: 'features.' + pair[0] + '.alias ',
                children: [],
                data: {
                  properties: feat['properties'],
                  id: feat.id,
                  labelid: pair[1],
                  featuretype: pair[0],
                },
                onSelect: scope.selectbranch,
                onHighlight: scope.hightlightbranch,
              });
            }
          });

          if (scope.featdata && scope.featdata.length > 0)
            scope.featdata.map((x) =>{
              if (x && x.children && x.children.length > 0) {
                x.children = x.children.sort(sortLayersByLabel);
              }
            });
        });


        /**
         * Affiche l'identifiant d'une feature en fonction du cas
         * - esri avec configuration du champ identifiant:
         *   <code>'fti.name' + '.' + 'id'</code>
         * - esri sans configuration du champ identifiant:
         *   <code>'fti.name' + '.' + 'objectid'</code>
         * - autres cas:
         *   <code>'fti.name' + '.' + 'fid'</code>
         *
         * @param {*} feat : feature dont on veut afficher l'identifiant
         * @returns : valeur de l'identifiant
         */
        scope.getIdOf = (feat) => {
          const pair = getPairFromFeatId(feat.id);
          const fti = FeatureTypeFactory.getFeatureByName(pair[0]);
          return gaJsUtils.getIdInCaseEsriId(feat, fti);
        };

        /**
         * A chaque mouvement de souris au-dessus de la boîte d'informations,
         * recalcule la hauteur du conteneur du tableau des attributs.<br>
         * La boîte d'information a une mise en page figée qui empêche d'affecter des règles CSS simples aux éléments HTML
         * pour maintenir un tableau d'attributs redimensionnable et inclus dans la hauteur de la popup.<br>
         * Modifie le style inline de la div principale de la directive
         * KIS-2987
         */
        scope.getTemplateHeight = () => {

          const titlebarHeight = 44;
          const popupVerticalPadding = 30;
          const expandedPopupMinHeight = '550px';

          const popupPanel = elt[0].closest('.popupPanel');

          if (popupPanel) {
            // hauteur fixe de la barre de titre = 44px
            // hauteur fixe du padding haut/bas = 30px
            const maxHeight = popupPanel.clientHeight - titlebarHeight - popupVerticalPadding;

            const directiveTemplate = elt[0].children[0];

            // partie haute de la popup (barre de boutons + feature-tree)
            const firstPart = directiveTemplate.querySelector('.selectedfeaturetree');

            if (scope.isFeatureSelected) {

              // additionne les hauteurs des éléments de la popup à l'exception du conteneur de la table des attributs
              // on doit tenir compte de la marge supérieure du conteneur de la table des attributs
              let heightSum = 0;

              // calcule la hauteur de la partie haute de la popup
              if (firstPart) {
                heightSum += firstPart.clientHeight;
              }

              // calcule la hauteur du gestionnaire d'action au bas de la popup
              const thirdPart = directiveTemplate.querySelector('div.row.action-row');
              if (thirdPart) {
                const thirdPartStyle = $window.getComputedStyle(thirdPart);
                const marginTop = Number.isNaN(Number.parseInt(thirdPartStyle.marginTop)) ? 0 : Number.parseInt(thirdPartStyle.marginTop);
                heightSum += thirdPart.clientHeight + marginTop;
              }

              // modification de la hauteur du tableau
              const secondPart = directiveTemplate.querySelector('div.selected-feature-desc');
              if (secondPart) {

                // calcule la valeur de la marge supérieure du conteneur de la table
                const secPartStyle = $window.getComputedStyle(secondPart);
                const marginTop = Number.isNaN(Number.parseInt(secPartStyle.marginTop)) ? 0 : Number.parseInt(secPartStyle.marginTop);
                heightSum += marginTop;

                const secondPartHeight = Number.isNaN(Number.parseInt(secPartStyle.height)) ? 0 : Number.parseInt(secPartStyle.height);

                // valeur du dépassement vertical du conteneur de la table par rapport à la taille de la popup
                const heightDifference = maxHeight - (secondPartHeight + heightSum);

                if (heightDifference !== 1) {
                  if (scope.configurationTab) {
                    // en mode fiche-objet
                    // ou ajoute/retire à la hauteur de l'onglet la différence entre la hauteur de l'onglet et la hauteur de la popup
                    const attributesTable = directiveTemplate.querySelector('div.objectFiles-tabs');
                    if (attributesTable) {
                      const tabContent = attributesTable.querySelector('div.tab-content');
                      if (tabContent) {
                        const newTabHeight = tabContent.clientHeight + heightDifference;
                        tabContent.style.height = newTabHeight + 'px';
                      }
                    }
                  } else {
                    // en mode classique (quand aucune fiche-objet n'est configurée pour le composant)
                    // on ajoute/retire à la hauteur de la table des attributs la différence entre la hauteur de la table et la hauteur de la popup
                    // on effectue la même opération pour le conteneur de la table des attributs
                    const attributesContainer = directiveTemplate.querySelector('.no-configuration-tabs');
                    if (attributesContainer) {
                      const newContainerHeight = attributesContainer.clientHeight + heightDifference;
                      attributesContainer.style.height = newContainerHeight + 'px';

                      const attributesTable = attributesContainer.children[0];
                      if (attributesTable) {
                        attributesTable.style.height = newContainerHeight + 'px';
                      }
                    }
                  }
                }
              }

              if (!scope.isPopupExpanded) {
                // on fixe à ce moment une hauteur minimale à la popup pour ne pas l'appliquer lorsqu'aucun objet est sélectionné dans l'arbre
                popupPanel.style.minHeight = expandedPopupMinHeight;
              }
              scope.isPopupExpanded = true;

            } else {
              if (scope.isPopupExpanded) {

                // isFeatureSelected = false
                // après sélection d'un objet
                // au clic sur la ligne d'un groupe
                popupPanel.style.height = 'unset';
                popupPanel.style.minHeight = 'unset';
                scope.isPopupExpanded = false;

              } else {
                // aucun objet n'a encore été sélectionné
                let popupMinHeight = 44;
                if (firstPart) {
                  const panelBody = firstPart.closest('.panel-body');
                  if (panelBody) {
                    const { paddingTop, paddingBottom } = window.getComputedStyle(panelBody);
                    popupMinHeight += firstPart.clientHeight + parseFloat(paddingTop) + parseFloat(paddingBottom);
                  }
                }
                popupPanel.style.minHeight = popupMinHeight + 'px';
              }
            }
          }

          // KIS-3316: Widget "Boîte d'information"
          const widget = document.getElementById('tool');
          if (widget) {
            const widgetContainer = widget.closest('.mapMenuWrapper');
            if (widgetContainer) {

              // Hauteur du titre de la catégorie
              const categoryTitleHeight = 50;

              // marges des différents éléments
              const margins = 40;

              // taille maximale du panel du widget
              const widgetContainerHeight = widgetContainer.clientHeight;

              // hauteur du titre du widget
              const widgetTitleHeight = widgetContainer.querySelector('.xtool:not(.toHide)').firstElementChild.offsetHeight;

              // boutons du widget
              const widgetButtons = widgetContainer.querySelector('.selectedfeaturetree');
              if (widgetButtons) {
                const widgetButtonsHeight = widgetButtons.clientHeight;

                // arbre des objets sélectionnés
                const tree = widgetContainer.querySelector('ul.abn-tree');
                if (tree) {
                  tree.style.maxHeight = widgetContainerHeight - margins - categoryTitleHeight - widgetTitleHeight - widgetButtonsHeight + 'px';
                  tree.style.overflowY = 'auto';
                }
              }
            }
          }
        };


        scope.$on('$destroy', () => {
          destroyevent(); // remove listener.
        });

        scope.featdata = [];

        let i = false;
        angular.forEach(scope.result.features, function(feat) {
          let pair = getPairFromFeatId(feat.id);
          if (!i) {
            scope.currentselect = {};
          }
          i = true;
          const fti = FeatureTypeFactory.getFeatureByName(pair[0]);
          if (fti && Array.isArray(fti.attributes)) {
            pair = getPairFromFeatId(feat.id);
          } else {
            console.error('no fti found for featId : ' + feat.id);
          }
          //Si il exite deja
          if (scope.containfeatureClass('features.' + pair[0] + '.alias ')) {
            scope
              .getfeatureClass('features.' + pair[0] + '.alias ')['children']
              .push({
                label: QueryFactory.getObjectId(feat, fti),
                children: [],

                data: {
                  properties: feat['properties'],
                  id: feat.id,
                  labelid: '',
                  featuretype: pair[0],
                  crs: scope.result.crs,
                },
                feat: feat,
                onSelect: scope.selectbranch,
                onHighlight: scope.hightlightbranch,
              });
          } else {
            //Si il n'existe pas
            const rootFTreeItem = {
              label: 'features.' + pair[0] + '.alias ',
              onSelect: scope.selecttype,
              data: { featuretype: pair[0] },
              children: [],
            };

            if (
              angular.isDefined(scope.result.realTotalFeatures) &&
              angular.isDefined(scope.result.realTotalFeatures[pair[0]]) &&
              scope.result.realTotalFeatures[pair[0]] > 10
            ) {
              rootFTreeItem.page = 0;
              const realCount = scope.result.realTotalFeatures[pair[0]];
              rootFTreeItem.realCount = realCount;
              rootFTreeItem.pages = Math.ceil(realCount / 10);
              rootFTreeItem.canUsePages = true;
              rootFTreeItem.onRefreshPage = scope.refreshPage;
              rootFTreeItem.nPages = generatePagesArray(0, realCount);
            }

            scope.featdata.push(rootFTreeItem);
            rootFTreeItem['children'].push({
              label: QueryFactory.getObjectId(feat, fti),
              children: [],
              data: {
                properties: feat['properties'],
                id: feat.id,
                labelid: '',
                featuretype: pair[0],
                crs: scope.result.crs,
              },
              feat: feat,
              onSelect: scope.selectbranch,
              onHighlight: scope.hightlightbranch,
            });
          }
        });
        if (scope.featdata && scope.featdata.length > 0)
          scope.featdata.map((x) => {
            if (x && x.children && x.children.length > 0) {
              x.children = x.children.sort(sortLayersByLabel);
            }
          });
        if (scope.result.totalFeatures === 1) {
          $timeout(() => {
            console.log('ICIC');
            scope.feattree.expand_all();
            scope.feattree.select_first_branch();
            scope.feattree.select_next_branch();
          });
        }

        /**
         * Zoom sur la sélection
         */
        scope.zoomAll = () => {
          const extent = SelectManager.getExtent();
          scope.map.getView().fit(extent, scope.map.getSize());
        };
      },
    };
  };

  selectfeaturetreewidget.$inject = [
    '$http',
    'extendedNgDialog',
    'ParametersFactory',
    'EditFactory',
    'SelectManager',
    'gclayers',
    'QueryFactory',
    '$translate',
    'GeometryFactory',
    'gcPopup',
    'FeatureTypeFactory',
    'ChartsFactory',
    '$filter',
    '$timeout',
    '$rootScope',
    'FeatureAttachmentFactory',
    'gcStyleFactory',
    'FontAwesomeFactory',
    'ActionsFactory',
    'gaJsUtils',
    'ChartLocaliseFactory',
    'ActionsManager',
    'gcRestrictionProvider',
    'mapJsUtils',
    'RolesFactory',
    'RightsFactory',
    'AssociationFactory',
    'PortalsFactory',
    'ObjectFilesFactory',
    '$window'
  ];
  return selectfeaturetreewidget;
});
