'use strict';
define(function() {
  var toolbarselecttool = function(
    gcStyleFactory,
    $http,
    SelectManager,
    gclayers,
    gcPopup,
    $filter,
    gcRestrictionProvider,
    gcInteractions,
    $rootScope,
    gaJsUtils,
    PortalsFactory,
    gaDomUtils,
    ogcFactory
  ) {
    return {
      templateUrl:
        'js/XG/widgets/mapapp/selecttool/views/toolbarselecttool.html',

      restrict: 'AZE',

      link: function(scope, element) {
        var map = scope.map;
        var dragBoxStyle = gcStyleFactory.getStyle('selectrectangle');
        var collection = new ol.Collection();
        scope.altKeyPressed = false;

        scope.$on('closeToolsBar_toolbarselecttool', () => {
          if (scope.dragBox.getActive()) {
            deactivate();
          }
        });

        //                var btnElt = $(element.children()[0]);
        var btnElt = $(element[0]);

        btnElt.bind('click', () => {
          if (scope.dragBox.getActive()) {
            deactivate();
          } else {
            activate();
          }
        });

        const activate = () => {
          gcInteractions.setCurrentToolBar(scope.toolBarWidget);
          scope.isActive = true;
          scope.dragBox.setActive(true);
          map.addInteraction(scope.dragBox);
          if (scope.toolbarInfo){
            scope.toolbarInfo.setActiveBtn('toolbarselecttool');
          }
        }
        
        const deactivate = () => {
          scope.dragBox.setActive(false);
          scope.isActive = false;
          map.removeInteraction(scope.dragBox);
          if (scope.toolbarInfo){
            scope.toolbarInfo.setActiveBtn(undefined);
          }
        }
        scope.dragBox = new ol.interaction.DragBox({
          condition: function(evt) {
            //console.log(evt.originalEvent.altKey);
            scope.altKeyPressed = evt.originalEvent.ctrlKey;
            //MacEnvironments don't get here because the event is not
            //recognized as mouseEvent on Mac by the google closure.
            //We have to use the apple key on those devices
            return evt.originalEvent.ctrlKey || scope.dragBox.getActive();
          },
          style: dragBoxStyle,
        });

        scope.dragBox.set('gctype', 'kis');
        scope.dragBox.set('interaction', 'Select');
        scope.dragBox.set('widget', 'select');
        scope.dragBox.setActive(false);
        scope.dragBox.on('boxstart', function(evt) {
        });

        scope.dragBox.on('boxend', function(evt) {
          // URL de rcup des objets
          // var filter = gclayers.getSelectFilterasString("name");
         // var filter = "kis_station_alertes";
          const filter = gclayers.getSelectFilterasStringuid(map);

          if (filter !== '') {

            const geometryExtent = scope.dragBox.getGeometry().getExtent();
            const srid = map.getView().getProjection().getCode();

            gaDomUtils.showGlobalLoader();
            ogcFactory.findIntersectedFeaturesByRectangle(geometryExtent, srid, filter).then(
              function(res) {
                gaJsUtils.prepareThingsWhenNewSelection(
                  scope,
                  SelectManager,
                  res
                );
                if (res.data.totalFeatures === 0) {
                  gclayers.clearhighLightFeatures();
                  SelectManager.clear();
                  require('toastr').error(
                      $filter('translate')('layermanager.no_selectable_layer')
                  );
                } else {
                  SelectManager.addFeaturesFromGeojson(res.data);
                  var newScope = $rootScope.$new();
                  newScope.map = scope.map;
                  newScope.panelsManager = scope.panelsManager;
                  // masque l'affichage du label.id dans la boite d'information
                  newScope.displayLabel = false;
                  var pop = gcPopup.open({
                    scope: newScope,
                    title: 'Informations : ',
                    content: '<div selectfeaturetreewidget></div>',
                    showClose: true,
                    minimizeMaximize: true,
                    resizable: true,
                    minWidth: 430,
                    className: 'no-default-height',
                    onclose: function() {
                      SelectManager.clear();
                    },
                  });
                  gclayers
                  .getDrawLayer()
                  .getSource()
                  .clear();
                  SelectManager.setpop(pop);
                }
                gclayers
                .getDrawLayer()
                .getSource()
                .clear();
              },
              function(result) {
                gcRestrictionProvider.showDetailsErrorMessage(result);
                if (SelectManager.getpop()) {
                  try {
                    if (SelectManager.getpop().element) {
                      SelectManager.getpop().destroy();
                    }
                    if (SelectManager.getpop().scope) {
                      SelectManager.getpop().scope.$broadcast('$destroy');
                    }
                  } catch (e) {
                    SelectManager.setpop(null);
                  }
                }
                gclayers.clearhighLightFeatures();
                gclayers
                  .getDrawLayer()
                  .getSource()
                  .clear();
                SelectManager.clear();
              }
            ).finally(() => {
              gaDomUtils.hideGlobalLoader();
            })
          } else {
            require('toastr').error(
              $filter('translate')('layermanager.no_selectable_layer')
            );
          }
        });
      },
    };
  };

  toolbarselecttool.$inject = [
    'gcStyleFactory',
    '$http',
    'SelectManager',
    'gclayers',
    'gcPopup',
    '$filter',
    'gcRestrictionProvider',
    'gcInteractions',
    '$rootScope',
    'gaJsUtils',
    'PortalsFactory',
    'gaDomUtils',
    'ogcFactory'
  ];
  return toolbarselecttool;
});
