'use strict';
define(function() {
  var gcsimpleintervwidget = function(
      gclayers,
      $http,
      SelectManager,
      GeometryFactory,
      EditFactory,
      gaJsUtils,
      PortalsFactory
  ) {
    return {
      templateUrl:
        'js/XG/widgets/mapapp/simpleIntervention/views/gcsimpleintervwidget.html',

      restrict: 'A',

      link: function(scope) {
        var map = scope.map;

        //config
        scope.featureid = '00cbb49f-6f8f-435a-a2eb-acb9f323825b';
        scope.relatedfeatureid = ['adaf7b35-84c3-4a7d-98db-ee1d20bbbdf5'];
        scope.selecttool = ['Network', 'SelectFeature'];
        //
        //  Selection courante
        scope.currentselect = {};
        scope.intervFeature = {};
        //le feature de l'intervention
        scope.currentfti = {};
        scope.relatedfti = [];
        //les feature a mettre en relation
        scope.relatedFeature = [];
        //SearchView
        scope.searchView = {
          fields: [
            { name: 'name', operand: 'like' },
            { name: 'domanialit', operand: '=' },
          ],
        };
        scope.searchAttribute = [];
        scope.searchparam = {};
        scope.whereclause = '';
        //
        scope.createView = {};

        scope.updateView = {};
        scope.mode = '';
        //UI
        scope.tabs = [
          { title: 'Recherche' },
          { title: 'Ajouter' },
          { title: 'Saisie' },
        ];
        scope.tabs.activeTab = 0;

        scope.relatedfeatureid.forEach(function(g) {
          scope.relatedfti.push(gclayers.getOperationalLayerById(g));
        });
        scope.currentfti = gclayers.getOperationalLayerById(scope.featureid);
        scope.currentfti.attributes.forEach(function(att) {
          var index = scope.searchView.fields //scope.searchView.fields.indexOf(att.name);
            .map(function(x) {
              return x.name;
            })
            .indexOf(att.name);
          if (index != -1) {
            scope.searchAttribute.push(att);
          }
        });
        // Save de la nouvelle intervention
        scope.save = function() {
          var data = angular.copy(scope.templatefeatcollect);
          data.features.push(scope.intervFeature); //format.writeFeatures(ft);
          var promiseadd = EditFactory.add(scope.featureid, data).then(function(
            res
          ) {
            if (res.data.create.length == 1) {
              console.log(Object.keys(res.data.create[0].id));
              scope.intervFeature.id = res.data.create[0].id;
            }
          });
          // les relations

          promiseadd.then(function() {
            scope.currentfti.relations.forEach(function(r) {
              var data = angular.copy(scope.templatefeatcollect);
              scope.relatedFeature.features.forEach(function(feat) {
                data.features.push(feat);
              });
              console.log(data);
              let id = gaJsUtils.getIdInCaseEsriId(scope.intervFeature,scope.currentfti);
              EditFactory.r_add(data, scope.currentfti.uid, id, r.name).then(
                (res) => {
                  console.log(res.data);
                });
            });
          });
        };
        // creation dynamique de la where clause
        scope.$watch(
          function() {
            return scope.searchparam;
          },
          function(data) {
            scope.whereclause = '';
            scope.searchView.fields.forEach(function(f) {
              if (
                !angular.isUndefined(scope.searchparam[f.name]) &&
                !scope.searchparam[f.name] == ''
              ) {
                scope.whereclause =
                  scope.whereclause +
                  f.name +
                  ' ' +
                  f.operand +
                  ' ' +
                  scope.searchparam[f.name] +
                  ' AND ';
              }
            });
            scope.whereclause = scope.whereclause.substr(
              0,
              scope.whereclause.length - 5
            );
          },
          true
        );
        //Ajout d'une nouvelle Intervention
        scope.add = function() {
          // passage à l'active table
          scope.tabs.activeTab = 1;
          scope.mode = 'add';
          scope.intervFeature = scope.templatefeat;
        };
        //Recherche via ECQL de l'intervention
        scope.search = function() {
          var cql = '';
          if (scope.whereclause != '') {
            cql = '&CQL_FILTER=' + scope.whereclause;
          }

          var catchments_url =
            '/services/' +
            PortalsFactory.getPortalId() +
            '/geoserver/ows?service=WFS&version=1.0.0&request=GetFeature&typeName=' +
            scope.currentfti.name +
            '&outputformat=json&srsName=' +
            map
              .getView()
              .getProjection()
              .getCode() +
            cql;

          var promise = $http.get(catchments_url);
          promise.then(function(res) {
            scope.currentselect = res.data;
            SelectManager.addFeaturesFromGeojson(res.data);
          });
        };
        // Calcul du buffer
        scope.generatebuffer = function() {
          var geom = [];
          scope.relatedFeature.features.forEach(function(f) {
            geom.push(f.geometry);
          });
          GeometryFactory.unionandbuffer(geom, 'ROUND', 5).then(function(res) {
            if (scope.intervFeature == {}) {
              scope.intervFeature = scope.templatefeat;
            }
            scope.intervFeature.geometry = res.data;
            scope.tabs.activeTab = 2;
            console.log(res.data);

            var vector_source = gclayers.getDrawLayer().getSource();
            var parser = new ol.format.GeoJSON();
            vector_source.addFeature(parser.readFeature(scope.intervFeature));
          });
        };
        scope.locate = function(feature) {
          var f = gclayers.getselectSource().getFeatureById(feature.id);

          var extent = f.getGeometry().getExtent();
          map.getView().fit(extent, map.getSize());
        };
        scope.edit = function(feature) {
          scope.tabs.activeTab = 2;
          scope.mode = 'update';
          scope.intervFeature = feature;
        };

        scope['delete'] = function() {};
        scope.templatefeat = {
          type: 'Feature',
          id: 'newid',
          geometry: {},
          geometry_name: 'geom',
          properties: {},
        };

        scope.templatefeatcollect = {
          type: 'FeatureCollection',
          features: [],
        };

        /* ConfigFactory.get('simpleintervention',"test").then(function(res)
          {
            if (!res.data == "")
            {
              alert(res.data);
            }
          });*/
      },
    };
  };

  gcsimpleintervwidget.$inject = [
    'gclayers',
    '$http',
    'SelectManager',
    'GeometryFactory',
    'EditFactory',
    'gaJsUtils',
    'PortalsFactory'
  ];
  return gcsimpleintervwidget;
});
