'use strict';
define(function() {
  var sldlinesymbolizer = function(sldUtils, $rootScope, $timeout) {
    return {
      templateUrl:
        'js/XG/widgets/mapapp/style/views/symbolizer/sldlinesymbolizer.html',
      restrict: 'A',
      scope: {
        component: '=component',
        fti: '=fti',
        rules: '=rules',
        ruletypepossibilities: '=ruletypepossibilities',
        selectsymbol: '=selectsymbol',
        selectedcomponent: '= selectedcomponent',
      },
      link: function(scope) {
        // Simple line or line of symbols ?
        scope.lineType = sldUtils.getSubTypeOfSymbolizer(
          'LINE',
          scope.component
        );
        scope.selectedComponent = { index: 0 };
        console.log(scope.component, scope.lineType);

        scope.$watch('position.distance', function(distance) {
          if (angular.isNumber(distance)) {
            // wont work if multiple css parameters, careful
            scope.component.Stroke.CssParameter.__text =
              scope.position.size + ' ' + distance;
          }
        });

        scope.$watch('lineType', function(type) {
          if (type == 'line-symbols') {
            scope.symbol = true;
          } else {
            scope.symbol = false;
          }
        });

        scope.lineCapOptions = [
          {
            key: 'butt',
            label: 'model.styles.editor.symbolizers.line.linecap.butt',
          },
          {
            key: 'round',
            label: 'model.styles.editor.symbolizers.line.linecap.round',
          },
          {
            key: 'square',
            label: 'model.styles.editor.symbolizers.line.linecap.square',
          },
        ];
        scope.lineJoinOptions = [
          {
            key: 'round',
            label: 'model.styles.editor.symbolizers.line.linejoin.round',
          },
          {
            key: 'bevel',
            label: 'model.styles.editor.symbolizers.line.linejoin.bevel',
          },
        ];

        if (scope.selectedcomponent) {
          /**
           * When the user select another rule
           */
          scope.$watch(
            function() {
              var index0 = scope.selectedcomponent.index;
              var lastIndex = parseInt(index0.charAt(index0.length - 1));
              scope.selectedComponent.index = lastIndex;
            },
            function(symbol) {
              if (symbol) {
                scope.component.symbolType = sldUtils.getSubTypeOfSymbolizer(
                  scope.selectsymbol.type,
                  symbol
                );
              }
            }
          );
        }

        /**
         * switchRuleSymbolType
         */
        scope.switchRuleSymbolType = function() {
          scope.cpt++;
          sldUtils
            .switchRuleSymbolType(scope.component.symbolType)
            .then(function(newRule) {
              var index0 = scope.selectedcomponent.index;
              var lastIndex = parseInt(index0.charAt(index0.length - 1));
              var firstIndex = parseInt(index0.charAt(0));
              scope.selectedComponent.index = lastIndex;
              scope.lineType = sldUtils.getSubTypeOfSymbolizer(
                'LINE',
                scope.component
              );
              scope.rules[firstIndex][scope.selectsymbol.type][
                scope.selectedComponent.index
              ] = newRule[scope.selectsymbol.type][0];
              var data = {
                index: lastIndex,
                rule: 0,
                type: 'LineSymbolizer',
              };
              //$timeout(function() {
              var component = scope.component;
              $rootScope.$broadcast('refresh_selected_component', {
                coord: data,
                cmp: component,
              });
              //}, 100);
              //console.log(scope.rules);
            });
        };
      },
    };
  };

  sldlinesymbolizer.$inject = ['sldUtils', '$rootScope', '$timeout'];
  return sldlinesymbolizer;
});
