'use strict';
define(function() {
  var What3WordFactory = function($http, $rootScope) {
    var apiKeyW3W = '';
    if (
      $rootScope.xgos.portal &&
      $rootScope.xgos.portal.parameters &&
      $rootScope.xgos.portal.parameters.apikey &&
      $rootScope.xgos.portal.parameters.apikey.what3words
    ) {
      apiKeyW3W = $rootScope.xgos.portal.parameters.apikey.what3words;
    } else {
      apiKeyW3W = '';
    }
    var What3WordFactory = {};

    function autoSuggest(input) {
      var lang;
      if (localStorage.getItem('current_language') == null) {
        lang = 'fr';
      } else {
        lang = localStorage.getItem('current_language');
      }

      var promise = $http.get(
        'https://api.what3words.com/v2/autosuggest?addr=' +
          input +
          '&display=full&format=geojson&key=' +
          apiKeyW3W +
          '&lang=' +
          lang +
          '&display=full'
      );

      return promise;
    }

    /**
     * Function: get
     */
    function search(first, second, third) {
      var lang;
      if (localStorage.getItem('current_language') == null) {
        lang = 'fr';
      } else {
        lang = localStorage.getItem('current_language');
      }

      var promise = $http.get(
        'https://api.what3words.com/v2/forward?addr=' +
          first +
          '.' +
          second +
          '.' +
          third +
          '&display=full&format=geojson&key=' +
          apiKeyW3W +
          '&lang=' +
          lang +
          '&display=full'
      );

      return promise;
    }
    /**
     * Function: get
     */
    function reverse(coords) {
      var lang;
      if (localStorage.getItem('current_language') == null) {
        lang = 'fr';
      } else {
        lang = localStorage.getItem('current_language');
      }
      var promise = $http.get(
        'https://api.what3words.com/v2/reverse?coords=' +
          coords[1] +
          ',' +
          coords[0] +
          '&lang=' +
          lang +
          '&display=full&format=json&key=' +
          apiKeyW3W
      );

      return promise;
    }

    return {
      What3WordFactory: What3WordFactory,
      search: search,
      reverse: reverse,
      autoSuggest: autoSuggest,
    };
  };
  What3WordFactory.$inject = ['$http', '$rootScope'];
  return What3WordFactory;
});
