'use strict';
define(function() {
  var listeDataCarte = function(
    AlertHpoFactory,
    FeatureTypeFactory,
    HpoCarteAppFactory,
    $window,
    EditFactory,
    $rootScope,
    $filter,
    ngDialog,
    $timeout,
    ParametersFactory,
    gaDomUtils,
    HpoAppServices,
    ImportExportFactory,
    authFactory
  ) {
    return {
      templateUrl:
        'js/XG/widgets/mapappv2/home_admin_data/views/directives/liste_data_carte.html',
      restrict: 'EA',
      scope: {
        fti: '=?',
        res: '=?',
        hideCrud: '=?',
        showAdvancedFilter: '=?',
        showToastr: '=?',
        operands: '=?',
        useOperands: '=?',
        listedata: '=',
        fixedheader: '=?',
        autoadjustheight: '=?',
        attributesSelected: '=?',
        specialChantiers: '=?',
        specialEdit: '=?',
        buttonSpecialActions: '=?',
        cannotUseThisFilter: '=?',
      },
      link: function(scope, elt, attrs, ctrl) {
        scope.configName =
          HpoCarteAppFactory.getAppFactory().getAppname() +
          '_' +
          'HpoDataConfig';
        if (angular.isUndefined(scope.fixedheader)) scope.fixedheader = true;
        if (angular.isUndefined(scope.autoadjustheight)) {
          scope.autoadjustheight = false;
          scope.datatableHeight =
            angular.element('.xgos_content').height() - 110 + 'px';
        }

        if (scope.fti) var ftis = [scope.fti];
        else {
          var ftis = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
            scope.listedata
          );
        }

        ftis = $filter('orderBy')(ftis, 'alias');

        var idx = -1;
        if (scope.hpo && scope.hpo.tableselected && scope.hpo.tableselected.uid)
          idx = ftis
            .map(function(x) {
              return x.uid;
            })
            .indexOf(scope.hpo.tableselected.uid);
        scope.hpo = {
          analysistools: 'allanalysis',
          ftis: ftis,
          tableselected: idx === -1 ? ftis[0] : ftis[idx],
          operands: scope.res && scope.res.operands ? scope.res.operands : [],
          clauseWhere:
            scope.res && scope.res.clauseWhere ? scope.res.clauseWhere : '1=1',
          wherefilter: '1=1',
          result: [],
          attributestoselect: {},
          interpreteattributes: 'and',
          interpreteconditions: 'and',
          currentsridName: undefined,
          activeTab: 0,
        };
        scope.lastWhere = {};
        scope.filtering = {
          filterValue: '',
        };

        /**
         * Configuration csv et enregistrement du delimiteur
         * @type {Object}
         */
        scope.configuser = { columnDelimiter: ';' };
        ParametersFactory.getbytype(scope.configName).then(
          function(res) {
            if (res.data && res.data.length > 0) {
              scope.configuser = res.data[0].data;
              scope.id = res.data[0].id;
            }
          },
          function(data) {
            console.log(scope.config);
          }
        );
        scope.saveConfig = function(configuser) {
          scope.configuser = configuser;
          ParametersFactory.getbytype(scope.configName).then(function(res) {
            var nameSaved = res.data.map(function(x) {
              return x.id;
            });
            if (
              scope.configuser &&
              scope.id &&
              nameSaved.indexOf(scope.id) !== -1
            ) {
              var idx = res.data
                .map(function(x) {
                  return x.id;
                })
                .indexOf(scope.id);
              var id = res.data[idx].id;
              res.data[idx].data = scope.configuser;
              ParametersFactory.update(res.data[idx], id).then(
                function(res) {
                  if (res.data && res.data.data > 0) {
                    scope.configuser = res.data.data;
                    scope.id = res.data.data;
                  }
                  require('toastr').success(
                    $filter('translate')('elastic.search.save_ok')
                  );
                },
                function() {
                  require('toastr').error(
                    $filter('translate')('elastic.search.save_nok')
                  );
                }
              );
            } else {
              ParametersFactory.add(
                scope.configuser,
                scope.configName,
                scope.configName
              ).then(
                function(res) {
                  if (res.data && res.data.data > 0) {
                    scope.configuser = res.data.data;
                    scope.id = res.data.data;
                  }
                  require('toastr').success(
                    $filter('translate')('elastic.search.save_ok')
                  );
                },
                function() {
                  require('toastr').error(
                    $filter('translate')('elastic.search.save_nok')
                  );
                }
              );
            }
          });
        };

        /**
         * Récupération du FTI
         * @type {Boolean}
         */
        var first = true;
        scope.changeTable = function(newval) {
          scope.hpo.tableselected = scope.hpo.ftis[newval];
          scope.hpo.operands = [];
          scope.hpo.clauseWhere = '1=1';
          scope.hpo.interpreteattributes = 'and';
          scope.hpo.interpreteconditions = 'and';
          scope.hpo.attributestoselect = {};
          scope.hpo.currentsridName = undefined;
        };
        scope.$watch('hpo.activeTab', function(newval, oldval) {
          if (
            angular.isDefined(newval) &&
            angular.isDefined(oldval) &&
            newval === -1 &&
            newval !== oldval
          ) {
            scope.hpo.activeTab = oldval;
            return;
          }
          if (angular.isDefined(newval) && newval !== -1 && newval !== oldval) {
            scope.changeTable(newval);
          }
        });

        scope.filterFunc = HpoCarteAppFactory.getAppFactory().filterFunc;
        scope.changedAnalysisToolOrFti = function(newval) {
          if (angular.isDefined(newval) && newval !== -1) {
            scope.changeTable(newval);
          }
        };

        if (scope.fti)
          scope.$watch('fti', function(newval, oldval) {
            if (newval) {
              scope.hpo.ftis = [newval];
              scope.hpo.tableselected = newval;
            }
          });

        /*
                Gestion de la tree
                 */
        scope.parameters_control = [];
        scope.parameters_data = [];

        var getRealAvailableCategories = function() {
          var categories = [];
          scope.parameters_data.map(function(x) {
            if (x.label && !~categories.indexOf(x.label))
              categories.push(x.label);
          });
          return categories;
        };

        var initVariables = function() {
          scope.hpo.tableselected = undefined;
        };

        scope.cleanBranch = function(branch) {
          var keys = Object.keys(branch);
          for (var i = 0; i < keys.length; i++) {
            if (!~keys_to_check.indexOf(keys[i])) delete branch[keys[i]];
          }
          return branch;
        };

        scope.selectBranch = function(obj) {
          if (scope.parameters_control.reset_rows)
            scope.parameters_control.reset_rows();
          var idx = scope.parameters_data
            .map(function(x) {
              return x.label;
            })
            .indexOf(obj.categorie);
          if (~idx) {
            if (scope.parameters_control.expand_branch) {
              scope.parameters_control.expand_branch(
                scope.parameters_data[idx]
              );
              scope.parameters_control.select_branch(
                scope.parameters_data[idx]
              );
            }
            var categorie = scope.parameters_data[idx];
            var idxb = categorie.children
              .map(function(x) {
                return x.uid;
              })
              .indexOf(obj.uid);
            if (~idxb) {
              if (scope.parameters_control.expand_branch) {
                scope.parameters_control.expand_branch(
                  categorie.children[idxb]
                );
                scope.parameters_control.select_branch(
                  categorie.children[idxb]
                );
                scope.hpo.tableselected = categorie.children[idxb];
              }
            }
          } else {
            idx = scope.parameters_data
              .map(function(x) {
                return x.label;
              })
              .indexOf(obj.label);
            if (~idx) {
              if (scope.parameters_control.expand_branch) {
                scope.parameters_control.expand_branch(
                  scope.parameters_data[idx]
                );
                scope.parameters_control.select_branch(
                  scope.parameters_data[idx]
                );
              }
              var categorie = scope.parameters_data[idx];
              var idxb = categorie.children
                .map(function(x) {
                  return x.uid;
                })
                .indexOf(obj.uid);
              if (~idxb) {
                if (scope.parameters_control.expand_branch) {
                  scope.parameters_control.expand_branch(
                    categorie.children[idxb]
                  );
                  scope.parameters_control.select_branch(
                    categorie.children[idxb]
                  );
                  scope.hpo.tableselected = categorie.children[idxb];
                }
              }
            }
          }
        };

        scope.tree_handler = function(branch) {
          if (
            !scope.hpo.tableselected ||
            (scope.hpo.tableselected &&
              branch.categorie &&
              scope.hpo.tableselected.categorie !== branch.categorie) ||
            (scope.hpo.tableselected &&
              branch.special &&
              scope.hpo.tableselected.categorie !== branch.label)
          ) {
            scope.filtering = {
              filterValue: '',
            };
          }
          scope.hpo.tableselected = branch;
          scope.hpo.operands = [];
          scope.hpo.clauseWhere = '1=1';
          scope.hpo.interpreteattributes = 'and';
          scope.hpo.interpreteconditions = 'and';
          scope.hpo.attributestoselect = {};
          scope.hpo.currentsridName = undefined;
        };

        var getCategorieIndexAndBranch = function(obj) {
          var categories = getRealAvailableCategories();
          if (scope.parameters_data.length > 0) {
            for (var i = 0; i < scope.parameters_data.length; i++) {
              var categ = scope.parameters_data[i];
              if (
                categ.label === obj.categorie &&
                categ.children &&
                categ.children.length > 0
              ) {
                categ.children.push(obj);
                break;
              }
            }
          }
        };

        var addParameterToData = function(objtoadd) {
          var categorie = objtoadd.categorie;
          var categories = getRealAvailableCategories();
          var idx = categories.indexOf(categorie);
          var elements = false;
          if (~idx) {
            elements = getCategorieIndexAndBranch(objtoadd);
          } else {
            if (
              scope.parameters_data &&
              scope.parameters_data.length > 0 &&
              scope.parameters_data[0].hasOwnProperty('type')
            )
              scope.parameters_data.splice(0, 1);
            var createCategorie = {
              label: categorie,
              special: 'categorie',
              children: [objtoadd],
            };
            scope.parameters_data.push(createCategorie);
          }
          return elements;
        };

        if (scope.parameters_control.reset_rows)
          scope.parameters_control.reset_rows();
        scope.hpo.ftis.map(function(x, i) {
          if (x) {
            x.label = x.alias;
            x.categorie =
              x.theme == 'undefined'
                ? $filter('translate')('mapv2.carte.notheme')
                : x.theme;
            switch (x.typeInfo) {
              case 'POINT':
                x.tree_icon = 'fa fa-map-marker';
                break;
              case 'LINE':
                x.tree_icon = 'fa fa-arrows-h';
                break;
              case 'POLYGON':
                x.tree_icon = 'fa fa-square';
                break;
              default:
                x.tree_icon = 'fa fa-table';
                break;
            }
            addParameterToData(x);
          }
        });
        function sortLayersByIndex(layer1, layer2) {
          var index1 = (layer1 && layer1.label) || layer1;
          var index2 = (layer2 && layer2.label) || layer2;
          if (index1 == null) return -1;
          else if (index2 == null) return 1;
          else if (index1 < index2) return -1;
          return 1;
        }
        setTimeout(function() {
          if (scope.parameters_control && scope.parameters_control.collapse_all)
            scope.parameters_control.collapse_all();
          if (scope.parameters_data.length > 0) {
            scope.parameters_data = scope.parameters_data.sort(
              sortLayersByIndex
            );
            for (var i = 0; i < scope.parameters_data.length; i++) {
              if (
                scope.parameters_data[i] &&
                scope.parameters_data[i].children &&
                scope.parameters_data[i].children.length > 0
              ) {
                scope.parameters_data[i].children = scope.parameters_data[
                  i
                ].children.sort(sortLayersByIndex);
              }
            }
            scope.selectBranch(scope.parameters_data[0]);
          }
          try {
            scope.$apply();
          } catch(err) {}
        }, 200);

        /**
         * Fonctions de la data-table
         * @type {[type]}
         */
        var dialog = null;
        scope.addFeature = function() {
          scope.featuretoadd = {
            type: 'Feature',
            properties: {},
          };
          scope.uploadfile = {};
          scope.currentProperties = {};
          scope.featuretoattach = {};

          scope.attributesAuthorised = HpoCarteAppFactory.getAppFactory().getAuthorizedAttributes(
            scope.hpo.tableselected,
            'w'
          );
          scope.attributesAuthorised.map(function(x) {
            scope.featuretoadd.properties[x.name] = null;
          });
          scope.newObj = true;

          dialog = ngDialog.openConfirm({
            template:
              'js/XG/widgets/hpoapp/home_admin_data/views/dialog/hpo.create.feature.html',
            className: 'ngdialog-theme-plain width800 nopadding miniclose',
            scope: scope,
          });
          dialog.then(function(data) {
            var features = {
              type: 'FeatureCollection',
              features: [data],
            };
            EditFactory.add(
              scope.hpo.tableselected.uid,
              features,
              scope.hpo.tableselected.srid
            ).then(function(res) {
              if (res.data.errors.length > 0) {
                require('toastr').error(res.data.errors[0]);
              }
              if (res.data.create.length > 0) {
                $rootScope.$broadcast('reloadDatatable');
                AlertHpoFactory.getSimpleSuccess(
                  $filter('translate')('hpo.data.exchange.succes'),
                  $filter('translate')('hpo.data.exchange.adds'),
                  false
                );
              }
            });
          });
        };
        scope.buttonEditIcon = [
          {
            type: 'component',
            config: {
              name: 'button',
              click: ['crud_update'],
            },
            cfg: {
              icon: { name: 'pencil-square-o' },
              iconOrLabel: 'icon',
              size: 'btn-xs',
              style: 'btn-default cursorHelp',
              title: 'Editer le dossier',
            },
          },
        ];
        scope.editFeature = function(obj) {
          scope.newObj = false;
          scope.featuretoadd = angular.copy(obj);
          if (scope.featuretoadd && scope.featuretoadd.properties)
            scope.featuretoadd.properties = {};
          scope.attributesAuthorised = HpoCarteAppFactory.getAppFactory().getAuthorizedAttributes(
            scope.hpo.tableselected,
            'w'
          );
          scope.attributesAuthorised.map(function(x) {
            scope.featuretoadd.properties[x.name] = obj.properties[x.name];
          });
          scope.uploadfile = {};
          scope.featuretoattach = {};

          dialog = ngDialog.openConfirm({
            template:
              'js/XG/widgets/hpoapp/home_admin_data/views/dialog/hpo.create.feature.html',
            className: 'ngdialog-theme-plain width800 nopadding miniclose',
            scope: scope,
          });
          dialog.then(function(data) {
            var features = {
              type: 'FeatureCollection',
              features: [data],
            };
            EditFactory.update(
              scope.hpo.tableselected.uid,
              features,
              scope.hpo.tableselected.srid
            ).then(
              function(res) {
                AlertHpoFactory.getSimpleSuccess(
                  $filter('translate')('hpo.data.exchange.succes'),
                  $filter('translate')('hpo.data.exchange.updates'),
                  false
                );
                $rootScope.$broadcast('reloadDatatable');
              },
              function(res) {
                AlertHpoFactory.getSimpleFail(
                  $filter('translate')('hpo.data.exchange.fail'),
                  $filter('translate')('hpo.data.exchange.updatesfail'),
                  true
                );
              }
            );
          });
        };
        scope.copyFeatures = function() {
          var callback = function(confirmed) {
            if (confirmed) {
              var f = angular.copy(scope.hpo.result);
              var features = {
                type: 'FeatureCollection',
                features: f.map(function(x) {
                  if (x.id) delete x.id;
                  return x;
                }),
              };
              EditFactory.add(
                scope.hpo.tableselected.uid,
                features,
                scope.hpo.tableselected.srid
              ).then(function(res) {
                if (res.data.errors.length > 0) {
                  require('toastr').error(res.data.errors[0]);
                }
                if (res.data.create.length > 0) {
                  $rootScope.$broadcast('reloadDatatable');
                  AlertHpoFactory.getSimpleSuccess(
                    $filter('translate')('hpo.data.exchange.succes'),
                    scope.hpo.result.length +
                      ' ' +
                      $filter('translate')('hpo.data.exchange.add'),
                    false
                  );
                }
              });
            }
          };
          AlertHpoFactory.alertConfirmCallback(
            $filter('translate')('hpo.common.warning'),
            $filter('translate')('hpo.data.check.add_copy'),
            'warning',
            true,
            undefined,
            '#F50072',
            true,
            undefined,
            undefined,
            true,
            true,
            callback
          );
        };

        var csvdialog;
        scope.importCsvOrShape = function() {
          scope.isModule = false;
          csvdialog = ngDialog.open({
            template:
              'js/XG/widgets/hpoapp/home_admin_data/views/dialog/hpo.data.import.html',
            className:
              'ngdialog-theme-plain ngdialog-theme-plain-hpo width95 nopadding import-csv-hpo miniclose',
            closeByDocument: false,
            title: $filter('translate')('hpo.common.importcsvshp'),
            scope: scope,
          });
        };

        var ngDialogPromise;
        scope.addAttribute = function() {
          scope.currentFeatureTypeAttribute = {};
          scope.newattribute = true;
          ngDialogPromise = ngDialog.open({
            template:
              'js/XG/widgets/hpoapp/home_admin_data/views/dialog/hpo.data.addcolumn.html',
            scope: scope,
            className: 'ngdialog-theme-plain width800 nopadding miniclose',
          });
        };

        scope.addOnecolumn = function(data) {
          gaDomUtils.showGlobalLoader();
          HpoAppServices.addAttribute(scope.hpo.tableselected.uid, data).then(
            function(res) {
              gaDomUtils.hideGlobalLoader();
              if (res && res.data) {
                scope.hpo.tableselected.attributes.push(res.data);
                authFactory.getcurrentuser().then(
                  function(res) {
                    $rootScope.$broadcast(
                      'reloadDatatable',
                      scope.hpo.tableselected.uid,
                      true
                    );
                    AlertHpoFactory.getSimpleSuccess(
                      $filter('translate')('hpo.common.success'),
                      $filter('translate')('hpo.common.addsuccess'),
                      true
                    );
                  },
                  function(res) {
                    $rootScope.$broadcast(
                      'reloadDatatable',
                      scope.hpo.tableselected.uid,
                      true
                    );
                    AlertHpoFactory.getSimpleSuccess(
                      $filter('translate')('hpo.common.success'),
                      $filter('translate')('hpo.common.addsuccess'),
                      true
                    );
                  }
                );
              } else {
                AlertHpoFactory.getSimpleFail(
                  $filter('translate')('hpo.common.fail'),
                  $filter('translate')('hpo.common.addfail'),
                  true
                );
                gaDomUtils.hideGlobalLoader();
              }
              ngDialogPromise.close();
            },
            function(res) {
              AlertHpoFactory.showErrorMessage(res);
              gaDomUtils.hideGlobalLoader();
            }
          );
        };

        var ngDialogFilter;
        scope.applyFilter = function() {
          scope.configNameModif =
            scope.configName + '_' + scope.hpo.tableselected.uid;
          ngDialogFilter = ngDialog.openConfirm({
            template:
              'js/XG/widgets/hpoapp/home_admin_data/views/dialog/hpo.data.applyfilter.html',
            scope: scope,
            className: 'ngdialog-theme-plain width1000 nopadding miniclose',
          });
          ngDialogFilter.then(function(data) {
            gaDomUtils.showGlobalLoader();
            HpoAppServices.createFilter(data).then(
              function(res) {
                gaDomUtils.hideGlobalLoader();
                if (res && res.data) {
                  scope.hpo.clauseWhere = res.data;
                  scope.lastWhere[scope.hpo.tableselected.uid] = {
                    filter: res.data,
                    operands: scope.hpo.operands,
                  };
                  if (scope.cannotUseThisFilter) {
                    scope.res.clauseWhere = res.data;
                    scope.res.operands = scope.hpo.operands;
                  }
                  if (scope.showToastr)
                    require('toastr').info(
                      $filter('translate')('hpo.common.utilisercefilter')
                    );
                }
              },
              function(res) {
                AlertHpoFactory.showErrorMessage(res);
                gaDomUtils.hideGlobalLoader();
              }
            );
          });
        };

        scope.removeFilter = function() {
          scope.hpo.clauseWhere = '1=1';
          scope.hpo.operands = [];
          if (scope.cannotUseThisFilter) {
            scope.res.clauseWhere = scope.hpo.clauseWhere;
            scope.res.operands = scope.hpo.operands;
          }
          if (scope.showToastr)
            require('toastr').info(
              $filter('translate')('hpo.common.utilisercefilter')
            );
        };

        scope.evaluateFitler = function() {
          if (scope.hpo.clauseWhere === '1=1') return true;
          else {
            return false;
          }
        };

        scope.getlastfilter = function() {
          scope.hpo.clauseWhere =
            scope.lastWhere[scope.hpo.tableselected.uid].filter;
          scope.hpo.operands =
            scope.lastWhere[scope.hpo.tableselected.uid].operands;
          if (scope.cannotUseThisFilter) {
            scope.res.clauseWhere = scope.hpo.clauseWhere;
            scope.res.operands = scope.hpo.operands;
          }
          if (scope.showToastr)
            require('toastr').info(
              $filter('translate')('hpo.common.utilisercefilter')
            );
        };

        scope.evaluatelastFitler = function() {
          if (
            !scope.hpo ||
            !scope.hpo.tableselected ||
            !scope.lastWhere.hasOwnProperty(scope.hpo.tableselected.uid) ||
            scope.lastWhere[scope.hpo.tableselected.uid].filter ===
              scope.hpo.clauseWhere
          )
            return true;
          else {
            return false;
          }
        };

        scope.getReturnedTemplate = function(dataHpo) {
          if (dataHpo) {
            scope.hpo.operands = dataHpo.savedata;
            if (scope.hpo.tableselected && scope.hpo.tableselected.uid) {
              var idx = scope.hpo.ftis
                .map(function(x) {
                  return x.uid;
                })
                .indexOf(scope.hpo.tableselected.uid);
              if (~idx) {
                scope.hpo.tableselected = scope.hpo.ftis[idx];
                var attributesName = scope.hpo.tableselected.attributes.map(
                  function(x) {
                    return x.name;
                  }
                );
                /**
                 * Case attributes
                 */
                if (scope.hpo.operands && scope.hpo.operands.length > 0) {
                  var todeleteAttributes = [];
                  scope.hpo.operands.map(function(x, i) {
                    if (x) {
                      var idx = attributesName.indexOf(x.name);
                      if (idx !== -1)
                        scope.hpo.operands[i] = Object.assign(
                          scope.hpo.operands[i],
                          scope.hpo.tableselected.attributes[idx]
                        );
                      else {
                        todeleteAttributes.push(i);
                      }
                    }
                  });
                  if (todeleteAttributes.length > 0) {
                    for (var i = todeleteAttributes.length - 1; i >= 0; i--)
                      scope.hpo.operands.splice(todeleteAttributes[i], 1);
                    AlertHpoFactory.showAlertTemplateUpdate();
                  }
                }
                // $rootScope.$broadcast("reloadDatatable");
              }
            }
          }
        };

        scope.saveTemplateHtml =
          'js/XG/widgets/hpoapp/main/views/templates/data/hpo.data.prepare.templates.html';
        scope.getTemplateHtml =
          'js/XG/widgets/hpoapp/main/views/templates/data/hpo.data.prepare.gettemplates.html';

        scope.exportShp = function() {
          ngDialogFilter = ngDialog.openConfirm({
            template:
              'js/XG/widgets/hpoapp/home_admin_data/views/dialog/hpo.data.exportSHP.html',
            scope: scope,
            className: 'ngdialog-theme-plain width1000 nopadding miniclose',
          });
          ngDialogFilter.then(function(data) {
            var attrs = [];
            for (var att in data.attributestoselect) {
              if (
                att &&
                data.attributestoselect.hasOwnProperty(att) &&
                data.attributestoselect[att]
              )
                attrs.push(att);
            }
            var attributes = [
              {
                uid: scope.hpo.tableselected.uid,
                attributes: attrs.join(';'),
              },
            ];
            gaDomUtils.showGlobalLoader();
            ImportExportFactory.exportLayersFeatures(
              'SHAPEFILE',
              data.currentsridName,
              scope.hpo.tableselected.uid,
              attributes,
              scope.hpo.wherefilter
            ).then(
              function(exportResult) {
                gaDomUtils.hideGlobalLoader();
                var resultFileName = exportResult.data;
                var downloadurl =
                  '/services/' +
                  localStorage.portal +
                  '/export/downloadexportedfile?f=json' +
                  '&exportedFileId=' +
                  resultFileName;
                window.open(downloadurl);
              },
              function(res) {
                gaDomUtils.hideGlobalLoader();
                AlertHpoFactory.showErrorMessage(res);
              }
            );
          });
        };

        scope.disableSelection = function(attributestoselect, currentsridName) {
          if (
            !attributestoselect ||
            Object.keys(attributestoselect).length === 0 ||
            !currentsridName
          )
            return true;
          else {
            return false;
          }
        };

        scope.updateMultiple = function(objs) {
          console.log(scope.hpo.result);
          scope.existingvalues = {
            properties: {},
            existingvalues: {},
            modified: {},
          };

          scope.attributesAuthorised = HpoCarteAppFactory.getAppFactory().getAuthorizedAttributes(
            scope.hpo.tableselected,
            'w'
          );
          var authorisedKeys = scope.attributesAuthorised.map(function(x) {
            return x.name;
          });

          scope.hpo.result.map(function(x) {
            if (x && x.properties) {
              for (var key in x.properties) {
                if (
                  key &&
                  x.properties.hasOwnProperty(key) &&
                  authorisedKeys.indexOf(key) !== -1
                ) {
                  if (
                    scope.existingvalues.existingvalues.hasOwnProperty(key) &&
                    angular.isDefined(x.properties[key]) &&
                    scope.existingvalues.existingvalues[key].indexOf(
                      x.properties[key]
                    ) == -1
                  ) {
                    scope.existingvalues.existingvalues[key].push(
                      x.properties[key]
                    );
                  } else {
                    scope.existingvalues.existingvalues[key] = [];
                    scope.existingvalues.existingvalues[key].push(
                      x.properties[key]
                    );
                    scope.existingvalues.modified[key] = false;
                    scope.existingvalues.properties[key] = undefined;
                  }
                }
              }
            }
          });
          dialog = ngDialog.openConfirm({
            template:
              'js/XG/widgets/hpoapp/home_admin_data/views/dialog/hpo.updateMultiple.feature.html',
            className: 'ngdialog-theme-plain width800 nopadding miniclose',
            scope: scope,
          });
          dialog.then(function(data) {
            var donn = angular.copy(scope.hpo.result);
            donn.map(function(x) {
              if (x && x.properties) {
                for (var key in data.properties) {
                  if (
                    key &&
                    data.properties.hasOwnProperty(key) &&
                    data.modified &&
                    data.modified.hasOwnProperty(key) &&
                    data.modified[key]
                  ) {
                    x.properties[key] = data.properties[key];
                  }
                }
              }
            });
            var features = {
              type: 'FeatureCollection',
              features: [donn],
            };
            EditFactory.update(
              scope.hpo.tableselected.uid,
              features,
              scope.hpo.tableselected.srid
            ).then(
              function(res) {
                AlertHpoFactory.getSimpleSuccess(
                  $filter('translate')('hpo.data.exchange.succes'),
                  $filter('translate')('hpo.data.exchange.updates'),
                  false
                );
                $rootScope.$broadcast('reloadDatatable');
              },
              function(res) {
                AlertHpoFactory.getSimpleFail(
                  $filter('translate')('hpo.data.exchange.fail'),
                  $filter('translate')('hpo.data.exchange.updatesfail'),
                  true
                );
              }
            );
          });
        };

        scope.refreshData = function() {
          $rootScope.$broadcast('reloadDatatable', scope.hpo.tableselected.uid);
        };

        if (!scope.hideCrud) {
          var extra = [
            {
              name: $filter('translate')('hpo.common.createfilter'),
              class: 'btn-primary margin-left-right pull-left',
              func: scope.applyFilter,
              special: true,
            },
            {
              name: $filter('translate')('hpo.common.lastfilter'),
              class: 'btn-default pull-left',
              icon: 'fa-refresh',
              func: scope.getlastfilter,
              specialhide: scope.evaluatelastFitler,
              special: true,
            },
            {
              name: $filter('translate')('hpo.common.removefilter'),
              class: 'btn-default pull-left',
              icon: 'fa-remove',
              func: scope.removeFilter,
              specialhide: scope.evaluateFitler,
              special: true,
            },
            {
              name: $filter('translate')('hpo.common.refresh'),
              class: 'btn-default small-margin-left-right',
              func: scope.refreshData,
              icon: 'fa-refresh',
              special: true,
            },
            {
              name: $filter('translate')('hpo.common.exportShp'),
              class: 'btn-default small-margin-left-right',
              func: scope.exportShp,
              special: true,
            },
          ];
          if (scope.specialChantiers) {
            scope.datatableCrudHpo = {
              update: {
                func: scope.specialEdit || scope.editFeature,
              },
              remove: true,
              extraActions: extra,
            };
          } else {
            scope.datatableCrudHpo = {
              create: { func: scope.addFeature },
              update: { func: scope.editFeature },
              multipleUpdate: { func: scope.updateMultiple },
              copy: { func: scope.copyFeatures },
              addcolumn: {
                func: scope.addAttribute,
                hidecolumn: function() {
                  return !HpoCarteAppFactory.getAppFactory().isAuthorisedToAddAttribute(
                    scope.hpo.tableselected
                  );
                },
              },
              remove: true,
              extraActions: extra,
            };
          }
        } else if (
          scope.hideCrud &&
          scope.showAdvancedFilter &&
          !scope.datatableCrudHpo
        ) {
          scope.usethisfilter = function() {
            $rootScope.$broadcast('changedHpoValue', scope.hpo);
          };
          scope.datatableCrudHpo = {
            update: { func: scope.editFeature },
            remove: false,
            extraActions: [
              {
                name: $filter('translate')('hpo.common.lastfilter'),
                class: 'btn-default small-margin-right',
                icon: 'fa-refresh',
                func: scope.getlastfilter,
                specialhide: scope.evaluatelastFitler,
                special: true,
              },
              {
                name: $filter('translate')('hpo.common.removefilter'),
                class: 'btn-default small-margin-right',
                icon: 'fa-remove',
                func: scope.removeFilter,
                specialhide: scope.evaluateFitler,
                special: true,
              },
              {
                name: $filter('translate')('hpo.common.createfilter'),
                class: 'btn-primary small-margin-right',
                func: scope.applyFilter,
                special: true,
              },
              {
                name: $filter('translate')('hpo.common.usefilter'),
                class: 'btn-info',
                func: scope.usethisfilter,
                special: true,
              },
            ],
          };
          if (scope.cannotUseThisFilter)
            scope.datatableCrudHpo.extraActions.splice(3, 1);
        } else {
          scope.datatableCrudHpo = {
            update: { func: scope.editFeature },
            remove: false,
          };
        }
        scope.finishedload = true;

        scope.minheight = angular.element('.xgos_content').height() + 'px';
        scope.maxheight = angular.element('.xgos_content').height() - 70 + 'px';
      },
    };
  };

  listeDataCarte.$inject = [
    'AlertHpoFactory',
    'FeatureTypeFactory',
    'HpoCarteAppFactory',
    '$window',
    'EditFactory',
    '$rootScope',
    '$filter',
    'ngDialog',
    '$timeout',
    'ParametersFactory',
    'gaDomUtils',
    'HpoAppServices',
    'ImportExportFactory',
    'authFactory',
  ];
  return listeDataCarte;
});
