'use strict';
define(function() {
  var gcelement = function(
    mapJsUtils,
    ngTableParams,
    QueryFactory,
    EditFactory
  ) {
    return {
      templateUrl:
        'js/XG/widgets/utilities/data/views/gcdatatable_geojson.html',
      restrict: 'A',
      scope: {
        map: '=map',
        res: '=res',
        geojson: '=geojson',
        actions: '=actions',
        attributes: '=attributes',
      },
      link: function(scope) {

        if (scope.geojson) {
          scope.data = scope.geojson.features;
        } else {
          scope.data = [];
        }

        scope.localisedata = (obj) => {
          mapJsUtils.localiseData(obj, scope.map);
        };

        scope.removedata = function(id) {
          EditFactory.remove(scope.fti.uid, id).then(function(res) {
            require('toastr').success(res.data);
            var deleteIndex = scope.data
              .map(function(x) {
                return x.id;
              })
              .indexOf(id);
            console.log(res);
            console.log(deleteIndex);
            scope.data.splice(deleteIndex, 1);
            scope.tableParams.reload();
          });
        };

        scope.removefromlist = function(index) {
          var removedItem;
          removedItem = scope.geojson.features.splice(index, 1);
          if (angular.isDefined(scope.geojson.totalFeatures))
            scope.geojson.totalFeatures--;
          scope.data = scope.geojson.features;
          scope.tableParams.reload();
          scope.$emit('datatableGeoJsonChanged', {
            action: 'remove',
            removedItem: removedItem,
          });
        };

        scope.tableParams = new ngTableParams({
            page: 1, // show first page
            count: 10, // count per page
          }, {
            total: scope.data.length, // length of data
            getData: function($defer, params) {
              $defer.resolve(
                scope.data.slice(
                  (params.page() - 1) * params.count(),
                  params.page() * params.count()
                )
              );
            },
          }
        );

        scope.selectobj = function(obj) {
          scope.res = obj;
        };

        scope.$watch('geojson', function(gj) {
          if (angular.isDefined(scope.geojson)) {
            scope.data = scope.geojson.features;
            scope.tableParams.reload();
          }
        });
      },
    };
  };

  gcelement.$inject = [
    'mapJsUtils',
    'ngTableParams',
    'QueryFactory',
    'EditFactory',
  ];
  return gcelement;
});
