'use strict';
define(function() {
  var gcElasticFilterTypeAhead = function(
    gclayers,
    $http,
    FeatureTypeFactory,
    elasticQueryService,
    ElasticFactory,
    $filter,
    SelectManager,
    gcPopup,
    panelsManager,
    gaDomUtils,
    ngDialog,
    $rootScope,
    ParametersFactory
  ) {
    return {
      templateUrl:
        'js/XG/widgets/utilities/elastic/views/elasticFilterTypeAhead.html',
      restrict: 'EA',
      scope: {
        matches: '=matches',
        thisModel: '=thengmodel',
      },
      link: function(scope, element, attrs, ctrl) {
        //-- Vrai quand le champ texte a le focus.
        scope.ddmVisible = false;

        //-- Récupére le "UL" pour pouvoir altérer l'attribut
        //-- "display" du style.
        var elt = element[0].getElementsByTagName('UL')[0];

        scope.setDdmVisibleFalse = function() {
          setTimeout(function() {
            scope.ddmVisible = false;
            scope.$digest();
          }, 1000);
        };
        scope.setUlVisibility = function() {
          //-- Positionner l'attribut "display" selon
          //-- que le champ texte a ou non le focus.
          if (scope.ddmVisible) elt.style.display = 'block';
          else elt.style.display = 'none';
        };

        //-- Quand le champ texte reçoit ou perd le focus
        //-- on appelle la fonction "scope.setUlVisibility".
        scope.$watch('ddmVisible', scope.setUlVisibility);

        scope.selectedSuggestion = {};
        scope.selectedSuggestion.selected = undefined;
        scope.setSelected = function(match) {
          scope.thisModel = match;
          scope.ddmVisible = false;
        };

        scope.$watch('selectedSuggestion.selected', scope.setSelected);
      },
    };
  };

  gcElasticFilterTypeAhead.$inject = [
    'gclayers',
    '$http',
    'FeatureTypeFactory',
    'elasticQueryService',
    'ElasticFactory',
    '$filter',
    'SelectManager',
    'gcPopup',
    'panelsManager',
    'gaDomUtils',
    'ngDialog',
    '$rootScope',
    'ParametersFactory',
  ];
  return gcElasticFilterTypeAhead;
});
