'use strict';
define(function() {
  var formBuilderVariables = function(ngDialog, $filter) {
    return {
      templateUrl:
        'js/XG/widgets/utilities/form/views/formBuilderVariables.html',
      restrict: 'EA',
      scope: {
        res: '=',
        formvariables: '=',
        escape: '=?',
        label: '@',
        globalsave: '=?',
        association: '=?'
      },
      link: function(scope) {
        if (scope.res==undefined){
          scope.res = '';
        }
        if (scope.escape) {
          scope.picked = scope.res.replace(/'/g, '');
        } else {
          scope.picked = scope.res;
        }
        // true à l'initialisation ou au reset de la variable
        // permet de ne pas appeler les $emit sur relation et association
        let init = true;

        scope.$watch('picked', function() {
          const result = !scope.escape ? scope.picked : '\'' + scope.picked + '\'';
          // globalsave est true quand il s'agit de l'objet en relation
          // du bouton global "Enregistrer" d'un form IS
          if (scope.globalsave && !init){
            // envoi au formBuilder
            scope.$emit('globalSaveRelated', result);
          } if (scope.association && !init){
            // envoi au formBuilder
            scope.$emit('globalSaveAssociation', result);
          }else{
            scope.res = result;
            init = false;
          }
        });

        scope.$on('resetVariable', (on, variable) => {
          if(variable === scope.label) {
            scope.cancelPickerVariable();
          }
        })

        scope.infos = { label: 'Result' };
        if (angular.isDefined(scope.label))
          scope.infos.label = $filter('translate')(scope.label);

        /**
         * Reset the variable that will be added to formvariables
         */
        var resetNewVariable = function() {
          scope.newVariable = {
            label: '',
            description: '',
            fields: [],
          };
        };
        resetNewVariable();

        /**
         * Open the variable editor Modal
         */
        scope.openVariablesEditor = function() {
          ngDialog.open({
            template:
              'js/XG/widgets/utilities/form/views/modal/variablesEditor.html',
            className: 'ngdialog-theme-plain width800 nopadding miniclose',
            closeByDocument: false,
            scope: scope,
          });
        };

        /**
         * Add a new variable to formvariables
         */
        scope.addVariable = function() {
          if (scope.newVariable.label == '') {
            require('toastr').error('Variable label cannot be empty.');
            return;
          }
          if (
            scope.formvariables
              .map(function(f) {
                return f.label;
              })
              .indexOf(scope.newVariable.label) != -1
          ) {
            require('toastr').error(
              'A variable with that label does already exist'
            );
            return;
          }

          scope.formvariables.push(scope.newVariable);
          resetNewVariable();
        };

        /**
         * Cancel whatever variable was picked
         */
        scope.cancelPickerVariable = function() {
          // If the variable had a value
          // Allow associations and relations variables to keep resetting each others
          if(scope.picked !== null) {
            init = true;
          }
          scope.picked = null;
        };

        scope.deleteFormVariable = function(index) {
          var ans = confirm(
            $filter('translate')(
              'tools.builder.formvariables.editor.confirm_delete'
            )
          );
          if (ans) {
            scope.formvariables.splice(index, 1);
          }
        };
      },
    };
  };

  formBuilderVariables.$inject = ['ngDialog', '$filter'];
  return formBuilderVariables;
});
