'use strict';
define(function() {
  var javalangstring = function(FeatureAttachmentFactory, gaJsUtils, FilesFactory, gaDomUtils,
    $filter, formFunctionUtils, EditFactory, FormsHelper, $rootScope, $q, $timeout) {
    return {
      templateUrl: 'js/XG/widgets/utilities/form/views/gcattachment.html',
      restrict: 'A',
      scope: {
        ftid: '=ftid',
        att: '=gcatt',
        filesressources: '=filesressources',
        result: '=result',
        activelabel: '=activelabel',
        initvalue: '=initvalue',
        fieldData: '=?fieldData',
        current: '=current',
        uploadfile: '=uploadfile'
      },

      link: function(scope, elt) {
        scope.restrict = false;
        scope.restricttype = '';

        scope.fileNameChanged = function(a) {
          const fileAdded = gaJsUtils.renameFileWithoutSpecialChar(a.files[0]);
          scope.result[scope.att.name] = fileAdded.name;

          if (!scope.uploadfile) {
            scope.uploadfile = {};
          }
          if (!scope.uploadfile[scope.att.name]) {
            scope.uploadfile[scope.att.name] = [];
          }
          scope.uploadfile[scope.att.name][0]=fileAdded;

          uploadFile(a).then(() => {
            // -- Informer le featureattachment de l'onglet "Pièces jointes"
            // -- qu'un fichier a été modifié
            $timeout(() => {
              $rootScope.$broadcast('attachmentChanged',
                { 'scopeId': scope.$id,
                  'addedFile': fileAdded.name,
                  'attName': scope.att.name,
                  'featureId': scope.current.id
                });
            });
          });
        };

        /**
         * Au clic sur le bouton "Supprimer" (-) du champ de type attachment,
         * supprime le fichier : <ul><li>
         * du dossier UPLOAD en mode création</li><li>
         * du dossier ATTACHMENTS en mode édition</li></ul>
         */
        scope.removeFile = () => {

          if (scope.current && scope.result[scope.att.name]) {
            const featureIsAlreadySaved = (typeof scope.current.id === 'string'
              && scope.current.id.length > 0)
                || (typeof scope.current.id === 'number' && Number.isFinite(scope.current.id));

            if (!featureIsAlreadySaved
               && Object.prototype.hasOwnProperty.call(scope.fieldData, 'attachmentId')) {
              const startTime = new Date().getTime();
              FilesFactory.removeUploaded(
                scope.fieldData.attachmentId, scope.result[scope.att.name]).then(
                () => {
                  const endTime = new Date().getTime();
                  const elapsedTime = (endTime - startTime) / 1000;
                  console.info($filter('translate')('featureattachment.uploadDeleteSuccess')
                      + scope.result[scope.att.name], ' ' + elapsedTime + ' sec');
                  scope.result[scope.att.name] = '';
                }
              );
            } else {
              let isProcessing = false;
              swal({
                title: $filter('translate')('featureattachment.deleteConfirm'),
                type: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#DD6B55',
                confirmButtonText: $filter('translate')('common.yes'),
                cancelButtonText: $filter('translate')('common.no'),
                closeOnConfirm: true,
              },
              isConfirm => {
                if (isConfirm && !isProcessing) {
                  // -- KIS-3484: Le "FeatureAttachmentFactory.remove" ne sert à rien
                  // -- car dans le cas d'un champ attachment, le updateSpecifiedField
                  // -- appelé par "updateAttachmentAttributeOnly"supprime la pièce jointe.
                  const filename = scope.result[scope.att.name];
                  scope.result[scope.att.name] = '';
                  // KIS-3010:  l’enregistrement du champ attachment/attachment-multi
                  // (et uniquement celui-ci) se fait automatiquement
                  updateAttachmentAttributeOnly(scope.current.id).then(() => {
                    $rootScope.$broadcast('attachmentChanged',
                      { 'scopeId': scope.$id,
                        'removedFile': filename,
                        'attName': scope.att.name,
                        'featureId': scope.current.id
                      });
                    isProcessing = false;
                  });
                  isProcessing = true;
                }
              }
              );
            }
          }
        };


        scope.addFile = function() {};


        scope.download = function() {
          // var fn = ""+$scope.selected_filename.name;
          let id = gaJsUtils.getIdInCaseEsriId(scope.current, scope.ftid,
            scope.result);
          FeatureAttachmentFactory.getdownloadurl(
            scope.result[scope.att.name], scope.ftid.name, id
          ).then(function(res) {
            gaJsUtils.downloadFile(res.data, id, scope.result[scope.att.name]);
          });
        };

        /**
         * Après avoir sélectionné un fichier,
         * si l'objet du formulaire n'est pas enregistré, charge le fichier dans
         * le dossier "UPLOAD".<br>
         * Ou bien si l'objet du formulaire est déjà enregistré, charge le fichier
         * dans le dossier "ATTACHMENT"
         * @param {object} inputData objet contenant la liste des fichiers importés
         */
        const uploadFile = (inputData) => {
          const defer = $q.defer();
          if (!scope.ftid) {
            require('toastr').error($filter('translate')('featureattachment.formWithoutFti'));
            return;
          }
          if (inputData && inputData.files && inputData.files.length > 0) {
            if (scope.current) {
              const featureIsAlreadySaved = (typeof scope.current.id === 'string'
                && scope.current.id.length > 0)
                  || (typeof scope.current.id === 'number' && Number.isFinite(scope.current.id));
              gaDomUtils.showGlobalLoader();

              const fileToImport = gaJsUtils.renameFileWithoutSpecialChar(inputData.files[0]);

              if (featureIsAlreadySaved) {
                // copie directement le fichier dans le dossier ATTACHMENTS du repo
                // -- KIS-3497
                // -- Sans scope;result en dernier paramétre getIdInCaseEsriId
                // -- ne retourne pas le bon id
                const featureId
                  = gaJsUtils.getIdInCaseEsriId(scope.current, scope.ftid, scope.result);
                const startTime = new Date().getTime();
                FeatureAttachmentFactory.addFile(scope.ftid.name, featureId, fileToImport).then(
                  () => {
                    const endTime = new Date().getTime();
                    const elapsedTime = (endTime - startTime) / 1000;
                    console.info(
                      $filter('translate')('featureattachment.copyToAttachmentSuccess'),
                      featureId, ' ' + elapsedTime + ' sec');

                    // KIS-2937 : met à jour le champ gcattachment de l'objet courant en base
                    updateAttachmentAttributeOnly(featureId).then(() => {
                      defer.resolve();
                    });
                  }
                ).catch(error => {
                  console.error(error);
                  require('toastr')
                    .error($filter('translate')('featureattachment.importToAttachmentsFailed'));
                }).finally(() => {
                  gaDomUtils.hideGlobalLoader();
                });
              } else {
                // copie le fichier  dans le dossier UPLOADS du repo.
                // Le fichier sera copié dans le dossier ATTACHMENTS après enregistrement
                // de la feature
                const attachmentId = formFunctionUtils.setAttachmentProcessId(scope.fieldData);
                const startTime = new Date().getTime();
                FilesFactory.uploadFile(attachmentId, fileToImport).then(
                  () => {
                    const endTime = new Date().getTime();
                    const elapsedTime = (endTime - startTime) / 1000;
                    require('toastr').success(
                      $filter('translate')('featureattachment.uploadFileSuccess')
                          + inputData.files[0].name);
                    console.info($filter('translate')('featureattachment.uploadFileSuccess'),
                      inputData.files[0].name, ' ' + elapsedTime + ' sec');
                    defer.resolve();
                  }
                ).catch(error => {
                  console.error(error);
                  require('toastr').error(
                    $filter('translate')('featureattachment.importToAttachmentsFailed'));
                }).finally(() => {
                  gaDomUtils.hideGlobalLoader();
                });
              }
            } else {
              console.error('uploadFile : aucun objet lié au formulaire. current = ',
                scope.current);
            }
          }
          return defer.promise;
        };

        /**
         * KIS-2937
         * Uniquement dans le cas d'un objet déjà enregistré,
         * met à jour uniquement l'attribut gcattachments de l'objet après copie
         * des fichiers dans le dossier ATTACHMENTS du repo
         * @param {string} featureId
         */
        const updateAttachmentAttributeOnly = (featureId) => {
          // met à jour l'atttribut de l'objet directement après la copie
          // dans le dossier ATTACHMENTS
          if (scope.ftid.type === 'esri' && gaJsUtils.notNullAndDefined(scope.result['objectid'])) {
            featureId = scope.ftid.name + '.' + scope.result['objectid'];
          }
          const featureToUpdate = {
            id: featureId,
            properties: {}
          };

          // il est possible que tous les fichiers n'aient pas été correctement uploadés
          // dans ce cas on ne conserve que les noms des fichiers réellement uploadés
          featureToUpdate.properties[scope.att.name] = scope.result[scope.att.name];
          const featureToUpdateWrapper = {
            features: [featureToUpdate]
          };

          return EditFactory.updatespecifiedproperties(scope.ftid.uid,
            featureToUpdateWrapper, null).then(
            () => {
              require('toastr')
                .success($filter('translate')('featureattachment.copyToAttachmentSuccess'));
              // met à jour l'objet dans la liste des objets sélectionnés
              scope.$emit('updateGcdatatable', {isNew: false, idPopup: FormsHelper.getIdDiv(elt)});
            },
            err => {
              if (err.data && Array.isArray(err.data.errors)) {
                for (const error of err.data.errors) {
                  console.error(error);
                }
                require('toastr')
                  .error($filter('translate')('featureattachment.updateFeatureError'),
                    ' Attribut : ', scope.att.name);
              }
            }
          );
        };


        /**
         * KIS-3484
         * Réaction à la suppression d'un document depuis l'onglet "Pièces jointes"
         *
         * KIS-3497
         * AJout de la gestion de l'ajout à synchroniser sur même type de champ
         * mais depuis le forumlaire d'édition méétier et vice-versa
         */
        scope.$on('attachmentChanged', (event, params) => {
          const id = scope.current.id;
          if (params && params.scopeId !== scope.$id && params.featureId===id) {
            if (params.removedFile && scope.result[scope.att.name] === params.removedFile) {
              // -- KIS-3484: si le document a été supprimé, donc, on remet le champ vide
              scope.result[scope.att.name] = '';
              updateAttachmentAttributeOnly(id);
            }
            else if (params.attName===scope.att.name) {
              scope.result[scope.att.name] = params.addedFile;
            }
          }
        });

      }
    };
  };

  javalangstring.$inject = ['FeatureAttachmentFactory','gaJsUtils', 'FilesFactory', 'gaDomUtils',
    '$filter', 'formFunctionUtils', 'EditFactory', 'FormsHelper', '$rootScope', '$q', '$timeout'];
  return javalangstring;
});
