'use strict';
define(function() {
  var gcdropzone = function(
      $http,
      $translate,
      gaDomUtils,
      $filter,
      PortalsFactory
  ) {
    return {
      templateUrl: 'js/XG/widgets/utilities/model/views/gcdropzone.html',

      restrict: 'AE',
      transclude: true,
      scope: {
        dropAction: '@',
        removeAction: '@?',
        completeAction: '&?',
        autoProcessQueue: '@',
        //dropzone: '&',
        //dropzoneConfig: '&',
        //eventHandlers: '&'
        processId: '=?',
        dropzoneComponent: '=?',
        //-- Utilise dropzoneMemShare pour récupérer dropzoneComponent et
        //-- processId, si le scope de la gcdropzone
        //-- n'est pas celui de la directive principal
        //-- (ng -if<-> ng - show par exemple).
        dropzoneMemShare: '=?',
        dropzoneTitle: '@?',
        extension: '@?',
        addRemoveLinks: '@?',
        paramName: '@?',
        maxFiles: '@?',
        maxFilesize: '@?',
        dictFileTooBig: '@?',
        init: '&',
        height: '@?',
        width: '@?'
      },
      link: function(scope, element) {
        try {
          Dropzone;
        } catch (error) {
          throw new Error('Dropzone.js not loaded.');
        }

        scope.processId = Math.floor(Math.random() * 100000000 + 1);

        var localProcessID = scope.processId;
        if (scope.dropzoneMemShare) {
          scope.dropzoneMemShare.processId = scope.processId;
        }

        var portalid = angular.module('gcMain').portalid;

        if (portalid == undefined || portalid == '') {
          portalid = PortalsFactory.getPortalId();
        }

        var dropAction = scope.dropAction;
        if (dropAction.indexOf('{portalid}') > -1)
          dropAction = dropAction.replace('{portalid}', portalid);

        if (localStorage.getItem('auth_token') && dropAction.indexOf('token=') === -1) {
          const queryParamDivider = (dropAction.indexOf('?') !== -1) ? '&' : '?';
          dropAction += queryParamDivider +
            'token=' + encodeURIComponent(localStorage.getItem('auth_token'));
        }

        var isApp = false;
        var appName = localStorage.getItem('app');
        if (dropAction.indexOf('{appname}') > -1) {
          dropAction = dropAction.replace('{appname}', appName);
          isApp = true;
        }

        if (localStorage.getItem('auth_token')) {
          dropAction += dropAction.indexOf('?') !== -1
            ? '&token='
            : '?token=';
          dropAction += encodeURIComponent(localStorage.getItem('auth_token'));
        }

        var removeAction = scope.removeAction;

        var autoPrcssQueue = true;

        if (!angular.isUndefined(scope.autoProcessQueue)) {
          autoPrcssQueue = scope.autoProcessQueue == 'true';
        }

        function removeUploadedFile(processId, fileName) {
          if (removeAction) {
            return $http.get(
              removeAction +'?f=json' +
                '&processId=' + processId +
                '&fileName=' + fileName
            );
          }
        }

        var deleteLabel = $filter('translate')('common.delete'); //"supprimer" ;

        $translate('importexportwidget.deleteFile').then(function(res) {
          deleteLabel = res;
        });

        var cancelLabel = $filter('translate')('common.cancel'); //"Annuler";

        $translate('importexportwidget.cancelFileUpload').then(function(res) {
          cancelLabel = res;
        });

        var dropzoneConfig = {
          url: dropAction,
          addRemoveLinks: scope.addRemoveLinks !== 'false',
          autoProcessQueue: autoPrcssQueue,
          dictRemoveFile: deleteLabel,
          dictCancelUpload: cancelLabel,
        };
        if (angular.isDefined(scope.extension)) {
          dropzoneConfig.acceptedFiles = scope.extension;
        }
        if (angular.isDefined(scope.paramName)) {
          dropzoneConfig.paramName = scope.paramName;
        }
        if (angular.isDefined(scope.maxFiles)) {
          dropzoneConfig.maxFiles = scope.maxFiles;
        }
        if (angular.isDefined(scope.height)) {
          scope.customStyle ={'height':scope.height, 'min-height': scope.height, 'width': scope.width};
        }
        if (angular.isDefined(scope.maxFilesize)) {
          dropzoneConfig.maxFilesize = scope.maxFilesize;
        }
        if (angular.isDefined(scope.dictFileTooBig)) {
          dropzoneConfig.dictFileTooBig = scope.dictFileTooBig;
        }
        if (angular.isFunction(scope.init())) {
          dropzoneConfig.init = scope.init();
        }
        dropzoneConfig.timeout = 500000;

        //var downloadurl = '/services/{portalid}/export/downloadexportedfile?f=json' +'&exportedFileId=' + resultFileName;
        var dropzone = new Dropzone(element[0].children[0], dropzoneConfig);

        /*
                 if (scope.eventHandlers) {
                 Object.keys(scope.eventHandlers).forEach(function (eventName) {
                 dropzone.on(eventName, scope.eventHandlers[eventName]);
                 });
                 }*/

        dropzone.on('error', function(file, message) {
          gaDomUtils.hideGlobalLoader();
          dropzone.removeFile(file);
          alert(message);
        });
        dropzone.on('complete', function(file) {
          if (typeof scope.completeAction === 'function' && file.status !== 'error') {
            scope.completeAction({file: file});
          }
          gaDomUtils.hideGlobalLoader();
          if (angular.isDefined(scope.completeAction)) {
            scope.completeAction();
          }
        });

        // Remove duplicates function
        dropzone.on("addedfiles", function(addedFiles) {
          if (this.files.length) {
            const numberOfFilesBeforeAdd = this.files.length - addedFiles.length;
            for(const addedFile of addedFiles) {
              // Parcours les fichiers déjà existants (- addedFiles.length pour ignorer ceux qu'on vient d'ajouter)
              for (let fileIndex = 0; fileIndex < numberOfFilesBeforeAdd; fileIndex++) {
                if (this.files[fileIndex].name === addedFile.name && this.files[fileIndex].size === addedFile.size
                  && this.files[fileIndex].lastModifiedDate.toString() === addedFile.lastModifiedDate.toString()) {
                  addedFile.clientRemoving = true;
                  this.removeFile(addedFile);
                }
              }
            }
          }
        });

        dropzone.on('sending', function(file, xhr, data) {
          gaDomUtils.showGlobalLoader();
          data.append('processId', localProcessID);
          if (isApp) {
            data.append('appname', appName);
          }
        });
        dropzone.on('removedfile', function(file) {
          if (file.clientRemoving) {
            console.log('Remove from client');
          } else removeUploadedFile(localProcessID, file.name);
        });

        scope.dropzoneComponent = dropzone;
        if (scope.dropzoneMemShare) {
          scope.dropzoneMemShare.dropzoneComponent = dropzone;
        }

        scope.$on('removeFile', function(evt, arg) {
          if (
            angular.isDefined(arg) &&
            angular.isDefined(arg.processid) &&
            arg.processid === localProcessID &&
            angular.isDefined(arg.filename)
          ) {
            var idx = dropzone.files
              .map(function(x) {
                return x.name;
              })
              .indexOf(arg.filename);
            if (idx !== -1) dropzone.removeFile(dropzone.files[idx]);
          }
        });
      },
    };
  };

  gcdropzone.$inject = [
    '$http',
    '$translate',
    'gaDomUtils',
    '$filter',
    'PortalsFactory'
  ];
  return gcdropzone;
});
