define(['angular','ngMock'], function(angular) {

    // declare what we need for this unit test in a clear manner
    let dialogInstance = null;
    let rootScope = null;
    let PopupInstance = null;
    let popupOpts = null;

    // description of what we are testing
    // this is for the entire service
    describe('extendedNgDialog', function() {

        // first load the app and making sure properties exists in the $rootScope
        beforeEach(module('app'));

        // before each test case (it statements), inject dependencies
        // and do some variable definitions
        beforeEach( inject(function(extendedNgDialog, $rootScope) {
            rootScope = $rootScope;
            dialogInstance = extendedNgDialog;
        }));

        // test cases for different functions in the extendedNgDialog.js
        it('open function should be a function', () => {
            expect(dialogInstance.open).toEqual(jasmine.any(Function));
        });

        it('Popup constructor should be a function', () => {
            expect(dialogInstance.Popup).toEqual(jasmine.any(Function));
        });

        // description of what we are testing
        // this is for the Popup constructor
        describe('dialogInstance.Popup', function() {
            // before each test case (it statements), inject dependencies
            // and do some variable definitions
            beforeEach(() => {
                popupOpts = {
                    scope: rootScope.$new(),
                    template: 'path/toTemplate.html',
                    title: 'Information',
                    showClose: true,
                };
                PopupInstance = new dialogInstance.Popup(popupOpts);
            });

            // test cases for feature functions in the extendedNgDialog.js
            it('this.popup.features should be defined and should be an object', () => {
                expect(PopupInstance.popup.features).toEqual(jasmine.any(Object));
            });

            it('this.popup.features.template should be defined and should equal with the popupOpts parameter', () => {
                expect(PopupInstance.popup.features.template).toEqual(popupOpts.template);
            });
        });

    });
});
