'use strict';

define([
  'angular',
  'modules/configuration/mod',
  'tools/UrlUtils',
  'toastr',
], function(angular, config, gaUrlUtils) {
  var apps = angular.module('app', config.standardAngularModulesKisMobileAnc);

  /*
   *  httpRequestInterceptor
   *  Handles every single HTTP Request sent to the backend
   */
  apps.factory('httpRequestInterceptor', [
    '$q',
    '$location',
    'gaUrlUtils',
    '$rootScope',
    function($q, $location, gaUrlUtils, $rootScope) {
      return {
        /**
         * Adds the JWT
         * and the portalid
         *
         * @param config
         * @returns {*}
         */

        request: function(config) {
          // only if logged !
          config.headers = config.headers || {};

          if (config.url.indexOf('services') !== -1) {
            // config.url = gaUrlUtils.encodeUriQuery(config.url);
            var baseUrl = config.url,
              urlFragments = baseUrl.split('/services/');

            // replaces the portal_id
            if (config.url.indexOf('{portalid}/') !== -1) {

              //// Ancienne façon de faire
              //-- If the application name is stored on the main module, use that one.
              //-- Else opening many tabs with different application won't work
              //-- because every tab would use the same application name !!!
              // var portalid = angular.module('gcMain').portalid;
              // if (portalid == undefined || portalid == '')
              //   portalid = localStorage.getItem('portal');
              // if (portalid == undefined || portalid == '') {
              //   config.url = config.url.replace('{portalid}', '-');
              // } else {
              //   config.url = config.url.replace('{portalid}', portalid);
              // }

              // Remplacement portalid par celui contenu dans gcMain ou l'URL ou datastorage ou '-'
              if (angular.module('gcMain')
                  && angular.module('gcMain').portalid
                  && angular.module('gcMain').portalid !== '') {
                config.url = config.url.replace('{portalid}', angular.module('gcMain').portalid);
              }
              if ($location.search().portal && $location.search().portal !== '') {
                config.url = config.url.replace('{portalid}', $location.search().portal);
              }
              if (localStorage.getItem('portal') && localStorage.getItem('portal') !== '') {
                config.url = config.url.replace('{portalid}', localStorage.getItem('portal'));
              }
              config.url = config.url.replace('{portalid}', '-');
            }

            /*console.log(config.url);*/
            if (config.url.indexOf('{appname}/') != -1) {
              //-- If the application name is stored on the main module, use that one.
              //-- Else opening many tabs with different application won't work
              //-- because every tab would use the same application name !!!

              // @RB if the app is set in the url, we get it from here, so it doesnt matter if we get multiple tabs
              if ($location.search().app) {
                var app = $location.search().app;
              } else {
                var app = angular.module('gcMain').app;
              }

              if (app == undefined || app == '')
                app = localStorage.getItem('app');

              if (app == undefined || app === '') {
                config.url = config.url.replace('{appname}', 'unknown');
              } else {
                config.url = config.url.replace('{appname}', app);
              }
            } else {
            }
            var posinterro = config.url.indexOf('?');

            /* if (posinterro != -1 )
                     {
                     var a = config.url.substr(0, posinterro);
                     var b = config.url.substr(posinterro +1);
                     config.url = a + '?' + gaUrlUtils.encodeUriQuery(b);

                     }*/
            // config.url = config.url + '&token='+encodeURIComponent('007');
            if (localStorage.getItem('auth_token')) {
              //config.url = config.url + '&token='+encodeURIComponent('007');
              var andChar = config.url.indexOf('?') !== -1 ? '&' : '?';
              config.url =
                config.url +
                andChar +
                'token=' +
                encodeURIComponent(localStorage.getItem('auth_token'));
            }

            if (
              $rootScope.xgos &&
              $rootScope.xgos.sector &&
              config.url.indexOf('token') !== -1
            )
              config.url = config.url + '&kis_app=' + $rootScope.xgos.sector;

            //console.log(config.url);
            //console.log(config.url);

            //console.log(config.url);
          }

          return config;
        },

        /**
         * Handles the server responses
         * @param response
         * @returns {Promise}
         */
        response: function(response) {
          // ERROR (CLASSTYPE == "Error")
          if (response.data.CLASSTYPE == 'Error') {
            // TODO: send to responseError to DRY the code
            // ex : http://stackoverflow.com/questions/21778183/angular-reject-from-response-into-responseerror
            //console.log(response.data);
            var errorMsg = '<h4>Error</h4> ' + response.data.message;
            if (response.data.details) {
              errorMsg += '<br/><h4>Details</h4>  ' + response.data.details;
            }

            if ($rootScope.xgos.user && $rootScope.xgos.user.name == 'root') {
              console.log('error');
              // require('toastr').error(errorMsg);
            }

            return $q.reject(response);
          }

          if (response.data.CLASSTYPE == 'UNAUTHORIZED') {
            /*require('toastr').error(response.data.message,
                     "Error",
                     {"closeButton": true,"timeOut": "0","extendedTimeOut": "0"}
                     );*/
            if ($rootScope.xgos.user && $rootScope.xgos.user.name == 'root') {
              console.log('error');
              require('toastr').error(response.data.message);
            }

            localStorage.removeItem('auth_token');
            // $location.path("/login");
          }

          return response;
        },

        /**
         * Handles the server errors
         * @param rejection
         * @returns {Promise}
         */
        responseError: function(rejection) {
          // 404
          if (rejection.status === 404) {
            //$location.path('/404/');
          }

          if (rejection.status === 403) {
            // require('toastr').error('Error ' +rejection.data );
          }

          /*if(rejection.status === 503){
                 localStorage.removeItem('auth_token');
                 $location.path("/login");
                 }*/

          if ($rootScope.xgos.user && $rootScope.xgos.user.name == 'root') {
            console.log('error:');
            console.log(rejection);
            //  require('toastr').error('Error ' +rejection.data );
          }

          return $q.reject(rejection);
        },
      };
    },
  ]);

  /*
   * Add the interceptor to $httpProvider
   */
  apps.config([
    '$httpProvider',
    '$routeProvider',
    function($httpProvider, $routeProvider) {
      angular.lowercase = angular.$$lowercase; 
      $httpProvider.interceptors.push('httpRequestInterceptor');
    },
  ]);

  /*
   * App run
   */
  apps.run([
    '$rootScope',
    '$window',
    '$location',
    'PortalsFactory',
    'authFactory',
    '$timeout',
    '$document',
    function(
      $rootScope,
      $window,
      $location,
      PortalsFactory,
      authFactory,
      $timeout,
      $document
    ) {
      var mydescription = document.getElementById('myProgress');
      if (mydescription) {
        window.kisLoadTime = window.kisLoadFullTime - 500;
      }

      // init global object
      $rootScope.xgos = {};
      // the portal list is always needed
      PortalsFactory.get().then(function() {
        PortalsFactory.setPortal();
      });

      // made this components visible only when the translation is loaded
      $rootScope.$on('$translateLoadingEnd', function() {
        // calendar
        $rootScope.calendar = { visible: false };
        //alert
        $rootScope.alert = { visible: false };
        // appswitcher
        $rootScope.appswitcher = { visible: false };
      });

      $document.on('keydown', function(e) {
        if (
          e.which === 8 &&
          e.target.nodeName !== 'INPUT' &&
          e.target.nodeName !== 'TEXTAREA' &&
          e.target.nodeName !== 'SELECT' &&
          e.target.nodeName !== 'DIV'
        ) {
          e.preventDefault();
        }
      });

      $rootScope.$on('$routeChangeStart', function(event, next, curent) {
        // if a new portal is forced which is different than the current one, logout
        if (typeof $location.search()['portal'] != 'undefined') {
          if (
            $rootScope.xgos.user && // user is logged
            $rootScope.portalChosen != $location.search()['portal'] // but the portal passed is different from the one stocked
          ) {
            authFactory.logout();
          }
        }

        /**
         * Check user auth
         * @returns {*}
         */
        var checkAuth = function() {
          var tok1 = $location.search().token;
          if (tok1 != undefined && tok1 != '') {
            localStorage.setItem('auth_token', tok1);
            localStorage.setItem('auth_token1', tok1);
            var urlUser = $location.search().user;
            if (urlUser != undefined && urlUser != '')
              localStorage.setItem('urlUser', urlUser);
          }
          //console.log('check auth depuis app.js');
          return authFactory.userLogged().then(
            // user is logged
            function() {
              // verif sector
              var parts = $location.path().split('/');
              // remove empty strings
              parts = parts.filter(Boolean);

              $rootScope.xgos.sectorParts = parts;
              $rootScope.xgos.sector = parts[0].replace(/\//g, '');

              switch ($rootScope.xgos.sector) {
                case 'map':
                case 'form':
                case 'anc':
                case 'bac':
                case 'indigau':
                case 'siroco':
                case 'login':
                case 'home':
                case '503':
                case '404':
                case 'calendar_invite':
                case 'supervision':
                  break;
                default:
                  $rootScope.xgos.sector = 'admin';
                  break;
              }
              //console.log($rootScope.xgos.sector);

              // is the user allowed to go access that page ?
              if (!authFactory.userIsAllowed()) {
                //event.preventDefault();
                authFactory.goToAccessDenied();
              }
            },
            // user is not logged
            function() {
              delete $rootScope.xgos.user;
              var tok = $location.search().token;
              if (tok != undefined && tok != '') {
                localStorage.setItem('auth_token', tok);
                /*
var urlUser = $location.search().user;
if (urlUser!=undefined && urlUser!="")
   {
       var mm = angular.module("rights").factory('UsersFactory');
       var promise = $http.get('/services/{portalid}/rights/user/get?f=json');
            promise.then(function(res){
                var users = res.data;
                for (var iuser=0;iuser<res.data.length;iuser++)
                    {
                        if (res.data[iuser].login==urlUser)
                           {
                               $rootScope.xgos.user = res.data[iuser];
                               break;
                           }
                    }
            });
   }
      */
              } else {
                // except for the logout page
                var target = $location.path().replace(/\//g, '');
                if (target != 'logout') {
                  authFactory.goToLogin();
                }
              }
            }
          );
        };

        // directly call checkAuth or wait a certain amount of time if secureSingleSession isnt set
        var checkSingleSession = function() {
          // dont check anything for the login
          if (next.$$route.originalPath == '/login/') return true;

          var secureSession = sessionStorage.getItem('secureSingleSession');
          // the secureSession is set, proceed to checkAuth
          if (secureSession != null) {
            return checkAuth();
            // the secureSession isnt set, lets wait for the answers from others tabs/windows
          } else {
            //console.log('Waiting for other tabs to respond');
            return $timeout(function() {
              //console.log('waited enough...');
              if (sessionStorage.getItem('secureSingleSession') == null) {
                //console.log('%c /!\\ FORCE DELOG ICI CAR PAS DE secureSingleSession ! /!\\', 'background: #f00; color: #fff');
                authFactory.logout();
              } else {
                checkAuth();
              }
            }, 0);
          }
        };

        // be sure that checkauth is resolved before loading the route
        next.resolve = angular.extend(next.resolve || {}, {
          // desctive temporairement le temps de trouver ce qui se passe parfois (delog auto...)
          // __authenticating__: checkSingleSession
          __authenticating__: checkAuth,
        });
      });
    },
  ]);

  return apps;
});
