/**
 *
 */
'use strict';
define(function() {
  var epanetexpareaCtrl = function($scope, gclayers, $filter, gcInteractions) {
    $scope.getMap = function(aScope) {
      if (aScope == null) return undefined;
      if (aScope.map != undefined) return aScope.map;
      else return $scope.getMap(aScope.$parent);
    };

    $scope.definePolygon = function() {
      if (
        $scope.drawinteraction instanceof ol.interaction.Draw &&
        $scope.drawinteraction.getActive()
      ) {
        $scope.clearGeom();
        $scope.drawinteraction.setActive(false);
        $scope.map.removeInteraction($scope.drawinteraction);
      } else {
        var source = new ol.source.Vector();

        $scope.drawinteraction = new ol.interaction.Draw({
          source: source,
          type:
            'Polygon' /** @type {ol.geom.GeometryType}  (typeSelect.value) LineString or Point */,
        });
        $scope.drawinteraction.set('gctype', 'kis');
        $scope.drawinteraction.set('interaction', 'Draw');
        $scope.drawinteraction.set('widget', 'aepepanetexp');

        $scope.drawinteraction.on('drawend', function(evt) {
          var coords = evt.feature.getGeometry().getCoordinates();
          $scope.theField.theRealField.geomvalue = angular.copy(coords[0]);
          $scope.theField.theRealField.geomproj = $scope.map
            .getView()
            .getProjection()
            .getCode();
          $scope.drawinteraction.setActive(false);
          $scope.map.removeInteraction($scope.drawinteraction);
          $scope.drawGeom();
        });
        $scope.clearGeom();
        $scope.drawinteraction.setActive(true);
        gcInteractions.setCurrentToolBar($scope.toolBarWidget);
        $scope.map.addInteraction($scope.drawinteraction);
      }
    };

    $scope.clearGeom = function() {
      var dl = gclayers.getDrawLayer();
      if (dl && dl.getSource) dl.getSource().clear();
    };

    $scope.drawGeom = function() {
      $scope.clearGeom();
      $scope.drawnFeature = new ol.Feature({
        geometry: new ol.geom.LineString(
          $scope.theField.theRealField.geomvalue
        ),
      });
      var style = new ol.style.Style({
        stroke: new ol.style.Stroke({
          color: 'rgba(100,255,255,1.0)',
          width: 4,
        }) /*
					    fill: new ol.style.Fill({
					       color: 'rgba(100,200,255,1.0)'
					    })*/,
      });
      $scope.drawnFeature.setStyle(style);
      gclayers
        .getDrawLayer()
        .getSource()
        .addFeature($scope.drawnFeature);
    };

    $scope.map = $scope.getMap($scope);

    $scope.$on('closeTools_epanetexp', function() {
      $scope.clearGeom();
    });
  };

  epanetexpareaCtrl.$inject = [
    '$scope',
    'gclayers',
    '$filter',
    'gcInteractions',
  ];
  return epanetexpareaCtrl;
});
