'use strict';
define(function() {
  /**
   * Class : TypeProjetFactory
   * Factory WebServices
   */
  var TypeProjetFactory = function(
    $http,
    FeatureTypeFactory,
    $q,
    QueryFactory,
    GlobalServices
  ) {
    var resources = { config: null, descField: null, objectId: null };

    /**
     * Function: get
     */
    function getConfig(type, name) {
      var promise = $http.get(
        '/services/{portalid}/config/get?f=json' +
          '&type=' +
          type +
          '&name=' +
          name
      );
      promise.then(function(res) {
        resources.config = res.data;
      });
      return promise;
    }

    /**
     * Function: get
     */
    function getObject00(tableUid, whereClause) {

      var promise = QueryFactory.data(
        tableUid,
        whereClause,
        undefined,
        undefined,
        undefined,
        undefined
      );
      promise.then(function(res) {
        resources.objects = res.data;
      });
      return promise;
    }
    /**
     * Function: get
     */
    function getObject(fid, featureID) {
      var promise = $http.post(
        '/services/{portalid}/query/' +
          fid +
          '/get?f=json' +
          '&fid=' +
          fid +
          '&featureID=' +
          featureID +
          '&propertyName=' +
          '&srsName=' +
          '&bbox=' +
          '&related='
      );
      promise.then(function(res) {
        resources.objects = res.data;
      });
      return promise;
    }

    /**
     * Function: add
     */
    function addObject(fid, senddata, featureType, theGeometry, crsName) {
      var features;

      //-- Build GeoJSON object describing the object we want  to insert
      features = {};
      features.type = 'FeatureCollection';
      features.features = [];
      features.features[0] = {};
      features.features[0].type = 'Feature';
      features.features[0].properties = senddata;
      if (theGeometry != undefined && theGeometry.coordinates != null)
        features.features[0].geometry = theGeometry;
      else features.features[0].geometry = {};

      //-- Do the insert
      resources.objectId = null;
      var promise = $http.post(
        '/services/{portalid}/edit/' + fid + '/add?f=json&crs=' + crsName,
        features
      );
      promise.then(function(res) {
        var indPt;

        resources.addedFeature = undefined;
        //- If the service returns OK (which does not mean the creation is OK)
        if (res.status == 200) {
          if (res.data.create.length != 0) {
            if (res.data.create[0].id != undefined) {
              //-- We''ve got the object ID so the creation is OK
              indPt = res.data.create[0].id.indexOf('.');
              resources.objectId = res.data.create[0].id.substr(indPt + 1);
              gaJsUtils.successMessage('Création réussie');
              resources.addedFeature = res.data.create;
            }
          } else gaJsUtils.errorMessage('La création a échoué', '');
        }
      });
      return promise;
    }

    /***********************************************************************
     *
     *
     *
     */

    function getWhere(where, resPrec) {
      var whereStr = where.attribute + where.operator;
      if (where.litteral == '!CURRENT_YEAR!')
        return whereStr + gaJsUtils.getCurrentYear();
      else if (where.litteral == 'id')
        return whereStr + QueryFactory.getFeatureId(resPrec);
    }

    function getExpectedValue(litteral) {
      var valueDesc = { type: 'unknown' };

      if (litteral == 'null') valueDesc.value = null;
      else if (litteral == '!TODAY!') {
        valueDesc.type = 'date';
        valueDesc.value = gaJsUtils.getCurrentDate();
      } else if (litteral == '!CURRENT_YEAR!')
        valueDesc.value = gaJsUtils.getCurrentYear();
      else valueDesc.value = litteral;

      return valueDesc;
    }

    function returnValue(condition, availabilityConfig, deferredObj, resPrec) {
      var value,
        expectedValueDesc,
        expectedValue,
        res = false;
      if (condition.attribute == 'id')
        value = QueryFactory.getFeatureId(resPrec);
      else value = resPrec.properties[condition.attribute];

      expectedValueDesc = getExpectedValue(condition.litteral);
      expectedValue = expectedValueDesc.value;

      if (condition.operator == '=') res = value == expectedValue;
      else if (condition.operator == '<>') res = value != expectedValue;
      else if (condition.operator == '<=') {
        if (expectedValueDesc.type == 'date')
          res = GlobalServices.getDateFromDbString(value) <= expectedValue;
        else res = value <= expectedValue;
      } else if (condition.operator == '>=') {
        if (expectedValueDesc.type == 'date')
          res = GlobalServices.getDateFromDbString(value) >= expectedValue;
        else res = value >= expectedValue;
      }

      if (deferredObj.deferred != undefined) deferredObj.deferred.resolve(res);
      deferredObj.deferred = undefined;
    }

    function answerWhenRecordNotFound(conditionTab, deferredObj) {
      if (conditionTab[conditionTab.length - 1].condition.operator == '=') {
        //-- Equal (searched value is different because not found so the condition is FALSE)
        deferredObj.deferred.resolve(false);
      } else {
        //-- Different (searched value is different because not found so the condition is TRUE)
        deferredObj.deferred.resolve(true);
      }
      deferredObj.deferred = undefined;
    }

    function getRecord(
      conditionTab,
      indCondTab,
      availabilityConfig,
      deferredObj,
      resPrec,
      oneParent
    ) {
      var pr = undefined;
      if (deferredObj == undefined) {
        deferredObj = {};
        deferredObj.objectCount = {};
        deferredObj.treatedObject = {};
        deferredObj.deferred = $q.defer();
        pr = deferredObj.deferred.promise;
      }
      if (indCondTab + 1 == conditionTab.length)
        returnValue(
          conditionTab[indCondTab].condition,
          availabilityConfig,
          deferredObj,
          resPrec
        );
      else {
        //var td = FeatureTypeFactory.getFeatureTypeDesc(conditionTab[indCondTab].datastore , conditionTab[indCondTab].table);
        var td;
        FeatureTypeFactory.getFeatureTypeDescAsPromise(
          conditionTab[indCondTab].datastore,
          conditionTab[indCondTab].table
        ).then(function(res) {
          td = res;

          var where = getWhere(conditionTab[indCondTab].condition, resPrec);
          QueryFactory.data(td.uid, where).then(function(res) {
            var whwh = where;
            deferredObj.treatedObject[indCondTab]++;
            if (res.data.features.length == 0) {
              if (oneParent) {
                answerWhenRecordNotFound(conditionTab, deferredObj);
              } else if (
                deferredObj.treatedObject[indCondTab] ==
                deferredObj.objectCount[indCondTab]
              )
                if (deferredObj.deferred != undefined)
                  answerWhenRecordNotFound(conditionTab, deferredObj);
            } else {
              var ind = 0,
                len = res.data.features.length;
              oneParent = len == 1;
              deferredObj.objectCount[indCondTab + 1] = len;
              deferredObj.treatedObject[indCondTab + 1] = 0;
              for (; ind < len; ind++)
                getRecord(
                  conditionTab,
                  indCondTab + 1,
                  availabilityConfig,
                  deferredObj,
                  res.data.features[ind],
                  oneParent
                );
            }
          });
        });
      }
      if (pr != undefined) return pr;
    }

    function getConditionStatus(
      conditionTab,
      indCondTab,
      availabilityConfig,
      deferred
    ) {
      getRecord(
        availabilityConfig.when.conditions[indCondTab],
        0,
        availabilityConfig,
        undefined,
        undefined,
        true
      ).then(function(res) {
        indCondTab++;
        if (indCondTab >= conditionTab.length) deferred.resolve(res);
        else if (conditionTab[indCondTab].operator == 'and') {
          if (!res) deferred.resolve(false);
          else
            getConditionStatus(
              conditionTab,
              indCondTab + 1,
              availabilityConfig,
              deferred
            );
        } else if (conditionTab[indCondTab].operator == 'or') {
          if (res) deferred.resolve(true);
          else
            getConditionStatus(
              conditionTab,
              indCondTab + 1,
              availabilityConfig,
              deferred
            );
        } else deferred.resolve(false);
      });
    }

    function getIsAvailableFromWhen(availabilityConfig, deferred) {
      if (availabilityConfig.when.conditions != undefined) {
        getConditionStatus(
          availabilityConfig.when.conditions,
          0,
          availabilityConfig,
          deferred,
          undefined,
          true
        );
      }
    }

    function isAvailable(availabilityConfig) {
      var deferred = $q.defer();
      if (availabilityConfig == undefined) deferred.resolve(true);
      else if (availabilityConfig.when != undefined)
        getIsAvailableFromWhen(availabilityConfig, deferred);
      else deferred.resolve(true);
      return deferred.promise;
    }

    /***********************************************************************
     */

    return {
      TypeProjetFactory: TypeProjetFactory,
      getConfig: getConfig,
      addObject: addObject,
      getObject: getObject,
      resources: resources,
      isAvailable: isAvailable,
    };
  };

  TypeProjetFactory.$inject = [
    '$http',
    'FeatureTypeFactory',
    '$q',
    'QueryFactory',
    'GlobalServices',
    'gaJsUtils',
  ];
  return TypeProjetFactory;
});
